package software.amazon.awscdk.services.secretsmanager;

/**
 * Properties for defining a `AWS::SecretsManager::RotationSchedule`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.433Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.secretsmanager.$Module.class, fqn = "@aws-cdk/aws-secretsmanager.CfnRotationScheduleProps")
@software.amazon.jsii.Jsii.Proxy(CfnRotationScheduleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRotationScheduleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::SecretsManager::RotationSchedule.SecretId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-secretid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSecretId();

    /**
     * `AWS::SecretsManager::RotationSchedule.HostedRotationLambda`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-hostedrotationlambda
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHostedRotationLambda() {
        return null;
    }

    /**
     * `AWS::SecretsManager::RotationSchedule.RotationLambdaARN`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-rotationlambdaarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRotationLambdaArn() {
        return null;
    }

    /**
     * `AWS::SecretsManager::RotationSchedule.RotationRules`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-rotationrules
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRotationRules() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRotationScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRotationScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRotationScheduleProps> {
        private java.lang.String secretId;
        private java.lang.Object hostedRotationLambda;
        private java.lang.String rotationLambdaArn;
        private java.lang.Object rotationRules;

        /**
         * Sets the value of {@link CfnRotationScheduleProps#getSecretId}
         * @param secretId `AWS::SecretsManager::RotationSchedule.SecretId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretId(java.lang.String secretId) {
            this.secretId = secretId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRotationScheduleProps#getHostedRotationLambda}
         * @param hostedRotationLambda `AWS::SecretsManager::RotationSchedule.HostedRotationLambda`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedRotationLambda(software.amazon.awscdk.core.IResolvable hostedRotationLambda) {
            this.hostedRotationLambda = hostedRotationLambda;
            return this;
        }

        /**
         * Sets the value of {@link CfnRotationScheduleProps#getHostedRotationLambda}
         * @param hostedRotationLambda `AWS::SecretsManager::RotationSchedule.HostedRotationLambda`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedRotationLambda(software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.HostedRotationLambdaProperty hostedRotationLambda) {
            this.hostedRotationLambda = hostedRotationLambda;
            return this;
        }

        /**
         * Sets the value of {@link CfnRotationScheduleProps#getRotationLambdaArn}
         * @param rotationLambdaArn `AWS::SecretsManager::RotationSchedule.RotationLambdaARN`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationLambdaArn(java.lang.String rotationLambdaArn) {
            this.rotationLambdaArn = rotationLambdaArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnRotationScheduleProps#getRotationRules}
         * @param rotationRules `AWS::SecretsManager::RotationSchedule.RotationRules`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationRules(software.amazon.awscdk.core.IResolvable rotationRules) {
            this.rotationRules = rotationRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnRotationScheduleProps#getRotationRules}
         * @param rotationRules `AWS::SecretsManager::RotationSchedule.RotationRules`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationRules(software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.RotationRulesProperty rotationRules) {
            this.rotationRules = rotationRules;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRotationScheduleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRotationScheduleProps build() {
            return new Jsii$Proxy(secretId, hostedRotationLambda, rotationLambdaArn, rotationRules);
        }
    }

    /**
     * An implementation for {@link CfnRotationScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRotationScheduleProps {
        private final java.lang.String secretId;
        private final java.lang.Object hostedRotationLambda;
        private final java.lang.String rotationLambdaArn;
        private final java.lang.Object rotationRules;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.secretId = this.jsiiGet("secretId", java.lang.String.class);
            this.hostedRotationLambda = this.jsiiGet("hostedRotationLambda", java.lang.Object.class);
            this.rotationLambdaArn = this.jsiiGet("rotationLambdaArn", java.lang.String.class);
            this.rotationRules = this.jsiiGet("rotationRules", java.lang.Object.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String secretId, final java.lang.Object hostedRotationLambda, final java.lang.String rotationLambdaArn, final java.lang.Object rotationRules) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.secretId = java.util.Objects.requireNonNull(secretId, "secretId is required");
            this.hostedRotationLambda = hostedRotationLambda;
            this.rotationLambdaArn = rotationLambdaArn;
            this.rotationRules = rotationRules;
        }

        @Override
        public java.lang.String getSecretId() {
            return this.secretId;
        }

        @Override
        public java.lang.Object getHostedRotationLambda() {
            return this.hostedRotationLambda;
        }

        @Override
        public java.lang.String getRotationLambdaArn() {
            return this.rotationLambdaArn;
        }

        @Override
        public java.lang.Object getRotationRules() {
            return this.rotationRules;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("secretId", om.valueToTree(this.getSecretId()));
            if (this.getHostedRotationLambda() != null) {
                data.set("hostedRotationLambda", om.valueToTree(this.getHostedRotationLambda()));
            }
            if (this.getRotationLambdaArn() != null) {
                data.set("rotationLambdaArn", om.valueToTree(this.getRotationLambdaArn()));
            }
            if (this.getRotationRules() != null) {
                data.set("rotationRules", om.valueToTree(this.getRotationRules()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-secretsmanager.CfnRotationScheduleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRotationScheduleProps.Jsii$Proxy that = (CfnRotationScheduleProps.Jsii$Proxy) o;

            if (!secretId.equals(that.secretId)) return false;
            if (this.hostedRotationLambda != null ? !this.hostedRotationLambda.equals(that.hostedRotationLambda) : that.hostedRotationLambda != null) return false;
            if (this.rotationLambdaArn != null ? !this.rotationLambdaArn.equals(that.rotationLambdaArn) : that.rotationLambdaArn != null) return false;
            return this.rotationRules != null ? this.rotationRules.equals(that.rotationRules) : that.rotationRules == null;
        }

        @Override
        public int hashCode() {
            int result = this.secretId.hashCode();
            result = 31 * result + (this.hostedRotationLambda != null ? this.hostedRotationLambda.hashCode() : 0);
            result = 31 * result + (this.rotationLambdaArn != null ? this.rotationLambdaArn.hashCode() : 0);
            result = 31 * result + (this.rotationRules != null ? this.rotationRules.hashCode() : 0);
            return result;
        }
    }
}
