package software.amazon.awscdk.services.secretsmanager;

/**
 * A CloudFormation `AWS::SecretsManager::RotationSchedule`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.432Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.secretsmanager.$Module.class, fqn = "@aws-cdk/aws-secretsmanager.CfnRotationSchedule")
public class CfnRotationSchedule extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnRotationSchedule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRotationSchedule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::SecretsManager::RotationSchedule`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRotationSchedule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.CfnRotationScheduleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::SecretsManager::RotationSchedule.SecretId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-secretid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSecretId() {
        return this.jsiiGet("secretId", java.lang.String.class);
    }

    /**
     * `AWS::SecretsManager::RotationSchedule.SecretId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-secretid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecretId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("secretId", java.util.Objects.requireNonNull(value, "secretId is required"));
    }

    /**
     * `AWS::SecretsManager::RotationSchedule.HostedRotationLambda`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-hostedrotationlambda
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHostedRotationLambda() {
        return this.jsiiGet("hostedRotationLambda", java.lang.Object.class);
    }

    /**
     * `AWS::SecretsManager::RotationSchedule.HostedRotationLambda`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-hostedrotationlambda
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostedRotationLambda(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("hostedRotationLambda", value);
    }

    /**
     * `AWS::SecretsManager::RotationSchedule.HostedRotationLambda`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-hostedrotationlambda
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostedRotationLambda(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.HostedRotationLambdaProperty value) {
        this.jsiiSet("hostedRotationLambda", value);
    }

    /**
     * `AWS::SecretsManager::RotationSchedule.RotationLambdaARN`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-rotationlambdaarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRotationLambdaArn() {
        return this.jsiiGet("rotationLambdaArn", java.lang.String.class);
    }

    /**
     * `AWS::SecretsManager::RotationSchedule.RotationLambdaARN`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-rotationlambdaarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRotationLambdaArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("rotationLambdaArn", value);
    }

    /**
     * `AWS::SecretsManager::RotationSchedule.RotationRules`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-rotationrules
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRotationRules() {
        return this.jsiiGet("rotationRules", java.lang.Object.class);
    }

    /**
     * `AWS::SecretsManager::RotationSchedule.RotationRules`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-rotationrules
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRotationRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("rotationRules", value);
    }

    /**
     * `AWS::SecretsManager::RotationSchedule.RotationRules`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-rotationrules
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRotationRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.RotationRulesProperty value) {
        this.jsiiSet("rotationRules", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-rotationschedule-hostedrotationlambda.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.secretsmanager.$Module.class, fqn = "@aws-cdk/aws-secretsmanager.CfnRotationSchedule.HostedRotationLambdaProperty")
    @software.amazon.jsii.Jsii.Proxy(HostedRotationLambdaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HostedRotationLambdaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnRotationSchedule.HostedRotationLambdaProperty.RotationType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-rotationschedule-hostedrotationlambda.html#cfn-secretsmanager-rotationschedule-hostedrotationlambda-rotationtype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRotationType();

        /**
         * `CfnRotationSchedule.HostedRotationLambdaProperty.KmsKeyArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-rotationschedule-hostedrotationlambda.html#cfn-secretsmanager-rotationschedule-hostedrotationlambda-kmskeyarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * `CfnRotationSchedule.HostedRotationLambdaProperty.MasterSecretArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-rotationschedule-hostedrotationlambda.html#cfn-secretsmanager-rotationschedule-hostedrotationlambda-mastersecretarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMasterSecretArn() {
            return null;
        }

        /**
         * `CfnRotationSchedule.HostedRotationLambdaProperty.MasterSecretKmsKeyArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-rotationschedule-hostedrotationlambda.html#cfn-secretsmanager-rotationschedule-hostedrotationlambda-mastersecretkmskeyarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMasterSecretKmsKeyArn() {
            return null;
        }

        /**
         * `CfnRotationSchedule.HostedRotationLambdaProperty.RotationLambdaName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-rotationschedule-hostedrotationlambda.html#cfn-secretsmanager-rotationschedule-hostedrotationlambda-rotationlambdaname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRotationLambdaName() {
            return null;
        }

        /**
         * `CfnRotationSchedule.HostedRotationLambdaProperty.VpcSecurityGroupIds`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-rotationschedule-hostedrotationlambda.html#cfn-secretsmanager-rotationschedule-hostedrotationlambda-vpcsecuritygroupids
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcSecurityGroupIds() {
            return null;
        }

        /**
         * `CfnRotationSchedule.HostedRotationLambdaProperty.VpcSubnetIds`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-rotationschedule-hostedrotationlambda.html#cfn-secretsmanager-rotationschedule-hostedrotationlambda-vpcsubnetids
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcSubnetIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HostedRotationLambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HostedRotationLambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HostedRotationLambdaProperty> {
            private java.lang.String rotationType;
            private java.lang.String kmsKeyArn;
            private java.lang.String masterSecretArn;
            private java.lang.String masterSecretKmsKeyArn;
            private java.lang.String rotationLambdaName;
            private java.lang.String vpcSecurityGroupIds;
            private java.lang.String vpcSubnetIds;

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getRotationType}
             * @param rotationType `CfnRotationSchedule.HostedRotationLambdaProperty.RotationType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rotationType(java.lang.String rotationType) {
                this.rotationType = rotationType;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getKmsKeyArn}
             * @param kmsKeyArn `CfnRotationSchedule.HostedRotationLambdaProperty.KmsKeyArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getMasterSecretArn}
             * @param masterSecretArn `CfnRotationSchedule.HostedRotationLambdaProperty.MasterSecretArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterSecretArn(java.lang.String masterSecretArn) {
                this.masterSecretArn = masterSecretArn;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getMasterSecretKmsKeyArn}
             * @param masterSecretKmsKeyArn `CfnRotationSchedule.HostedRotationLambdaProperty.MasterSecretKmsKeyArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterSecretKmsKeyArn(java.lang.String masterSecretKmsKeyArn) {
                this.masterSecretKmsKeyArn = masterSecretKmsKeyArn;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getRotationLambdaName}
             * @param rotationLambdaName `CfnRotationSchedule.HostedRotationLambdaProperty.RotationLambdaName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rotationLambdaName(java.lang.String rotationLambdaName) {
                this.rotationLambdaName = rotationLambdaName;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getVpcSecurityGroupIds}
             * @param vpcSecurityGroupIds `CfnRotationSchedule.HostedRotationLambdaProperty.VpcSecurityGroupIds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcSecurityGroupIds(java.lang.String vpcSecurityGroupIds) {
                this.vpcSecurityGroupIds = vpcSecurityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getVpcSubnetIds}
             * @param vpcSubnetIds `CfnRotationSchedule.HostedRotationLambdaProperty.VpcSubnetIds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcSubnetIds(java.lang.String vpcSubnetIds) {
                this.vpcSubnetIds = vpcSubnetIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HostedRotationLambdaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HostedRotationLambdaProperty build() {
                return new Jsii$Proxy(rotationType, kmsKeyArn, masterSecretArn, masterSecretKmsKeyArn, rotationLambdaName, vpcSecurityGroupIds, vpcSubnetIds);
            }
        }

        /**
         * An implementation for {@link HostedRotationLambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HostedRotationLambdaProperty {
            private final java.lang.String rotationType;
            private final java.lang.String kmsKeyArn;
            private final java.lang.String masterSecretArn;
            private final java.lang.String masterSecretKmsKeyArn;
            private final java.lang.String rotationLambdaName;
            private final java.lang.String vpcSecurityGroupIds;
            private final java.lang.String vpcSubnetIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rotationType = this.jsiiGet("rotationType", java.lang.String.class);
                this.kmsKeyArn = this.jsiiGet("kmsKeyArn", java.lang.String.class);
                this.masterSecretArn = this.jsiiGet("masterSecretArn", java.lang.String.class);
                this.masterSecretKmsKeyArn = this.jsiiGet("masterSecretKmsKeyArn", java.lang.String.class);
                this.rotationLambdaName = this.jsiiGet("rotationLambdaName", java.lang.String.class);
                this.vpcSecurityGroupIds = this.jsiiGet("vpcSecurityGroupIds", java.lang.String.class);
                this.vpcSubnetIds = this.jsiiGet("vpcSubnetIds", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String rotationType, final java.lang.String kmsKeyArn, final java.lang.String masterSecretArn, final java.lang.String masterSecretKmsKeyArn, final java.lang.String rotationLambdaName, final java.lang.String vpcSecurityGroupIds, final java.lang.String vpcSubnetIds) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rotationType = java.util.Objects.requireNonNull(rotationType, "rotationType is required");
                this.kmsKeyArn = kmsKeyArn;
                this.masterSecretArn = masterSecretArn;
                this.masterSecretKmsKeyArn = masterSecretKmsKeyArn;
                this.rotationLambdaName = rotationLambdaName;
                this.vpcSecurityGroupIds = vpcSecurityGroupIds;
                this.vpcSubnetIds = vpcSubnetIds;
            }

            @Override
            public java.lang.String getRotationType() {
                return this.rotationType;
            }

            @Override
            public java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            public java.lang.String getMasterSecretArn() {
                return this.masterSecretArn;
            }

            @Override
            public java.lang.String getMasterSecretKmsKeyArn() {
                return this.masterSecretKmsKeyArn;
            }

            @Override
            public java.lang.String getRotationLambdaName() {
                return this.rotationLambdaName;
            }

            @Override
            public java.lang.String getVpcSecurityGroupIds() {
                return this.vpcSecurityGroupIds;
            }

            @Override
            public java.lang.String getVpcSubnetIds() {
                return this.vpcSubnetIds;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("rotationType", om.valueToTree(this.getRotationType()));
                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }
                if (this.getMasterSecretArn() != null) {
                    data.set("masterSecretArn", om.valueToTree(this.getMasterSecretArn()));
                }
                if (this.getMasterSecretKmsKeyArn() != null) {
                    data.set("masterSecretKmsKeyArn", om.valueToTree(this.getMasterSecretKmsKeyArn()));
                }
                if (this.getRotationLambdaName() != null) {
                    data.set("rotationLambdaName", om.valueToTree(this.getRotationLambdaName()));
                }
                if (this.getVpcSecurityGroupIds() != null) {
                    data.set("vpcSecurityGroupIds", om.valueToTree(this.getVpcSecurityGroupIds()));
                }
                if (this.getVpcSubnetIds() != null) {
                    data.set("vpcSubnetIds", om.valueToTree(this.getVpcSubnetIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-secretsmanager.CfnRotationSchedule.HostedRotationLambdaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HostedRotationLambdaProperty.Jsii$Proxy that = (HostedRotationLambdaProperty.Jsii$Proxy) o;

                if (!rotationType.equals(that.rotationType)) return false;
                if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
                if (this.masterSecretArn != null ? !this.masterSecretArn.equals(that.masterSecretArn) : that.masterSecretArn != null) return false;
                if (this.masterSecretKmsKeyArn != null ? !this.masterSecretKmsKeyArn.equals(that.masterSecretKmsKeyArn) : that.masterSecretKmsKeyArn != null) return false;
                if (this.rotationLambdaName != null ? !this.rotationLambdaName.equals(that.rotationLambdaName) : that.rotationLambdaName != null) return false;
                if (this.vpcSecurityGroupIds != null ? !this.vpcSecurityGroupIds.equals(that.vpcSecurityGroupIds) : that.vpcSecurityGroupIds != null) return false;
                return this.vpcSubnetIds != null ? this.vpcSubnetIds.equals(that.vpcSubnetIds) : that.vpcSubnetIds == null;
            }

            @Override
            public int hashCode() {
                int result = this.rotationType.hashCode();
                result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
                result = 31 * result + (this.masterSecretArn != null ? this.masterSecretArn.hashCode() : 0);
                result = 31 * result + (this.masterSecretKmsKeyArn != null ? this.masterSecretKmsKeyArn.hashCode() : 0);
                result = 31 * result + (this.rotationLambdaName != null ? this.rotationLambdaName.hashCode() : 0);
                result = 31 * result + (this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.hashCode() : 0);
                result = 31 * result + (this.vpcSubnetIds != null ? this.vpcSubnetIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-rotationschedule-rotationrules.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.secretsmanager.$Module.class, fqn = "@aws-cdk/aws-secretsmanager.CfnRotationSchedule.RotationRulesProperty")
    @software.amazon.jsii.Jsii.Proxy(RotationRulesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RotationRulesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnRotationSchedule.RotationRulesProperty.AutomaticallyAfterDays`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-rotationschedule-rotationrules.html#cfn-secretsmanager-rotationschedule-rotationrules-automaticallyafterdays
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAutomaticallyAfterDays() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RotationRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RotationRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RotationRulesProperty> {
            private java.lang.Number automaticallyAfterDays;

            /**
             * Sets the value of {@link RotationRulesProperty#getAutomaticallyAfterDays}
             * @param automaticallyAfterDays `CfnRotationSchedule.RotationRulesProperty.AutomaticallyAfterDays`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticallyAfterDays(java.lang.Number automaticallyAfterDays) {
                this.automaticallyAfterDays = automaticallyAfterDays;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RotationRulesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RotationRulesProperty build() {
                return new Jsii$Proxy(automaticallyAfterDays);
            }
        }

        /**
         * An implementation for {@link RotationRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RotationRulesProperty {
            private final java.lang.Number automaticallyAfterDays;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.automaticallyAfterDays = this.jsiiGet("automaticallyAfterDays", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number automaticallyAfterDays) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.automaticallyAfterDays = automaticallyAfterDays;
            }

            @Override
            public java.lang.Number getAutomaticallyAfterDays() {
                return this.automaticallyAfterDays;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutomaticallyAfterDays() != null) {
                    data.set("automaticallyAfterDays", om.valueToTree(this.getAutomaticallyAfterDays()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-secretsmanager.CfnRotationSchedule.RotationRulesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RotationRulesProperty.Jsii$Proxy that = (RotationRulesProperty.Jsii$Proxy) o;

                return this.automaticallyAfterDays != null ? this.automaticallyAfterDays.equals(that.automaticallyAfterDays) : that.automaticallyAfterDays == null;
            }

            @Override
            public int hashCode() {
                int result = this.automaticallyAfterDays != null ? this.automaticallyAfterDays.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.secretsmanager.CfnRotationScheduleProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.secretsmanager.CfnRotationScheduleProps.Builder();
        }

        /**
         * `AWS::SecretsManager::RotationSchedule.SecretId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-secretid
         * @param secretId `AWS::SecretsManager::RotationSchedule.SecretId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretId(final java.lang.String secretId) {
            this.props.secretId(secretId);
            return this;
        }

        /**
         * `AWS::SecretsManager::RotationSchedule.HostedRotationLambda`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-hostedrotationlambda
         * @param hostedRotationLambda `AWS::SecretsManager::RotationSchedule.HostedRotationLambda`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedRotationLambda(final software.amazon.awscdk.core.IResolvable hostedRotationLambda) {
            this.props.hostedRotationLambda(hostedRotationLambda);
            return this;
        }
        /**
         * `AWS::SecretsManager::RotationSchedule.HostedRotationLambda`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-hostedrotationlambda
         * @param hostedRotationLambda `AWS::SecretsManager::RotationSchedule.HostedRotationLambda`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedRotationLambda(final software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.HostedRotationLambdaProperty hostedRotationLambda) {
            this.props.hostedRotationLambda(hostedRotationLambda);
            return this;
        }

        /**
         * `AWS::SecretsManager::RotationSchedule.RotationLambdaARN`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-rotationlambdaarn
         * @param rotationLambdaArn `AWS::SecretsManager::RotationSchedule.RotationLambdaARN`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationLambdaArn(final java.lang.String rotationLambdaArn) {
            this.props.rotationLambdaArn(rotationLambdaArn);
            return this;
        }

        /**
         * `AWS::SecretsManager::RotationSchedule.RotationRules`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-rotationrules
         * @param rotationRules `AWS::SecretsManager::RotationSchedule.RotationRules`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationRules(final software.amazon.awscdk.core.IResolvable rotationRules) {
            this.props.rotationRules(rotationRules);
            return this;
        }
        /**
         * `AWS::SecretsManager::RotationSchedule.RotationRules`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-rotationschedule.html#cfn-secretsmanager-rotationschedule-rotationrules
         * @param rotationRules `AWS::SecretsManager::RotationSchedule.RotationRules`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationRules(final software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.RotationRulesProperty rotationRules) {
            this.props.rotationRules(rotationRules);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule build() {
            return new software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
