/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sam;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.sam.$Module;
import software.amazon.awscdk.services.sam.CfnFunction;
import software.amazon.awscdk.services.sam.CfnFunctionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction")
public class CfnFunction
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFunction.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);
    public static final String REQUIRED_TRANSFORM = (String)JsiiObject.jsiiStaticGet(CfnFunction.class, (String)"REQUIRED_TRANSFORM", String.class);

    protected CfnFunction(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFunction(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnFunction(@NotNull Construct scope, @NotNull String id, @NotNull CfnFunctionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    @NotNull
    public Object getCodeUri() {
        return this.jsiiGet("codeUri", Object.class);
    }

    public void setCodeUri(@NotNull String value) {
        this.jsiiSet("codeUri", Objects.requireNonNull(value, "codeUri is required"));
    }

    public void setCodeUri(@NotNull IResolvable value) {
        this.jsiiSet("codeUri", Objects.requireNonNull(value, "codeUri is required"));
    }

    public void setCodeUri(@NotNull S3LocationProperty value) {
        this.jsiiSet("codeUri", Objects.requireNonNull(value, "codeUri is required"));
    }

    @NotNull
    public String getHandler() {
        return (String)this.jsiiGet("handler", String.class);
    }

    public void setHandler(@NotNull String value) {
        this.jsiiSet("handler", Objects.requireNonNull(value, "handler is required"));
    }

    @NotNull
    public String getRuntime() {
        return (String)this.jsiiGet("runtime", String.class);
    }

    public void setRuntime(@NotNull String value) {
        this.jsiiSet("runtime", Objects.requireNonNull(value, "runtime is required"));
    }

    @Nullable
    public String getAutoPublishAlias() {
        return (String)this.jsiiGet("autoPublishAlias", String.class);
    }

    public void setAutoPublishAlias(@Nullable String value) {
        this.jsiiSet("autoPublishAlias", value);
    }

    @Nullable
    public Object getDeadLetterQueue() {
        return this.jsiiGet("deadLetterQueue", Object.class);
    }

    public void setDeadLetterQueue(@Nullable IResolvable value) {
        this.jsiiSet("deadLetterQueue", value);
    }

    public void setDeadLetterQueue(@Nullable DeadLetterQueueProperty value) {
        this.jsiiSet("deadLetterQueue", value);
    }

    @Nullable
    public Object getDeploymentPreference() {
        return this.jsiiGet("deploymentPreference", Object.class);
    }

    public void setDeploymentPreference(@Nullable IResolvable value) {
        this.jsiiSet("deploymentPreference", value);
    }

    public void setDeploymentPreference(@Nullable DeploymentPreferenceProperty value) {
        this.jsiiSet("deploymentPreference", value);
    }

    @Nullable
    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(@Nullable String value) {
        this.jsiiSet("description", value);
    }

    @Nullable
    public Object getEnvironment() {
        return this.jsiiGet("environment", Object.class);
    }

    public void setEnvironment(@Nullable IResolvable value) {
        this.jsiiSet("environment", value);
    }

    public void setEnvironment(@Nullable FunctionEnvironmentProperty value) {
        this.jsiiSet("environment", value);
    }

    @Nullable
    public Object getEvents() {
        return this.jsiiGet("events", Object.class);
    }

    public void setEvents(@Nullable IResolvable value) {
        this.jsiiSet("events", value);
    }

    public void setEvents(@Nullable Map<String, Object> value) {
        this.jsiiSet("events", value);
    }

    @Nullable
    public Object getFileSystemConfigs() {
        return this.jsiiGet("fileSystemConfigs", Object.class);
    }

    public void setFileSystemConfigs(@Nullable IResolvable value) {
        this.jsiiSet("fileSystemConfigs", value);
    }

    public void setFileSystemConfigs(@Nullable List<Object> value) {
        this.jsiiSet("fileSystemConfigs", value);
    }

    @Nullable
    public String getFunctionName() {
        return (String)this.jsiiGet("functionName", String.class);
    }

    public void setFunctionName(@Nullable String value) {
        this.jsiiSet("functionName", value);
    }

    @Nullable
    public String getKmsKeyArn() {
        return (String)this.jsiiGet("kmsKeyArn", String.class);
    }

    public void setKmsKeyArn(@Nullable String value) {
        this.jsiiSet("kmsKeyArn", value);
    }

    @Nullable
    public List<String> getLayers() {
        return Optional.ofNullable((List)this.jsiiGet("layers", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setLayers(@Nullable List<String> value) {
        this.jsiiSet("layers", value);
    }

    @Nullable
    public Number getMemorySize() {
        return (Number)this.jsiiGet("memorySize", Number.class);
    }

    public void setMemorySize(@Nullable Number value) {
        this.jsiiSet("memorySize", value);
    }

    @Nullable
    public String getPermissionsBoundary() {
        return (String)this.jsiiGet("permissionsBoundary", String.class);
    }

    public void setPermissionsBoundary(@Nullable String value) {
        this.jsiiSet("permissionsBoundary", value);
    }

    @Nullable
    public Object getPolicies() {
        return this.jsiiGet("policies", Object.class);
    }

    public void setPolicies(@Nullable String value) {
        this.jsiiSet("policies", value);
    }

    public void setPolicies(@Nullable IResolvable value) {
        this.jsiiSet("policies", value);
    }

    public void setPolicies(@Nullable IAMPolicyDocumentProperty value) {
        this.jsiiSet("policies", value);
    }

    public void setPolicies(@Nullable List<Object> value) {
        this.jsiiSet("policies", value);
    }

    @Nullable
    public Number getReservedConcurrentExecutions() {
        return (Number)this.jsiiGet("reservedConcurrentExecutions", Number.class);
    }

    public void setReservedConcurrentExecutions(@Nullable Number value) {
        this.jsiiSet("reservedConcurrentExecutions", value);
    }

    @Nullable
    public String getRole() {
        return (String)this.jsiiGet("role", String.class);
    }

    public void setRole(@Nullable String value) {
        this.jsiiSet("role", value);
    }

    @Nullable
    public Number getTimeout() {
        return (Number)this.jsiiGet("timeout", Number.class);
    }

    public void setTimeout(@Nullable Number value) {
        this.jsiiSet("timeout", value);
    }

    @Nullable
    public String getTracing() {
        return (String)this.jsiiGet("tracing", String.class);
    }

    public void setTracing(@Nullable String value) {
        this.jsiiSet("tracing", value);
    }

    @Nullable
    public Object getVpcConfig() {
        return this.jsiiGet("vpcConfig", Object.class);
    }

    public void setVpcConfig(@Nullable IResolvable value) {
        this.jsiiSet("vpcConfig", value);
    }

    public void setVpcConfig(@Nullable VpcConfigProperty value) {
        this.jsiiSet("vpcConfig", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnFunction> {
        private final Construct scope;
        private final String id;
        private final CfnFunctionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnFunctionProps.Builder();
        }

        public Builder codeUri(String codeUri) {
            this.props.codeUri(codeUri);
            return this;
        }

        public Builder codeUri(IResolvable codeUri) {
            this.props.codeUri(codeUri);
            return this;
        }

        public Builder codeUri(S3LocationProperty codeUri) {
            this.props.codeUri(codeUri);
            return this;
        }

        public Builder handler(String handler) {
            this.props.handler(handler);
            return this;
        }

        public Builder runtime(String runtime) {
            this.props.runtime(runtime);
            return this;
        }

        public Builder autoPublishAlias(String autoPublishAlias) {
            this.props.autoPublishAlias(autoPublishAlias);
            return this;
        }

        public Builder deadLetterQueue(IResolvable deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder deadLetterQueue(DeadLetterQueueProperty deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder deploymentPreference(IResolvable deploymentPreference) {
            this.props.deploymentPreference(deploymentPreference);
            return this;
        }

        public Builder deploymentPreference(DeploymentPreferenceProperty deploymentPreference) {
            this.props.deploymentPreference(deploymentPreference);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder environment(IResolvable environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder environment(FunctionEnvironmentProperty environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder events(IResolvable events) {
            this.props.events(events);
            return this;
        }

        public Builder events(Map<String, ? extends Object> events) {
            this.props.events(events);
            return this;
        }

        public Builder fileSystemConfigs(IResolvable fileSystemConfigs) {
            this.props.fileSystemConfigs(fileSystemConfigs);
            return this;
        }

        public Builder fileSystemConfigs(List<? extends Object> fileSystemConfigs) {
            this.props.fileSystemConfigs(fileSystemConfigs);
            return this;
        }

        public Builder functionName(String functionName) {
            this.props.functionName(functionName);
            return this;
        }

        public Builder kmsKeyArn(String kmsKeyArn) {
            this.props.kmsKeyArn(kmsKeyArn);
            return this;
        }

        public Builder layers(List<String> layers) {
            this.props.layers(layers);
            return this;
        }

        public Builder memorySize(Number memorySize) {
            this.props.memorySize(memorySize);
            return this;
        }

        public Builder permissionsBoundary(String permissionsBoundary) {
            this.props.permissionsBoundary(permissionsBoundary);
            return this;
        }

        public Builder policies(String policies) {
            this.props.policies(policies);
            return this;
        }

        public Builder policies(IResolvable policies) {
            this.props.policies(policies);
            return this;
        }

        public Builder policies(IAMPolicyDocumentProperty policies) {
            this.props.policies(policies);
            return this;
        }

        public Builder policies(List<? extends Object> policies) {
            this.props.policies(policies);
            return this;
        }

        public Builder reservedConcurrentExecutions(Number reservedConcurrentExecutions) {
            this.props.reservedConcurrentExecutions(reservedConcurrentExecutions);
            return this;
        }

        public Builder role(String role) {
            this.props.role(role);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder timeout(Number timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder tracing(String tracing) {
            this.props.tracing(tracing);
            return this;
        }

        public Builder vpcConfig(IResolvable vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        public Builder vpcConfig(VpcConfigProperty vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        public CfnFunction build() {
            return new CfnFunction(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.VpcConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcConfigProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSecurityGroupIds();

        @NotNull
        public List<String> getSubnetIds();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcConfigProperty> {
            private List<String> securityGroupIds;
            private List<String> subnetIds;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public VpcConfigProperty build() {
                return new Jsii.Proxy(this.securityGroupIds, this.subnetIds, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.TopicSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TopicSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getTopicName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TopicSAMPTProperty> {
            private String topicName;

            public Builder topicName(String topicName) {
                this.topicName = topicName;
                return this;
            }

            public TopicSAMPTProperty build() {
                return new Jsii.Proxy(this.topicName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.TableStreamSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableStreamSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getStreamName();

        @NotNull
        public String getTableName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableStreamSAMPTProperty> {
            private String streamName;
            private String tableName;

            public Builder streamName(String streamName) {
                this.streamName = streamName;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public TableStreamSAMPTProperty build() {
                return new Jsii.Proxy(this.streamName, this.tableName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.TableSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getTableName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableSAMPTProperty> {
            private String tableName;

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public TableSAMPTProperty build() {
                return new Jsii.Proxy(this.tableName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.StreamSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StreamSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getStreamName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StreamSAMPTProperty> {
            private String streamName;

            public Builder streamName(String streamName) {
                this.streamName = streamName;
                return this;
            }

            public StreamSAMPTProperty build() {
                return new Jsii.Proxy(this.streamName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.StateMachineSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StateMachineSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getStateMachineName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StateMachineSAMPTProperty> {
            private String stateMachineName;

            public Builder stateMachineName(String stateMachineName) {
                this.stateMachineName = stateMachineName;
                return this;
            }

            public StateMachineSAMPTProperty build() {
                return new Jsii.Proxy(this.stateMachineName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.ScheduleEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScheduleEventProperty
    extends JsiiSerializable {
        @NotNull
        public String getSchedule();

        @Nullable
        default public String getInput() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScheduleEventProperty> {
            private String schedule;
            private String input;

            public Builder schedule(String schedule) {
                this.schedule = schedule;
                return this;
            }

            public Builder input(String input) {
                this.input = input;
                return this;
            }

            public ScheduleEventProperty build() {
                return new Jsii.Proxy(this.schedule, this.input, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.SQSEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SQSEventProperty
    extends JsiiSerializable {
        @NotNull
        public String getQueue();

        @Nullable
        default public Number getBatchSize() {
            return null;
        }

        @Nullable
        default public Object getEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SQSEventProperty> {
            private String queue;
            private Number batchSize;
            private Object enabled;

            public Builder queue(String queue) {
                this.queue = queue;
                return this;
            }

            public Builder batchSize(Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public SQSEventProperty build() {
                return new Jsii.Proxy(this.queue, this.batchSize, this.enabled, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.SNSEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SNSEventProperty
    extends JsiiSerializable {
        @NotNull
        public String getTopic();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SNSEventProperty> {
            private String topic;

            public Builder topic(String topic) {
                this.topic = topic;
                return this;
            }

            public SNSEventProperty build() {
                return new Jsii.Proxy(this.topic, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.SAMPolicyTemplateProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SAMPolicyTemplateProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAmiDescribePolicy() {
            return null;
        }

        @Nullable
        default public Object getCloudFormationDescribeStacksPolicy() {
            return null;
        }

        @Nullable
        default public Object getCloudWatchPutMetricPolicy() {
            return null;
        }

        @Nullable
        default public Object getDynamoDbCrudPolicy() {
            return null;
        }

        @Nullable
        default public Object getDynamoDbReadPolicy() {
            return null;
        }

        @Nullable
        default public Object getDynamoDbStreamReadPolicy() {
            return null;
        }

        @Nullable
        default public Object getEc2DescribePolicy() {
            return null;
        }

        @Nullable
        default public Object getElasticsearchHttpPostPolicy() {
            return null;
        }

        @Nullable
        default public Object getFilterLogEventsPolicy() {
            return null;
        }

        @Nullable
        default public Object getKinesisCrudPolicy() {
            return null;
        }

        @Nullable
        default public Object getKinesisStreamReadPolicy() {
            return null;
        }

        @Nullable
        default public Object getKmsDecryptPolicy() {
            return null;
        }

        @Nullable
        default public Object getLambdaInvokePolicy() {
            return null;
        }

        @Nullable
        default public Object getRekognitionDetectOnlyPolicy() {
            return null;
        }

        @Nullable
        default public Object getRekognitionLabelsPolicy() {
            return null;
        }

        @Nullable
        default public Object getRekognitionNoDataAccessPolicy() {
            return null;
        }

        @Nullable
        default public Object getRekognitionReadPolicy() {
            return null;
        }

        @Nullable
        default public Object getRekognitionWriteOnlyAccessPolicy() {
            return null;
        }

        @Nullable
        default public Object getS3CrudPolicy() {
            return null;
        }

        @Nullable
        default public Object getS3ReadPolicy() {
            return null;
        }

        @Nullable
        default public Object getSesBulkTemplatedCrudPolicy() {
            return null;
        }

        @Nullable
        default public Object getSesCrudPolicy() {
            return null;
        }

        @Nullable
        default public Object getSesEmailTemplateCrudPolicy() {
            return null;
        }

        @Nullable
        default public Object getSesSendBouncePolicy() {
            return null;
        }

        @Nullable
        default public Object getSnsCrudPolicy() {
            return null;
        }

        @Nullable
        default public Object getSnsPublishMessagePolicy() {
            return null;
        }

        @Nullable
        default public Object getSqsPollerPolicy() {
            return null;
        }

        @Nullable
        default public Object getSqsSendMessagePolicy() {
            return null;
        }

        @Nullable
        default public Object getStepFunctionsExecutionPolicy() {
            return null;
        }

        @Nullable
        default public Object getVpcAccessPolicy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SAMPolicyTemplateProperty> {
            private Object amiDescribePolicy;
            private Object cloudFormationDescribeStacksPolicy;
            private Object cloudWatchPutMetricPolicy;
            private Object dynamoDbCrudPolicy;
            private Object dynamoDbReadPolicy;
            private Object dynamoDbStreamReadPolicy;
            private Object ec2DescribePolicy;
            private Object elasticsearchHttpPostPolicy;
            private Object filterLogEventsPolicy;
            private Object kinesisCrudPolicy;
            private Object kinesisStreamReadPolicy;
            private Object kmsDecryptPolicy;
            private Object lambdaInvokePolicy;
            private Object rekognitionDetectOnlyPolicy;
            private Object rekognitionLabelsPolicy;
            private Object rekognitionNoDataAccessPolicy;
            private Object rekognitionReadPolicy;
            private Object rekognitionWriteOnlyAccessPolicy;
            private Object s3CrudPolicy;
            private Object s3ReadPolicy;
            private Object sesBulkTemplatedCrudPolicy;
            private Object sesCrudPolicy;
            private Object sesEmailTemplateCrudPolicy;
            private Object sesSendBouncePolicy;
            private Object snsCrudPolicy;
            private Object snsPublishMessagePolicy;
            private Object sqsPollerPolicy;
            private Object sqsSendMessagePolicy;
            private Object stepFunctionsExecutionPolicy;
            private Object vpcAccessPolicy;

            public Builder amiDescribePolicy(IResolvable amiDescribePolicy) {
                this.amiDescribePolicy = amiDescribePolicy;
                return this;
            }

            public Builder amiDescribePolicy(EmptySAMPTProperty amiDescribePolicy) {
                this.amiDescribePolicy = amiDescribePolicy;
                return this;
            }

            public Builder cloudFormationDescribeStacksPolicy(IResolvable cloudFormationDescribeStacksPolicy) {
                this.cloudFormationDescribeStacksPolicy = cloudFormationDescribeStacksPolicy;
                return this;
            }

            public Builder cloudFormationDescribeStacksPolicy(EmptySAMPTProperty cloudFormationDescribeStacksPolicy) {
                this.cloudFormationDescribeStacksPolicy = cloudFormationDescribeStacksPolicy;
                return this;
            }

            public Builder cloudWatchPutMetricPolicy(IResolvable cloudWatchPutMetricPolicy) {
                this.cloudWatchPutMetricPolicy = cloudWatchPutMetricPolicy;
                return this;
            }

            public Builder cloudWatchPutMetricPolicy(EmptySAMPTProperty cloudWatchPutMetricPolicy) {
                this.cloudWatchPutMetricPolicy = cloudWatchPutMetricPolicy;
                return this;
            }

            public Builder dynamoDbCrudPolicy(IResolvable dynamoDbCrudPolicy) {
                this.dynamoDbCrudPolicy = dynamoDbCrudPolicy;
                return this;
            }

            public Builder dynamoDbCrudPolicy(TableSAMPTProperty dynamoDbCrudPolicy) {
                this.dynamoDbCrudPolicy = dynamoDbCrudPolicy;
                return this;
            }

            public Builder dynamoDbReadPolicy(IResolvable dynamoDbReadPolicy) {
                this.dynamoDbReadPolicy = dynamoDbReadPolicy;
                return this;
            }

            public Builder dynamoDbReadPolicy(TableSAMPTProperty dynamoDbReadPolicy) {
                this.dynamoDbReadPolicy = dynamoDbReadPolicy;
                return this;
            }

            public Builder dynamoDbStreamReadPolicy(IResolvable dynamoDbStreamReadPolicy) {
                this.dynamoDbStreamReadPolicy = dynamoDbStreamReadPolicy;
                return this;
            }

            public Builder dynamoDbStreamReadPolicy(TableStreamSAMPTProperty dynamoDbStreamReadPolicy) {
                this.dynamoDbStreamReadPolicy = dynamoDbStreamReadPolicy;
                return this;
            }

            public Builder ec2DescribePolicy(IResolvable ec2DescribePolicy) {
                this.ec2DescribePolicy = ec2DescribePolicy;
                return this;
            }

            public Builder ec2DescribePolicy(EmptySAMPTProperty ec2DescribePolicy) {
                this.ec2DescribePolicy = ec2DescribePolicy;
                return this;
            }

            public Builder elasticsearchHttpPostPolicy(IResolvable elasticsearchHttpPostPolicy) {
                this.elasticsearchHttpPostPolicy = elasticsearchHttpPostPolicy;
                return this;
            }

            public Builder elasticsearchHttpPostPolicy(DomainSAMPTProperty elasticsearchHttpPostPolicy) {
                this.elasticsearchHttpPostPolicy = elasticsearchHttpPostPolicy;
                return this;
            }

            public Builder filterLogEventsPolicy(IResolvable filterLogEventsPolicy) {
                this.filterLogEventsPolicy = filterLogEventsPolicy;
                return this;
            }

            public Builder filterLogEventsPolicy(LogGroupSAMPTProperty filterLogEventsPolicy) {
                this.filterLogEventsPolicy = filterLogEventsPolicy;
                return this;
            }

            public Builder kinesisCrudPolicy(IResolvable kinesisCrudPolicy) {
                this.kinesisCrudPolicy = kinesisCrudPolicy;
                return this;
            }

            public Builder kinesisCrudPolicy(StreamSAMPTProperty kinesisCrudPolicy) {
                this.kinesisCrudPolicy = kinesisCrudPolicy;
                return this;
            }

            public Builder kinesisStreamReadPolicy(IResolvable kinesisStreamReadPolicy) {
                this.kinesisStreamReadPolicy = kinesisStreamReadPolicy;
                return this;
            }

            public Builder kinesisStreamReadPolicy(StreamSAMPTProperty kinesisStreamReadPolicy) {
                this.kinesisStreamReadPolicy = kinesisStreamReadPolicy;
                return this;
            }

            public Builder kmsDecryptPolicy(IResolvable kmsDecryptPolicy) {
                this.kmsDecryptPolicy = kmsDecryptPolicy;
                return this;
            }

            public Builder kmsDecryptPolicy(KeySAMPTProperty kmsDecryptPolicy) {
                this.kmsDecryptPolicy = kmsDecryptPolicy;
                return this;
            }

            public Builder lambdaInvokePolicy(IResolvable lambdaInvokePolicy) {
                this.lambdaInvokePolicy = lambdaInvokePolicy;
                return this;
            }

            public Builder lambdaInvokePolicy(FunctionSAMPTProperty lambdaInvokePolicy) {
                this.lambdaInvokePolicy = lambdaInvokePolicy;
                return this;
            }

            public Builder rekognitionDetectOnlyPolicy(IResolvable rekognitionDetectOnlyPolicy) {
                this.rekognitionDetectOnlyPolicy = rekognitionDetectOnlyPolicy;
                return this;
            }

            public Builder rekognitionDetectOnlyPolicy(EmptySAMPTProperty rekognitionDetectOnlyPolicy) {
                this.rekognitionDetectOnlyPolicy = rekognitionDetectOnlyPolicy;
                return this;
            }

            public Builder rekognitionLabelsPolicy(IResolvable rekognitionLabelsPolicy) {
                this.rekognitionLabelsPolicy = rekognitionLabelsPolicy;
                return this;
            }

            public Builder rekognitionLabelsPolicy(EmptySAMPTProperty rekognitionLabelsPolicy) {
                this.rekognitionLabelsPolicy = rekognitionLabelsPolicy;
                return this;
            }

            public Builder rekognitionNoDataAccessPolicy(IResolvable rekognitionNoDataAccessPolicy) {
                this.rekognitionNoDataAccessPolicy = rekognitionNoDataAccessPolicy;
                return this;
            }

            public Builder rekognitionNoDataAccessPolicy(CollectionSAMPTProperty rekognitionNoDataAccessPolicy) {
                this.rekognitionNoDataAccessPolicy = rekognitionNoDataAccessPolicy;
                return this;
            }

            public Builder rekognitionReadPolicy(IResolvable rekognitionReadPolicy) {
                this.rekognitionReadPolicy = rekognitionReadPolicy;
                return this;
            }

            public Builder rekognitionReadPolicy(CollectionSAMPTProperty rekognitionReadPolicy) {
                this.rekognitionReadPolicy = rekognitionReadPolicy;
                return this;
            }

            public Builder rekognitionWriteOnlyAccessPolicy(IResolvable rekognitionWriteOnlyAccessPolicy) {
                this.rekognitionWriteOnlyAccessPolicy = rekognitionWriteOnlyAccessPolicy;
                return this;
            }

            public Builder rekognitionWriteOnlyAccessPolicy(CollectionSAMPTProperty rekognitionWriteOnlyAccessPolicy) {
                this.rekognitionWriteOnlyAccessPolicy = rekognitionWriteOnlyAccessPolicy;
                return this;
            }

            public Builder s3CrudPolicy(IResolvable s3CrudPolicy) {
                this.s3CrudPolicy = s3CrudPolicy;
                return this;
            }

            public Builder s3CrudPolicy(BucketSAMPTProperty s3CrudPolicy) {
                this.s3CrudPolicy = s3CrudPolicy;
                return this;
            }

            public Builder s3ReadPolicy(IResolvable s3ReadPolicy) {
                this.s3ReadPolicy = s3ReadPolicy;
                return this;
            }

            public Builder s3ReadPolicy(BucketSAMPTProperty s3ReadPolicy) {
                this.s3ReadPolicy = s3ReadPolicy;
                return this;
            }

            public Builder sesBulkTemplatedCrudPolicy(IResolvable sesBulkTemplatedCrudPolicy) {
                this.sesBulkTemplatedCrudPolicy = sesBulkTemplatedCrudPolicy;
                return this;
            }

            public Builder sesBulkTemplatedCrudPolicy(IdentitySAMPTProperty sesBulkTemplatedCrudPolicy) {
                this.sesBulkTemplatedCrudPolicy = sesBulkTemplatedCrudPolicy;
                return this;
            }

            public Builder sesCrudPolicy(IResolvable sesCrudPolicy) {
                this.sesCrudPolicy = sesCrudPolicy;
                return this;
            }

            public Builder sesCrudPolicy(IdentitySAMPTProperty sesCrudPolicy) {
                this.sesCrudPolicy = sesCrudPolicy;
                return this;
            }

            public Builder sesEmailTemplateCrudPolicy(IResolvable sesEmailTemplateCrudPolicy) {
                this.sesEmailTemplateCrudPolicy = sesEmailTemplateCrudPolicy;
                return this;
            }

            public Builder sesEmailTemplateCrudPolicy(EmptySAMPTProperty sesEmailTemplateCrudPolicy) {
                this.sesEmailTemplateCrudPolicy = sesEmailTemplateCrudPolicy;
                return this;
            }

            public Builder sesSendBouncePolicy(IResolvable sesSendBouncePolicy) {
                this.sesSendBouncePolicy = sesSendBouncePolicy;
                return this;
            }

            public Builder sesSendBouncePolicy(IdentitySAMPTProperty sesSendBouncePolicy) {
                this.sesSendBouncePolicy = sesSendBouncePolicy;
                return this;
            }

            public Builder snsCrudPolicy(IResolvable snsCrudPolicy) {
                this.snsCrudPolicy = snsCrudPolicy;
                return this;
            }

            public Builder snsCrudPolicy(TopicSAMPTProperty snsCrudPolicy) {
                this.snsCrudPolicy = snsCrudPolicy;
                return this;
            }

            public Builder snsPublishMessagePolicy(IResolvable snsPublishMessagePolicy) {
                this.snsPublishMessagePolicy = snsPublishMessagePolicy;
                return this;
            }

            public Builder snsPublishMessagePolicy(TopicSAMPTProperty snsPublishMessagePolicy) {
                this.snsPublishMessagePolicy = snsPublishMessagePolicy;
                return this;
            }

            public Builder sqsPollerPolicy(IResolvable sqsPollerPolicy) {
                this.sqsPollerPolicy = sqsPollerPolicy;
                return this;
            }

            public Builder sqsPollerPolicy(QueueSAMPTProperty sqsPollerPolicy) {
                this.sqsPollerPolicy = sqsPollerPolicy;
                return this;
            }

            public Builder sqsSendMessagePolicy(IResolvable sqsSendMessagePolicy) {
                this.sqsSendMessagePolicy = sqsSendMessagePolicy;
                return this;
            }

            public Builder sqsSendMessagePolicy(QueueSAMPTProperty sqsSendMessagePolicy) {
                this.sqsSendMessagePolicy = sqsSendMessagePolicy;
                return this;
            }

            public Builder stepFunctionsExecutionPolicy(IResolvable stepFunctionsExecutionPolicy) {
                this.stepFunctionsExecutionPolicy = stepFunctionsExecutionPolicy;
                return this;
            }

            public Builder stepFunctionsExecutionPolicy(StateMachineSAMPTProperty stepFunctionsExecutionPolicy) {
                this.stepFunctionsExecutionPolicy = stepFunctionsExecutionPolicy;
                return this;
            }

            public Builder vpcAccessPolicy(IResolvable vpcAccessPolicy) {
                this.vpcAccessPolicy = vpcAccessPolicy;
                return this;
            }

            public Builder vpcAccessPolicy(EmptySAMPTProperty vpcAccessPolicy) {
                this.vpcAccessPolicy = vpcAccessPolicy;
                return this;
            }

            public SAMPolicyTemplateProperty build() {
                return new Jsii.Proxy(this.amiDescribePolicy, this.cloudFormationDescribeStacksPolicy, this.cloudWatchPutMetricPolicy, this.dynamoDbCrudPolicy, this.dynamoDbReadPolicy, this.dynamoDbStreamReadPolicy, this.ec2DescribePolicy, this.elasticsearchHttpPostPolicy, this.filterLogEventsPolicy, this.kinesisCrudPolicy, this.kinesisStreamReadPolicy, this.kmsDecryptPolicy, this.lambdaInvokePolicy, this.rekognitionDetectOnlyPolicy, this.rekognitionLabelsPolicy, this.rekognitionNoDataAccessPolicy, this.rekognitionReadPolicy, this.rekognitionWriteOnlyAccessPolicy, this.s3CrudPolicy, this.s3ReadPolicy, this.sesBulkTemplatedCrudPolicy, this.sesCrudPolicy, this.sesEmailTemplateCrudPolicy, this.sesSendBouncePolicy, this.snsCrudPolicy, this.snsPublishMessagePolicy, this.sqsPollerPolicy, this.sqsSendMessagePolicy, this.stepFunctionsExecutionPolicy, this.vpcAccessPolicy, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.S3NotificationFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3NotificationFilterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getS3Key();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3NotificationFilterProperty> {
            private Object s3Key;

            public Builder s3Key(IResolvable s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            public Builder s3Key(S3KeyFilterProperty s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            public S3NotificationFilterProperty build() {
                return new Jsii.Proxy(this.s3Key, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.S3LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @NotNull
        public String getKey();

        @Nullable
        default public Number getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LocationProperty> {
            private String bucket;
            private String key;
            private Number version;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder version(Number version) {
                this.version = version;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this.bucket, this.key, this.version, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.S3KeyFilterRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3KeyFilterRuleProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3KeyFilterRuleProperty> {
            private String name;
            private String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public S3KeyFilterRuleProperty build() {
                return new Jsii.Proxy(this.name, this.value, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.S3KeyFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3KeyFilterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3KeyFilterProperty> {
            private Object rules;

            public Builder rules(IResolvable rules) {
                this.rules = rules;
                return this;
            }

            public Builder rules(List<? extends Object> rules) {
                this.rules = rules;
                return this;
            }

            public S3KeyFilterProperty build() {
                return new Jsii.Proxy(this.rules, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.S3EventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3EventProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @NotNull
        public Object getEvents();

        @Nullable
        default public Object getFilter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3EventProperty> {
            private String bucket;
            private Object events;
            private Object filter;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder events(String events) {
                this.events = events;
                return this;
            }

            public Builder events(IResolvable events) {
                this.events = events;
                return this;
            }

            public Builder events(List<String> events) {
                this.events = events;
                return this;
            }

            public Builder filter(IResolvable filter) {
                this.filter = filter;
                return this;
            }

            public Builder filter(S3NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            public S3EventProperty build() {
                return new Jsii.Proxy(this.bucket, this.events, this.filter, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.QueueSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface QueueSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getQueueName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<QueueSAMPTProperty> {
            private String queueName;

            public Builder queueName(String queueName) {
                this.queueName = queueName;
                return this;
            }

            public QueueSAMPTProperty build() {
                return new Jsii.Proxy(this.queueName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.OnFailureProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OnFailureProperty
    extends JsiiSerializable {
        @NotNull
        public String getDestination();

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OnFailureProperty> {
            private String destination;
            private String type;

            public Builder destination(String destination) {
                this.destination = destination;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public OnFailureProperty build() {
                return new Jsii.Proxy(this.destination, this.type, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.LogGroupSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LogGroupSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getLogGroupName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LogGroupSAMPTProperty> {
            private String logGroupName;

            public Builder logGroupName(String logGroupName) {
                this.logGroupName = logGroupName;
                return this;
            }

            public LogGroupSAMPTProperty build() {
                return new Jsii.Proxy(this.logGroupName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.KinesisEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KinesisEventProperty
    extends JsiiSerializable {
        @NotNull
        public String getStartingPosition();

        @NotNull
        public String getStream();

        @Nullable
        default public Number getBatchSize() {
            return null;
        }

        @Nullable
        default public Object getEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KinesisEventProperty> {
            private String startingPosition;
            private String stream;
            private Number batchSize;
            private Object enabled;

            public Builder startingPosition(String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            public Builder stream(String stream) {
                this.stream = stream;
                return this;
            }

            public Builder batchSize(Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public KinesisEventProperty build() {
                return new Jsii.Proxy(this.startingPosition, this.stream, this.batchSize, this.enabled, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.KeySAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KeySAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getKeyId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KeySAMPTProperty> {
            private String keyId;

            public Builder keyId(String keyId) {
                this.keyId = keyId;
                return this;
            }

            public KeySAMPTProperty build() {
                return new Jsii.Proxy(this.keyId, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.IoTRuleEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IoTRuleEventProperty
    extends JsiiSerializable {
        @NotNull
        public String getSql();

        @Nullable
        default public String getAwsIotSqlVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IoTRuleEventProperty> {
            private String sql;
            private String awsIotSqlVersion;

            public Builder sql(String sql) {
                this.sql = sql;
                return this;
            }

            public Builder awsIotSqlVersion(String awsIotSqlVersion) {
                this.awsIotSqlVersion = awsIotSqlVersion;
                return this;
            }

            public IoTRuleEventProperty build() {
                return new Jsii.Proxy(this.sql, this.awsIotSqlVersion, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.IdentitySAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IdentitySAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getIdentityName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IdentitySAMPTProperty> {
            private String identityName;

            public Builder identityName(String identityName) {
                this.identityName = identityName;
                return this;
            }

            public IdentitySAMPTProperty build() {
                return new Jsii.Proxy(this.identityName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.IAMPolicyDocumentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IAMPolicyDocumentProperty
    extends JsiiSerializable {
        @NotNull
        public Object getStatement();
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.FunctionSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FunctionSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getFunctionName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FunctionSAMPTProperty> {
            private String functionName;

            public Builder functionName(String functionName) {
                this.functionName = functionName;
                return this;
            }

            public FunctionSAMPTProperty build() {
                return new Jsii.Proxy(this.functionName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.FunctionEnvironmentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FunctionEnvironmentProperty
    extends JsiiSerializable {
        @NotNull
        public Object getVariables();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FunctionEnvironmentProperty> {
            private Object variables;

            public Builder variables(IResolvable variables) {
                this.variables = variables;
                return this;
            }

            public Builder variables(Map<String, String> variables) {
                this.variables = variables;
                return this;
            }

            public FunctionEnvironmentProperty build() {
                return new Jsii.Proxy(this.variables, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.FileSystemConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FileSystemConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getArn() {
            return null;
        }

        @Nullable
        default public String getLocalMountPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FileSystemConfigProperty> {
            private String arn;
            private String localMountPath;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder localMountPath(String localMountPath) {
                this.localMountPath = localMountPath;
                return this;
            }

            public FileSystemConfigProperty build() {
                return new Jsii.Proxy(this.arn, this.localMountPath, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.EventSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EventSourceProperty
    extends JsiiSerializable {
        @NotNull
        public Object getProperties();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EventSourceProperty> {
            private Object properties;
            private String type;

            public Builder properties(IResolvable properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(AlexaSkillEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(ApiEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(CloudWatchEventEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(CloudWatchLogsEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(DynamoDBEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(EventBridgeRuleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(IoTRuleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(KinesisEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(S3EventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(SNSEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(SQSEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(ScheduleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public EventSourceProperty build() {
                return new Jsii.Proxy(this.properties, this.type, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.EventBridgeRuleEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EventBridgeRuleEventProperty
    extends JsiiSerializable {
        @NotNull
        public Object getPattern();

        @Nullable
        default public String getEventBusName() {
            return null;
        }

        @Nullable
        default public String getInput() {
            return null;
        }

        @Nullable
        default public String getInputPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EventBridgeRuleEventProperty> {
            private Object pattern;
            private String eventBusName;
            private String input;
            private String inputPath;

            public Builder pattern(Object pattern) {
                this.pattern = pattern;
                return this;
            }

            public Builder eventBusName(String eventBusName) {
                this.eventBusName = eventBusName;
                return this;
            }

            public Builder input(String input) {
                this.input = input;
                return this;
            }

            public Builder inputPath(String inputPath) {
                this.inputPath = inputPath;
                return this;
            }

            public EventBridgeRuleEventProperty build() {
                return new Jsii.Proxy(this.pattern, this.eventBusName, this.input, this.inputPath, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.EmptySAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EmptySAMPTProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EmptySAMPTProperty> {
            public EmptySAMPTProperty build() {
                return new Jsii.Proxy(null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.DynamoDBEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DynamoDBEventProperty
    extends JsiiSerializable {
        @NotNull
        public String getStartingPosition();

        @NotNull
        public String getStream();

        @Nullable
        default public Number getBatchSize() {
            return null;
        }

        @Nullable
        default public Object getBisectBatchOnFunctionError() {
            return null;
        }

        @Nullable
        default public Object getDestinationConfig() {
            return null;
        }

        @Nullable
        default public Object getEnabled() {
            return null;
        }

        @Nullable
        default public Number getMaximumBatchingWindowInSeconds() {
            return null;
        }

        @Nullable
        default public Number getMaximumRecordAgeInSeconds() {
            return null;
        }

        @Nullable
        default public Number getMaximumRetryAttempts() {
            return null;
        }

        @Nullable
        default public Number getParallelizationFactor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DynamoDBEventProperty> {
            private String startingPosition;
            private String stream;
            private Number batchSize;
            private Object bisectBatchOnFunctionError;
            private Object destinationConfig;
            private Object enabled;
            private Number maximumBatchingWindowInSeconds;
            private Number maximumRecordAgeInSeconds;
            private Number maximumRetryAttempts;
            private Number parallelizationFactor;

            public Builder startingPosition(String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            public Builder stream(String stream) {
                this.stream = stream;
                return this;
            }

            public Builder batchSize(Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder bisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError) {
                this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
                return this;
            }

            public Builder bisectBatchOnFunctionError(IResolvable bisectBatchOnFunctionError) {
                this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
                return this;
            }

            public Builder destinationConfig(IResolvable destinationConfig) {
                this.destinationConfig = destinationConfig;
                return this;
            }

            public Builder destinationConfig(DestinationConfigProperty destinationConfig) {
                this.destinationConfig = destinationConfig;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder maximumBatchingWindowInSeconds(Number maximumBatchingWindowInSeconds) {
                this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
                return this;
            }

            public Builder maximumRecordAgeInSeconds(Number maximumRecordAgeInSeconds) {
                this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
                return this;
            }

            public Builder maximumRetryAttempts(Number maximumRetryAttempts) {
                this.maximumRetryAttempts = maximumRetryAttempts;
                return this;
            }

            public Builder parallelizationFactor(Number parallelizationFactor) {
                this.parallelizationFactor = parallelizationFactor;
                return this;
            }

            public DynamoDBEventProperty build() {
                return new Jsii.Proxy(this.startingPosition, this.stream, this.batchSize, this.bisectBatchOnFunctionError, this.destinationConfig, this.enabled, this.maximumBatchingWindowInSeconds, this.maximumRecordAgeInSeconds, this.maximumRetryAttempts, this.parallelizationFactor, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.DomainSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DomainSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getDomainName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DomainSAMPTProperty> {
            private String domainName;

            public Builder domainName(String domainName) {
                this.domainName = domainName;
                return this;
            }

            public DomainSAMPTProperty build() {
                return new Jsii.Proxy(this.domainName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.DestinationConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DestinationConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getOnFailure();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DestinationConfigProperty> {
            private Object onFailure;

            public Builder onFailure(IResolvable onFailure) {
                this.onFailure = onFailure;
                return this;
            }

            public Builder onFailure(OnFailureProperty onFailure) {
                this.onFailure = onFailure;
                return this;
            }

            public DestinationConfigProperty build() {
                return new Jsii.Proxy(this.onFailure, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.DeploymentPreferenceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeploymentPreferenceProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        @NotNull
        public String getType();

        @Nullable
        default public List<String> getAlarms() {
            return null;
        }

        @Nullable
        default public List<String> getHooks() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeploymentPreferenceProperty> {
            private Object enabled;
            private String type;
            private List<String> alarms;
            private List<String> hooks;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder alarms(List<String> alarms) {
                this.alarms = alarms;
                return this;
            }

            public Builder hooks(List<String> hooks) {
                this.hooks = hooks;
                return this;
            }

            public DeploymentPreferenceProperty build() {
                return new Jsii.Proxy(this.enabled, this.type, this.alarms, this.hooks, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.DeadLetterQueueProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeadLetterQueueProperty
    extends JsiiSerializable {
        @NotNull
        public String getTargetArn();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeadLetterQueueProperty> {
            private String targetArn;
            private String type;

            public Builder targetArn(String targetArn) {
                this.targetArn = targetArn;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public DeadLetterQueueProperty build() {
                return new Jsii.Proxy(this.targetArn, this.type, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.CollectionSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CollectionSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getCollectionId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CollectionSAMPTProperty> {
            private String collectionId;

            public Builder collectionId(String collectionId) {
                this.collectionId = collectionId;
                return this;
            }

            public CollectionSAMPTProperty build() {
                return new Jsii.Proxy(this.collectionId, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.CloudWatchLogsEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudWatchLogsEventProperty
    extends JsiiSerializable {
        @NotNull
        public String getFilterPattern();

        @NotNull
        public String getLogGroupName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudWatchLogsEventProperty> {
            private String filterPattern;
            private String logGroupName;

            public Builder filterPattern(String filterPattern) {
                this.filterPattern = filterPattern;
                return this;
            }

            public Builder logGroupName(String logGroupName) {
                this.logGroupName = logGroupName;
                return this;
            }

            public CloudWatchLogsEventProperty build() {
                return new Jsii.Proxy(this.filterPattern, this.logGroupName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.CloudWatchEventEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudWatchEventEventProperty
    extends JsiiSerializable {
        @NotNull
        public Object getPattern();

        @Nullable
        default public String getInput() {
            return null;
        }

        @Nullable
        default public String getInputPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudWatchEventEventProperty> {
            private Object pattern;
            private String input;
            private String inputPath;

            public Builder pattern(Object pattern) {
                this.pattern = pattern;
                return this;
            }

            public Builder input(String input) {
                this.input = input;
                return this;
            }

            public Builder inputPath(String inputPath) {
                this.inputPath = inputPath;
                return this;
            }

            public CloudWatchEventEventProperty build() {
                return new Jsii.Proxy(this.pattern, this.input, this.inputPath, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.BucketSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BucketSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BucketSAMPTProperty> {
            private String bucketName;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public BucketSAMPTProperty build() {
                return new Jsii.Proxy(this.bucketName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.ApiEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApiEventProperty
    extends JsiiSerializable {
        @NotNull
        public String getMethod();

        @NotNull
        public String getPath();

        @Nullable
        default public String getRestApiId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ApiEventProperty> {
            private String method;
            private String path;
            private String restApiId;

            public Builder method(String method) {
                this.method = method;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder restApiId(String restApiId) {
                this.restApiId = restApiId;
                return this;
            }

            public ApiEventProperty build() {
                return new Jsii.Proxy(this.method, this.path, this.restApiId, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.AlexaSkillEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AlexaSkillEventProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getVariables() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AlexaSkillEventProperty> {
            private Object variables;

            public Builder variables(IResolvable variables) {
                this.variables = variables;
                return this;
            }

            public Builder variables(Map<String, String> variables) {
                this.variables = variables;
                return this;
            }

            public AlexaSkillEventProperty build() {
                return new Jsii.Proxy(this.variables, null);
            }
        }
    }
}

