/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sam;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.sam.;
import software.amazon.awscdk.services.sam.CfnFunction;
import software.amazon.awscdk.services.sam.CfnFunctionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction")
public class CfnFunction
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFunction.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);
    public static final String REQUIRED_TRANSFORM = (String)JsiiObject.jsiiStaticGet(CfnFunction.class, (String)"REQUIRED_TRANSFORM", String.class);

    protected CfnFunction(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFunction(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnFunction(Construct scope, String id, CfnFunctionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", Map.class));
    }

    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    public Object getCodeUri() {
        return this.jsiiGet("codeUri", Object.class);
    }

    public void setCodeUri(String value) {
        this.jsiiSet("codeUri", Objects.requireNonNull(value, "codeUri is required"));
    }

    public void setCodeUri(IResolvable value) {
        this.jsiiSet("codeUri", Objects.requireNonNull(value, "codeUri is required"));
    }

    public void setCodeUri(S3LocationProperty value) {
        this.jsiiSet("codeUri", Objects.requireNonNull(value, "codeUri is required"));
    }

    public String getHandler() {
        return (String)this.jsiiGet("handler", String.class);
    }

    public void setHandler(String value) {
        this.jsiiSet("handler", Objects.requireNonNull(value, "handler is required"));
    }

    public String getRuntime() {
        return (String)this.jsiiGet("runtime", String.class);
    }

    public void setRuntime(String value) {
        this.jsiiSet("runtime", Objects.requireNonNull(value, "runtime is required"));
    }

    public String getAutoPublishAlias() {
        return (String)this.jsiiGet("autoPublishAlias", String.class);
    }

    public void setAutoPublishAlias(String value) {
        this.jsiiSet("autoPublishAlias", value);
    }

    public Object getDeadLetterQueue() {
        return this.jsiiGet("deadLetterQueue", Object.class);
    }

    public void setDeadLetterQueue(IResolvable value) {
        this.jsiiSet("deadLetterQueue", value);
    }

    public void setDeadLetterQueue(DeadLetterQueueProperty value) {
        this.jsiiSet("deadLetterQueue", value);
    }

    public Object getDeploymentPreference() {
        return this.jsiiGet("deploymentPreference", Object.class);
    }

    public void setDeploymentPreference(IResolvable value) {
        this.jsiiSet("deploymentPreference", value);
    }

    public void setDeploymentPreference(DeploymentPreferenceProperty value) {
        this.jsiiSet("deploymentPreference", value);
    }

    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(String value) {
        this.jsiiSet("description", value);
    }

    public Object getEnvironment() {
        return this.jsiiGet("environment", Object.class);
    }

    public void setEnvironment(IResolvable value) {
        this.jsiiSet("environment", value);
    }

    public void setEnvironment(FunctionEnvironmentProperty value) {
        this.jsiiSet("environment", value);
    }

    public Object getEvents() {
        return this.jsiiGet("events", Object.class);
    }

    public void setEvents(IResolvable value) {
        this.jsiiSet("events", value);
    }

    public void setEvents(Map<String, Object> value) {
        this.jsiiSet("events", value);
    }

    public String getFunctionName() {
        return (String)this.jsiiGet("functionName", String.class);
    }

    public void setFunctionName(String value) {
        this.jsiiSet("functionName", value);
    }

    public String getKmsKeyArn() {
        return (String)this.jsiiGet("kmsKeyArn", String.class);
    }

    public void setKmsKeyArn(String value) {
        this.jsiiSet("kmsKeyArn", value);
    }

    public List<String> getLayers() {
        return Optional.ofNullable((List)this.jsiiGet("layers", List.class)).map(Collections::unmodifiableList).orElse(null);
    }

    public void setLayers(List<String> value) {
        this.jsiiSet("layers", value);
    }

    public Number getMemorySize() {
        return (Number)this.jsiiGet("memorySize", Number.class);
    }

    public void setMemorySize(Number value) {
        this.jsiiSet("memorySize", value);
    }

    public String getPermissionsBoundary() {
        return (String)this.jsiiGet("permissionsBoundary", String.class);
    }

    public void setPermissionsBoundary(String value) {
        this.jsiiSet("permissionsBoundary", value);
    }

    public Object getPolicies() {
        return this.jsiiGet("policies", Object.class);
    }

    public void setPolicies(String value) {
        this.jsiiSet("policies", value);
    }

    public void setPolicies(IResolvable value) {
        this.jsiiSet("policies", value);
    }

    public void setPolicies(IAMPolicyDocumentProperty value) {
        this.jsiiSet("policies", value);
    }

    public void setPolicies(List<Object> value) {
        this.jsiiSet("policies", value);
    }

    public Number getReservedConcurrentExecutions() {
        return (Number)this.jsiiGet("reservedConcurrentExecutions", Number.class);
    }

    public void setReservedConcurrentExecutions(Number value) {
        this.jsiiSet("reservedConcurrentExecutions", value);
    }

    public String getRole() {
        return (String)this.jsiiGet("role", String.class);
    }

    public void setRole(String value) {
        this.jsiiSet("role", value);
    }

    public Number getTimeout() {
        return (Number)this.jsiiGet("timeout", Number.class);
    }

    public void setTimeout(Number value) {
        this.jsiiSet("timeout", value);
    }

    public String getTracing() {
        return (String)this.jsiiGet("tracing", String.class);
    }

    public void setTracing(String value) {
        this.jsiiSet("tracing", value);
    }

    public Object getVpcConfig() {
        return this.jsiiGet("vpcConfig", Object.class);
    }

    public void setVpcConfig(IResolvable value) {
        this.jsiiSet("vpcConfig", value);
    }

    public void setVpcConfig(VpcConfigProperty value) {
        this.jsiiSet("vpcConfig", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final CfnFunctionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnFunctionProps.Builder();
        }

        public Builder codeUri(String codeUri) {
            this.props.codeUri(codeUri);
            return this;
        }

        public Builder codeUri(IResolvable codeUri) {
            this.props.codeUri(codeUri);
            return this;
        }

        public Builder codeUri(S3LocationProperty codeUri) {
            this.props.codeUri(codeUri);
            return this;
        }

        public Builder handler(String handler) {
            this.props.handler(handler);
            return this;
        }

        public Builder runtime(String runtime) {
            this.props.runtime(runtime);
            return this;
        }

        public Builder autoPublishAlias(String autoPublishAlias) {
            this.props.autoPublishAlias(autoPublishAlias);
            return this;
        }

        public Builder deadLetterQueue(IResolvable deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder deadLetterQueue(DeadLetterQueueProperty deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder deploymentPreference(IResolvable deploymentPreference) {
            this.props.deploymentPreference(deploymentPreference);
            return this;
        }

        public Builder deploymentPreference(DeploymentPreferenceProperty deploymentPreference) {
            this.props.deploymentPreference(deploymentPreference);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder environment(IResolvable environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder environment(FunctionEnvironmentProperty environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder events(IResolvable events) {
            this.props.events(events);
            return this;
        }

        public Builder events(Map<String, Object> events) {
            this.props.events(events);
            return this;
        }

        public Builder functionName(String functionName) {
            this.props.functionName(functionName);
            return this;
        }

        public Builder kmsKeyArn(String kmsKeyArn) {
            this.props.kmsKeyArn(kmsKeyArn);
            return this;
        }

        public Builder layers(List<String> layers) {
            this.props.layers(layers);
            return this;
        }

        public Builder memorySize(Number memorySize) {
            this.props.memorySize(memorySize);
            return this;
        }

        public Builder permissionsBoundary(String permissionsBoundary) {
            this.props.permissionsBoundary(permissionsBoundary);
            return this;
        }

        public Builder policies(String policies) {
            this.props.policies(policies);
            return this;
        }

        public Builder policies(IResolvable policies) {
            this.props.policies(policies);
            return this;
        }

        public Builder policies(IAMPolicyDocumentProperty policies) {
            this.props.policies(policies);
            return this;
        }

        public Builder policies(List<Object> policies) {
            this.props.policies(policies);
            return this;
        }

        public Builder reservedConcurrentExecutions(Number reservedConcurrentExecutions) {
            this.props.reservedConcurrentExecutions(reservedConcurrentExecutions);
            return this;
        }

        public Builder role(String role) {
            this.props.role(role);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder timeout(Number timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder tracing(String tracing) {
            this.props.tracing(tracing);
            return this;
        }

        public Builder vpcConfig(IResolvable vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        public Builder vpcConfig(VpcConfigProperty vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        public CfnFunction build() {
            return new CfnFunction(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.VpcConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcConfigProperty
    extends JsiiSerializable {
        public List<String> getSecurityGroupIds();

        public List<String> getSubnetIds();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<String> securityGroupIds;
            private List<String> subnetIds;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public VpcConfigProperty build() {
                return new Jsii.Proxy(this.securityGroupIds, this.subnetIds, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.TopicSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TopicSAMPTProperty
    extends JsiiSerializable {
        public String getTopicName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String topicName;

            public Builder topicName(String topicName) {
                this.topicName = topicName;
                return this;
            }

            public TopicSAMPTProperty build() {
                return new Jsii.Proxy(this.topicName, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.TableStreamSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableStreamSAMPTProperty
    extends JsiiSerializable {
        public String getStreamName();

        public String getTableName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String streamName;
            private String tableName;

            public Builder streamName(String streamName) {
                this.streamName = streamName;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public TableStreamSAMPTProperty build() {
                return new Jsii.Proxy(this.streamName, this.tableName, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.TableSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableSAMPTProperty
    extends JsiiSerializable {
        public String getTableName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String tableName;

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public TableSAMPTProperty build() {
                return new Jsii.Proxy(this.tableName, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.StreamSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StreamSAMPTProperty
    extends JsiiSerializable {
        public String getStreamName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String streamName;

            public Builder streamName(String streamName) {
                this.streamName = streamName;
                return this;
            }

            public StreamSAMPTProperty build() {
                return new Jsii.Proxy(this.streamName, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.StateMachineSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StateMachineSAMPTProperty
    extends JsiiSerializable {
        public String getStateMachineName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String stateMachineName;

            public Builder stateMachineName(String stateMachineName) {
                this.stateMachineName = stateMachineName;
                return this;
            }

            public StateMachineSAMPTProperty build() {
                return new Jsii.Proxy(this.stateMachineName, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.ScheduleEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScheduleEventProperty
    extends JsiiSerializable {
        public String getSchedule();

        default public String getInput() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String schedule;
            private String input;

            public Builder schedule(String schedule) {
                this.schedule = schedule;
                return this;
            }

            public Builder input(String input) {
                this.input = input;
                return this;
            }

            public ScheduleEventProperty build() {
                return new Jsii.Proxy(this.schedule, this.input, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.SQSEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SQSEventProperty
    extends JsiiSerializable {
        public String getQueue();

        default public Number getBatchSize() {
            return null;
        }

        default public Object getEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String queue;
            private Number batchSize;
            private Object enabled;

            public Builder queue(String queue) {
                this.queue = queue;
                return this;
            }

            public Builder batchSize(Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public SQSEventProperty build() {
                return new Jsii.Proxy(this.queue, this.batchSize, this.enabled, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.SNSEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SNSEventProperty
    extends JsiiSerializable {
        public String getTopic();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String topic;

            public Builder topic(String topic) {
                this.topic = topic;
                return this;
            }

            public SNSEventProperty build() {
                return new Jsii.Proxy(this.topic, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.SAMPolicyTemplateProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SAMPolicyTemplateProperty
    extends JsiiSerializable {
        default public Object getAmiDescribePolicy() {
            return null;
        }

        default public Object getCloudFormationDescribeStacksPolicy() {
            return null;
        }

        default public Object getCloudWatchPutMetricPolicy() {
            return null;
        }

        default public Object getDynamoDbCrudPolicy() {
            return null;
        }

        default public Object getDynamoDbReadPolicy() {
            return null;
        }

        default public Object getDynamoDbStreamReadPolicy() {
            return null;
        }

        default public Object getEc2DescribePolicy() {
            return null;
        }

        default public Object getElasticsearchHttpPostPolicy() {
            return null;
        }

        default public Object getFilterLogEventsPolicy() {
            return null;
        }

        default public Object getKinesisCrudPolicy() {
            return null;
        }

        default public Object getKinesisStreamReadPolicy() {
            return null;
        }

        default public Object getKmsDecryptPolicy() {
            return null;
        }

        default public Object getLambdaInvokePolicy() {
            return null;
        }

        default public Object getRekognitionDetectOnlyPolicy() {
            return null;
        }

        default public Object getRekognitionLabelsPolicy() {
            return null;
        }

        default public Object getRekognitionNoDataAccessPolicy() {
            return null;
        }

        default public Object getRekognitionReadPolicy() {
            return null;
        }

        default public Object getRekognitionWriteOnlyAccessPolicy() {
            return null;
        }

        default public Object getS3CrudPolicy() {
            return null;
        }

        default public Object getS3ReadPolicy() {
            return null;
        }

        default public Object getSesBulkTemplatedCrudPolicy() {
            return null;
        }

        default public Object getSesCrudPolicy() {
            return null;
        }

        default public Object getSesEmailTemplateCrudPolicy() {
            return null;
        }

        default public Object getSesSendBouncePolicy() {
            return null;
        }

        default public Object getSnsCrudPolicy() {
            return null;
        }

        default public Object getSnsPublishMessagePolicy() {
            return null;
        }

        default public Object getSqsPollerPolicy() {
            return null;
        }

        default public Object getSqsSendMessagePolicy() {
            return null;
        }

        default public Object getStepFunctionsExecutionPolicy() {
            return null;
        }

        default public Object getVpcAccessPolicy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object amiDescribePolicy;
            private Object cloudFormationDescribeStacksPolicy;
            private Object cloudWatchPutMetricPolicy;
            private Object dynamoDbCrudPolicy;
            private Object dynamoDbReadPolicy;
            private Object dynamoDbStreamReadPolicy;
            private Object ec2DescribePolicy;
            private Object elasticsearchHttpPostPolicy;
            private Object filterLogEventsPolicy;
            private Object kinesisCrudPolicy;
            private Object kinesisStreamReadPolicy;
            private Object kmsDecryptPolicy;
            private Object lambdaInvokePolicy;
            private Object rekognitionDetectOnlyPolicy;
            private Object rekognitionLabelsPolicy;
            private Object rekognitionNoDataAccessPolicy;
            private Object rekognitionReadPolicy;
            private Object rekognitionWriteOnlyAccessPolicy;
            private Object s3CrudPolicy;
            private Object s3ReadPolicy;
            private Object sesBulkTemplatedCrudPolicy;
            private Object sesCrudPolicy;
            private Object sesEmailTemplateCrudPolicy;
            private Object sesSendBouncePolicy;
            private Object snsCrudPolicy;
            private Object snsPublishMessagePolicy;
            private Object sqsPollerPolicy;
            private Object sqsSendMessagePolicy;
            private Object stepFunctionsExecutionPolicy;
            private Object vpcAccessPolicy;

            public Builder amiDescribePolicy(IResolvable amiDescribePolicy) {
                this.amiDescribePolicy = amiDescribePolicy;
                return this;
            }

            public Builder amiDescribePolicy(EmptySAMPTProperty amiDescribePolicy) {
                this.amiDescribePolicy = amiDescribePolicy;
                return this;
            }

            public Builder cloudFormationDescribeStacksPolicy(IResolvable cloudFormationDescribeStacksPolicy) {
                this.cloudFormationDescribeStacksPolicy = cloudFormationDescribeStacksPolicy;
                return this;
            }

            public Builder cloudFormationDescribeStacksPolicy(EmptySAMPTProperty cloudFormationDescribeStacksPolicy) {
                this.cloudFormationDescribeStacksPolicy = cloudFormationDescribeStacksPolicy;
                return this;
            }

            public Builder cloudWatchPutMetricPolicy(IResolvable cloudWatchPutMetricPolicy) {
                this.cloudWatchPutMetricPolicy = cloudWatchPutMetricPolicy;
                return this;
            }

            public Builder cloudWatchPutMetricPolicy(EmptySAMPTProperty cloudWatchPutMetricPolicy) {
                this.cloudWatchPutMetricPolicy = cloudWatchPutMetricPolicy;
                return this;
            }

            public Builder dynamoDbCrudPolicy(IResolvable dynamoDbCrudPolicy) {
                this.dynamoDbCrudPolicy = dynamoDbCrudPolicy;
                return this;
            }

            public Builder dynamoDbCrudPolicy(TableSAMPTProperty dynamoDbCrudPolicy) {
                this.dynamoDbCrudPolicy = dynamoDbCrudPolicy;
                return this;
            }

            public Builder dynamoDbReadPolicy(IResolvable dynamoDbReadPolicy) {
                this.dynamoDbReadPolicy = dynamoDbReadPolicy;
                return this;
            }

            public Builder dynamoDbReadPolicy(TableSAMPTProperty dynamoDbReadPolicy) {
                this.dynamoDbReadPolicy = dynamoDbReadPolicy;
                return this;
            }

            public Builder dynamoDbStreamReadPolicy(IResolvable dynamoDbStreamReadPolicy) {
                this.dynamoDbStreamReadPolicy = dynamoDbStreamReadPolicy;
                return this;
            }

            public Builder dynamoDbStreamReadPolicy(TableStreamSAMPTProperty dynamoDbStreamReadPolicy) {
                this.dynamoDbStreamReadPolicy = dynamoDbStreamReadPolicy;
                return this;
            }

            public Builder ec2DescribePolicy(IResolvable ec2DescribePolicy) {
                this.ec2DescribePolicy = ec2DescribePolicy;
                return this;
            }

            public Builder ec2DescribePolicy(EmptySAMPTProperty ec2DescribePolicy) {
                this.ec2DescribePolicy = ec2DescribePolicy;
                return this;
            }

            public Builder elasticsearchHttpPostPolicy(IResolvable elasticsearchHttpPostPolicy) {
                this.elasticsearchHttpPostPolicy = elasticsearchHttpPostPolicy;
                return this;
            }

            public Builder elasticsearchHttpPostPolicy(DomainSAMPTProperty elasticsearchHttpPostPolicy) {
                this.elasticsearchHttpPostPolicy = elasticsearchHttpPostPolicy;
                return this;
            }

            public Builder filterLogEventsPolicy(IResolvable filterLogEventsPolicy) {
                this.filterLogEventsPolicy = filterLogEventsPolicy;
                return this;
            }

            public Builder filterLogEventsPolicy(LogGroupSAMPTProperty filterLogEventsPolicy) {
                this.filterLogEventsPolicy = filterLogEventsPolicy;
                return this;
            }

            public Builder kinesisCrudPolicy(IResolvable kinesisCrudPolicy) {
                this.kinesisCrudPolicy = kinesisCrudPolicy;
                return this;
            }

            public Builder kinesisCrudPolicy(StreamSAMPTProperty kinesisCrudPolicy) {
                this.kinesisCrudPolicy = kinesisCrudPolicy;
                return this;
            }

            public Builder kinesisStreamReadPolicy(IResolvable kinesisStreamReadPolicy) {
                this.kinesisStreamReadPolicy = kinesisStreamReadPolicy;
                return this;
            }

            public Builder kinesisStreamReadPolicy(StreamSAMPTProperty kinesisStreamReadPolicy) {
                this.kinesisStreamReadPolicy = kinesisStreamReadPolicy;
                return this;
            }

            public Builder kmsDecryptPolicy(IResolvable kmsDecryptPolicy) {
                this.kmsDecryptPolicy = kmsDecryptPolicy;
                return this;
            }

            public Builder kmsDecryptPolicy(KeySAMPTProperty kmsDecryptPolicy) {
                this.kmsDecryptPolicy = kmsDecryptPolicy;
                return this;
            }

            public Builder lambdaInvokePolicy(IResolvable lambdaInvokePolicy) {
                this.lambdaInvokePolicy = lambdaInvokePolicy;
                return this;
            }

            public Builder lambdaInvokePolicy(FunctionSAMPTProperty lambdaInvokePolicy) {
                this.lambdaInvokePolicy = lambdaInvokePolicy;
                return this;
            }

            public Builder rekognitionDetectOnlyPolicy(IResolvable rekognitionDetectOnlyPolicy) {
                this.rekognitionDetectOnlyPolicy = rekognitionDetectOnlyPolicy;
                return this;
            }

            public Builder rekognitionDetectOnlyPolicy(EmptySAMPTProperty rekognitionDetectOnlyPolicy) {
                this.rekognitionDetectOnlyPolicy = rekognitionDetectOnlyPolicy;
                return this;
            }

            public Builder rekognitionLabelsPolicy(IResolvable rekognitionLabelsPolicy) {
                this.rekognitionLabelsPolicy = rekognitionLabelsPolicy;
                return this;
            }

            public Builder rekognitionLabelsPolicy(EmptySAMPTProperty rekognitionLabelsPolicy) {
                this.rekognitionLabelsPolicy = rekognitionLabelsPolicy;
                return this;
            }

            public Builder rekognitionNoDataAccessPolicy(IResolvable rekognitionNoDataAccessPolicy) {
                this.rekognitionNoDataAccessPolicy = rekognitionNoDataAccessPolicy;
                return this;
            }

            public Builder rekognitionNoDataAccessPolicy(CollectionSAMPTProperty rekognitionNoDataAccessPolicy) {
                this.rekognitionNoDataAccessPolicy = rekognitionNoDataAccessPolicy;
                return this;
            }

            public Builder rekognitionReadPolicy(IResolvable rekognitionReadPolicy) {
                this.rekognitionReadPolicy = rekognitionReadPolicy;
                return this;
            }

            public Builder rekognitionReadPolicy(CollectionSAMPTProperty rekognitionReadPolicy) {
                this.rekognitionReadPolicy = rekognitionReadPolicy;
                return this;
            }

            public Builder rekognitionWriteOnlyAccessPolicy(IResolvable rekognitionWriteOnlyAccessPolicy) {
                this.rekognitionWriteOnlyAccessPolicy = rekognitionWriteOnlyAccessPolicy;
                return this;
            }

            public Builder rekognitionWriteOnlyAccessPolicy(CollectionSAMPTProperty rekognitionWriteOnlyAccessPolicy) {
                this.rekognitionWriteOnlyAccessPolicy = rekognitionWriteOnlyAccessPolicy;
                return this;
            }

            public Builder s3CrudPolicy(IResolvable s3CrudPolicy) {
                this.s3CrudPolicy = s3CrudPolicy;
                return this;
            }

            public Builder s3CrudPolicy(BucketSAMPTProperty s3CrudPolicy) {
                this.s3CrudPolicy = s3CrudPolicy;
                return this;
            }

            public Builder s3ReadPolicy(IResolvable s3ReadPolicy) {
                this.s3ReadPolicy = s3ReadPolicy;
                return this;
            }

            public Builder s3ReadPolicy(BucketSAMPTProperty s3ReadPolicy) {
                this.s3ReadPolicy = s3ReadPolicy;
                return this;
            }

            public Builder sesBulkTemplatedCrudPolicy(IResolvable sesBulkTemplatedCrudPolicy) {
                this.sesBulkTemplatedCrudPolicy = sesBulkTemplatedCrudPolicy;
                return this;
            }

            public Builder sesBulkTemplatedCrudPolicy(IdentitySAMPTProperty sesBulkTemplatedCrudPolicy) {
                this.sesBulkTemplatedCrudPolicy = sesBulkTemplatedCrudPolicy;
                return this;
            }

            public Builder sesCrudPolicy(IResolvable sesCrudPolicy) {
                this.sesCrudPolicy = sesCrudPolicy;
                return this;
            }

            public Builder sesCrudPolicy(IdentitySAMPTProperty sesCrudPolicy) {
                this.sesCrudPolicy = sesCrudPolicy;
                return this;
            }

            public Builder sesEmailTemplateCrudPolicy(IResolvable sesEmailTemplateCrudPolicy) {
                this.sesEmailTemplateCrudPolicy = sesEmailTemplateCrudPolicy;
                return this;
            }

            public Builder sesEmailTemplateCrudPolicy(EmptySAMPTProperty sesEmailTemplateCrudPolicy) {
                this.sesEmailTemplateCrudPolicy = sesEmailTemplateCrudPolicy;
                return this;
            }

            public Builder sesSendBouncePolicy(IResolvable sesSendBouncePolicy) {
                this.sesSendBouncePolicy = sesSendBouncePolicy;
                return this;
            }

            public Builder sesSendBouncePolicy(IdentitySAMPTProperty sesSendBouncePolicy) {
                this.sesSendBouncePolicy = sesSendBouncePolicy;
                return this;
            }

            public Builder snsCrudPolicy(IResolvable snsCrudPolicy) {
                this.snsCrudPolicy = snsCrudPolicy;
                return this;
            }

            public Builder snsCrudPolicy(TopicSAMPTProperty snsCrudPolicy) {
                this.snsCrudPolicy = snsCrudPolicy;
                return this;
            }

            public Builder snsPublishMessagePolicy(IResolvable snsPublishMessagePolicy) {
                this.snsPublishMessagePolicy = snsPublishMessagePolicy;
                return this;
            }

            public Builder snsPublishMessagePolicy(TopicSAMPTProperty snsPublishMessagePolicy) {
                this.snsPublishMessagePolicy = snsPublishMessagePolicy;
                return this;
            }

            public Builder sqsPollerPolicy(IResolvable sqsPollerPolicy) {
                this.sqsPollerPolicy = sqsPollerPolicy;
                return this;
            }

            public Builder sqsPollerPolicy(QueueSAMPTProperty sqsPollerPolicy) {
                this.sqsPollerPolicy = sqsPollerPolicy;
                return this;
            }

            public Builder sqsSendMessagePolicy(IResolvable sqsSendMessagePolicy) {
                this.sqsSendMessagePolicy = sqsSendMessagePolicy;
                return this;
            }

            public Builder sqsSendMessagePolicy(QueueSAMPTProperty sqsSendMessagePolicy) {
                this.sqsSendMessagePolicy = sqsSendMessagePolicy;
                return this;
            }

            public Builder stepFunctionsExecutionPolicy(IResolvable stepFunctionsExecutionPolicy) {
                this.stepFunctionsExecutionPolicy = stepFunctionsExecutionPolicy;
                return this;
            }

            public Builder stepFunctionsExecutionPolicy(StateMachineSAMPTProperty stepFunctionsExecutionPolicy) {
                this.stepFunctionsExecutionPolicy = stepFunctionsExecutionPolicy;
                return this;
            }

            public Builder vpcAccessPolicy(IResolvable vpcAccessPolicy) {
                this.vpcAccessPolicy = vpcAccessPolicy;
                return this;
            }

            public Builder vpcAccessPolicy(EmptySAMPTProperty vpcAccessPolicy) {
                this.vpcAccessPolicy = vpcAccessPolicy;
                return this;
            }

            public SAMPolicyTemplateProperty build() {
                return new Jsii.Proxy(this.amiDescribePolicy, this.cloudFormationDescribeStacksPolicy, this.cloudWatchPutMetricPolicy, this.dynamoDbCrudPolicy, this.dynamoDbReadPolicy, this.dynamoDbStreamReadPolicy, this.ec2DescribePolicy, this.elasticsearchHttpPostPolicy, this.filterLogEventsPolicy, this.kinesisCrudPolicy, this.kinesisStreamReadPolicy, this.kmsDecryptPolicy, this.lambdaInvokePolicy, this.rekognitionDetectOnlyPolicy, this.rekognitionLabelsPolicy, this.rekognitionNoDataAccessPolicy, this.rekognitionReadPolicy, this.rekognitionWriteOnlyAccessPolicy, this.s3CrudPolicy, this.s3ReadPolicy, this.sesBulkTemplatedCrudPolicy, this.sesCrudPolicy, this.sesEmailTemplateCrudPolicy, this.sesSendBouncePolicy, this.snsCrudPolicy, this.snsPublishMessagePolicy, this.sqsPollerPolicy, this.sqsSendMessagePolicy, this.stepFunctionsExecutionPolicy, this.vpcAccessPolicy, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.S3NotificationFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3NotificationFilterProperty
    extends JsiiSerializable {
        public Object getS3Key();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object s3Key;

            public Builder s3Key(IResolvable s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            public Builder s3Key(S3KeyFilterProperty s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            public S3NotificationFilterProperty build() {
                return new Jsii.Proxy(this.s3Key, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.S3LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LocationProperty
    extends JsiiSerializable {
        public String getBucket();

        public String getKey();

        default public Number getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String bucket;
            private String key;
            private Number version;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder version(Number version) {
                this.version = version;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this.bucket, this.key, this.version, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.S3KeyFilterRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3KeyFilterRuleProperty
    extends JsiiSerializable {
        public String getName();

        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String name;
            private String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public S3KeyFilterRuleProperty build() {
                return new Jsii.Proxy(this.name, this.value, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.S3KeyFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3KeyFilterProperty
    extends JsiiSerializable {
        public Object getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object rules;

            public Builder rules(IResolvable rules) {
                this.rules = rules;
                return this;
            }

            public Builder rules(List<Object> rules) {
                this.rules = rules;
                return this;
            }

            public S3KeyFilterProperty build() {
                return new Jsii.Proxy(this.rules, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.S3EventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3EventProperty
    extends JsiiSerializable {
        public String getBucket();

        public Object getEvents();

        default public Object getFilter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String bucket;
            private Object events;
            private Object filter;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder events(String events) {
                this.events = events;
                return this;
            }

            public Builder events(IResolvable events) {
                this.events = events;
                return this;
            }

            public Builder events(List<String> events) {
                this.events = events;
                return this;
            }

            public Builder filter(IResolvable filter) {
                this.filter = filter;
                return this;
            }

            public Builder filter(S3NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            public S3EventProperty build() {
                return new Jsii.Proxy(this.bucket, this.events, this.filter, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.QueueSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface QueueSAMPTProperty
    extends JsiiSerializable {
        public String getQueueName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String queueName;

            public Builder queueName(String queueName) {
                this.queueName = queueName;
                return this;
            }

            public QueueSAMPTProperty build() {
                return new Jsii.Proxy(this.queueName, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.LogGroupSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LogGroupSAMPTProperty
    extends JsiiSerializable {
        public String getLogGroupName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String logGroupName;

            public Builder logGroupName(String logGroupName) {
                this.logGroupName = logGroupName;
                return this;
            }

            public LogGroupSAMPTProperty build() {
                return new Jsii.Proxy(this.logGroupName, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.KinesisEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KinesisEventProperty
    extends JsiiSerializable {
        public String getStartingPosition();

        public String getStream();

        default public Number getBatchSize() {
            return null;
        }

        default public Object getEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String startingPosition;
            private String stream;
            private Number batchSize;
            private Object enabled;

            public Builder startingPosition(String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            public Builder stream(String stream) {
                this.stream = stream;
                return this;
            }

            public Builder batchSize(Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public KinesisEventProperty build() {
                return new Jsii.Proxy(this.startingPosition, this.stream, this.batchSize, this.enabled, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.KeySAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KeySAMPTProperty
    extends JsiiSerializable {
        public String getKeyId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String keyId;

            public Builder keyId(String keyId) {
                this.keyId = keyId;
                return this;
            }

            public KeySAMPTProperty build() {
                return new Jsii.Proxy(this.keyId, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.IoTRuleEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IoTRuleEventProperty
    extends JsiiSerializable {
        public String getSql();

        default public String getAwsIotSqlVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String sql;
            private String awsIotSqlVersion;

            public Builder sql(String sql) {
                this.sql = sql;
                return this;
            }

            public Builder awsIotSqlVersion(String awsIotSqlVersion) {
                this.awsIotSqlVersion = awsIotSqlVersion;
                return this;
            }

            public IoTRuleEventProperty build() {
                return new Jsii.Proxy(this.sql, this.awsIotSqlVersion, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.IdentitySAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IdentitySAMPTProperty
    extends JsiiSerializable {
        public String getIdentityName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String identityName;

            public Builder identityName(String identityName) {
                this.identityName = identityName;
                return this;
            }

            public IdentitySAMPTProperty build() {
                return new Jsii.Proxy(this.identityName, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.IAMPolicyDocumentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IAMPolicyDocumentProperty
    extends JsiiSerializable {
        public Object getStatement();
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.FunctionSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FunctionSAMPTProperty
    extends JsiiSerializable {
        public String getFunctionName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String functionName;

            public Builder functionName(String functionName) {
                this.functionName = functionName;
                return this;
            }

            public FunctionSAMPTProperty build() {
                return new Jsii.Proxy(this.functionName, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.FunctionEnvironmentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FunctionEnvironmentProperty
    extends JsiiSerializable {
        public Object getVariables();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object variables;

            public Builder variables(IResolvable variables) {
                this.variables = variables;
                return this;
            }

            public Builder variables(Map<String, String> variables) {
                this.variables = variables;
                return this;
            }

            public FunctionEnvironmentProperty build() {
                return new Jsii.Proxy(this.variables, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.EventSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EventSourceProperty
    extends JsiiSerializable {
        public Object getProperties();

        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object properties;
            private String type;

            public Builder properties(IResolvable properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(AlexaSkillEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(ApiEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(CloudWatchEventEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(DynamoDBEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(IoTRuleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(KinesisEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(S3EventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(SNSEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(SQSEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(ScheduleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public EventSourceProperty build() {
                return new Jsii.Proxy(this.properties, this.type, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.EmptySAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EmptySAMPTProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public EmptySAMPTProperty build() {
                return new Jsii.Proxy(null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.DynamoDBEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DynamoDBEventProperty
    extends JsiiSerializable {
        public String getStartingPosition();

        public String getStream();

        default public Number getBatchSize() {
            return null;
        }

        default public Object getEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String startingPosition;
            private String stream;
            private Number batchSize;
            private Object enabled;

            public Builder startingPosition(String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            public Builder stream(String stream) {
                this.stream = stream;
                return this;
            }

            public Builder batchSize(Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public DynamoDBEventProperty build() {
                return new Jsii.Proxy(this.startingPosition, this.stream, this.batchSize, this.enabled, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.DomainSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DomainSAMPTProperty
    extends JsiiSerializable {
        public String getDomainName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String domainName;

            public Builder domainName(String domainName) {
                this.domainName = domainName;
                return this;
            }

            public DomainSAMPTProperty build() {
                return new Jsii.Proxy(this.domainName, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.DeploymentPreferenceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeploymentPreferenceProperty
    extends JsiiSerializable {
        public Object getEnabled();

        public String getType();

        default public List<String> getAlarms() {
            return null;
        }

        default public List<String> getHooks() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object enabled;
            private String type;
            private List<String> alarms;
            private List<String> hooks;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder alarms(List<String> alarms) {
                this.alarms = alarms;
                return this;
            }

            public Builder hooks(List<String> hooks) {
                this.hooks = hooks;
                return this;
            }

            public DeploymentPreferenceProperty build() {
                return new Jsii.Proxy(this.enabled, this.type, this.alarms, this.hooks, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.DeadLetterQueueProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeadLetterQueueProperty
    extends JsiiSerializable {
        public String getTargetArn();

        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String targetArn;
            private String type;

            public Builder targetArn(String targetArn) {
                this.targetArn = targetArn;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public DeadLetterQueueProperty build() {
                return new Jsii.Proxy(this.targetArn, this.type, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.CollectionSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CollectionSAMPTProperty
    extends JsiiSerializable {
        public String getCollectionId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String collectionId;

            public Builder collectionId(String collectionId) {
                this.collectionId = collectionId;
                return this;
            }

            public CollectionSAMPTProperty build() {
                return new Jsii.Proxy(this.collectionId, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.CloudWatchEventEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudWatchEventEventProperty
    extends JsiiSerializable {
        public Object getPattern();

        default public String getInput() {
            return null;
        }

        default public String getInputPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object pattern;
            private String input;
            private String inputPath;

            public Builder pattern(Object pattern) {
                this.pattern = pattern;
                return this;
            }

            public Builder input(String input) {
                this.input = input;
                return this;
            }

            public Builder inputPath(String inputPath) {
                this.inputPath = inputPath;
                return this;
            }

            public CloudWatchEventEventProperty build() {
                return new Jsii.Proxy(this.pattern, this.input, this.inputPath, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.BucketSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BucketSAMPTProperty
    extends JsiiSerializable {
        public String getBucketName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String bucketName;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public BucketSAMPTProperty build() {
                return new Jsii.Proxy(this.bucketName, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.ApiEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApiEventProperty
    extends JsiiSerializable {
        public String getMethod();

        public String getPath();

        default public String getRestApiId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String method;
            private String path;
            private String restApiId;

            public Builder method(String method) {
                this.method = method;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder restApiId(String restApiId) {
                this.restApiId = restApiId;
                return this;
            }

            public ApiEventProperty build() {
                return new Jsii.Proxy(this.method, this.path, this.restApiId, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.AlexaSkillEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AlexaSkillEventProperty
    extends JsiiSerializable {
        default public Object getVariables() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object variables;

            public Builder variables(IResolvable variables) {
                this.variables = variables;
                return this;
            }

            public Builder variables(Map<String, String> variables) {
                this.variables = variables;
                return this;
            }

            public AlexaSkillEventProperty build() {
                return new Jsii.Proxy(this.variables, null);
            }
        }
    }
}

