/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sam;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.sam.;
import software.amazon.awscdk.services.sam.CfnLayerVersion;
import software.amazon.awscdk.services.sam.CfnLayerVersionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnLayerVersion")
public class CfnLayerVersion
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnLayerVersion.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));
    public static final String REQUIRED_TRANSFORM = (String)JsiiObject.jsiiStaticGet(CfnLayerVersion.class, (String)"REQUIRED_TRANSFORM", (NativeType)NativeType.forClass(String.class));

    protected CfnLayerVersion(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLayerVersion(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnLayerVersion(@NotNull Construct scope, @NotNull String id, @Nullable CfnLayerVersionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnLayerVersion(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Nullable
    public List<String> getCompatibleRuntimes() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"compatibleRuntimes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setCompatibleRuntimes(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"compatibleRuntimes", value);
    }

    @Nullable
    public Object getContentUri() {
        return Kernel.get((Object)((Object)this), (String)"contentUri", (NativeType)NativeType.forClass(Object.class));
    }

    public void setContentUri(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"contentUri", (Object)value);
    }

    public void setContentUri(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"contentUri", (Object)value);
    }

    public void setContentUri(@Nullable S3LocationProperty value) {
        Kernel.set((Object)((Object)this), (String)"contentUri", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)((Object)this), (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"description", (Object)value);
    }

    @Nullable
    public String getLayerName() {
        return (String)Kernel.get((Object)((Object)this), (String)"layerName", (NativeType)NativeType.forClass(String.class));
    }

    public void setLayerName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"layerName", (Object)value);
    }

    @Nullable
    public String getLicenseInfo() {
        return (String)Kernel.get((Object)((Object)this), (String)"licenseInfo", (NativeType)NativeType.forClass(String.class));
    }

    public void setLicenseInfo(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"licenseInfo", (Object)value);
    }

    @Nullable
    public String getRetentionPolicy() {
        return (String)Kernel.get((Object)((Object)this), (String)"retentionPolicy", (NativeType)NativeType.forClass(String.class));
    }

    public void setRetentionPolicy(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"retentionPolicy", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnLayerVersion> {
        private final Construct scope;
        private final String id;
        private CfnLayerVersionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder compatibleRuntimes(List<String> compatibleRuntimes) {
            this.props().compatibleRuntimes(compatibleRuntimes);
            return this;
        }

        public Builder contentUri(String contentUri) {
            this.props().contentUri(contentUri);
            return this;
        }

        public Builder contentUri(IResolvable contentUri) {
            this.props().contentUri(contentUri);
            return this;
        }

        public Builder contentUri(S3LocationProperty contentUri) {
            this.props().contentUri(contentUri);
            return this;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder layerName(String layerName) {
            this.props().layerName(layerName);
            return this;
        }

        public Builder licenseInfo(String licenseInfo) {
            this.props().licenseInfo(licenseInfo);
            return this;
        }

        public Builder retentionPolicy(String retentionPolicy) {
            this.props().retentionPolicy(retentionPolicy);
            return this;
        }

        public CfnLayerVersion build() {
            return new CfnLayerVersion(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnLayerVersionProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnLayerVersionProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnLayerVersion.S3LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @NotNull
        public String getKey();

        @Nullable
        default public Number getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LocationProperty> {
            String bucket;
            String key;
            Number version;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder version(Number version) {
                this.version = version;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

