/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sam;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.sam.$Module;
import software.amazon.awscdk.services.sam.CfnFunction;
import software.amazon.awscdk.services.sam.CfnFunctionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction")
public class CfnFunction
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFunction.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));
    public static final String REQUIRED_TRANSFORM = (String)JsiiObject.jsiiStaticGet(CfnFunction.class, (String)"REQUIRED_TRANSFORM", (NativeType)NativeType.forClass(String.class));

    protected CfnFunction(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFunction(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnFunction(@NotNull Construct scope, @NotNull String id, @Nullable CfnFunctionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnFunction(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.forClass(TagManager.class));
    }

    @NotNull
    public Object getAssumeRolePolicyDocument() {
        return Kernel.get((Object)((Object)this), (String)"assumeRolePolicyDocument", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAssumeRolePolicyDocument(@NotNull Object value) {
        Kernel.set((Object)((Object)this), (String)"assumeRolePolicyDocument", (Object)Objects.requireNonNull(value, "assumeRolePolicyDocument is required"));
    }

    @Nullable
    public List<String> getArchitectures() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"architectures", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setArchitectures(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"architectures", value);
    }

    @Nullable
    public String getAutoPublishAlias() {
        return (String)Kernel.get((Object)((Object)this), (String)"autoPublishAlias", (NativeType)NativeType.forClass(String.class));
    }

    public void setAutoPublishAlias(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"autoPublishAlias", (Object)value);
    }

    @Nullable
    public String getAutoPublishCodeSha256() {
        return (String)Kernel.get((Object)((Object)this), (String)"autoPublishCodeSha256", (NativeType)NativeType.forClass(String.class));
    }

    public void setAutoPublishCodeSha256(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"autoPublishCodeSha256", (Object)value);
    }

    @Nullable
    public String getCodeSigningConfigArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"codeSigningConfigArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setCodeSigningConfigArn(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"codeSigningConfigArn", (Object)value);
    }

    @Nullable
    public Object getCodeUri() {
        return Kernel.get((Object)((Object)this), (String)"codeUri", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCodeUri(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"codeUri", (Object)value);
    }

    public void setCodeUri(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"codeUri", (Object)value);
    }

    public void setCodeUri(@Nullable S3LocationProperty value) {
        Kernel.set((Object)((Object)this), (String)"codeUri", (Object)value);
    }

    @Nullable
    public Object getDeadLetterQueue() {
        return Kernel.get((Object)((Object)this), (String)"deadLetterQueue", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDeadLetterQueue(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"deadLetterQueue", (Object)value);
    }

    public void setDeadLetterQueue(@Nullable DeadLetterQueueProperty value) {
        Kernel.set((Object)((Object)this), (String)"deadLetterQueue", (Object)value);
    }

    @Nullable
    public Object getDeploymentPreference() {
        return Kernel.get((Object)((Object)this), (String)"deploymentPreference", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDeploymentPreference(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"deploymentPreference", (Object)value);
    }

    public void setDeploymentPreference(@Nullable DeploymentPreferenceProperty value) {
        Kernel.set((Object)((Object)this), (String)"deploymentPreference", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)((Object)this), (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"description", (Object)value);
    }

    @Nullable
    public Object getEnvironment() {
        return Kernel.get((Object)((Object)this), (String)"environment", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnvironment(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"environment", (Object)value);
    }

    public void setEnvironment(@Nullable FunctionEnvironmentProperty value) {
        Kernel.set((Object)((Object)this), (String)"environment", (Object)value);
    }

    @Nullable
    public Object getEventInvokeConfig() {
        return Kernel.get((Object)((Object)this), (String)"eventInvokeConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEventInvokeConfig(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"eventInvokeConfig", (Object)value);
    }

    public void setEventInvokeConfig(@Nullable EventInvokeConfigProperty value) {
        Kernel.set((Object)((Object)this), (String)"eventInvokeConfig", (Object)value);
    }

    @Nullable
    public Object getEvents() {
        return Kernel.get((Object)((Object)this), (String)"events", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEvents(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"events", (Object)value);
    }

    public void setEvents(@Nullable Map<String, Object> value) {
        Kernel.set((Object)((Object)this), (String)"events", value);
    }

    @Nullable
    public Object getFileSystemConfigs() {
        return Kernel.get((Object)((Object)this), (String)"fileSystemConfigs", (NativeType)NativeType.forClass(Object.class));
    }

    public void setFileSystemConfigs(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"fileSystemConfigs", (Object)value);
    }

    public void setFileSystemConfigs(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"fileSystemConfigs", value);
    }

    @Nullable
    public String getFunctionName() {
        return (String)Kernel.get((Object)((Object)this), (String)"functionName", (NativeType)NativeType.forClass(String.class));
    }

    public void setFunctionName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"functionName", (Object)value);
    }

    @Nullable
    public String getHandler() {
        return (String)Kernel.get((Object)((Object)this), (String)"handler", (NativeType)NativeType.forClass(String.class));
    }

    public void setHandler(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"handler", (Object)value);
    }

    @Nullable
    public Object getImageConfig() {
        return Kernel.get((Object)((Object)this), (String)"imageConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setImageConfig(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"imageConfig", (Object)value);
    }

    public void setImageConfig(@Nullable ImageConfigProperty value) {
        Kernel.set((Object)((Object)this), (String)"imageConfig", (Object)value);
    }

    @Nullable
    public String getImageUri() {
        return (String)Kernel.get((Object)((Object)this), (String)"imageUri", (NativeType)NativeType.forClass(String.class));
    }

    public void setImageUri(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"imageUri", (Object)value);
    }

    @Nullable
    public String getInlineCode() {
        return (String)Kernel.get((Object)((Object)this), (String)"inlineCode", (NativeType)NativeType.forClass(String.class));
    }

    public void setInlineCode(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"inlineCode", (Object)value);
    }

    @Nullable
    public String getKmsKeyArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"kmsKeyArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setKmsKeyArn(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"kmsKeyArn", (Object)value);
    }

    @Nullable
    public List<String> getLayers() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"layers", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setLayers(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"layers", value);
    }

    @Nullable
    public Number getMemorySize() {
        return (Number)Kernel.get((Object)((Object)this), (String)"memorySize", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMemorySize(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"memorySize", (Object)value);
    }

    @Nullable
    public String getPackageType() {
        return (String)Kernel.get((Object)((Object)this), (String)"packageType", (NativeType)NativeType.forClass(String.class));
    }

    public void setPackageType(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"packageType", (Object)value);
    }

    @Nullable
    public String getPermissionsBoundary() {
        return (String)Kernel.get((Object)((Object)this), (String)"permissionsBoundary", (NativeType)NativeType.forClass(String.class));
    }

    public void setPermissionsBoundary(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"permissionsBoundary", (Object)value);
    }

    @Nullable
    public Object getPolicies() {
        return Kernel.get((Object)((Object)this), (String)"policies", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPolicies(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"policies", (Object)value);
    }

    public void setPolicies(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"policies", (Object)value);
    }

    public void setPolicies(@Nullable IAMPolicyDocumentProperty value) {
        Kernel.set((Object)((Object)this), (String)"policies", (Object)value);
    }

    public void setPolicies(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"policies", value);
    }

    @Nullable
    public Object getProvisionedConcurrencyConfig() {
        return Kernel.get((Object)((Object)this), (String)"provisionedConcurrencyConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setProvisionedConcurrencyConfig(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"provisionedConcurrencyConfig", (Object)value);
    }

    public void setProvisionedConcurrencyConfig(@Nullable ProvisionedConcurrencyConfigProperty value) {
        Kernel.set((Object)((Object)this), (String)"provisionedConcurrencyConfig", (Object)value);
    }

    @Nullable
    public Number getReservedConcurrentExecutions() {
        return (Number)Kernel.get((Object)((Object)this), (String)"reservedConcurrentExecutions", (NativeType)NativeType.forClass(Number.class));
    }

    public void setReservedConcurrentExecutions(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"reservedConcurrentExecutions", (Object)value);
    }

    @Nullable
    public String getRole() {
        return (String)Kernel.get((Object)((Object)this), (String)"role", (NativeType)NativeType.forClass(String.class));
    }

    public void setRole(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"role", (Object)value);
    }

    @Nullable
    public String getRuntime() {
        return (String)Kernel.get((Object)((Object)this), (String)"runtime", (NativeType)NativeType.forClass(String.class));
    }

    public void setRuntime(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"runtime", (Object)value);
    }

    @Nullable
    public Number getTimeout() {
        return (Number)Kernel.get((Object)((Object)this), (String)"timeout", (NativeType)NativeType.forClass(Number.class));
    }

    public void setTimeout(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"timeout", (Object)value);
    }

    @Nullable
    public String getTracing() {
        return (String)Kernel.get((Object)((Object)this), (String)"tracing", (NativeType)NativeType.forClass(String.class));
    }

    public void setTracing(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"tracing", (Object)value);
    }

    @Nullable
    public String getVersionDescription() {
        return (String)Kernel.get((Object)((Object)this), (String)"versionDescription", (NativeType)NativeType.forClass(String.class));
    }

    public void setVersionDescription(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"versionDescription", (Object)value);
    }

    @Nullable
    public Object getVpcConfig() {
        return Kernel.get((Object)((Object)this), (String)"vpcConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVpcConfig(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"vpcConfig", (Object)value);
    }

    public void setVpcConfig(@Nullable VpcConfigProperty value) {
        Kernel.set((Object)((Object)this), (String)"vpcConfig", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnFunction> {
        private final Construct scope;
        private final String id;
        private CfnFunctionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder architectures(List<String> architectures) {
            this.props().architectures(architectures);
            return this;
        }

        public Builder assumeRolePolicyDocument(Object assumeRolePolicyDocument) {
            this.props().assumeRolePolicyDocument(assumeRolePolicyDocument);
            return this;
        }

        public Builder autoPublishAlias(String autoPublishAlias) {
            this.props().autoPublishAlias(autoPublishAlias);
            return this;
        }

        public Builder autoPublishCodeSha256(String autoPublishCodeSha256) {
            this.props().autoPublishCodeSha256(autoPublishCodeSha256);
            return this;
        }

        public Builder codeSigningConfigArn(String codeSigningConfigArn) {
            this.props().codeSigningConfigArn(codeSigningConfigArn);
            return this;
        }

        public Builder codeUri(String codeUri) {
            this.props().codeUri(codeUri);
            return this;
        }

        public Builder codeUri(IResolvable codeUri) {
            this.props().codeUri(codeUri);
            return this;
        }

        public Builder codeUri(S3LocationProperty codeUri) {
            this.props().codeUri(codeUri);
            return this;
        }

        public Builder deadLetterQueue(IResolvable deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder deadLetterQueue(DeadLetterQueueProperty deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder deploymentPreference(IResolvable deploymentPreference) {
            this.props().deploymentPreference(deploymentPreference);
            return this;
        }

        public Builder deploymentPreference(DeploymentPreferenceProperty deploymentPreference) {
            this.props().deploymentPreference(deploymentPreference);
            return this;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder environment(IResolvable environment) {
            this.props().environment(environment);
            return this;
        }

        public Builder environment(FunctionEnvironmentProperty environment) {
            this.props().environment(environment);
            return this;
        }

        public Builder eventInvokeConfig(IResolvable eventInvokeConfig) {
            this.props().eventInvokeConfig(eventInvokeConfig);
            return this;
        }

        public Builder eventInvokeConfig(EventInvokeConfigProperty eventInvokeConfig) {
            this.props().eventInvokeConfig(eventInvokeConfig);
            return this;
        }

        public Builder events(IResolvable events) {
            this.props().events(events);
            return this;
        }

        public Builder events(Map<String, ? extends Object> events) {
            this.props().events(events);
            return this;
        }

        public Builder fileSystemConfigs(IResolvable fileSystemConfigs) {
            this.props().fileSystemConfigs(fileSystemConfigs);
            return this;
        }

        public Builder fileSystemConfigs(List<? extends Object> fileSystemConfigs) {
            this.props().fileSystemConfigs(fileSystemConfigs);
            return this;
        }

        public Builder functionName(String functionName) {
            this.props().functionName(functionName);
            return this;
        }

        public Builder handler(String handler) {
            this.props().handler(handler);
            return this;
        }

        public Builder imageConfig(IResolvable imageConfig) {
            this.props().imageConfig(imageConfig);
            return this;
        }

        public Builder imageConfig(ImageConfigProperty imageConfig) {
            this.props().imageConfig(imageConfig);
            return this;
        }

        public Builder imageUri(String imageUri) {
            this.props().imageUri(imageUri);
            return this;
        }

        public Builder inlineCode(String inlineCode) {
            this.props().inlineCode(inlineCode);
            return this;
        }

        public Builder kmsKeyArn(String kmsKeyArn) {
            this.props().kmsKeyArn(kmsKeyArn);
            return this;
        }

        public Builder layers(List<String> layers) {
            this.props().layers(layers);
            return this;
        }

        public Builder memorySize(Number memorySize) {
            this.props().memorySize(memorySize);
            return this;
        }

        public Builder packageType(String packageType) {
            this.props().packageType(packageType);
            return this;
        }

        public Builder permissionsBoundary(String permissionsBoundary) {
            this.props().permissionsBoundary(permissionsBoundary);
            return this;
        }

        public Builder policies(String policies) {
            this.props().policies(policies);
            return this;
        }

        public Builder policies(IResolvable policies) {
            this.props().policies(policies);
            return this;
        }

        public Builder policies(IAMPolicyDocumentProperty policies) {
            this.props().policies(policies);
            return this;
        }

        public Builder policies(List<? extends Object> policies) {
            this.props().policies(policies);
            return this;
        }

        public Builder provisionedConcurrencyConfig(IResolvable provisionedConcurrencyConfig) {
            this.props().provisionedConcurrencyConfig(provisionedConcurrencyConfig);
            return this;
        }

        public Builder provisionedConcurrencyConfig(ProvisionedConcurrencyConfigProperty provisionedConcurrencyConfig) {
            this.props().provisionedConcurrencyConfig(provisionedConcurrencyConfig);
            return this;
        }

        public Builder reservedConcurrentExecutions(Number reservedConcurrentExecutions) {
            this.props().reservedConcurrentExecutions(reservedConcurrentExecutions);
            return this;
        }

        public Builder role(String role) {
            this.props().role(role);
            return this;
        }

        public Builder runtime(String runtime) {
            this.props().runtime(runtime);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder timeout(Number timeout) {
            this.props().timeout(timeout);
            return this;
        }

        public Builder tracing(String tracing) {
            this.props().tracing(tracing);
            return this;
        }

        public Builder versionDescription(String versionDescription) {
            this.props().versionDescription(versionDescription);
            return this;
        }

        public Builder vpcConfig(IResolvable vpcConfig) {
            this.props().vpcConfig(vpcConfig);
            return this;
        }

        public Builder vpcConfig(VpcConfigProperty vpcConfig) {
            this.props().vpcConfig(vpcConfig);
            return this;
        }

        public CfnFunction build() {
            return new CfnFunction(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnFunctionProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnFunctionProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.VpcConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcConfigProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSecurityGroupIds();

        @NotNull
        public List<String> getSubnetIds();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcConfigProperty> {
            List<String> securityGroupIds;
            List<String> subnetIds;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public VpcConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.TopicSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TopicSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getTopicName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TopicSAMPTProperty> {
            String topicName;

            public Builder topicName(String topicName) {
                this.topicName = topicName;
                return this;
            }

            public TopicSAMPTProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.TableStreamSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableStreamSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getStreamName();

        @NotNull
        public String getTableName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableStreamSAMPTProperty> {
            String streamName;
            String tableName;

            public Builder streamName(String streamName) {
                this.streamName = streamName;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public TableStreamSAMPTProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.TableSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TableSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getTableName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TableSAMPTProperty> {
            String tableName;

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public TableSAMPTProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.StreamSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StreamSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getStreamName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StreamSAMPTProperty> {
            String streamName;

            public Builder streamName(String streamName) {
                this.streamName = streamName;
                return this;
            }

            public StreamSAMPTProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.StateMachineSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StateMachineSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getStateMachineName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StateMachineSAMPTProperty> {
            String stateMachineName;

            public Builder stateMachineName(String stateMachineName) {
                this.stateMachineName = stateMachineName;
                return this;
            }

            public StateMachineSAMPTProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.ScheduleEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScheduleEventProperty
    extends JsiiSerializable {
        @NotNull
        public String getSchedule();

        @Nullable
        default public String getInput() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScheduleEventProperty> {
            String schedule;
            String input;

            public Builder schedule(String schedule) {
                this.schedule = schedule;
                return this;
            }

            public Builder input(String input) {
                this.input = input;
                return this;
            }

            public ScheduleEventProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.SQSEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SQSEventProperty
    extends JsiiSerializable {
        @NotNull
        public String getQueue();

        @Nullable
        default public Number getBatchSize() {
            return null;
        }

        @Nullable
        default public Object getEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SQSEventProperty> {
            String queue;
            Number batchSize;
            Object enabled;

            public Builder queue(String queue) {
                this.queue = queue;
                return this;
            }

            public Builder batchSize(Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public SQSEventProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.SNSEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SNSEventProperty
    extends JsiiSerializable {
        @NotNull
        public String getTopic();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SNSEventProperty> {
            String topic;

            public Builder topic(String topic) {
                this.topic = topic;
                return this;
            }

            public SNSEventProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.SAMPolicyTemplateProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SAMPolicyTemplateProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAmiDescribePolicy() {
            return null;
        }

        @Nullable
        default public Object getCloudFormationDescribeStacksPolicy() {
            return null;
        }

        @Nullable
        default public Object getCloudWatchPutMetricPolicy() {
            return null;
        }

        @Nullable
        default public Object getDynamoDbCrudPolicy() {
            return null;
        }

        @Nullable
        default public Object getDynamoDbReadPolicy() {
            return null;
        }

        @Nullable
        default public Object getDynamoDbStreamReadPolicy() {
            return null;
        }

        @Nullable
        default public Object getEc2DescribePolicy() {
            return null;
        }

        @Nullable
        default public Object getElasticsearchHttpPostPolicy() {
            return null;
        }

        @Nullable
        default public Object getFilterLogEventsPolicy() {
            return null;
        }

        @Nullable
        default public Object getKinesisCrudPolicy() {
            return null;
        }

        @Nullable
        default public Object getKinesisStreamReadPolicy() {
            return null;
        }

        @Nullable
        default public Object getKmsDecryptPolicy() {
            return null;
        }

        @Nullable
        default public Object getLambdaInvokePolicy() {
            return null;
        }

        @Nullable
        default public Object getRekognitionDetectOnlyPolicy() {
            return null;
        }

        @Nullable
        default public Object getRekognitionLabelsPolicy() {
            return null;
        }

        @Nullable
        default public Object getRekognitionNoDataAccessPolicy() {
            return null;
        }

        @Nullable
        default public Object getRekognitionReadPolicy() {
            return null;
        }

        @Nullable
        default public Object getRekognitionWriteOnlyAccessPolicy() {
            return null;
        }

        @Nullable
        default public Object getS3CrudPolicy() {
            return null;
        }

        @Nullable
        default public Object getS3ReadPolicy() {
            return null;
        }

        @Nullable
        default public Object getSesBulkTemplatedCrudPolicy() {
            return null;
        }

        @Nullable
        default public Object getSesCrudPolicy() {
            return null;
        }

        @Nullable
        default public Object getSesEmailTemplateCrudPolicy() {
            return null;
        }

        @Nullable
        default public Object getSesSendBouncePolicy() {
            return null;
        }

        @Nullable
        default public Object getSnsCrudPolicy() {
            return null;
        }

        @Nullable
        default public Object getSnsPublishMessagePolicy() {
            return null;
        }

        @Nullable
        default public Object getSqsPollerPolicy() {
            return null;
        }

        @Nullable
        default public Object getSqsSendMessagePolicy() {
            return null;
        }

        @Nullable
        default public Object getStepFunctionsExecutionPolicy() {
            return null;
        }

        @Nullable
        default public Object getVpcAccessPolicy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SAMPolicyTemplateProperty> {
            Object amiDescribePolicy;
            Object cloudFormationDescribeStacksPolicy;
            Object cloudWatchPutMetricPolicy;
            Object dynamoDbCrudPolicy;
            Object dynamoDbReadPolicy;
            Object dynamoDbStreamReadPolicy;
            Object ec2DescribePolicy;
            Object elasticsearchHttpPostPolicy;
            Object filterLogEventsPolicy;
            Object kinesisCrudPolicy;
            Object kinesisStreamReadPolicy;
            Object kmsDecryptPolicy;
            Object lambdaInvokePolicy;
            Object rekognitionDetectOnlyPolicy;
            Object rekognitionLabelsPolicy;
            Object rekognitionNoDataAccessPolicy;
            Object rekognitionReadPolicy;
            Object rekognitionWriteOnlyAccessPolicy;
            Object s3CrudPolicy;
            Object s3ReadPolicy;
            Object sesBulkTemplatedCrudPolicy;
            Object sesCrudPolicy;
            Object sesEmailTemplateCrudPolicy;
            Object sesSendBouncePolicy;
            Object snsCrudPolicy;
            Object snsPublishMessagePolicy;
            Object sqsPollerPolicy;
            Object sqsSendMessagePolicy;
            Object stepFunctionsExecutionPolicy;
            Object vpcAccessPolicy;

            public Builder amiDescribePolicy(IResolvable amiDescribePolicy) {
                this.amiDescribePolicy = amiDescribePolicy;
                return this;
            }

            public Builder amiDescribePolicy(EmptySAMPTProperty amiDescribePolicy) {
                this.amiDescribePolicy = amiDescribePolicy;
                return this;
            }

            public Builder cloudFormationDescribeStacksPolicy(IResolvable cloudFormationDescribeStacksPolicy) {
                this.cloudFormationDescribeStacksPolicy = cloudFormationDescribeStacksPolicy;
                return this;
            }

            public Builder cloudFormationDescribeStacksPolicy(EmptySAMPTProperty cloudFormationDescribeStacksPolicy) {
                this.cloudFormationDescribeStacksPolicy = cloudFormationDescribeStacksPolicy;
                return this;
            }

            public Builder cloudWatchPutMetricPolicy(IResolvable cloudWatchPutMetricPolicy) {
                this.cloudWatchPutMetricPolicy = cloudWatchPutMetricPolicy;
                return this;
            }

            public Builder cloudWatchPutMetricPolicy(EmptySAMPTProperty cloudWatchPutMetricPolicy) {
                this.cloudWatchPutMetricPolicy = cloudWatchPutMetricPolicy;
                return this;
            }

            public Builder dynamoDbCrudPolicy(IResolvable dynamoDbCrudPolicy) {
                this.dynamoDbCrudPolicy = dynamoDbCrudPolicy;
                return this;
            }

            public Builder dynamoDbCrudPolicy(TableSAMPTProperty dynamoDbCrudPolicy) {
                this.dynamoDbCrudPolicy = dynamoDbCrudPolicy;
                return this;
            }

            public Builder dynamoDbReadPolicy(IResolvable dynamoDbReadPolicy) {
                this.dynamoDbReadPolicy = dynamoDbReadPolicy;
                return this;
            }

            public Builder dynamoDbReadPolicy(TableSAMPTProperty dynamoDbReadPolicy) {
                this.dynamoDbReadPolicy = dynamoDbReadPolicy;
                return this;
            }

            public Builder dynamoDbStreamReadPolicy(IResolvable dynamoDbStreamReadPolicy) {
                this.dynamoDbStreamReadPolicy = dynamoDbStreamReadPolicy;
                return this;
            }

            public Builder dynamoDbStreamReadPolicy(TableStreamSAMPTProperty dynamoDbStreamReadPolicy) {
                this.dynamoDbStreamReadPolicy = dynamoDbStreamReadPolicy;
                return this;
            }

            public Builder ec2DescribePolicy(IResolvable ec2DescribePolicy) {
                this.ec2DescribePolicy = ec2DescribePolicy;
                return this;
            }

            public Builder ec2DescribePolicy(EmptySAMPTProperty ec2DescribePolicy) {
                this.ec2DescribePolicy = ec2DescribePolicy;
                return this;
            }

            public Builder elasticsearchHttpPostPolicy(IResolvable elasticsearchHttpPostPolicy) {
                this.elasticsearchHttpPostPolicy = elasticsearchHttpPostPolicy;
                return this;
            }

            public Builder elasticsearchHttpPostPolicy(DomainSAMPTProperty elasticsearchHttpPostPolicy) {
                this.elasticsearchHttpPostPolicy = elasticsearchHttpPostPolicy;
                return this;
            }

            public Builder filterLogEventsPolicy(IResolvable filterLogEventsPolicy) {
                this.filterLogEventsPolicy = filterLogEventsPolicy;
                return this;
            }

            public Builder filterLogEventsPolicy(LogGroupSAMPTProperty filterLogEventsPolicy) {
                this.filterLogEventsPolicy = filterLogEventsPolicy;
                return this;
            }

            public Builder kinesisCrudPolicy(IResolvable kinesisCrudPolicy) {
                this.kinesisCrudPolicy = kinesisCrudPolicy;
                return this;
            }

            public Builder kinesisCrudPolicy(StreamSAMPTProperty kinesisCrudPolicy) {
                this.kinesisCrudPolicy = kinesisCrudPolicy;
                return this;
            }

            public Builder kinesisStreamReadPolicy(IResolvable kinesisStreamReadPolicy) {
                this.kinesisStreamReadPolicy = kinesisStreamReadPolicy;
                return this;
            }

            public Builder kinesisStreamReadPolicy(StreamSAMPTProperty kinesisStreamReadPolicy) {
                this.kinesisStreamReadPolicy = kinesisStreamReadPolicy;
                return this;
            }

            public Builder kmsDecryptPolicy(IResolvable kmsDecryptPolicy) {
                this.kmsDecryptPolicy = kmsDecryptPolicy;
                return this;
            }

            public Builder kmsDecryptPolicy(KeySAMPTProperty kmsDecryptPolicy) {
                this.kmsDecryptPolicy = kmsDecryptPolicy;
                return this;
            }

            public Builder lambdaInvokePolicy(IResolvable lambdaInvokePolicy) {
                this.lambdaInvokePolicy = lambdaInvokePolicy;
                return this;
            }

            public Builder lambdaInvokePolicy(FunctionSAMPTProperty lambdaInvokePolicy) {
                this.lambdaInvokePolicy = lambdaInvokePolicy;
                return this;
            }

            public Builder rekognitionDetectOnlyPolicy(IResolvable rekognitionDetectOnlyPolicy) {
                this.rekognitionDetectOnlyPolicy = rekognitionDetectOnlyPolicy;
                return this;
            }

            public Builder rekognitionDetectOnlyPolicy(EmptySAMPTProperty rekognitionDetectOnlyPolicy) {
                this.rekognitionDetectOnlyPolicy = rekognitionDetectOnlyPolicy;
                return this;
            }

            public Builder rekognitionLabelsPolicy(IResolvable rekognitionLabelsPolicy) {
                this.rekognitionLabelsPolicy = rekognitionLabelsPolicy;
                return this;
            }

            public Builder rekognitionLabelsPolicy(EmptySAMPTProperty rekognitionLabelsPolicy) {
                this.rekognitionLabelsPolicy = rekognitionLabelsPolicy;
                return this;
            }

            public Builder rekognitionNoDataAccessPolicy(IResolvable rekognitionNoDataAccessPolicy) {
                this.rekognitionNoDataAccessPolicy = rekognitionNoDataAccessPolicy;
                return this;
            }

            public Builder rekognitionNoDataAccessPolicy(CollectionSAMPTProperty rekognitionNoDataAccessPolicy) {
                this.rekognitionNoDataAccessPolicy = rekognitionNoDataAccessPolicy;
                return this;
            }

            public Builder rekognitionReadPolicy(IResolvable rekognitionReadPolicy) {
                this.rekognitionReadPolicy = rekognitionReadPolicy;
                return this;
            }

            public Builder rekognitionReadPolicy(CollectionSAMPTProperty rekognitionReadPolicy) {
                this.rekognitionReadPolicy = rekognitionReadPolicy;
                return this;
            }

            public Builder rekognitionWriteOnlyAccessPolicy(IResolvable rekognitionWriteOnlyAccessPolicy) {
                this.rekognitionWriteOnlyAccessPolicy = rekognitionWriteOnlyAccessPolicy;
                return this;
            }

            public Builder rekognitionWriteOnlyAccessPolicy(CollectionSAMPTProperty rekognitionWriteOnlyAccessPolicy) {
                this.rekognitionWriteOnlyAccessPolicy = rekognitionWriteOnlyAccessPolicy;
                return this;
            }

            public Builder s3CrudPolicy(IResolvable s3CrudPolicy) {
                this.s3CrudPolicy = s3CrudPolicy;
                return this;
            }

            public Builder s3CrudPolicy(BucketSAMPTProperty s3CrudPolicy) {
                this.s3CrudPolicy = s3CrudPolicy;
                return this;
            }

            public Builder s3ReadPolicy(IResolvable s3ReadPolicy) {
                this.s3ReadPolicy = s3ReadPolicy;
                return this;
            }

            public Builder s3ReadPolicy(BucketSAMPTProperty s3ReadPolicy) {
                this.s3ReadPolicy = s3ReadPolicy;
                return this;
            }

            public Builder sesBulkTemplatedCrudPolicy(IResolvable sesBulkTemplatedCrudPolicy) {
                this.sesBulkTemplatedCrudPolicy = sesBulkTemplatedCrudPolicy;
                return this;
            }

            public Builder sesBulkTemplatedCrudPolicy(IdentitySAMPTProperty sesBulkTemplatedCrudPolicy) {
                this.sesBulkTemplatedCrudPolicy = sesBulkTemplatedCrudPolicy;
                return this;
            }

            public Builder sesCrudPolicy(IResolvable sesCrudPolicy) {
                this.sesCrudPolicy = sesCrudPolicy;
                return this;
            }

            public Builder sesCrudPolicy(IdentitySAMPTProperty sesCrudPolicy) {
                this.sesCrudPolicy = sesCrudPolicy;
                return this;
            }

            public Builder sesEmailTemplateCrudPolicy(IResolvable sesEmailTemplateCrudPolicy) {
                this.sesEmailTemplateCrudPolicy = sesEmailTemplateCrudPolicy;
                return this;
            }

            public Builder sesEmailTemplateCrudPolicy(EmptySAMPTProperty sesEmailTemplateCrudPolicy) {
                this.sesEmailTemplateCrudPolicy = sesEmailTemplateCrudPolicy;
                return this;
            }

            public Builder sesSendBouncePolicy(IResolvable sesSendBouncePolicy) {
                this.sesSendBouncePolicy = sesSendBouncePolicy;
                return this;
            }

            public Builder sesSendBouncePolicy(IdentitySAMPTProperty sesSendBouncePolicy) {
                this.sesSendBouncePolicy = sesSendBouncePolicy;
                return this;
            }

            public Builder snsCrudPolicy(IResolvable snsCrudPolicy) {
                this.snsCrudPolicy = snsCrudPolicy;
                return this;
            }

            public Builder snsCrudPolicy(TopicSAMPTProperty snsCrudPolicy) {
                this.snsCrudPolicy = snsCrudPolicy;
                return this;
            }

            public Builder snsPublishMessagePolicy(IResolvable snsPublishMessagePolicy) {
                this.snsPublishMessagePolicy = snsPublishMessagePolicy;
                return this;
            }

            public Builder snsPublishMessagePolicy(TopicSAMPTProperty snsPublishMessagePolicy) {
                this.snsPublishMessagePolicy = snsPublishMessagePolicy;
                return this;
            }

            public Builder sqsPollerPolicy(IResolvable sqsPollerPolicy) {
                this.sqsPollerPolicy = sqsPollerPolicy;
                return this;
            }

            public Builder sqsPollerPolicy(QueueSAMPTProperty sqsPollerPolicy) {
                this.sqsPollerPolicy = sqsPollerPolicy;
                return this;
            }

            public Builder sqsSendMessagePolicy(IResolvable sqsSendMessagePolicy) {
                this.sqsSendMessagePolicy = sqsSendMessagePolicy;
                return this;
            }

            public Builder sqsSendMessagePolicy(QueueSAMPTProperty sqsSendMessagePolicy) {
                this.sqsSendMessagePolicy = sqsSendMessagePolicy;
                return this;
            }

            public Builder stepFunctionsExecutionPolicy(IResolvable stepFunctionsExecutionPolicy) {
                this.stepFunctionsExecutionPolicy = stepFunctionsExecutionPolicy;
                return this;
            }

            public Builder stepFunctionsExecutionPolicy(StateMachineSAMPTProperty stepFunctionsExecutionPolicy) {
                this.stepFunctionsExecutionPolicy = stepFunctionsExecutionPolicy;
                return this;
            }

            public Builder vpcAccessPolicy(IResolvable vpcAccessPolicy) {
                this.vpcAccessPolicy = vpcAccessPolicy;
                return this;
            }

            public Builder vpcAccessPolicy(EmptySAMPTProperty vpcAccessPolicy) {
                this.vpcAccessPolicy = vpcAccessPolicy;
                return this;
            }

            public SAMPolicyTemplateProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.S3NotificationFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3NotificationFilterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getS3Key();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3NotificationFilterProperty> {
            Object s3Key;

            public Builder s3Key(IResolvable s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            public Builder s3Key(S3KeyFilterProperty s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            public S3NotificationFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.S3LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @NotNull
        public String getKey();

        @Nullable
        default public Number getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LocationProperty> {
            String bucket;
            String key;
            Number version;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder version(Number version) {
                this.version = version;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.S3KeyFilterRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3KeyFilterRuleProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3KeyFilterRuleProperty> {
            String name;
            String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public S3KeyFilterRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.S3KeyFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3KeyFilterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3KeyFilterProperty> {
            Object rules;

            public Builder rules(IResolvable rules) {
                this.rules = rules;
                return this;
            }

            public Builder rules(List<? extends Object> rules) {
                this.rules = rules;
                return this;
            }

            public S3KeyFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.S3EventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3EventProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @NotNull
        public Object getEvents();

        @Nullable
        default public Object getFilter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3EventProperty> {
            String bucket;
            Object events;
            Object filter;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder events(String events) {
                this.events = events;
                return this;
            }

            public Builder events(IResolvable events) {
                this.events = events;
                return this;
            }

            public Builder events(List<String> events) {
                this.events = events;
                return this;
            }

            public Builder filter(IResolvable filter) {
                this.filter = filter;
                return this;
            }

            public Builder filter(S3NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            public S3EventProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.QueueSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface QueueSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getQueueName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<QueueSAMPTProperty> {
            String queueName;

            public Builder queueName(String queueName) {
                this.queueName = queueName;
                return this;
            }

            public QueueSAMPTProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.ProvisionedConcurrencyConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProvisionedConcurrencyConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getProvisionedConcurrentExecutions();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProvisionedConcurrencyConfigProperty> {
            String provisionedConcurrentExecutions;

            public Builder provisionedConcurrentExecutions(String provisionedConcurrentExecutions) {
                this.provisionedConcurrentExecutions = provisionedConcurrentExecutions;
                return this;
            }

            public ProvisionedConcurrencyConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.LogGroupSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LogGroupSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getLogGroupName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LogGroupSAMPTProperty> {
            String logGroupName;

            public Builder logGroupName(String logGroupName) {
                this.logGroupName = logGroupName;
                return this;
            }

            public LogGroupSAMPTProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.KinesisEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KinesisEventProperty
    extends JsiiSerializable {
        @NotNull
        public String getStartingPosition();

        @NotNull
        public String getStream();

        @Nullable
        default public Number getBatchSize() {
            return null;
        }

        @Nullable
        default public Object getEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KinesisEventProperty> {
            String startingPosition;
            String stream;
            Number batchSize;
            Object enabled;

            public Builder startingPosition(String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            public Builder stream(String stream) {
                this.stream = stream;
                return this;
            }

            public Builder batchSize(Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public KinesisEventProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.KeySAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KeySAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getKeyId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KeySAMPTProperty> {
            String keyId;

            public Builder keyId(String keyId) {
                this.keyId = keyId;
                return this;
            }

            public KeySAMPTProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.IoTRuleEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IoTRuleEventProperty
    extends JsiiSerializable {
        @NotNull
        public String getSql();

        @Nullable
        default public String getAwsIotSqlVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IoTRuleEventProperty> {
            String sql;
            String awsIotSqlVersion;

            public Builder sql(String sql) {
                this.sql = sql;
                return this;
            }

            public Builder awsIotSqlVersion(String awsIotSqlVersion) {
                this.awsIotSqlVersion = awsIotSqlVersion;
                return this;
            }

            public IoTRuleEventProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.ImageConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ImageConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getCommand() {
            return null;
        }

        @Nullable
        default public List<String> getEntryPoint() {
            return null;
        }

        @Nullable
        default public String getWorkingDirectory() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ImageConfigProperty> {
            List<String> command;
            List<String> entryPoint;
            String workingDirectory;

            public Builder command(List<String> command) {
                this.command = command;
                return this;
            }

            public Builder entryPoint(List<String> entryPoint) {
                this.entryPoint = entryPoint;
                return this;
            }

            public Builder workingDirectory(String workingDirectory) {
                this.workingDirectory = workingDirectory;
                return this;
            }

            public ImageConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.IdentitySAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IdentitySAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getIdentityName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IdentitySAMPTProperty> {
            String identityName;

            public Builder identityName(String identityName) {
                this.identityName = identityName;
                return this;
            }

            public IdentitySAMPTProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.IAMPolicyDocumentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IAMPolicyDocumentProperty
    extends JsiiSerializable {
        @NotNull
        public Object getStatement();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IAMPolicyDocumentProperty> {
            Object statement;

            public Builder statement(Object statement) {
                this.statement = statement;
                return this;
            }

            public IAMPolicyDocumentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.FunctionSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FunctionSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getFunctionName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FunctionSAMPTProperty> {
            String functionName;

            public Builder functionName(String functionName) {
                this.functionName = functionName;
                return this;
            }

            public FunctionSAMPTProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.FunctionEnvironmentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FunctionEnvironmentProperty
    extends JsiiSerializable {
        @NotNull
        public Object getVariables();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FunctionEnvironmentProperty> {
            Object variables;

            public Builder variables(IResolvable variables) {
                this.variables = variables;
                return this;
            }

            public Builder variables(Map<String, String> variables) {
                this.variables = variables;
                return this;
            }

            public FunctionEnvironmentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.FileSystemConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FileSystemConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getArn() {
            return null;
        }

        @Nullable
        default public String getLocalMountPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FileSystemConfigProperty> {
            String arn;
            String localMountPath;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder localMountPath(String localMountPath) {
                this.localMountPath = localMountPath;
                return this;
            }

            public FileSystemConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.EventSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EventSourceProperty
    extends JsiiSerializable {
        @NotNull
        public Object getProperties();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EventSourceProperty> {
            Object properties;
            String type;

            public Builder properties(IResolvable properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(AlexaSkillEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(ApiEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(CloudWatchEventEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(CloudWatchLogsEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(DynamoDBEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(EventBridgeRuleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(IoTRuleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(KinesisEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(S3EventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(SNSEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(SQSEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder properties(ScheduleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public EventSourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.EventInvokeDestinationConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EventInvokeDestinationConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getOnFailure();

        @NotNull
        public Object getOnSuccess();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EventInvokeDestinationConfigProperty> {
            Object onFailure;
            Object onSuccess;

            public Builder onFailure(IResolvable onFailure) {
                this.onFailure = onFailure;
                return this;
            }

            public Builder onFailure(DestinationProperty onFailure) {
                this.onFailure = onFailure;
                return this;
            }

            public Builder onSuccess(IResolvable onSuccess) {
                this.onSuccess = onSuccess;
                return this;
            }

            public Builder onSuccess(DestinationProperty onSuccess) {
                this.onSuccess = onSuccess;
                return this;
            }

            public EventInvokeDestinationConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.EventInvokeConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EventInvokeConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDestinationConfig() {
            return null;
        }

        @Nullable
        default public Number getMaximumEventAgeInSeconds() {
            return null;
        }

        @Nullable
        default public Number getMaximumRetryAttempts() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EventInvokeConfigProperty> {
            Object destinationConfig;
            Number maximumEventAgeInSeconds;
            Number maximumRetryAttempts;

            public Builder destinationConfig(IResolvable destinationConfig) {
                this.destinationConfig = destinationConfig;
                return this;
            }

            public Builder destinationConfig(EventInvokeDestinationConfigProperty destinationConfig) {
                this.destinationConfig = destinationConfig;
                return this;
            }

            public Builder maximumEventAgeInSeconds(Number maximumEventAgeInSeconds) {
                this.maximumEventAgeInSeconds = maximumEventAgeInSeconds;
                return this;
            }

            public Builder maximumRetryAttempts(Number maximumRetryAttempts) {
                this.maximumRetryAttempts = maximumRetryAttempts;
                return this;
            }

            public EventInvokeConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.EventBridgeRuleEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EventBridgeRuleEventProperty
    extends JsiiSerializable {
        @NotNull
        public Object getPattern();

        @Nullable
        default public String getEventBusName() {
            return null;
        }

        @Nullable
        default public String getInput() {
            return null;
        }

        @Nullable
        default public String getInputPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EventBridgeRuleEventProperty> {
            Object pattern;
            String eventBusName;
            String input;
            String inputPath;

            public Builder pattern(Object pattern) {
                this.pattern = pattern;
                return this;
            }

            public Builder eventBusName(String eventBusName) {
                this.eventBusName = eventBusName;
                return this;
            }

            public Builder input(String input) {
                this.input = input;
                return this;
            }

            public Builder inputPath(String inputPath) {
                this.inputPath = inputPath;
                return this;
            }

            public EventBridgeRuleEventProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.EmptySAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EmptySAMPTProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EmptySAMPTProperty> {
            public EmptySAMPTProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.DynamoDBEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DynamoDBEventProperty
    extends JsiiSerializable {
        @NotNull
        public String getStartingPosition();

        @NotNull
        public String getStream();

        @Nullable
        default public Number getBatchSize() {
            return null;
        }

        @Nullable
        default public Object getBisectBatchOnFunctionError() {
            return null;
        }

        @Nullable
        default public Object getDestinationConfig() {
            return null;
        }

        @Nullable
        default public Object getEnabled() {
            return null;
        }

        @Nullable
        default public Number getMaximumBatchingWindowInSeconds() {
            return null;
        }

        @Nullable
        default public Number getMaximumRecordAgeInSeconds() {
            return null;
        }

        @Nullable
        default public Number getMaximumRetryAttempts() {
            return null;
        }

        @Nullable
        default public Number getParallelizationFactor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DynamoDBEventProperty> {
            String startingPosition;
            String stream;
            Number batchSize;
            Object bisectBatchOnFunctionError;
            Object destinationConfig;
            Object enabled;
            Number maximumBatchingWindowInSeconds;
            Number maximumRecordAgeInSeconds;
            Number maximumRetryAttempts;
            Number parallelizationFactor;

            public Builder startingPosition(String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            public Builder stream(String stream) {
                this.stream = stream;
                return this;
            }

            public Builder batchSize(Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder bisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError) {
                this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
                return this;
            }

            public Builder bisectBatchOnFunctionError(IResolvable bisectBatchOnFunctionError) {
                this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
                return this;
            }

            public Builder destinationConfig(IResolvable destinationConfig) {
                this.destinationConfig = destinationConfig;
                return this;
            }

            public Builder destinationConfig(DestinationConfigProperty destinationConfig) {
                this.destinationConfig = destinationConfig;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder maximumBatchingWindowInSeconds(Number maximumBatchingWindowInSeconds) {
                this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
                return this;
            }

            public Builder maximumRecordAgeInSeconds(Number maximumRecordAgeInSeconds) {
                this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
                return this;
            }

            public Builder maximumRetryAttempts(Number maximumRetryAttempts) {
                this.maximumRetryAttempts = maximumRetryAttempts;
                return this;
            }

            public Builder parallelizationFactor(Number parallelizationFactor) {
                this.parallelizationFactor = parallelizationFactor;
                return this;
            }

            public DynamoDBEventProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.DomainSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DomainSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getDomainName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DomainSAMPTProperty> {
            String domainName;

            public Builder domainName(String domainName) {
                this.domainName = domainName;
                return this;
            }

            public DomainSAMPTProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.DestinationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DestinationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDestination();

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DestinationProperty> {
            String destination;
            String type;

            public Builder destination(String destination) {
                this.destination = destination;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public DestinationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.DestinationConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DestinationConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getOnFailure();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DestinationConfigProperty> {
            Object onFailure;

            public Builder onFailure(IResolvable onFailure) {
                this.onFailure = onFailure;
                return this;
            }

            public Builder onFailure(DestinationProperty onFailure) {
                this.onFailure = onFailure;
                return this;
            }

            public DestinationConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.DeploymentPreferenceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeploymentPreferenceProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        @NotNull
        public String getType();

        @Nullable
        default public List<String> getAlarms() {
            return null;
        }

        @Nullable
        default public List<String> getHooks() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeploymentPreferenceProperty> {
            Object enabled;
            String type;
            List<String> alarms;
            List<String> hooks;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder alarms(List<String> alarms) {
                this.alarms = alarms;
                return this;
            }

            public Builder hooks(List<String> hooks) {
                this.hooks = hooks;
                return this;
            }

            public DeploymentPreferenceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.DeadLetterQueueProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeadLetterQueueProperty
    extends JsiiSerializable {
        @NotNull
        public String getTargetArn();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeadLetterQueueProperty> {
            String targetArn;
            String type;

            public Builder targetArn(String targetArn) {
                this.targetArn = targetArn;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public DeadLetterQueueProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.CollectionSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CollectionSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getCollectionId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CollectionSAMPTProperty> {
            String collectionId;

            public Builder collectionId(String collectionId) {
                this.collectionId = collectionId;
                return this;
            }

            public CollectionSAMPTProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.CloudWatchLogsEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudWatchLogsEventProperty
    extends JsiiSerializable {
        @NotNull
        public String getFilterPattern();

        @NotNull
        public String getLogGroupName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudWatchLogsEventProperty> {
            String filterPattern;
            String logGroupName;

            public Builder filterPattern(String filterPattern) {
                this.filterPattern = filterPattern;
                return this;
            }

            public Builder logGroupName(String logGroupName) {
                this.logGroupName = logGroupName;
                return this;
            }

            public CloudWatchLogsEventProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.CloudWatchEventEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudWatchEventEventProperty
    extends JsiiSerializable {
        @NotNull
        public Object getPattern();

        @Nullable
        default public String getInput() {
            return null;
        }

        @Nullable
        default public String getInputPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudWatchEventEventProperty> {
            Object pattern;
            String input;
            String inputPath;

            public Builder pattern(Object pattern) {
                this.pattern = pattern;
                return this;
            }

            public Builder input(String input) {
                this.input = input;
                return this;
            }

            public Builder inputPath(String inputPath) {
                this.inputPath = inputPath;
                return this;
            }

            public CloudWatchEventEventProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.BucketSAMPTProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BucketSAMPTProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BucketSAMPTProperty> {
            String bucketName;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public BucketSAMPTProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.AuthResourcePolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthResourcePolicyProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getAwsAccountBlacklist() {
            return null;
        }

        @Nullable
        default public List<String> getAwsAccountWhitelist() {
            return null;
        }

        @Nullable
        default public Object getCustomStatements() {
            return null;
        }

        @Nullable
        default public List<String> getIntrinsicVpcBlacklist() {
            return null;
        }

        @Nullable
        default public List<String> getIntrinsicVpceBlacklist() {
            return null;
        }

        @Nullable
        default public List<String> getIntrinsicVpceWhitelist() {
            return null;
        }

        @Nullable
        default public List<String> getIntrinsicVpcWhitelist() {
            return null;
        }

        @Nullable
        default public List<String> getIpRangeBlacklist() {
            return null;
        }

        @Nullable
        default public List<String> getIpRangeWhitelist() {
            return null;
        }

        @Nullable
        default public List<String> getSourceVpcBlacklist() {
            return null;
        }

        @Nullable
        default public List<String> getSourceVpcWhitelist() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuthResourcePolicyProperty> {
            List<String> awsAccountBlacklist;
            List<String> awsAccountWhitelist;
            Object customStatements;
            List<String> intrinsicVpcBlacklist;
            List<String> intrinsicVpceBlacklist;
            List<String> intrinsicVpceWhitelist;
            List<String> intrinsicVpcWhitelist;
            List<String> ipRangeBlacklist;
            List<String> ipRangeWhitelist;
            List<String> sourceVpcBlacklist;
            List<String> sourceVpcWhitelist;

            public Builder awsAccountBlacklist(List<String> awsAccountBlacklist) {
                this.awsAccountBlacklist = awsAccountBlacklist;
                return this;
            }

            public Builder awsAccountWhitelist(List<String> awsAccountWhitelist) {
                this.awsAccountWhitelist = awsAccountWhitelist;
                return this;
            }

            public Builder customStatements(List<? extends Object> customStatements) {
                this.customStatements = customStatements;
                return this;
            }

            public Builder customStatements(IResolvable customStatements) {
                this.customStatements = customStatements;
                return this;
            }

            public Builder intrinsicVpcBlacklist(List<String> intrinsicVpcBlacklist) {
                this.intrinsicVpcBlacklist = intrinsicVpcBlacklist;
                return this;
            }

            public Builder intrinsicVpceBlacklist(List<String> intrinsicVpceBlacklist) {
                this.intrinsicVpceBlacklist = intrinsicVpceBlacklist;
                return this;
            }

            public Builder intrinsicVpceWhitelist(List<String> intrinsicVpceWhitelist) {
                this.intrinsicVpceWhitelist = intrinsicVpceWhitelist;
                return this;
            }

            public Builder intrinsicVpcWhitelist(List<String> intrinsicVpcWhitelist) {
                this.intrinsicVpcWhitelist = intrinsicVpcWhitelist;
                return this;
            }

            public Builder ipRangeBlacklist(List<String> ipRangeBlacklist) {
                this.ipRangeBlacklist = ipRangeBlacklist;
                return this;
            }

            public Builder ipRangeWhitelist(List<String> ipRangeWhitelist) {
                this.ipRangeWhitelist = ipRangeWhitelist;
                return this;
            }

            public Builder sourceVpcBlacklist(List<String> sourceVpcBlacklist) {
                this.sourceVpcBlacklist = sourceVpcBlacklist;
                return this;
            }

            public Builder sourceVpcWhitelist(List<String> sourceVpcWhitelist) {
                this.sourceVpcWhitelist = sourceVpcWhitelist;
                return this;
            }

            public AuthResourcePolicyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.AuthProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getApiKeyRequired() {
            return null;
        }

        @Nullable
        default public List<String> getAuthorizationScopes() {
            return null;
        }

        @Nullable
        default public String getAuthorizer() {
            return null;
        }

        @Nullable
        default public Object getResourcePolicy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuthProperty> {
            Object apiKeyRequired;
            List<String> authorizationScopes;
            String authorizer;
            Object resourcePolicy;

            public Builder apiKeyRequired(Boolean apiKeyRequired) {
                this.apiKeyRequired = apiKeyRequired;
                return this;
            }

            public Builder apiKeyRequired(IResolvable apiKeyRequired) {
                this.apiKeyRequired = apiKeyRequired;
                return this;
            }

            public Builder authorizationScopes(List<String> authorizationScopes) {
                this.authorizationScopes = authorizationScopes;
                return this;
            }

            public Builder authorizer(String authorizer) {
                this.authorizer = authorizer;
                return this;
            }

            public Builder resourcePolicy(IResolvable resourcePolicy) {
                this.resourcePolicy = resourcePolicy;
                return this;
            }

            public Builder resourcePolicy(AuthResourcePolicyProperty resourcePolicy) {
                this.resourcePolicy = resourcePolicy;
                return this;
            }

            public AuthProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.ApiEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApiEventProperty
    extends JsiiSerializable {
        @NotNull
        public String getMethod();

        @NotNull
        public String getPath();

        @Nullable
        default public Object getAuth() {
            return null;
        }

        @Nullable
        default public String getRestApiId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ApiEventProperty> {
            String method;
            String path;
            Object auth;
            String restApiId;

            public Builder method(String method) {
                this.method = method;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder auth(IResolvable auth) {
                this.auth = auth;
                return this;
            }

            public Builder auth(AuthProperty auth) {
                this.auth = auth;
                return this;
            }

            public Builder restApiId(String restApiId) {
                this.restApiId = restApiId;
                return this;
            }

            public ApiEventProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnFunction.AlexaSkillEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AlexaSkillEventProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getVariables() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AlexaSkillEventProperty> {
            Object variables;

            public Builder variables(IResolvable variables) {
                this.variables = variables;
                return this;
            }

            public Builder variables(Map<String, String> variables) {
                this.variables = variables;
                return this;
            }

            public AlexaSkillEventProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

