/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sam;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.sam.CfnApi;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnApiProps
extends JsiiSerializable {
    public String getStageName();

    public Object getAuth();

    public List<String> getBinaryMediaTypes();

    public Object getCacheClusterEnabled();

    public String getCacheClusterSize();

    public String getCors();

    public Object getDefinitionBody();

    public Object getDefinitionUri();

    public String getEndpointConfiguration();

    public Object getMethodSettings();

    public String getName();

    public Object getTracingEnabled();

    public Object getVariables();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _stageName;
        @Nullable
        private Object _auth;
        @Nullable
        private List<String> _binaryMediaTypes;
        @Nullable
        private Object _cacheClusterEnabled;
        @Nullable
        private String _cacheClusterSize;
        @Nullable
        private String _cors;
        @Nullable
        private Object _definitionBody;
        @Nullable
        private Object _definitionUri;
        @Nullable
        private String _endpointConfiguration;
        @Nullable
        private Object _methodSettings;
        @Nullable
        private String _name;
        @Nullable
        private Object _tracingEnabled;
        @Nullable
        private Object _variables;

        public Builder withStageName(String value) {
            this._stageName = Objects.requireNonNull(value, "stageName is required");
            return this;
        }

        public Builder withAuth(@Nullable CfnApi.AuthProperty value) {
            this._auth = value;
            return this;
        }

        public Builder withAuth(@Nullable Token value) {
            this._auth = value;
            return this;
        }

        public Builder withBinaryMediaTypes(@Nullable List<String> value) {
            this._binaryMediaTypes = value;
            return this;
        }

        public Builder withCacheClusterEnabled(@Nullable Boolean value) {
            this._cacheClusterEnabled = value;
            return this;
        }

        public Builder withCacheClusterEnabled(@Nullable Token value) {
            this._cacheClusterEnabled = value;
            return this;
        }

        public Builder withCacheClusterSize(@Nullable String value) {
            this._cacheClusterSize = value;
            return this;
        }

        public Builder withCors(@Nullable String value) {
            this._cors = value;
            return this;
        }

        public Builder withDefinitionBody(@Nullable ObjectNode value) {
            this._definitionBody = value;
            return this;
        }

        public Builder withDefinitionBody(@Nullable Token value) {
            this._definitionBody = value;
            return this;
        }

        public Builder withDefinitionUri(@Nullable String value) {
            this._definitionUri = value;
            return this;
        }

        public Builder withDefinitionUri(@Nullable Token value) {
            this._definitionUri = value;
            return this;
        }

        public Builder withDefinitionUri(@Nullable CfnApi.S3LocationProperty value) {
            this._definitionUri = value;
            return this;
        }

        public Builder withEndpointConfiguration(@Nullable String value) {
            this._endpointConfiguration = value;
            return this;
        }

        public Builder withMethodSettings(@Nullable ObjectNode value) {
            this._methodSettings = value;
            return this;
        }

        public Builder withMethodSettings(@Nullable Token value) {
            this._methodSettings = value;
            return this;
        }

        public Builder withName(@Nullable String value) {
            this._name = value;
            return this;
        }

        public Builder withTracingEnabled(@Nullable Boolean value) {
            this._tracingEnabled = value;
            return this;
        }

        public Builder withTracingEnabled(@Nullable Token value) {
            this._tracingEnabled = value;
            return this;
        }

        public Builder withVariables(@Nullable Token value) {
            this._variables = value;
            return this;
        }

        public Builder withVariables(@Nullable Map<String, String> value) {
            this._variables = value;
            return this;
        }

        public CfnApiProps build() {
            return new CfnApiProps(){
                private final String $stageName;
                @Nullable
                private final Object $auth;
                @Nullable
                private final List<String> $binaryMediaTypes;
                @Nullable
                private final Object $cacheClusterEnabled;
                @Nullable
                private final String $cacheClusterSize;
                @Nullable
                private final String $cors;
                @Nullable
                private final Object $definitionBody;
                @Nullable
                private final Object $definitionUri;
                @Nullable
                private final String $endpointConfiguration;
                @Nullable
                private final Object $methodSettings;
                @Nullable
                private final String $name;
                @Nullable
                private final Object $tracingEnabled;
                @Nullable
                private final Object $variables;
                {
                    this.$stageName = Objects.requireNonNull(_stageName, "stageName is required");
                    this.$auth = _auth;
                    this.$binaryMediaTypes = _binaryMediaTypes;
                    this.$cacheClusterEnabled = _cacheClusterEnabled;
                    this.$cacheClusterSize = _cacheClusterSize;
                    this.$cors = _cors;
                    this.$definitionBody = _definitionBody;
                    this.$definitionUri = _definitionUri;
                    this.$endpointConfiguration = _endpointConfiguration;
                    this.$methodSettings = _methodSettings;
                    this.$name = _name;
                    this.$tracingEnabled = _tracingEnabled;
                    this.$variables = _variables;
                }

                @Override
                public String getStageName() {
                    return this.$stageName;
                }

                @Override
                public Object getAuth() {
                    return this.$auth;
                }

                @Override
                public List<String> getBinaryMediaTypes() {
                    return this.$binaryMediaTypes;
                }

                @Override
                public Object getCacheClusterEnabled() {
                    return this.$cacheClusterEnabled;
                }

                @Override
                public String getCacheClusterSize() {
                    return this.$cacheClusterSize;
                }

                @Override
                public String getCors() {
                    return this.$cors;
                }

                @Override
                public Object getDefinitionBody() {
                    return this.$definitionBody;
                }

                @Override
                public Object getDefinitionUri() {
                    return this.$definitionUri;
                }

                @Override
                public String getEndpointConfiguration() {
                    return this.$endpointConfiguration;
                }

                @Override
                public Object getMethodSettings() {
                    return this.$methodSettings;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public Object getTracingEnabled() {
                    return this.$tracingEnabled;
                }

                @Override
                public Object getVariables() {
                    return this.$variables;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("stageName", om.valueToTree((Object)this.getStageName()));
                    obj.set("auth", om.valueToTree(this.getAuth()));
                    obj.set("binaryMediaTypes", om.valueToTree(this.getBinaryMediaTypes()));
                    obj.set("cacheClusterEnabled", om.valueToTree(this.getCacheClusterEnabled()));
                    obj.set("cacheClusterSize", om.valueToTree((Object)this.getCacheClusterSize()));
                    obj.set("cors", om.valueToTree((Object)this.getCors()));
                    obj.set("definitionBody", om.valueToTree(this.getDefinitionBody()));
                    obj.set("definitionUri", om.valueToTree(this.getDefinitionUri()));
                    obj.set("endpointConfiguration", om.valueToTree((Object)this.getEndpointConfiguration()));
                    obj.set("methodSettings", om.valueToTree(this.getMethodSettings()));
                    obj.set("name", om.valueToTree((Object)this.getName()));
                    obj.set("tracingEnabled", om.valueToTree(this.getTracingEnabled()));
                    obj.set("variables", om.valueToTree(this.getVariables()));
                    return obj;
                }
            };
        }
    }
}

