/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sagemaker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.sagemaker.;
import software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule;
import software.amazon.awscdk.services.sagemaker.CfnMonitoringScheduleProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule")
public class CfnMonitoringSchedule
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnMonitoringSchedule.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnMonitoringSchedule(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMonitoringSchedule(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnMonitoringSchedule(@NotNull Construct scope, @NotNull String id, @NotNull CfnMonitoringScheduleProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    @NotNull
    public Object getMonitoringScheduleConfig() {
        return this.jsiiGet("monitoringScheduleConfig", Object.class);
    }

    public void setMonitoringScheduleConfig(@NotNull IResolvable value) {
        this.jsiiSet("monitoringScheduleConfig", Objects.requireNonNull(value, "monitoringScheduleConfig is required"));
    }

    public void setMonitoringScheduleConfig(@NotNull MonitoringScheduleConfigProperty value) {
        this.jsiiSet("monitoringScheduleConfig", Objects.requireNonNull(value, "monitoringScheduleConfig is required"));
    }

    @NotNull
    public String getMonitoringScheduleName() {
        return (String)this.jsiiGet("monitoringScheduleName", String.class);
    }

    public void setMonitoringScheduleName(@NotNull String value) {
        this.jsiiSet("monitoringScheduleName", Objects.requireNonNull(value, "monitoringScheduleName is required"));
    }

    @Nullable
    public String getCreationTime() {
        return (String)this.jsiiGet("creationTime", String.class);
    }

    public void setCreationTime(@Nullable String value) {
        this.jsiiSet("creationTime", value);
    }

    @Nullable
    public String getEndpointName() {
        return (String)this.jsiiGet("endpointName", String.class);
    }

    public void setEndpointName(@Nullable String value) {
        this.jsiiSet("endpointName", value);
    }

    @Nullable
    public String getFailureReason() {
        return (String)this.jsiiGet("failureReason", String.class);
    }

    public void setFailureReason(@Nullable String value) {
        this.jsiiSet("failureReason", value);
    }

    @Nullable
    public String getLastModifiedTime() {
        return (String)this.jsiiGet("lastModifiedTime", String.class);
    }

    public void setLastModifiedTime(@Nullable String value) {
        this.jsiiSet("lastModifiedTime", value);
    }

    @Nullable
    public Object getLastMonitoringExecutionSummary() {
        return this.jsiiGet("lastMonitoringExecutionSummary", Object.class);
    }

    public void setLastMonitoringExecutionSummary(@Nullable IResolvable value) {
        this.jsiiSet("lastMonitoringExecutionSummary", value);
    }

    public void setLastMonitoringExecutionSummary(@Nullable MonitoringExecutionSummaryProperty value) {
        this.jsiiSet("lastMonitoringExecutionSummary", value);
    }

    @Nullable
    public String getMonitoringScheduleArn() {
        return (String)this.jsiiGet("monitoringScheduleArn", String.class);
    }

    public void setMonitoringScheduleArn(@Nullable String value) {
        this.jsiiSet("monitoringScheduleArn", value);
    }

    @Nullable
    public String getMonitoringScheduleStatus() {
        return (String)this.jsiiGet("monitoringScheduleStatus", String.class);
    }

    public void setMonitoringScheduleStatus(@Nullable String value) {
        this.jsiiSet("monitoringScheduleStatus", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnMonitoringSchedule> {
        private final Construct scope;
        private final String id;
        private final CfnMonitoringScheduleProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnMonitoringScheduleProps.Builder();
        }

        public Builder monitoringScheduleConfig(IResolvable monitoringScheduleConfig) {
            this.props.monitoringScheduleConfig(monitoringScheduleConfig);
            return this;
        }

        public Builder monitoringScheduleConfig(MonitoringScheduleConfigProperty monitoringScheduleConfig) {
            this.props.monitoringScheduleConfig(monitoringScheduleConfig);
            return this;
        }

        public Builder monitoringScheduleName(String monitoringScheduleName) {
            this.props.monitoringScheduleName(monitoringScheduleName);
            return this;
        }

        public Builder creationTime(String creationTime) {
            this.props.creationTime(creationTime);
            return this;
        }

        public Builder endpointName(String endpointName) {
            this.props.endpointName(endpointName);
            return this;
        }

        public Builder failureReason(String failureReason) {
            this.props.failureReason(failureReason);
            return this;
        }

        public Builder lastModifiedTime(String lastModifiedTime) {
            this.props.lastModifiedTime(lastModifiedTime);
            return this;
        }

        public Builder lastMonitoringExecutionSummary(IResolvable lastMonitoringExecutionSummary) {
            this.props.lastMonitoringExecutionSummary(lastMonitoringExecutionSummary);
            return this;
        }

        public Builder lastMonitoringExecutionSummary(MonitoringExecutionSummaryProperty lastMonitoringExecutionSummary) {
            this.props.lastMonitoringExecutionSummary(lastMonitoringExecutionSummary);
            return this;
        }

        public Builder monitoringScheduleArn(String monitoringScheduleArn) {
            this.props.monitoringScheduleArn(monitoringScheduleArn);
            return this;
        }

        public Builder monitoringScheduleStatus(String monitoringScheduleStatus) {
            this.props.monitoringScheduleStatus(monitoringScheduleStatus);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnMonitoringSchedule build() {
            return new CfnMonitoringSchedule(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.VpcConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcConfigProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSecurityGroupIds();

        @NotNull
        public List<String> getSubnets();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcConfigProperty> {
            private List<String> securityGroupIds;
            private List<String> subnets;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnets(List<String> subnets) {
                this.subnets = subnets;
                return this;
            }

            public VpcConfigProperty build() {
                return new Jsii.Proxy(this.securityGroupIds, this.subnets, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.StoppingConditionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StoppingConditionProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaxRuntimeInSeconds();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StoppingConditionProperty> {
            private Number maxRuntimeInSeconds;

            public Builder maxRuntimeInSeconds(Number maxRuntimeInSeconds) {
                this.maxRuntimeInSeconds = maxRuntimeInSeconds;
                return this;
            }

            public StoppingConditionProperty build() {
                return new Jsii.Proxy(this.maxRuntimeInSeconds, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.StatisticsResourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StatisticsResourceProperty
    extends JsiiSerializable {
        @Nullable
        default public String getS3Uri() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StatisticsResourceProperty> {
            private String s3Uri;

            public Builder s3Uri(String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            public StatisticsResourceProperty build() {
                return new Jsii.Proxy(this.s3Uri, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.ScheduleConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScheduleConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getScheduleExpression();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScheduleConfigProperty> {
            private String scheduleExpression;

            public Builder scheduleExpression(String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
                return this;
            }

            public ScheduleConfigProperty build() {
                return new Jsii.Proxy(this.scheduleExpression, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.S3OutputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3OutputProperty
    extends JsiiSerializable {
        @NotNull
        public String getLocalPath();

        @NotNull
        public String getS3Uri();

        @Nullable
        default public String getS3UploadMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3OutputProperty> {
            private String localPath;
            private String s3Uri;
            private String s3UploadMode;

            public Builder localPath(String localPath) {
                this.localPath = localPath;
                return this;
            }

            public Builder s3Uri(String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            public Builder s3UploadMode(String s3UploadMode) {
                this.s3UploadMode = s3UploadMode;
                return this;
            }

            public S3OutputProperty build() {
                return new Jsii.Proxy(this.localPath, this.s3Uri, this.s3UploadMode, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.NetworkConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnableInterContainerTrafficEncryption() {
            return null;
        }

        @Nullable
        default public Object getEnableNetworkIsolation() {
            return null;
        }

        @Nullable
        default public Object getVpcConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkConfigProperty> {
            private Object enableInterContainerTrafficEncryption;
            private Object enableNetworkIsolation;
            private Object vpcConfig;

            public Builder enableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
                this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
                return this;
            }

            public Builder enableInterContainerTrafficEncryption(IResolvable enableInterContainerTrafficEncryption) {
                this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
                return this;
            }

            public Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
                this.enableNetworkIsolation = enableNetworkIsolation;
                return this;
            }

            public Builder enableNetworkIsolation(IResolvable enableNetworkIsolation) {
                this.enableNetworkIsolation = enableNetworkIsolation;
                return this;
            }

            public Builder vpcConfig(IResolvable vpcConfig) {
                this.vpcConfig = vpcConfig;
                return this;
            }

            public Builder vpcConfig(VpcConfigProperty vpcConfig) {
                this.vpcConfig = vpcConfig;
                return this;
            }

            public NetworkConfigProperty build() {
                return new Jsii.Proxy(this.enableInterContainerTrafficEncryption, this.enableNetworkIsolation, this.vpcConfig, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringScheduleConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringScheduleConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getMonitoringJobDefinition();

        @Nullable
        default public Object getScheduleConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringScheduleConfigProperty> {
            private Object monitoringJobDefinition;
            private Object scheduleConfig;

            public Builder monitoringJobDefinition(IResolvable monitoringJobDefinition) {
                this.monitoringJobDefinition = monitoringJobDefinition;
                return this;
            }

            public Builder monitoringJobDefinition(MonitoringJobDefinitionProperty monitoringJobDefinition) {
                this.monitoringJobDefinition = monitoringJobDefinition;
                return this;
            }

            public Builder scheduleConfig(IResolvable scheduleConfig) {
                this.scheduleConfig = scheduleConfig;
                return this;
            }

            public Builder scheduleConfig(ScheduleConfigProperty scheduleConfig) {
                this.scheduleConfig = scheduleConfig;
                return this;
            }

            public MonitoringScheduleConfigProperty build() {
                return new Jsii.Proxy(this.monitoringJobDefinition, this.scheduleConfig, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringResourcesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringResourcesProperty
    extends JsiiSerializable {
        @NotNull
        public Object getClusterConfig();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringResourcesProperty> {
            private Object clusterConfig;

            public Builder clusterConfig(IResolvable clusterConfig) {
                this.clusterConfig = clusterConfig;
                return this;
            }

            public Builder clusterConfig(ClusterConfigProperty clusterConfig) {
                this.clusterConfig = clusterConfig;
                return this;
            }

            public MonitoringResourcesProperty build() {
                return new Jsii.Proxy(this.clusterConfig, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringOutputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringOutputProperty
    extends JsiiSerializable {
        @NotNull
        public Object getS3Output();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringOutputProperty> {
            private Object s3Output;

            public Builder s3Output(IResolvable s3Output) {
                this.s3Output = s3Output;
                return this;
            }

            public Builder s3Output(S3OutputProperty s3Output) {
                this.s3Output = s3Output;
                return this;
            }

            public MonitoringOutputProperty build() {
                return new Jsii.Proxy(this.s3Output, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringOutputConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringOutputConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getMonitoringOutputs();

        @Nullable
        default public String getKmsKeyId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringOutputConfigProperty> {
            private Object monitoringOutputs;
            private String kmsKeyId;

            public Builder monitoringOutputs(IResolvable monitoringOutputs) {
                this.monitoringOutputs = monitoringOutputs;
                return this;
            }

            public Builder monitoringOutputs(List<? extends Object> monitoringOutputs) {
                this.monitoringOutputs = monitoringOutputs;
                return this;
            }

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public MonitoringOutputConfigProperty build() {
                return new Jsii.Proxy(this.monitoringOutputs, this.kmsKeyId, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringJobDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringJobDefinitionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getMonitoringAppSpecification();

        @NotNull
        public Object getMonitoringInputs();

        @NotNull
        public Object getMonitoringOutputConfig();

        @NotNull
        public Object getMonitoringResources();

        @NotNull
        public String getRoleArn();

        @Nullable
        default public Object getBaselineConfig() {
            return null;
        }

        @Nullable
        default public Object getEnvironment() {
            return null;
        }

        @Nullable
        default public Object getNetworkConfig() {
            return null;
        }

        @Nullable
        default public Object getStoppingCondition() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringJobDefinitionProperty> {
            private Object monitoringAppSpecification;
            private Object monitoringInputs;
            private Object monitoringOutputConfig;
            private Object monitoringResources;
            private String roleArn;
            private Object baselineConfig;
            private Object environment;
            private Object networkConfig;
            private Object stoppingCondition;

            public Builder monitoringAppSpecification(IResolvable monitoringAppSpecification) {
                this.monitoringAppSpecification = monitoringAppSpecification;
                return this;
            }

            public Builder monitoringAppSpecification(MonitoringAppSpecificationProperty monitoringAppSpecification) {
                this.monitoringAppSpecification = monitoringAppSpecification;
                return this;
            }

            public Builder monitoringInputs(IResolvable monitoringInputs) {
                this.monitoringInputs = monitoringInputs;
                return this;
            }

            public Builder monitoringInputs(MonitoringInputsProperty monitoringInputs) {
                this.monitoringInputs = monitoringInputs;
                return this;
            }

            public Builder monitoringOutputConfig(IResolvable monitoringOutputConfig) {
                this.monitoringOutputConfig = monitoringOutputConfig;
                return this;
            }

            public Builder monitoringOutputConfig(MonitoringOutputConfigProperty monitoringOutputConfig) {
                this.monitoringOutputConfig = monitoringOutputConfig;
                return this;
            }

            public Builder monitoringResources(IResolvable monitoringResources) {
                this.monitoringResources = monitoringResources;
                return this;
            }

            public Builder monitoringResources(MonitoringResourcesProperty monitoringResources) {
                this.monitoringResources = monitoringResources;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder baselineConfig(IResolvable baselineConfig) {
                this.baselineConfig = baselineConfig;
                return this;
            }

            public Builder baselineConfig(BaselineConfigProperty baselineConfig) {
                this.baselineConfig = baselineConfig;
                return this;
            }

            public Builder environment(IResolvable environment) {
                this.environment = environment;
                return this;
            }

            public Builder environment(EnvironmentProperty environment) {
                this.environment = environment;
                return this;
            }

            public Builder networkConfig(IResolvable networkConfig) {
                this.networkConfig = networkConfig;
                return this;
            }

            public Builder networkConfig(NetworkConfigProperty networkConfig) {
                this.networkConfig = networkConfig;
                return this;
            }

            public Builder stoppingCondition(IResolvable stoppingCondition) {
                this.stoppingCondition = stoppingCondition;
                return this;
            }

            public Builder stoppingCondition(StoppingConditionProperty stoppingCondition) {
                this.stoppingCondition = stoppingCondition;
                return this;
            }

            public MonitoringJobDefinitionProperty build() {
                return new Jsii.Proxy(this.monitoringAppSpecification, this.monitoringInputs, this.monitoringOutputConfig, this.monitoringResources, this.roleArn, this.baselineConfig, this.environment, this.networkConfig, this.stoppingCondition, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringInputsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringInputsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getMonitoringInputs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringInputsProperty> {
            private Object monitoringInputs;

            public Builder monitoringInputs(IResolvable monitoringInputs) {
                this.monitoringInputs = monitoringInputs;
                return this;
            }

            public Builder monitoringInputs(List<? extends Object> monitoringInputs) {
                this.monitoringInputs = monitoringInputs;
                return this;
            }

            public MonitoringInputsProperty build() {
                return new Jsii.Proxy(this.monitoringInputs, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringInputProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEndpointInput();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringInputProperty> {
            private Object endpointInput;

            public Builder endpointInput(IResolvable endpointInput) {
                this.endpointInput = endpointInput;
                return this;
            }

            public Builder endpointInput(EndpointInputProperty endpointInput) {
                this.endpointInput = endpointInput;
                return this;
            }

            public MonitoringInputProperty build() {
                return new Jsii.Proxy(this.endpointInput, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringExecutionSummaryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringExecutionSummaryProperty
    extends JsiiSerializable {
        @NotNull
        public String getCreationTime();

        @NotNull
        public String getLastModifiedTime();

        @NotNull
        public String getMonitoringExecutionStatus();

        @NotNull
        public String getMonitoringScheduleName();

        @NotNull
        public String getScheduledTime();

        @Nullable
        default public String getEndpointName() {
            return null;
        }

        @Nullable
        default public String getFailureReason() {
            return null;
        }

        @Nullable
        default public String getProcessingJobArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringExecutionSummaryProperty> {
            private String creationTime;
            private String lastModifiedTime;
            private String monitoringExecutionStatus;
            private String monitoringScheduleName;
            private String scheduledTime;
            private String endpointName;
            private String failureReason;
            private String processingJobArn;

            public Builder creationTime(String creationTime) {
                this.creationTime = creationTime;
                return this;
            }

            public Builder lastModifiedTime(String lastModifiedTime) {
                this.lastModifiedTime = lastModifiedTime;
                return this;
            }

            public Builder monitoringExecutionStatus(String monitoringExecutionStatus) {
                this.monitoringExecutionStatus = monitoringExecutionStatus;
                return this;
            }

            public Builder monitoringScheduleName(String monitoringScheduleName) {
                this.monitoringScheduleName = monitoringScheduleName;
                return this;
            }

            public Builder scheduledTime(String scheduledTime) {
                this.scheduledTime = scheduledTime;
                return this;
            }

            public Builder endpointName(String endpointName) {
                this.endpointName = endpointName;
                return this;
            }

            public Builder failureReason(String failureReason) {
                this.failureReason = failureReason;
                return this;
            }

            public Builder processingJobArn(String processingJobArn) {
                this.processingJobArn = processingJobArn;
                return this;
            }

            public MonitoringExecutionSummaryProperty build() {
                return new Jsii.Proxy(this.creationTime, this.lastModifiedTime, this.monitoringExecutionStatus, this.monitoringScheduleName, this.scheduledTime, this.endpointName, this.failureReason, this.processingJobArn, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.MonitoringAppSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringAppSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getImageUri();

        @Nullable
        default public List<String> getContainerArguments() {
            return null;
        }

        @Nullable
        default public List<String> getContainerEntrypoint() {
            return null;
        }

        @Nullable
        default public String getPostAnalyticsProcessorSourceUri() {
            return null;
        }

        @Nullable
        default public String getRecordPreprocessorSourceUri() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringAppSpecificationProperty> {
            private String imageUri;
            private List<String> containerArguments;
            private List<String> containerEntrypoint;
            private String postAnalyticsProcessorSourceUri;
            private String recordPreprocessorSourceUri;

            public Builder imageUri(String imageUri) {
                this.imageUri = imageUri;
                return this;
            }

            public Builder containerArguments(List<String> containerArguments) {
                this.containerArguments = containerArguments;
                return this;
            }

            public Builder containerEntrypoint(List<String> containerEntrypoint) {
                this.containerEntrypoint = containerEntrypoint;
                return this;
            }

            public Builder postAnalyticsProcessorSourceUri(String postAnalyticsProcessorSourceUri) {
                this.postAnalyticsProcessorSourceUri = postAnalyticsProcessorSourceUri;
                return this;
            }

            public Builder recordPreprocessorSourceUri(String recordPreprocessorSourceUri) {
                this.recordPreprocessorSourceUri = recordPreprocessorSourceUri;
                return this;
            }

            public MonitoringAppSpecificationProperty build() {
                return new Jsii.Proxy(this.imageUri, this.containerArguments, this.containerEntrypoint, this.postAnalyticsProcessorSourceUri, this.recordPreprocessorSourceUri, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.EnvironmentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnvironmentProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnvironmentProperty> {
            public EnvironmentProperty build() {
                return new Jsii.Proxy(null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.EndpointInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EndpointInputProperty
    extends JsiiSerializable {
        @NotNull
        public String getEndpointName();

        @NotNull
        public String getLocalPath();

        @Nullable
        default public String getS3DataDistributionType() {
            return null;
        }

        @Nullable
        default public String getS3InputMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EndpointInputProperty> {
            private String endpointName;
            private String localPath;
            private String s3DataDistributionType;
            private String s3InputMode;

            public Builder endpointName(String endpointName) {
                this.endpointName = endpointName;
                return this;
            }

            public Builder localPath(String localPath) {
                this.localPath = localPath;
                return this;
            }

            public Builder s3DataDistributionType(String s3DataDistributionType) {
                this.s3DataDistributionType = s3DataDistributionType;
                return this;
            }

            public Builder s3InputMode(String s3InputMode) {
                this.s3InputMode = s3InputMode;
                return this;
            }

            public EndpointInputProperty build() {
                return new Jsii.Proxy(this.endpointName, this.localPath, this.s3DataDistributionType, this.s3InputMode, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.ConstraintsResourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConstraintsResourceProperty
    extends JsiiSerializable {
        @Nullable
        default public String getS3Uri() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConstraintsResourceProperty> {
            private String s3Uri;

            public Builder s3Uri(String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            public ConstraintsResourceProperty build() {
                return new Jsii.Proxy(this.s3Uri, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.ClusterConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClusterConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Number getInstanceCount();

        @NotNull
        public String getInstanceType();

        @NotNull
        public Number getVolumeSizeInGb();

        @Nullable
        default public String getVolumeKmsKeyId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClusterConfigProperty> {
            private Number instanceCount;
            private String instanceType;
            private Number volumeSizeInGb;
            private String volumeKmsKeyId;

            public Builder instanceCount(Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder volumeSizeInGb(Number volumeSizeInGb) {
                this.volumeSizeInGb = volumeSizeInGb;
                return this;
            }

            public Builder volumeKmsKeyId(String volumeKmsKeyId) {
                this.volumeKmsKeyId = volumeKmsKeyId;
                return this;
            }

            public ClusterConfigProperty build() {
                return new Jsii.Proxy(this.instanceCount, this.instanceType, this.volumeSizeInGb, this.volumeKmsKeyId, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sagemaker.CfnMonitoringSchedule.BaselineConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BaselineConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConstraintsResource() {
            return null;
        }

        @Nullable
        default public Object getStatisticsResource() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BaselineConfigProperty> {
            private Object constraintsResource;
            private Object statisticsResource;

            public Builder constraintsResource(IResolvable constraintsResource) {
                this.constraintsResource = constraintsResource;
                return this;
            }

            public Builder constraintsResource(ConstraintsResourceProperty constraintsResource) {
                this.constraintsResource = constraintsResource;
                return this;
            }

            public Builder statisticsResource(IResolvable statisticsResource) {
                this.statisticsResource = statisticsResource;
                return this;
            }

            public Builder statisticsResource(StatisticsResourceProperty statisticsResource) {
                this.statisticsResource = statisticsResource;
                return this;
            }

            public BaselineConfigProperty build() {
                return new Jsii.Proxy(this.constraintsResource, this.statisticsResource, null);
            }
        }
    }
}

