/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3.deployment;

import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.s3.deployment.ISource;
import software.amazon.jsii.JsiiSerializable;

public interface BucketDeploymentProps
extends JsiiSerializable {
    public IBucket getDestinationBucket();

    public void setDestinationBucket(IBucket var1);

    public ISource getSource();

    public void setSource(ISource var1);

    public String getDestinationKeyPrefix();

    public void setDestinationKeyPrefix(String var1);

    public Boolean getRetainOnDelete();

    public void setRetainOnDelete(Boolean var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IBucket _destinationBucket;
        private ISource _source;
        @Nullable
        private String _destinationKeyPrefix;
        @Nullable
        private Boolean _retainOnDelete;

        public Builder withDestinationBucket(IBucket value) {
            this._destinationBucket = Objects.requireNonNull(value, "destinationBucket is required");
            return this;
        }

        public Builder withSource(ISource value) {
            this._source = Objects.requireNonNull(value, "source is required");
            return this;
        }

        public Builder withDestinationKeyPrefix(@Nullable String value) {
            this._destinationKeyPrefix = value;
            return this;
        }

        public Builder withRetainOnDelete(@Nullable Boolean value) {
            this._retainOnDelete = value;
            return this;
        }

        public BucketDeploymentProps build() {
            return new BucketDeploymentProps(){
                private IBucket $destinationBucket;
                private ISource $source;
                @Nullable
                private String $destinationKeyPrefix;
                @Nullable
                private Boolean $retainOnDelete;
                {
                    this.$destinationBucket = Objects.requireNonNull(_destinationBucket, "destinationBucket is required");
                    this.$source = Objects.requireNonNull(_source, "source is required");
                    this.$destinationKeyPrefix = _destinationKeyPrefix;
                    this.$retainOnDelete = _retainOnDelete;
                }

                @Override
                public IBucket getDestinationBucket() {
                    return this.$destinationBucket;
                }

                @Override
                public void setDestinationBucket(IBucket value) {
                    this.$destinationBucket = Objects.requireNonNull(value, "destinationBucket is required");
                }

                @Override
                public ISource getSource() {
                    return this.$source;
                }

                @Override
                public void setSource(ISource value) {
                    this.$source = Objects.requireNonNull(value, "source is required");
                }

                @Override
                public String getDestinationKeyPrefix() {
                    return this.$destinationKeyPrefix;
                }

                @Override
                public void setDestinationKeyPrefix(@Nullable String value) {
                    this.$destinationKeyPrefix = value;
                }

                @Override
                public Boolean getRetainOnDelete() {
                    return this.$retainOnDelete;
                }

                @Override
                public void setRetainOnDelete(@Nullable Boolean value) {
                    this.$retainOnDelete = value;
                }
            };
        }
    }
}

