package software.amazon.awscdk.services.redshift;

/**
 * Properties for creating a ClusterSubnetGroup.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.12.0 (build 5ddc9f2)", date = "2020-09-25T17:39:22.159Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.redshift.$Module.class, fqn = "@aws-cdk/aws-redshift.ClusterSubnetGroupProps")
@software.amazon.jsii.Jsii.Proxy(ClusterSubnetGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ClusterSubnetGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Description of the subnet group.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getDescription();

    /**
     * The VPC to place the subnet group in.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * The removal policy to apply when the subnet group are removed from the stack or replaced during an update.
     * <p>
     * Default: RemovalPolicy.RETAIN
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * Which subnets within the VPC to associate with this group.
     * <p>
     * Default: - private subnets
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ClusterSubnetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClusterSubnetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ClusterSubnetGroupProps> {
        private java.lang.String description;
        private software.amazon.awscdk.services.ec2.IVpc vpc;
        private software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link ClusterSubnetGroupProps#getDescription}
         * @param description Description of the subnet group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ClusterSubnetGroupProps#getVpc}
         * @param vpc The VPC to place the subnet group in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link ClusterSubnetGroupProps#getRemovalPolicy}
         * @param removalPolicy The removal policy to apply when the subnet group are removed from the stack or replaced during an update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ClusterSubnetGroupProps#getVpcSubnets}
         * @param vpcSubnets Which subnets within the VPC to associate with this group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClusterSubnetGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ClusterSubnetGroupProps build() {
            return new Jsii$Proxy(description, vpc, removalPolicy, vpcSubnets);
        }
    }

    /**
     * An implementation for {@link ClusterSubnetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterSubnetGroupProps {
        private final java.lang.String description;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
            this.removalPolicy = this.jsiiGet("removalPolicy", software.amazon.awscdk.core.RemovalPolicy.class);
            this.vpcSubnets = this.jsiiGet("vpcSubnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String description, final software.amazon.awscdk.services.ec2.IVpc vpc, final software.amazon.awscdk.core.RemovalPolicy removalPolicy, final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = java.util.Objects.requireNonNull(description, "description is required");
            this.vpc = java.util.Objects.requireNonNull(vpc, "vpc is required");
            this.removalPolicy = removalPolicy;
            this.vpcSubnets = vpcSubnets;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("description", om.valueToTree(this.getDescription()));
            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-redshift.ClusterSubnetGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClusterSubnetGroupProps.Jsii$Proxy that = (ClusterSubnetGroupProps.Jsii$Proxy) o;

            if (!description.equals(that.description)) return false;
            if (!vpc.equals(that.vpc)) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public int hashCode() {
            int result = this.description.hashCode();
            result = 31 * result + (this.vpc.hashCode());
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
