package software.amazon.awscdk.services.redshift;

/**
 * (experimental) A user in a Redshift cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kms.*;
 * Key encryptionKey = new Key(this, "Key");
 * User.Builder.create(this, "User")
 *         .encryptionKey(encryptionKey)
 *         .cluster(cluster)
 *         .databaseName("databaseName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.50.0 (build d1830a4)", date = "2022-01-07T14:33:54.810Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.redshift.$Module.class, fqn = "@aws-cdk/aws-redshift.User")
public class User extends software.amazon.awscdk.core.Construct implements software.amazon.awscdk.services.redshift.IUser {

    protected User(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected User(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public User(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.redshift.UserProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Specify a Redshift user using credentials that already exist.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.redshift.IUser fromUserAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.redshift.UserAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.redshift.User.class, "fromUserAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.redshift.IUser.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) Grant this user privilege to access a table.
     * <p>
     * @param table This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addTablePrivileges(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.redshift.ITable table, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.redshift.TableAction... actions) {
        software.amazon.jsii.Kernel.call(this, "addTablePrivileges", software.amazon.jsii.NativeType.VOID, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(table, "table is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * (experimental) Apply the given removal policy to this resource.
     * <p>
     * The Removal Policy controls what happens to this resource when it stops
     * being managed by CloudFormation, either because you've removed it from the
     * CDK application or because you've made a change that requires the resource
     * to be replaced.
     * <p>
     * The resource can be destroyed (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
     * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
     * <p>
     * This resource is destroyed by default.
     * <p>
     * @param policy This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.RemovalPolicy policy) {
        software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
    }

    /**
     * (experimental) The cluster where the table is located.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.redshift.ICluster getCluster() {
        return software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.redshift.ICluster.class));
    }

    /**
     * (experimental) The name of the database where the table is located.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName() {
        return software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The password of the user.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.SecretValue getPassword() {
        return software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.SecretValue.class));
    }

    /**
     * (experimental) The name of the user.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getUsername() {
        return software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.redshift.DatabaseOptions getDatabaseProps() {
        return software.amazon.jsii.Kernel.get(this, "databaseProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.redshift.DatabaseOptions.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void setDatabaseProps(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.redshift.DatabaseOptions value) {
        software.amazon.jsii.Kernel.set(this, "databaseProps", java.util.Objects.requireNonNull(value, "databaseProps is required"));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.redshift.User}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.redshift.User> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.redshift.UserProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.redshift.UserProps.Builder();
        }

        /**
         * (experimental) The cluster containing the database.
         * <p>
         * @return {@code this}
         * @param cluster The cluster containing the database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cluster(final software.amazon.awscdk.services.redshift.ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * (experimental) The name of the database.
         * <p>
         * @return {@code this}
         * @param databaseName The name of the database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder databaseName(final java.lang.String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        /**
         * (experimental) The secret containing credentials to a Redshift user with administrator privileges.
         * <p>
         * Secret JSON schema: <code>{ username: string; password: string }</code>.
         * <p>
         * Default: - the admin secret is taken from the cluster
         * <p>
         * @return {@code this}
         * @param adminUser The secret containing credentials to a Redshift user with administrator privileges. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder adminUser(final software.amazon.awscdk.services.secretsmanager.ISecret adminUser) {
            this.props.adminUser(adminUser);
            return this;
        }

        /**
         * (experimental) KMS key to encrypt the generated secret.
         * <p>
         * Default: - the default AWS managed key is used
         * <p>
         * @return {@code this}
         * @param encryptionKey KMS key to encrypt the generated secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        /**
         * (experimental) The policy to apply when this resource is removed from the application.
         * <p>
         * Default: cdk.RemovalPolicy.Destroy
         * <p>
         * @return {@code this}
         * @param removalPolicy The policy to apply when this resource is removed from the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(final software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * (experimental) The name of the user.
         * <p>
         * For valid values, see: https://docs.aws.amazon.com/redshift/latest/dg/r_names.html
         * <p>
         * Default: - a name is generated
         * <p>
         * @return {@code this}
         * @param username The name of the user. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder username(final java.lang.String username) {
            this.props.username(username);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.redshift.User}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.redshift.User build() {
            return new software.amazon.awscdk.services.redshift.User(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
