package software.amazon.awscdk.services.redshift;

/**
 * (experimental) A full specification of a Redshift user that can be used to import it fluently into the CDK application.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * String databaseName = "databaseName";
 * String username = "myuser";
 * String tableName = "mytable";
 * IUser user = User.fromUserAttributes(this, "User", UserAttributes.builder()
 *         .username(username)
 *         .password(SecretValue.plainText("NOT_FOR_PRODUCTION"))
 *         .cluster(cluster)
 *         .databaseName(databaseName)
 *         .build());
 * ITable table = Table.fromTableAttributes(this, "Table", TableAttributes.builder()
 *         .tableName(tableName)
 *         .tableColumns(List.of(Column.builder().name("col1").dataType("varchar(4)").build(), Column.builder().name("col2").dataType("float").build()))
 *         .cluster(cluster)
 *         .databaseName("databaseName")
 *         .build());
 * table.grant(user, TableAction.INSERT);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-15T10:03:46.166Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.redshift.$Module.class, fqn = "@aws-cdk/aws-redshift.UserAttributes")
@software.amazon.jsii.Jsii.Proxy(UserAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface UserAttributes extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.redshift.DatabaseOptions {

    /**
     * (experimental) The password of the user.
     * <p>
     * Do not put passwords in CDK code directly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.SecretValue getPassword();

    /**
     * (experimental) The name of the user.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getUsername();

    /**
     * @return a {@link Builder} of {@link UserAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<UserAttributes> {
        software.amazon.awscdk.core.SecretValue password;
        java.lang.String username;
        software.amazon.awscdk.services.secretsmanager.ISecret adminUser;
        software.amazon.awscdk.services.redshift.ICluster cluster;
        java.lang.String databaseName;

        /**
         * Sets the value of {@link UserAttributes#getPassword}
         * @param password The password of the user. This parameter is required.
         *                 Do not put passwords in CDK code directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder password(software.amazon.awscdk.core.SecretValue password) {
            this.password = password;
            return this;
        }

        /**
         * Sets the value of {@link UserAttributes#getUsername}
         * @param username The name of the user. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder username(java.lang.String username) {
            this.username = username;
            return this;
        }

        /**
         * Sets the value of {@link UserAttributes#getAdminUser}
         * @param adminUser The secret containing credentials to a Redshift user with administrator privileges.
         *                  Secret JSON schema: <code>{ username: string; password: string }</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder adminUser(software.amazon.awscdk.services.secretsmanager.ISecret adminUser) {
            this.adminUser = adminUser;
            return this;
        }

        /**
         * Sets the value of {@link UserAttributes#getCluster}
         * @param cluster The cluster containing the database. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cluster(software.amazon.awscdk.services.redshift.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link UserAttributes#getDatabaseName}
         * @param databaseName The name of the database. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder databaseName(java.lang.String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public UserAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserAttributes {
        private final software.amazon.awscdk.core.SecretValue password;
        private final java.lang.String username;
        private final software.amazon.awscdk.services.secretsmanager.ISecret adminUser;
        private final software.amazon.awscdk.services.redshift.ICluster cluster;
        private final java.lang.String databaseName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.SecretValue.class));
            this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.adminUser = software.amazon.jsii.Kernel.get(this, "adminUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.redshift.ICluster.class));
            this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.password = java.util.Objects.requireNonNull(builder.password, "password is required");
            this.username = java.util.Objects.requireNonNull(builder.username, "username is required");
            this.adminUser = builder.adminUser;
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
        }

        @Override
        public final software.amazon.awscdk.core.SecretValue getPassword() {
            return this.password;
        }

        @Override
        public final java.lang.String getUsername() {
            return this.username;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getAdminUser() {
            return this.adminUser;
        }

        @Override
        public final software.amazon.awscdk.services.redshift.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.lang.String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("password", om.valueToTree(this.getPassword()));
            data.set("username", om.valueToTree(this.getUsername()));
            if (this.getAdminUser() != null) {
                data.set("adminUser", om.valueToTree(this.getAdminUser()));
            }
            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("databaseName", om.valueToTree(this.getDatabaseName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-redshift.UserAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserAttributes.Jsii$Proxy that = (UserAttributes.Jsii$Proxy) o;

            if (!password.equals(that.password)) return false;
            if (!username.equals(that.username)) return false;
            if (this.adminUser != null ? !this.adminUser.equals(that.adminUser) : that.adminUser != null) return false;
            if (!cluster.equals(that.cluster)) return false;
            return this.databaseName.equals(that.databaseName);
        }

        @Override
        public final int hashCode() {
            int result = this.password.hashCode();
            result = 31 * result + (this.username.hashCode());
            result = 31 * result + (this.adminUser != null ? this.adminUser.hashCode() : 0);
            result = 31 * result + (this.cluster.hashCode());
            result = 31 * result + (this.databaseName.hashCode());
            return result;
        }
    }
}
