package software.amazon.awscdk.services.redshift;

/**
 * (experimental) Properties for configuring a Redshift table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Table.Builder.create(this, "Table")
 *         .tableColumns(List.of(Column.builder().name("col1").dataType("varchar(4)").distKey(true).build(), Column.builder().name("col2").dataType("float").build()))
 *         .cluster(cluster)
 *         .databaseName("databaseName")
 *         .distStyle(TableDistStyle.KEY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-10T18:02:01.940Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.redshift.$Module.class, fqn = "@aws-cdk/aws-redshift.TableProps")
@software.amazon.jsii.Jsii.Proxy(TableProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface TableProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.redshift.DatabaseOptions {

    /**
     * (experimental) The columns of the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.redshift.Column> getTableColumns();

    /**
     * (experimental) The distribution style of the table.
     * <p>
     * Default: TableDistStyle.AUTO
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.redshift.TableDistStyle getDistStyle() {
        return null;
    }

    /**
     * (experimental) The policy to apply when this resource is removed from the application.
     * <p>
     * Default: cdk.RemovalPolicy.Retain
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * (experimental) The sort style of the table.
     * <p>
     * Default: TableSortStyle.AUTO if no sort key is specified, TableSortStyle.COMPOUND if a sort key is specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.redshift.TableSortStyle getSortStyle() {
        return null;
    }

    /**
     * (experimental) The name of the table.
     * <p>
     * Default: - a name is generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<TableProps> {
        java.util.List<software.amazon.awscdk.services.redshift.Column> tableColumns;
        software.amazon.awscdk.services.redshift.TableDistStyle distStyle;
        software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        software.amazon.awscdk.services.redshift.TableSortStyle sortStyle;
        java.lang.String tableName;
        software.amazon.awscdk.services.secretsmanager.ISecret adminUser;
        software.amazon.awscdk.services.redshift.ICluster cluster;
        java.lang.String databaseName;

        /**
         * Sets the value of {@link TableProps#getTableColumns}
         * @param tableColumns The columns of the table. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder tableColumns(java.util.List<? extends software.amazon.awscdk.services.redshift.Column> tableColumns) {
            this.tableColumns = (java.util.List<software.amazon.awscdk.services.redshift.Column>)tableColumns;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getDistStyle}
         * @param distStyle The distribution style of the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder distStyle(software.amazon.awscdk.services.redshift.TableDistStyle distStyle) {
            this.distStyle = distStyle;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getRemovalPolicy}
         * @param removalPolicy The policy to apply when this resource is removed from the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getSortStyle}
         * @param sortStyle The sort style of the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sortStyle(software.amazon.awscdk.services.redshift.TableSortStyle sortStyle) {
            this.sortStyle = sortStyle;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getTableName}
         * @param tableName The name of the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getAdminUser}
         * @param adminUser The secret containing credentials to a Redshift user with administrator privileges.
         *                  Secret JSON schema: <code>{ username: string; password: string }</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder adminUser(software.amazon.awscdk.services.secretsmanager.ISecret adminUser) {
            this.adminUser = adminUser;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getCluster}
         * @param cluster The cluster containing the database. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cluster(software.amazon.awscdk.services.redshift.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getDatabaseName}
         * @param databaseName The name of the database. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder databaseName(java.lang.String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TableProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public TableProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableProps {
        private final java.util.List<software.amazon.awscdk.services.redshift.Column> tableColumns;
        private final software.amazon.awscdk.services.redshift.TableDistStyle distStyle;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.services.redshift.TableSortStyle sortStyle;
        private final java.lang.String tableName;
        private final software.amazon.awscdk.services.secretsmanager.ISecret adminUser;
        private final software.amazon.awscdk.services.redshift.ICluster cluster;
        private final java.lang.String databaseName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.tableColumns = software.amazon.jsii.Kernel.get(this, "tableColumns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.redshift.Column.class)));
            this.distStyle = software.amazon.jsii.Kernel.get(this, "distStyle", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.redshift.TableDistStyle.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.RemovalPolicy.class));
            this.sortStyle = software.amazon.jsii.Kernel.get(this, "sortStyle", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.redshift.TableSortStyle.class));
            this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.adminUser = software.amazon.jsii.Kernel.get(this, "adminUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.redshift.ICluster.class));
            this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.tableColumns = (java.util.List<software.amazon.awscdk.services.redshift.Column>)java.util.Objects.requireNonNull(builder.tableColumns, "tableColumns is required");
            this.distStyle = builder.distStyle;
            this.removalPolicy = builder.removalPolicy;
            this.sortStyle = builder.sortStyle;
            this.tableName = builder.tableName;
            this.adminUser = builder.adminUser;
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.redshift.Column> getTableColumns() {
            return this.tableColumns;
        }

        @Override
        public final software.amazon.awscdk.services.redshift.TableDistStyle getDistStyle() {
            return this.distStyle;
        }

        @Override
        public final software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.redshift.TableSortStyle getSortStyle() {
            return this.sortStyle;
        }

        @Override
        public final java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getAdminUser() {
            return this.adminUser;
        }

        @Override
        public final software.amazon.awscdk.services.redshift.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.lang.String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("tableColumns", om.valueToTree(this.getTableColumns()));
            if (this.getDistStyle() != null) {
                data.set("distStyle", om.valueToTree(this.getDistStyle()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getSortStyle() != null) {
                data.set("sortStyle", om.valueToTree(this.getSortStyle()));
            }
            if (this.getTableName() != null) {
                data.set("tableName", om.valueToTree(this.getTableName()));
            }
            if (this.getAdminUser() != null) {
                data.set("adminUser", om.valueToTree(this.getAdminUser()));
            }
            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("databaseName", om.valueToTree(this.getDatabaseName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-redshift.TableProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TableProps.Jsii$Proxy that = (TableProps.Jsii$Proxy) o;

            if (!tableColumns.equals(that.tableColumns)) return false;
            if (this.distStyle != null ? !this.distStyle.equals(that.distStyle) : that.distStyle != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.sortStyle != null ? !this.sortStyle.equals(that.sortStyle) : that.sortStyle != null) return false;
            if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) return false;
            if (this.adminUser != null ? !this.adminUser.equals(that.adminUser) : that.adminUser != null) return false;
            if (!cluster.equals(that.cluster)) return false;
            return this.databaseName.equals(that.databaseName);
        }

        @Override
        public final int hashCode() {
            int result = this.tableColumns.hashCode();
            result = 31 * result + (this.distStyle != null ? this.distStyle.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.sortStyle != null ? this.sortStyle.hashCode() : 0);
            result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
            result = 31 * result + (this.adminUser != null ? this.adminUser.hashCode() : 0);
            result = 31 * result + (this.cluster.hashCode());
            result = 31 * result + (this.databaseName.hashCode());
            return result;
        }
    }
}
