/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.redshift;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.services.redshift.$Module;
import software.amazon.awscdk.services.redshift.Column;
import software.amazon.awscdk.services.redshift.ICluster;
import software.amazon.awscdk.services.redshift.ITable;
import software.amazon.awscdk.services.redshift.IUser;
import software.amazon.awscdk.services.redshift.TableAction;
import software.amazon.awscdk.services.redshift.TableAttributes;
import software.amazon.awscdk.services.redshift.TableProps;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-redshift.Table")
public class Table
extends Construct
implements ITable {
    protected Table(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Table(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Table(@NotNull software.constructs.Construct scope, @NotNull String id, @NotNull TableProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ITable fromTableAttributes(@NotNull software.constructs.Construct scope, @NotNull String id, @NotNull TableAttributes attrs) {
        return (ITable)JsiiObject.jsiiStaticCall(Table.class, (String)"fromTableAttributes", (NativeType)NativeType.forClass(ITable.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    public void applyRemovalPolicy(@NotNull RemovalPolicy policy) {
        Kernel.call((Object)this, (String)"applyRemovalPolicy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(policy, "policy is required")});
    }

    @Override
    public void grant(@NotNull IUser user, TableAction ... actions) {
        Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.VOID, (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(user, "user is required")}), Arrays.stream(actions)).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public ICluster getCluster() {
        return (ICluster)Kernel.get((Object)this, (String)"cluster", (NativeType)NativeType.forClass(ICluster.class));
    }

    @Override
    @NotNull
    public String getDatabaseName() {
        return (String)Kernel.get((Object)this, (String)"databaseName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public List<Column> getTableColumns() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"tableColumns", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Column.class))));
    }

    @Override
    @NotNull
    public String getTableName() {
        return (String)Kernel.get((Object)this, (String)"tableName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Table> {
        private final software.constructs.Construct scope;
        private final String id;
        private final TableProps.Builder props;

        public static Builder create(software.constructs.Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(software.constructs.Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new TableProps.Builder();
        }

        public Builder cluster(ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        public Builder adminUser(ISecret adminUser) {
            this.props.adminUser(adminUser);
            return this;
        }

        public Builder tableColumns(List<? extends Column> tableColumns) {
            this.props.tableColumns(tableColumns);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder tableName(String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        public Table build() {
            return new Table(this.scope, this.id, this.props.build());
        }
    }
}

