/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.redshift;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.redshift.CfnCluster;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnClusterProps
extends JsiiSerializable {
    public String getClusterType();

    public String getDbName();

    public String getMasterUsername();

    public String getMasterUserPassword();

    public String getNodeType();

    public Object getAllowVersionUpgrade();

    public Object getAutomatedSnapshotRetentionPeriod();

    public String getAvailabilityZone();

    public String getClusterIdentifier();

    public String getClusterParameterGroupName();

    public List<String> getClusterSecurityGroups();

    public String getClusterSubnetGroupName();

    public String getClusterVersion();

    public String getElasticIp();

    public Object getEncrypted();

    public String getHsmClientCertificateIdentifier();

    public String getHsmConfigurationIdentifier();

    public List<String> getIamRoles();

    public String getKmsKeyId();

    public Object getLoggingProperties();

    public Object getNumberOfNodes();

    public String getOwnerAccount();

    public Object getPort();

    public String getPreferredMaintenanceWindow();

    public Object getPubliclyAccessible();

    public String getSnapshotClusterIdentifier();

    public String getSnapshotIdentifier();

    public List<CfnTag> getTags();

    public List<String> getVpcSecurityGroupIds();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _clusterType;
        private String _dbName;
        private String _masterUsername;
        private String _masterUserPassword;
        private String _nodeType;
        @Nullable
        private Object _allowVersionUpgrade;
        @Nullable
        private Object _automatedSnapshotRetentionPeriod;
        @Nullable
        private String _availabilityZone;
        @Nullable
        private String _clusterIdentifier;
        @Nullable
        private String _clusterParameterGroupName;
        @Nullable
        private List<String> _clusterSecurityGroups;
        @Nullable
        private String _clusterSubnetGroupName;
        @Nullable
        private String _clusterVersion;
        @Nullable
        private String _elasticIp;
        @Nullable
        private Object _encrypted;
        @Nullable
        private String _hsmClientCertificateIdentifier;
        @Nullable
        private String _hsmConfigurationIdentifier;
        @Nullable
        private List<String> _iamRoles;
        @Nullable
        private String _kmsKeyId;
        @Nullable
        private Object _loggingProperties;
        @Nullable
        private Object _numberOfNodes;
        @Nullable
        private String _ownerAccount;
        @Nullable
        private Object _port;
        @Nullable
        private String _preferredMaintenanceWindow;
        @Nullable
        private Object _publiclyAccessible;
        @Nullable
        private String _snapshotClusterIdentifier;
        @Nullable
        private String _snapshotIdentifier;
        @Nullable
        private List<CfnTag> _tags;
        @Nullable
        private List<String> _vpcSecurityGroupIds;

        public Builder withClusterType(String value) {
            this._clusterType = Objects.requireNonNull(value, "clusterType is required");
            return this;
        }

        public Builder withDbName(String value) {
            this._dbName = Objects.requireNonNull(value, "dbName is required");
            return this;
        }

        public Builder withMasterUsername(String value) {
            this._masterUsername = Objects.requireNonNull(value, "masterUsername is required");
            return this;
        }

        public Builder withMasterUserPassword(String value) {
            this._masterUserPassword = Objects.requireNonNull(value, "masterUserPassword is required");
            return this;
        }

        public Builder withNodeType(String value) {
            this._nodeType = Objects.requireNonNull(value, "nodeType is required");
            return this;
        }

        public Builder withAllowVersionUpgrade(@Nullable Boolean value) {
            this._allowVersionUpgrade = value;
            return this;
        }

        public Builder withAllowVersionUpgrade(@Nullable Token value) {
            this._allowVersionUpgrade = value;
            return this;
        }

        public Builder withAutomatedSnapshotRetentionPeriod(@Nullable Number value) {
            this._automatedSnapshotRetentionPeriod = value;
            return this;
        }

        public Builder withAutomatedSnapshotRetentionPeriod(@Nullable Token value) {
            this._automatedSnapshotRetentionPeriod = value;
            return this;
        }

        public Builder withAvailabilityZone(@Nullable String value) {
            this._availabilityZone = value;
            return this;
        }

        public Builder withClusterIdentifier(@Nullable String value) {
            this._clusterIdentifier = value;
            return this;
        }

        public Builder withClusterParameterGroupName(@Nullable String value) {
            this._clusterParameterGroupName = value;
            return this;
        }

        public Builder withClusterSecurityGroups(@Nullable List<String> value) {
            this._clusterSecurityGroups = value;
            return this;
        }

        public Builder withClusterSubnetGroupName(@Nullable String value) {
            this._clusterSubnetGroupName = value;
            return this;
        }

        public Builder withClusterVersion(@Nullable String value) {
            this._clusterVersion = value;
            return this;
        }

        public Builder withElasticIp(@Nullable String value) {
            this._elasticIp = value;
            return this;
        }

        public Builder withEncrypted(@Nullable Boolean value) {
            this._encrypted = value;
            return this;
        }

        public Builder withEncrypted(@Nullable Token value) {
            this._encrypted = value;
            return this;
        }

        public Builder withHsmClientCertificateIdentifier(@Nullable String value) {
            this._hsmClientCertificateIdentifier = value;
            return this;
        }

        public Builder withHsmConfigurationIdentifier(@Nullable String value) {
            this._hsmConfigurationIdentifier = value;
            return this;
        }

        public Builder withIamRoles(@Nullable List<String> value) {
            this._iamRoles = value;
            return this;
        }

        public Builder withKmsKeyId(@Nullable String value) {
            this._kmsKeyId = value;
            return this;
        }

        public Builder withLoggingProperties(@Nullable Token value) {
            this._loggingProperties = value;
            return this;
        }

        public Builder withLoggingProperties(@Nullable CfnCluster.LoggingPropertiesProperty value) {
            this._loggingProperties = value;
            return this;
        }

        public Builder withNumberOfNodes(@Nullable Number value) {
            this._numberOfNodes = value;
            return this;
        }

        public Builder withNumberOfNodes(@Nullable Token value) {
            this._numberOfNodes = value;
            return this;
        }

        public Builder withOwnerAccount(@Nullable String value) {
            this._ownerAccount = value;
            return this;
        }

        public Builder withPort(@Nullable Number value) {
            this._port = value;
            return this;
        }

        public Builder withPort(@Nullable Token value) {
            this._port = value;
            return this;
        }

        public Builder withPreferredMaintenanceWindow(@Nullable String value) {
            this._preferredMaintenanceWindow = value;
            return this;
        }

        public Builder withPubliclyAccessible(@Nullable Boolean value) {
            this._publiclyAccessible = value;
            return this;
        }

        public Builder withPubliclyAccessible(@Nullable Token value) {
            this._publiclyAccessible = value;
            return this;
        }

        public Builder withSnapshotClusterIdentifier(@Nullable String value) {
            this._snapshotClusterIdentifier = value;
            return this;
        }

        public Builder withSnapshotIdentifier(@Nullable String value) {
            this._snapshotIdentifier = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public Builder withVpcSecurityGroupIds(@Nullable List<String> value) {
            this._vpcSecurityGroupIds = value;
            return this;
        }

        public CfnClusterProps build() {
            return new CfnClusterProps(){
                private final String $clusterType;
                private final String $dbName;
                private final String $masterUsername;
                private final String $masterUserPassword;
                private final String $nodeType;
                @Nullable
                private final Object $allowVersionUpgrade;
                @Nullable
                private final Object $automatedSnapshotRetentionPeriod;
                @Nullable
                private final String $availabilityZone;
                @Nullable
                private final String $clusterIdentifier;
                @Nullable
                private final String $clusterParameterGroupName;
                @Nullable
                private final List<String> $clusterSecurityGroups;
                @Nullable
                private final String $clusterSubnetGroupName;
                @Nullable
                private final String $clusterVersion;
                @Nullable
                private final String $elasticIp;
                @Nullable
                private final Object $encrypted;
                @Nullable
                private final String $hsmClientCertificateIdentifier;
                @Nullable
                private final String $hsmConfigurationIdentifier;
                @Nullable
                private final List<String> $iamRoles;
                @Nullable
                private final String $kmsKeyId;
                @Nullable
                private final Object $loggingProperties;
                @Nullable
                private final Object $numberOfNodes;
                @Nullable
                private final String $ownerAccount;
                @Nullable
                private final Object $port;
                @Nullable
                private final String $preferredMaintenanceWindow;
                @Nullable
                private final Object $publiclyAccessible;
                @Nullable
                private final String $snapshotClusterIdentifier;
                @Nullable
                private final String $snapshotIdentifier;
                @Nullable
                private final List<CfnTag> $tags;
                @Nullable
                private final List<String> $vpcSecurityGroupIds;
                {
                    this.$clusterType = Objects.requireNonNull(_clusterType, "clusterType is required");
                    this.$dbName = Objects.requireNonNull(_dbName, "dbName is required");
                    this.$masterUsername = Objects.requireNonNull(_masterUsername, "masterUsername is required");
                    this.$masterUserPassword = Objects.requireNonNull(_masterUserPassword, "masterUserPassword is required");
                    this.$nodeType = Objects.requireNonNull(_nodeType, "nodeType is required");
                    this.$allowVersionUpgrade = _allowVersionUpgrade;
                    this.$automatedSnapshotRetentionPeriod = _automatedSnapshotRetentionPeriod;
                    this.$availabilityZone = _availabilityZone;
                    this.$clusterIdentifier = _clusterIdentifier;
                    this.$clusterParameterGroupName = _clusterParameterGroupName;
                    this.$clusterSecurityGroups = _clusterSecurityGroups;
                    this.$clusterSubnetGroupName = _clusterSubnetGroupName;
                    this.$clusterVersion = _clusterVersion;
                    this.$elasticIp = _elasticIp;
                    this.$encrypted = _encrypted;
                    this.$hsmClientCertificateIdentifier = _hsmClientCertificateIdentifier;
                    this.$hsmConfigurationIdentifier = _hsmConfigurationIdentifier;
                    this.$iamRoles = _iamRoles;
                    this.$kmsKeyId = _kmsKeyId;
                    this.$loggingProperties = _loggingProperties;
                    this.$numberOfNodes = _numberOfNodes;
                    this.$ownerAccount = _ownerAccount;
                    this.$port = _port;
                    this.$preferredMaintenanceWindow = _preferredMaintenanceWindow;
                    this.$publiclyAccessible = _publiclyAccessible;
                    this.$snapshotClusterIdentifier = _snapshotClusterIdentifier;
                    this.$snapshotIdentifier = _snapshotIdentifier;
                    this.$tags = _tags;
                    this.$vpcSecurityGroupIds = _vpcSecurityGroupIds;
                }

                @Override
                public String getClusterType() {
                    return this.$clusterType;
                }

                @Override
                public String getDbName() {
                    return this.$dbName;
                }

                @Override
                public String getMasterUsername() {
                    return this.$masterUsername;
                }

                @Override
                public String getMasterUserPassword() {
                    return this.$masterUserPassword;
                }

                @Override
                public String getNodeType() {
                    return this.$nodeType;
                }

                @Override
                public Object getAllowVersionUpgrade() {
                    return this.$allowVersionUpgrade;
                }

                @Override
                public Object getAutomatedSnapshotRetentionPeriod() {
                    return this.$automatedSnapshotRetentionPeriod;
                }

                @Override
                public String getAvailabilityZone() {
                    return this.$availabilityZone;
                }

                @Override
                public String getClusterIdentifier() {
                    return this.$clusterIdentifier;
                }

                @Override
                public String getClusterParameterGroupName() {
                    return this.$clusterParameterGroupName;
                }

                @Override
                public List<String> getClusterSecurityGroups() {
                    return this.$clusterSecurityGroups;
                }

                @Override
                public String getClusterSubnetGroupName() {
                    return this.$clusterSubnetGroupName;
                }

                @Override
                public String getClusterVersion() {
                    return this.$clusterVersion;
                }

                @Override
                public String getElasticIp() {
                    return this.$elasticIp;
                }

                @Override
                public Object getEncrypted() {
                    return this.$encrypted;
                }

                @Override
                public String getHsmClientCertificateIdentifier() {
                    return this.$hsmClientCertificateIdentifier;
                }

                @Override
                public String getHsmConfigurationIdentifier() {
                    return this.$hsmConfigurationIdentifier;
                }

                @Override
                public List<String> getIamRoles() {
                    return this.$iamRoles;
                }

                @Override
                public String getKmsKeyId() {
                    return this.$kmsKeyId;
                }

                @Override
                public Object getLoggingProperties() {
                    return this.$loggingProperties;
                }

                @Override
                public Object getNumberOfNodes() {
                    return this.$numberOfNodes;
                }

                @Override
                public String getOwnerAccount() {
                    return this.$ownerAccount;
                }

                @Override
                public Object getPort() {
                    return this.$port;
                }

                @Override
                public String getPreferredMaintenanceWindow() {
                    return this.$preferredMaintenanceWindow;
                }

                @Override
                public Object getPubliclyAccessible() {
                    return this.$publiclyAccessible;
                }

                @Override
                public String getSnapshotClusterIdentifier() {
                    return this.$snapshotClusterIdentifier;
                }

                @Override
                public String getSnapshotIdentifier() {
                    return this.$snapshotIdentifier;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                @Override
                public List<String> getVpcSecurityGroupIds() {
                    return this.$vpcSecurityGroupIds;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("clusterType", om.valueToTree((Object)this.getClusterType()));
                    obj.set("dbName", om.valueToTree((Object)this.getDbName()));
                    obj.set("masterUsername", om.valueToTree((Object)this.getMasterUsername()));
                    obj.set("masterUserPassword", om.valueToTree((Object)this.getMasterUserPassword()));
                    obj.set("nodeType", om.valueToTree((Object)this.getNodeType()));
                    if (this.getAllowVersionUpgrade() != null) {
                        obj.set("allowVersionUpgrade", om.valueToTree(this.getAllowVersionUpgrade()));
                    }
                    if (this.getAutomatedSnapshotRetentionPeriod() != null) {
                        obj.set("automatedSnapshotRetentionPeriod", om.valueToTree(this.getAutomatedSnapshotRetentionPeriod()));
                    }
                    if (this.getAvailabilityZone() != null) {
                        obj.set("availabilityZone", om.valueToTree((Object)this.getAvailabilityZone()));
                    }
                    if (this.getClusterIdentifier() != null) {
                        obj.set("clusterIdentifier", om.valueToTree((Object)this.getClusterIdentifier()));
                    }
                    if (this.getClusterParameterGroupName() != null) {
                        obj.set("clusterParameterGroupName", om.valueToTree((Object)this.getClusterParameterGroupName()));
                    }
                    if (this.getClusterSecurityGroups() != null) {
                        obj.set("clusterSecurityGroups", om.valueToTree(this.getClusterSecurityGroups()));
                    }
                    if (this.getClusterSubnetGroupName() != null) {
                        obj.set("clusterSubnetGroupName", om.valueToTree((Object)this.getClusterSubnetGroupName()));
                    }
                    if (this.getClusterVersion() != null) {
                        obj.set("clusterVersion", om.valueToTree((Object)this.getClusterVersion()));
                    }
                    if (this.getElasticIp() != null) {
                        obj.set("elasticIp", om.valueToTree((Object)this.getElasticIp()));
                    }
                    if (this.getEncrypted() != null) {
                        obj.set("encrypted", om.valueToTree(this.getEncrypted()));
                    }
                    if (this.getHsmClientCertificateIdentifier() != null) {
                        obj.set("hsmClientCertificateIdentifier", om.valueToTree((Object)this.getHsmClientCertificateIdentifier()));
                    }
                    if (this.getHsmConfigurationIdentifier() != null) {
                        obj.set("hsmConfigurationIdentifier", om.valueToTree((Object)this.getHsmConfigurationIdentifier()));
                    }
                    if (this.getIamRoles() != null) {
                        obj.set("iamRoles", om.valueToTree(this.getIamRoles()));
                    }
                    if (this.getKmsKeyId() != null) {
                        obj.set("kmsKeyId", om.valueToTree((Object)this.getKmsKeyId()));
                    }
                    if (this.getLoggingProperties() != null) {
                        obj.set("loggingProperties", om.valueToTree(this.getLoggingProperties()));
                    }
                    if (this.getNumberOfNodes() != null) {
                        obj.set("numberOfNodes", om.valueToTree(this.getNumberOfNodes()));
                    }
                    if (this.getOwnerAccount() != null) {
                        obj.set("ownerAccount", om.valueToTree((Object)this.getOwnerAccount()));
                    }
                    if (this.getPort() != null) {
                        obj.set("port", om.valueToTree(this.getPort()));
                    }
                    if (this.getPreferredMaintenanceWindow() != null) {
                        obj.set("preferredMaintenanceWindow", om.valueToTree((Object)this.getPreferredMaintenanceWindow()));
                    }
                    if (this.getPubliclyAccessible() != null) {
                        obj.set("publiclyAccessible", om.valueToTree(this.getPubliclyAccessible()));
                    }
                    if (this.getSnapshotClusterIdentifier() != null) {
                        obj.set("snapshotClusterIdentifier", om.valueToTree((Object)this.getSnapshotClusterIdentifier()));
                    }
                    if (this.getSnapshotIdentifier() != null) {
                        obj.set("snapshotIdentifier", om.valueToTree((Object)this.getSnapshotIdentifier()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    if (this.getVpcSecurityGroupIds() != null) {
                        obj.set("vpcSecurityGroupIds", om.valueToTree(this.getVpcSecurityGroupIds()));
                    }
                    return obj;
                }
            };
        }
    }
}

