package software.amazon.awscdk.services.redshift;

/**
 * A CloudFormation `AWS::Redshift::Cluster`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:02:33.199Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.redshift.$Module.class, fqn = "@aws-cdk/aws-redshift.CfnCluster")
public class CfnCluster extends software.amazon.awscdk.CfnResource {
    protected CfnCluster(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.redshift.CfnCluster.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::Redshift::Cluster`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnCluster(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.redshift.CfnClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    /**
     */
    public java.lang.String getClusterEndpointAddress() {
        return this.jsiiGet("clusterEndpointAddress", java.lang.String.class);
    }

    /**
     */
    public java.lang.String getClusterEndpointPort() {
        return this.jsiiGet("clusterEndpointPort", java.lang.String.class);
    }

    public java.lang.String getClusterName() {
        return this.jsiiGet("clusterName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.redshift.CfnClusterProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.redshift.CfnClusterProps.class);
    }

    /**
     * The `TagManager` handles setting, removing and formatting tags.
     * 
     * Tags should be managed either passing them as properties during
     * initiation or by calling methods on this object. If both techniques are
     * used only the tags from the TagManager will be used. `Tag` (aspect)
     * will use the manager.
     */
    public software.amazon.awscdk.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.TagManager.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html
     */
    public static interface LoggingPropertiesProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnCluster.LoggingPropertiesProperty.BucketName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-bucketname
         */
        java.lang.String getBucketName();
        /**
         * `CfnCluster.LoggingPropertiesProperty.S3KeyPrefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-s3keyprefix
         */
        java.lang.String getS3KeyPrefix();

        /**
         * @return a {@link Builder} of {@link LoggingPropertiesProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LoggingPropertiesProperty}
         */
        final class Builder {
            private java.lang.String _bucketName;
            @javax.annotation.Nullable
            private java.lang.String _s3KeyPrefix;

            /**
             * Sets the value of BucketName
             * @param value `CfnCluster.LoggingPropertiesProperty.BucketName`.
             * @return {@code this}
             */
            public Builder withBucketName(final java.lang.String value) {
                this._bucketName = java.util.Objects.requireNonNull(value, "bucketName is required");
                return this;
            }
            /**
             * Sets the value of S3KeyPrefix
             * @param value `CfnCluster.LoggingPropertiesProperty.S3KeyPrefix`.
             * @return {@code this}
             */
            public Builder withS3KeyPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._s3KeyPrefix = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LoggingPropertiesProperty build() {
                return new LoggingPropertiesProperty() {
                    private final java.lang.String $bucketName = java.util.Objects.requireNonNull(_bucketName, "bucketName is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $s3KeyPrefix = _s3KeyPrefix;

                    @Override
                    public java.lang.String getBucketName() {
                        return this.$bucketName;
                    }

                    @Override
                    public java.lang.String getS3KeyPrefix() {
                        return this.$s3KeyPrefix;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("bucketName", om.valueToTree(this.getBucketName()));
                        obj.set("s3KeyPrefix", om.valueToTree(this.getS3KeyPrefix()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.redshift.CfnCluster.LoggingPropertiesProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnCluster.LoggingPropertiesProperty.BucketName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-bucketname
             */
            @Override
            public java.lang.String getBucketName() {
                return this.jsiiGet("bucketName", java.lang.String.class);
            }

            /**
             * `CfnCluster.LoggingPropertiesProperty.S3KeyPrefix`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-s3keyprefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getS3KeyPrefix() {
                return this.jsiiGet("s3KeyPrefix", java.lang.String.class);
            }
        }
    }
}
