/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.codeguruprofiler.IProfilingGroup;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.lambda.;
import software.amazon.awscdk.services.lambda.Code;
import software.amazon.awscdk.services.lambda.FileSystem;
import software.amazon.awscdk.services.lambda.FunctionProps;
import software.amazon.awscdk.services.lambda.IDestination;
import software.amazon.awscdk.services.lambda.IEventSource;
import software.amazon.awscdk.services.lambda.ILayerVersion;
import software.amazon.awscdk.services.lambda.LogRetentionRetryOptions;
import software.amazon.awscdk.services.lambda.Runtime;
import software.amazon.awscdk.services.lambda.SingletonFunctionProps;
import software.amazon.awscdk.services.lambda.Tracing;
import software.amazon.awscdk.services.lambda.VersionOptions;
import software.amazon.awscdk.services.logs.RetentionDays;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-lambda.SingletonFunctionProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface SingletonFunctionProps
extends JsiiSerializable,
FunctionProps {
    @NotNull
    public String getUuid();

    @Nullable
    default public String getLambdaPurpose() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<SingletonFunctionProps> {
        private String uuid;
        private String lambdaPurpose;
        private Code code;
        private String handler;
        private Runtime runtime;
        private Boolean allowPublicSubnet;
        private FileSystem filesystem;
        private Boolean allowAllOutbound;
        private VersionOptions currentVersionOptions;
        private IQueue deadLetterQueue;
        private Boolean deadLetterQueueEnabled;
        private String description;
        private Map<String, String> environment;
        private List<IEventSource> events;
        private String functionName;
        private List<PolicyStatement> initialPolicy;
        private List<ILayerVersion> layers;
        private RetentionDays logRetention;
        private LogRetentionRetryOptions logRetentionRetryOptions;
        private IRole logRetentionRole;
        private Number memorySize;
        private Boolean profiling;
        private IProfilingGroup profilingGroup;
        private Number reservedConcurrentExecutions;
        private IRole role;
        private ISecurityGroup securityGroup;
        private List<ISecurityGroup> securityGroups;
        private Duration timeout;
        private Tracing tracing;
        private IVpc vpc;
        private SubnetSelection vpcSubnets;
        private Duration maxEventAge;
        private IDestination onFailure;
        private IDestination onSuccess;
        private Number retryAttempts;

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder lambdaPurpose(String lambdaPurpose) {
            this.lambdaPurpose = lambdaPurpose;
            return this;
        }

        public Builder code(Code code) {
            this.code = code;
            return this;
        }

        public Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public Builder runtime(Runtime runtime) {
            this.runtime = runtime;
            return this;
        }

        public Builder allowPublicSubnet(Boolean allowPublicSubnet) {
            this.allowPublicSubnet = allowPublicSubnet;
            return this;
        }

        public Builder filesystem(FileSystem filesystem) {
            this.filesystem = filesystem;
            return this;
        }

        public Builder allowAllOutbound(Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        public Builder currentVersionOptions(VersionOptions currentVersionOptions) {
            this.currentVersionOptions = currentVersionOptions;
            return this;
        }

        public Builder deadLetterQueue(IQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        public Builder deadLetterQueueEnabled(Boolean deadLetterQueueEnabled) {
            this.deadLetterQueueEnabled = deadLetterQueueEnabled;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.environment = environment;
            return this;
        }

        public Builder events(List<IEventSource> events) {
            this.events = events;
            return this;
        }

        public Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public Builder initialPolicy(List<PolicyStatement> initialPolicy) {
            this.initialPolicy = initialPolicy;
            return this;
        }

        public Builder layers(List<ILayerVersion> layers) {
            this.layers = layers;
            return this;
        }

        public Builder logRetention(RetentionDays logRetention) {
            this.logRetention = logRetention;
            return this;
        }

        public Builder logRetentionRetryOptions(LogRetentionRetryOptions logRetentionRetryOptions) {
            this.logRetentionRetryOptions = logRetentionRetryOptions;
            return this;
        }

        public Builder logRetentionRole(IRole logRetentionRole) {
            this.logRetentionRole = logRetentionRole;
            return this;
        }

        public Builder memorySize(Number memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public Builder profiling(Boolean profiling) {
            this.profiling = profiling;
            return this;
        }

        public Builder profilingGroup(IProfilingGroup profilingGroup) {
            this.profilingGroup = profilingGroup;
            return this;
        }

        public Builder reservedConcurrentExecutions(Number reservedConcurrentExecutions) {
            this.reservedConcurrentExecutions = reservedConcurrentExecutions;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        @Deprecated
        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public Builder securityGroups(List<ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder tracing(Tracing tracing) {
            this.tracing = tracing;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public Builder maxEventAge(Duration maxEventAge) {
            this.maxEventAge = maxEventAge;
            return this;
        }

        public Builder onFailure(IDestination onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        public Builder onSuccess(IDestination onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        public SingletonFunctionProps build() {
            return new Jsii.Proxy(this.uuid, this.lambdaPurpose, this.code, this.handler, this.runtime, this.allowPublicSubnet, this.filesystem, this.allowAllOutbound, this.currentVersionOptions, this.deadLetterQueue, this.deadLetterQueueEnabled, this.description, this.environment, this.events, this.functionName, this.initialPolicy, this.layers, this.logRetention, this.logRetentionRetryOptions, this.logRetentionRole, this.memorySize, this.profiling, this.profilingGroup, this.reservedConcurrentExecutions, this.role, this.securityGroup, this.securityGroups, this.timeout, this.tracing, this.vpc, this.vpcSubnets, this.maxEventAge, this.onFailure, this.onSuccess, this.retryAttempts, null);
        }
    }
}

