/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IConstruct;
import software.amazon.awscdk.core.IDependable;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.DefaultInstanceTenancy;
import software.amazon.awscdk.services.ec2.EnableVpnGatewayOptions;
import software.amazon.awscdk.services.ec2.FlowLog;
import software.amazon.awscdk.services.ec2.FlowLogOptions;
import software.amazon.awscdk.services.ec2.GatewayVpcEndpoint;
import software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions;
import software.amazon.awscdk.services.ec2.ISubnet;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InterfaceVpcEndpoint;
import software.amazon.awscdk.services.ec2.InterfaceVpcEndpointOptions;
import software.amazon.awscdk.services.ec2.NatProvider;
import software.amazon.awscdk.services.ec2.SelectedSubnets;
import software.amazon.awscdk.services.ec2.SubnetConfiguration;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ec2.VpcAttributes;
import software.amazon.awscdk.services.ec2.VpcLookupOptions;
import software.amazon.awscdk.services.ec2.VpcProps;
import software.amazon.awscdk.services.ec2.VpnConnection;
import software.amazon.awscdk.services.ec2.VpnConnectionOptions;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.Vpc")
public class Vpc
extends Resource
implements IVpc {
    public static final String DEFAULT_CIDR_RANGE = (String)JsiiObject.jsiiStaticGet(Vpc.class, (String)"DEFAULT_CIDR_RANGE", String.class);
    public static final List<SubnetConfiguration> DEFAULT_SUBNETS = Collections.unmodifiableList((List)JsiiObject.jsiiStaticGet(Vpc.class, (String)"DEFAULT_SUBNETS", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(SubnetConfiguration.class))));
    public static final List<SubnetConfiguration> DEFAULT_SUBNETS_NO_NAT = Collections.unmodifiableList((List)JsiiObject.jsiiStaticGet(Vpc.class, (String)"DEFAULT_SUBNETS_NO_NAT", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(SubnetConfiguration.class))));

    protected Vpc(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Vpc(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Vpc(@NotNull Construct scope, @NotNull String id, @Nullable VpcProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Vpc(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IVpc fromLookup(@NotNull Construct scope, @NotNull String id, @NotNull VpcLookupOptions options) {
        return (IVpc)JsiiObject.jsiiStaticCall(Vpc.class, (String)"fromLookup", IVpc.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public static IVpc fromVpcAttributes(@NotNull Construct scope, @NotNull String id, @NotNull VpcAttributes attrs) {
        return (IVpc)JsiiObject.jsiiStaticCall(Vpc.class, (String)"fromVpcAttributes", IVpc.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Deprecated
    @NotNull
    public GatewayVpcEndpoint addDynamoDbEndpoint(@NotNull String id, @Nullable List<SubnetSelection> subnets) {
        return (GatewayVpcEndpoint)this.jsiiCall("addDynamoDbEndpoint", GatewayVpcEndpoint.class, new Object[]{Objects.requireNonNull(id, "id is required"), subnets});
    }

    @Deprecated
    @NotNull
    public GatewayVpcEndpoint addDynamoDbEndpoint(@NotNull String id) {
        return (GatewayVpcEndpoint)this.jsiiCall("addDynamoDbEndpoint", GatewayVpcEndpoint.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public FlowLog addFlowLog(@NotNull String id, @Nullable FlowLogOptions options) {
        return (FlowLog)this.jsiiCall("addFlowLog", FlowLog.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public FlowLog addFlowLog(@NotNull String id) {
        return (FlowLog)this.jsiiCall("addFlowLog", FlowLog.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public GatewayVpcEndpoint addGatewayEndpoint(@NotNull String id, @NotNull GatewayVpcEndpointOptions options) {
        return (GatewayVpcEndpoint)this.jsiiCall("addGatewayEndpoint", GatewayVpcEndpoint.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public InterfaceVpcEndpoint addInterfaceEndpoint(@NotNull String id, @NotNull InterfaceVpcEndpointOptions options) {
        return (InterfaceVpcEndpoint)this.jsiiCall("addInterfaceEndpoint", InterfaceVpcEndpoint.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Deprecated
    @NotNull
    public GatewayVpcEndpoint addS3Endpoint(@NotNull String id, @Nullable List<SubnetSelection> subnets) {
        return (GatewayVpcEndpoint)this.jsiiCall("addS3Endpoint", GatewayVpcEndpoint.class, new Object[]{Objects.requireNonNull(id, "id is required"), subnets});
    }

    @Deprecated
    @NotNull
    public GatewayVpcEndpoint addS3Endpoint(@NotNull String id) {
        return (GatewayVpcEndpoint)this.jsiiCall("addS3Endpoint", GatewayVpcEndpoint.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public VpnConnection addVpnConnection(@NotNull String id, @NotNull VpnConnectionOptions options) {
        return (VpnConnection)this.jsiiCall("addVpnConnection", VpnConnection.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    public void enableVpnGateway(@NotNull EnableVpnGatewayOptions options) {
        this.jsiiCall("enableVpnGateway", NativeType.VOID, new Object[]{Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    protected List<ISubnet> selectSubnetObjects(@Nullable SubnetSelection selection) {
        return Collections.unmodifiableList((List)this.jsiiCall("selectSubnetObjects", NativeType.listOf((NativeType)NativeType.forClass(ISubnet.class)), new Object[]{selection}));
    }

    @NotNull
    protected List<ISubnet> selectSubnetObjects() {
        return Collections.unmodifiableList((List)this.jsiiCall("selectSubnetObjects", NativeType.listOf((NativeType)NativeType.forClass(ISubnet.class)), new Object[0]));
    }

    @Override
    @NotNull
    public SelectedSubnets selectSubnets(@Nullable SubnetSelection selection) {
        return (SelectedSubnets)this.jsiiCall("selectSubnets", SelectedSubnets.class, new Object[]{selection});
    }

    @Override
    @NotNull
    public SelectedSubnets selectSubnets() {
        return (SelectedSubnets)this.jsiiCall("selectSubnets", SelectedSubnets.class, new Object[0]);
    }

    @Override
    @NotNull
    public List<String> getAvailabilityZones() {
        return Collections.unmodifiableList((List)this.jsiiGet("availabilityZones", NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public Boolean getDnsHostnamesEnabled() {
        return (Boolean)this.jsiiGet("dnsHostnamesEnabled", Boolean.class);
    }

    @NotNull
    public Boolean getDnsSupportEnabled() {
        return (Boolean)this.jsiiGet("dnsSupportEnabled", Boolean.class);
    }

    @Override
    @NotNull
    public IDependable getInternetConnectivityEstablished() {
        return (IDependable)this.jsiiGet("internetConnectivityEstablished", IDependable.class);
    }

    @Override
    @NotNull
    public List<ISubnet> getIsolatedSubnets() {
        return Collections.unmodifiableList((List)this.jsiiGet("isolatedSubnets", NativeType.listOf((NativeType)NativeType.forClass(ISubnet.class))));
    }

    @Deprecated
    @NotNull
    protected List<IConstruct> getNatDependencies() {
        return Collections.unmodifiableList((List)this.jsiiGet("natDependencies", NativeType.listOf((NativeType)NativeType.forClass(IConstruct.class))));
    }

    @Override
    @NotNull
    public List<ISubnet> getPrivateSubnets() {
        return Collections.unmodifiableList((List)this.jsiiGet("privateSubnets", NativeType.listOf((NativeType)NativeType.forClass(ISubnet.class))));
    }

    @Override
    @NotNull
    public List<ISubnet> getPublicSubnets() {
        return Collections.unmodifiableList((List)this.jsiiGet("publicSubnets", NativeType.listOf((NativeType)NativeType.forClass(ISubnet.class))));
    }

    @Override
    @NotNull
    public String getVpcCidrBlock() {
        return (String)this.jsiiGet("vpcCidrBlock", String.class);
    }

    @NotNull
    public List<String> getVpcCidrBlockAssociations() {
        return Collections.unmodifiableList((List)this.jsiiGet("vpcCidrBlockAssociations", NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public String getVpcDefaultNetworkAcl() {
        return (String)this.jsiiGet("vpcDefaultNetworkAcl", String.class);
    }

    @NotNull
    public String getVpcDefaultSecurityGroup() {
        return (String)this.jsiiGet("vpcDefaultSecurityGroup", String.class);
    }

    @Override
    @NotNull
    public String getVpcId() {
        return (String)this.jsiiGet("vpcId", String.class);
    }

    @NotNull
    public List<String> getVpcIpv6CidrBlocks() {
        return Collections.unmodifiableList((List)this.jsiiGet("vpcIpv6CidrBlocks", NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @Nullable
    public String getInternetGatewayId() {
        return (String)this.jsiiGet("internetGatewayId", String.class);
    }

    @Override
    @Nullable
    public String getVpnGatewayId() {
        return (String)this.jsiiGet("vpnGatewayId", String.class);
    }

    @NotNull
    protected Boolean getIncompleteSubnetDefinition() {
        return (Boolean)this.jsiiGet("incompleteSubnetDefinition", Boolean.class);
    }

    protected void setIncompleteSubnetDefinition(@NotNull Boolean value) {
        this.jsiiSet("incompleteSubnetDefinition", Objects.requireNonNull(value, "incompleteSubnetDefinition is required"));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Vpc> {
        private final Construct scope;
        private final String id;
        private VpcProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder cidr(String cidr) {
            this.props().cidr(cidr);
            return this;
        }

        public Builder defaultInstanceTenancy(DefaultInstanceTenancy defaultInstanceTenancy) {
            this.props().defaultInstanceTenancy(defaultInstanceTenancy);
            return this;
        }

        public Builder enableDnsHostnames(Boolean enableDnsHostnames) {
            this.props().enableDnsHostnames(enableDnsHostnames);
            return this;
        }

        public Builder enableDnsSupport(Boolean enableDnsSupport) {
            this.props().enableDnsSupport(enableDnsSupport);
            return this;
        }

        public Builder flowLogs(Map<String, FlowLogOptions> flowLogs) {
            this.props().flowLogs(flowLogs);
            return this;
        }

        public Builder gatewayEndpoints(Map<String, GatewayVpcEndpointOptions> gatewayEndpoints) {
            this.props().gatewayEndpoints(gatewayEndpoints);
            return this;
        }

        public Builder maxAzs(Number maxAzs) {
            this.props().maxAzs(maxAzs);
            return this;
        }

        public Builder natGatewayProvider(NatProvider natGatewayProvider) {
            this.props().natGatewayProvider(natGatewayProvider);
            return this;
        }

        public Builder natGateways(Number natGateways) {
            this.props().natGateways(natGateways);
            return this;
        }

        public Builder natGatewaySubnets(SubnetSelection natGatewaySubnets) {
            this.props().natGatewaySubnets(natGatewaySubnets);
            return this;
        }

        public Builder subnetConfiguration(List<SubnetConfiguration> subnetConfiguration) {
            this.props().subnetConfiguration(subnetConfiguration);
            return this;
        }

        public Builder vpnConnections(Map<String, VpnConnectionOptions> vpnConnections) {
            this.props().vpnConnections(vpnConnections);
            return this;
        }

        public Builder vpnGateway(Boolean vpnGateway) {
            this.props().vpnGateway(vpnGateway);
            return this;
        }

        public Builder vpnGatewayAsn(Number vpnGatewayAsn) {
            this.props().vpnGatewayAsn(vpnGatewayAsn);
            return this;
        }

        public Builder vpnRoutePropagation(List<SubnetSelection> vpnRoutePropagation) {
            this.props().vpnRoutePropagation(vpnRoutePropagation);
            return this;
        }

        public Vpc build() {
            return new Vpc(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private VpcProps.Builder props() {
            if (this.props == null) {
                this.props = new VpcProps.Builder();
            }
            return this.props;
        }
    }
}

