package software.amazon.awscdk.services.codecommit;

/**
 * Provides a CodeCommit Repository.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:06.526Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codecommit.$Module.class, fqn = "@aws-cdk/aws-codecommit.Repository")
public class Repository extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.codecommit.IRepository {

    protected Repository(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Repository(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Repository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.RepositoryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports a codecommit repository.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param repositoryArn (e.g. `arn:aws:codecommit:us-east-1:123456789012:MyDemoRepo`). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.IRepository fromRepositoryArn(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String repositoryArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codecommit.Repository.class, "fromRepositoryArn", software.amazon.awscdk.services.codecommit.IRepository.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(repositoryArn, "repositoryArn is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param repositoryName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.IRepository fromRepositoryName(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String repositoryName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codecommit.Repository.class, "fromRepositoryName", software.amazon.awscdk.services.codecommit.IRepository.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(repositoryName, "repositoryName is required") });
    }

    /**
     * Grant the given principal identity permissions to perform the actions on this repository.
     * <p>
     * @param grantee This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return this.jsiiCall("grant", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Grant the given identity permissions to pull this repository.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPull(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantPull", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant the given identity permissions to pull and push this repository.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPullPush(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantPullPush", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant the given identity permissions to read this repository.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantRead", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Create a trigger to notify another service to run actions on repository events.
     * <p>
     * @param arn Arn of the resource that repository events will notify. This parameter is required.
     * @param options Trigger options to run actions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.Repository notify(final @org.jetbrains.annotations.NotNull java.lang.String arn, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codecommit.RepositoryTriggerOptions options) {
        return this.jsiiCall("notify", software.amazon.awscdk.services.codecommit.Repository.class, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required"), options });
    }

    /**
     * Create a trigger to notify another service to run actions on repository events.
     * <p>
     * @param arn Arn of the resource that repository events will notify. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.Repository notify(final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return this.jsiiCall("notify", software.amazon.awscdk.services.codecommit.Repository.class, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a comment is made on a commit.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCommentOnCommit(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return this.jsiiCall("onCommentOnCommit", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a comment is made on a commit.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCommentOnCommit(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return this.jsiiCall("onCommentOnCommit", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a comment is made on a pull request.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCommentOnPullRequest(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return this.jsiiCall("onCommentOnPullRequest", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a comment is made on a pull request.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCommentOnPullRequest(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return this.jsiiCall("onCommentOnPullRequest", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a commit is pushed to a branch.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCommit(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codecommit.OnCommitOptions options) {
        return this.jsiiCall("onCommit", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a commit is pushed to a branch.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCommit(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return this.jsiiCall("onCommit", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines a CloudWatch event rule which triggers for repository events.
     * <p>
     * Use
     * <code>rule.addEventPattern(pattern)</code> to specify a filter.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return this.jsiiCall("onEvent", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule which triggers for repository events.
     * <p>
     * Use
     * <code>rule.addEventPattern(pattern)</code> to specify a filter.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return this.jsiiCall("onEvent", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a pull request state is changed.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onPullRequestStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return this.jsiiCall("onPullRequestStateChange", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a pull request state is changed.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onPullRequestStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return this.jsiiCall("onPullRequestStateChange", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a reference is created (i.e. a new branch/tag is created) to the repository.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReferenceCreated(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return this.jsiiCall("onReferenceCreated", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a reference is created (i.e. a new branch/tag is created) to the repository.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReferenceCreated(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return this.jsiiCall("onReferenceCreated", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a reference is delete (i.e. a branch/tag is deleted) from the repository.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReferenceDeleted(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return this.jsiiCall("onReferenceDeleted", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a reference is delete (i.e. a branch/tag is deleted) from the repository.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReferenceDeleted(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return this.jsiiCall("onReferenceDeleted", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a reference is updated (i.e. a commit is pushed to an existing or new branch) from the repository.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReferenceUpdated(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return this.jsiiCall("onReferenceUpdated", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a reference is updated (i.e. a commit is pushed to an existing or new branch) from the repository.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReferenceUpdated(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return this.jsiiCall("onReferenceUpdated", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a "CodeCommit Repository State Change" event occurs.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return this.jsiiCall("onStateChange", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a "CodeCommit Repository State Change" event occurs.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return this.jsiiCall("onStateChange", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * The ARN of this Repository.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRepositoryArn() {
        return this.jsiiGet("repositoryArn", java.lang.String.class);
    }

    /**
     * The HTTP clone URL.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRepositoryCloneUrlHttp() {
        return this.jsiiGet("repositoryCloneUrlHttp", java.lang.String.class);
    }

    /**
     * The SSH clone URL.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRepositoryCloneUrlSsh() {
        return this.jsiiGet("repositoryCloneUrlSsh", java.lang.String.class);
    }

    /**
     * The human-visible name of this Repository.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRepositoryName() {
        return this.jsiiGet("repositoryName", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codecommit.Repository}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codecommit.Repository> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codecommit.RepositoryProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codecommit.RepositoryProps.Builder();
        }

        /**
         * Name of the repository.
         * <p>
         * This property is required for all CodeCommit repositories.
         * <p>
         * @return {@code this}
         * @param repositoryName Name of the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(final java.lang.String repositoryName) {
            this.props.repositoryName(repositoryName);
            return this;
        }

        /**
         * A description of the repository.
         * <p>
         * Use the description to identify the
         * purpose of the repository.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codecommit.Repository}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codecommit.Repository build() {
            return new software.amazon.awscdk.services.codecommit.Repository(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
