package software.amazon.awscdk.services.codebuild;

/**
 * A CloudFormation `AWS::CodeBuild::Project`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:29.388Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject")
public class CfnProject extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnProject(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnProject(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.CfnProject.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::CodeBuild::Project`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnProject(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.CfnProjectProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return this.jsiiGet("attrArn", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::CodeBuild::Project.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::CodeBuild::Project.Artifacts`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-artifacts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getArtifacts() {
        return this.jsiiGet("artifacts", java.lang.Object.class);
    }

    /**
     * `AWS::CodeBuild::Project.Artifacts`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-artifacts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArtifacts(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.CfnProject.ArtifactsProperty value) {
        this.jsiiSet("artifacts", java.util.Objects.requireNonNull(value, "artifacts is required"));
    }

    /**
     * `AWS::CodeBuild::Project.Artifacts`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-artifacts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArtifacts(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("artifacts", java.util.Objects.requireNonNull(value, "artifacts is required"));
    }

    /**
     * `AWS::CodeBuild::Project.Environment`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-environment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getEnvironment() {
        return this.jsiiGet("environment", java.lang.Object.class);
    }

    /**
     * `AWS::CodeBuild::Project.Environment`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-environment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("environment", java.util.Objects.requireNonNull(value, "environment is required"));
    }

    /**
     * `AWS::CodeBuild::Project.Environment`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-environment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.CfnProject.EnvironmentProperty value) {
        this.jsiiSet("environment", java.util.Objects.requireNonNull(value, "environment is required"));
    }

    /**
     * `AWS::CodeBuild::Project.ServiceRole`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-servicerole
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceRole() {
        return this.jsiiGet("serviceRole", java.lang.String.class);
    }

    /**
     * `AWS::CodeBuild::Project.ServiceRole`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-servicerole
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceRole(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("serviceRole", java.util.Objects.requireNonNull(value, "serviceRole is required"));
    }

    /**
     * `AWS::CodeBuild::Project.Source`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-source
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSource() {
        return this.jsiiGet("source", java.lang.Object.class);
    }

    /**
     * `AWS::CodeBuild::Project.Source`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-source
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.CfnProject.SourceProperty value) {
        this.jsiiSet("source", java.util.Objects.requireNonNull(value, "source is required"));
    }

    /**
     * `AWS::CodeBuild::Project.Source`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-source
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("source", java.util.Objects.requireNonNull(value, "source is required"));
    }

    /**
     * `AWS::CodeBuild::Project.BadgeEnabled`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-badgeenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBadgeEnabled() {
        return this.jsiiGet("badgeEnabled", java.lang.Object.class);
    }

    /**
     * `AWS::CodeBuild::Project.BadgeEnabled`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-badgeenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBadgeEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        this.jsiiSet("badgeEnabled", value);
    }

    /**
     * `AWS::CodeBuild::Project.BadgeEnabled`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-badgeenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBadgeEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("badgeEnabled", value);
    }

    /**
     * `AWS::CodeBuild::Project.BuildBatchConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-buildbatchconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBuildBatchConfig() {
        return this.jsiiGet("buildBatchConfig", java.lang.Object.class);
    }

    /**
     * `AWS::CodeBuild::Project.BuildBatchConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-buildbatchconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBuildBatchConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("buildBatchConfig", value);
    }

    /**
     * `AWS::CodeBuild::Project.BuildBatchConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-buildbatchconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBuildBatchConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.CfnProject.ProjectBuildBatchConfigProperty value) {
        this.jsiiSet("buildBatchConfig", value);
    }

    /**
     * `AWS::CodeBuild::Project.Cache`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-cache
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCache() {
        return this.jsiiGet("cache", java.lang.Object.class);
    }

    /**
     * `AWS::CodeBuild::Project.Cache`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-cache
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCache(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("cache", value);
    }

    /**
     * `AWS::CodeBuild::Project.Cache`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-cache
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCache(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.CfnProject.ProjectCacheProperty value) {
        this.jsiiSet("cache", value);
    }

    /**
     * `AWS::CodeBuild::Project.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::CodeBuild::Project.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("description", value);
    }

    /**
     * `AWS::CodeBuild::Project.EncryptionKey`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-encryptionkey
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEncryptionKey() {
        return this.jsiiGet("encryptionKey", java.lang.String.class);
    }

    /**
     * `AWS::CodeBuild::Project.EncryptionKey`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-encryptionkey
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionKey(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("encryptionKey", value);
    }

    /**
     * `AWS::CodeBuild::Project.FileSystemLocations`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-filesystemlocations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFileSystemLocations() {
        return this.jsiiGet("fileSystemLocations", java.lang.Object.class);
    }

    /**
     * `AWS::CodeBuild::Project.FileSystemLocations`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-filesystemlocations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemLocations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("fileSystemLocations", value);
    }

    /**
     * `AWS::CodeBuild::Project.FileSystemLocations`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-filesystemlocations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemLocations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("fileSystemLocations", value);
    }

    /**
     * `AWS::CodeBuild::Project.LogsConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-logsconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogsConfig() {
        return this.jsiiGet("logsConfig", java.lang.Object.class);
    }

    /**
     * `AWS::CodeBuild::Project.LogsConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-logsconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogsConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("logsConfig", value);
    }

    /**
     * `AWS::CodeBuild::Project.LogsConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-logsconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogsConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.CfnProject.LogsConfigProperty value) {
        this.jsiiSet("logsConfig", value);
    }

    /**
     * `AWS::CodeBuild::Project.Name`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return this.jsiiGet("name", java.lang.String.class);
    }

    /**
     * `AWS::CodeBuild::Project.Name`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("name", value);
    }

    /**
     * `AWS::CodeBuild::Project.QueuedTimeoutInMinutes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-queuedtimeoutinminutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getQueuedTimeoutInMinutes() {
        return this.jsiiGet("queuedTimeoutInMinutes", java.lang.Number.class);
    }

    /**
     * `AWS::CodeBuild::Project.QueuedTimeoutInMinutes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-queuedtimeoutinminutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQueuedTimeoutInMinutes(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        this.jsiiSet("queuedTimeoutInMinutes", value);
    }

    /**
     * `AWS::CodeBuild::Project.SecondaryArtifacts`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondaryartifacts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSecondaryArtifacts() {
        return this.jsiiGet("secondaryArtifacts", java.lang.Object.class);
    }

    /**
     * `AWS::CodeBuild::Project.SecondaryArtifacts`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondaryartifacts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecondaryArtifacts(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("secondaryArtifacts", value);
    }

    /**
     * `AWS::CodeBuild::Project.SecondaryArtifacts`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondaryartifacts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecondaryArtifacts(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("secondaryArtifacts", value);
    }

    /**
     * `AWS::CodeBuild::Project.SecondarySources`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondarysources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSecondarySources() {
        return this.jsiiGet("secondarySources", java.lang.Object.class);
    }

    /**
     * `AWS::CodeBuild::Project.SecondarySources`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondarysources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecondarySources(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("secondarySources", value);
    }

    /**
     * `AWS::CodeBuild::Project.SecondarySources`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondarysources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecondarySources(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("secondarySources", value);
    }

    /**
     * `AWS::CodeBuild::Project.SecondarySourceVersions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondarysourceversions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSecondarySourceVersions() {
        return this.jsiiGet("secondarySourceVersions", java.lang.Object.class);
    }

    /**
     * `AWS::CodeBuild::Project.SecondarySourceVersions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondarysourceversions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecondarySourceVersions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("secondarySourceVersions", value);
    }

    /**
     * `AWS::CodeBuild::Project.SecondarySourceVersions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondarysourceversions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecondarySourceVersions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("secondarySourceVersions", value);
    }

    /**
     * `AWS::CodeBuild::Project.SourceVersion`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-sourceversion
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceVersion() {
        return this.jsiiGet("sourceVersion", java.lang.String.class);
    }

    /**
     * `AWS::CodeBuild::Project.SourceVersion`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-sourceversion
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("sourceVersion", value);
    }

    /**
     * `AWS::CodeBuild::Project.TimeoutInMinutes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-timeoutinminutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInMinutes() {
        return this.jsiiGet("timeoutInMinutes", java.lang.Number.class);
    }

    /**
     * `AWS::CodeBuild::Project.TimeoutInMinutes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-timeoutinminutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeoutInMinutes(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        this.jsiiSet("timeoutInMinutes", value);
    }

    /**
     * `AWS::CodeBuild::Project.Triggers`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-triggers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTriggers() {
        return this.jsiiGet("triggers", java.lang.Object.class);
    }

    /**
     * `AWS::CodeBuild::Project.Triggers`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-triggers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggers(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("triggers", value);
    }

    /**
     * `AWS::CodeBuild::Project.Triggers`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-triggers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggers(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.CfnProject.ProjectTriggersProperty value) {
        this.jsiiSet("triggers", value);
    }

    /**
     * `AWS::CodeBuild::Project.VpcConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-vpcconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
        return this.jsiiGet("vpcConfig", java.lang.Object.class);
    }

    /**
     * `AWS::CodeBuild::Project.VpcConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-vpcconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("vpcConfig", value);
    }

    /**
     * `AWS::CodeBuild::Project.VpcConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-vpcconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.CfnProject.VpcConfigProperty value) {
        this.jsiiSet("vpcConfig", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject.ArtifactsProperty")
    @software.amazon.jsii.Jsii.Proxy(ArtifactsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArtifactsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnProject.ArtifactsProperty.Type`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * `CfnProject.ArtifactsProperty.ArtifactIdentifier`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-artifactidentifier
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArtifactIdentifier() {
            return null;
        }

        /**
         * `CfnProject.ArtifactsProperty.EncryptionDisabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-encryptiondisabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionDisabled() {
            return null;
        }

        /**
         * `CfnProject.ArtifactsProperty.Location`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-location
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocation() {
            return null;
        }

        /**
         * `CfnProject.ArtifactsProperty.Name`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * `CfnProject.ArtifactsProperty.NamespaceType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-namespacetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespaceType() {
            return null;
        }

        /**
         * `CfnProject.ArtifactsProperty.OverrideArtifactName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-overrideartifactname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverrideArtifactName() {
            return null;
        }

        /**
         * `CfnProject.ArtifactsProperty.Packaging`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-packaging
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPackaging() {
            return null;
        }

        /**
         * `CfnProject.ArtifactsProperty.Path`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-path
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArtifactsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArtifactsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArtifactsProperty> {
            private java.lang.String type;
            private java.lang.String artifactIdentifier;
            private java.lang.Object encryptionDisabled;
            private java.lang.String location;
            private java.lang.String name;
            private java.lang.String namespaceType;
            private java.lang.Object overrideArtifactName;
            private java.lang.String packaging;
            private java.lang.String path;

            /**
             * Sets the value of {@link ArtifactsProperty#getType}
             * @param type `CfnProject.ArtifactsProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getArtifactIdentifier}
             * @param artifactIdentifier `CfnProject.ArtifactsProperty.ArtifactIdentifier`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder artifactIdentifier(java.lang.String artifactIdentifier) {
                this.artifactIdentifier = artifactIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getEncryptionDisabled}
             * @param encryptionDisabled `CfnProject.ArtifactsProperty.EncryptionDisabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionDisabled(java.lang.Boolean encryptionDisabled) {
                this.encryptionDisabled = encryptionDisabled;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getEncryptionDisabled}
             * @param encryptionDisabled `CfnProject.ArtifactsProperty.EncryptionDisabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionDisabled(software.amazon.awscdk.core.IResolvable encryptionDisabled) {
                this.encryptionDisabled = encryptionDisabled;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getLocation}
             * @param location `CfnProject.ArtifactsProperty.Location`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(java.lang.String location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getName}
             * @param name `CfnProject.ArtifactsProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getNamespaceType}
             * @param namespaceType `CfnProject.ArtifactsProperty.NamespaceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespaceType(java.lang.String namespaceType) {
                this.namespaceType = namespaceType;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getOverrideArtifactName}
             * @param overrideArtifactName `CfnProject.ArtifactsProperty.OverrideArtifactName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrideArtifactName(java.lang.Boolean overrideArtifactName) {
                this.overrideArtifactName = overrideArtifactName;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getOverrideArtifactName}
             * @param overrideArtifactName `CfnProject.ArtifactsProperty.OverrideArtifactName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrideArtifactName(software.amazon.awscdk.core.IResolvable overrideArtifactName) {
                this.overrideArtifactName = overrideArtifactName;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getPackaging}
             * @param packaging `CfnProject.ArtifactsProperty.Packaging`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder packaging(java.lang.String packaging) {
                this.packaging = packaging;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactsProperty#getPath}
             * @param path `CfnProject.ArtifactsProperty.Path`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArtifactsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArtifactsProperty build() {
                return new Jsii$Proxy(type, artifactIdentifier, encryptionDisabled, location, name, namespaceType, overrideArtifactName, packaging, path);
            }
        }

        /**
         * An implementation for {@link ArtifactsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArtifactsProperty {
            private final java.lang.String type;
            private final java.lang.String artifactIdentifier;
            private final java.lang.Object encryptionDisabled;
            private final java.lang.String location;
            private final java.lang.String name;
            private final java.lang.String namespaceType;
            private final java.lang.Object overrideArtifactName;
            private final java.lang.String packaging;
            private final java.lang.String path;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.artifactIdentifier = this.jsiiGet("artifactIdentifier", java.lang.String.class);
                this.encryptionDisabled = this.jsiiGet("encryptionDisabled", java.lang.Object.class);
                this.location = this.jsiiGet("location", java.lang.String.class);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.namespaceType = this.jsiiGet("namespaceType", java.lang.String.class);
                this.overrideArtifactName = this.jsiiGet("overrideArtifactName", java.lang.Object.class);
                this.packaging = this.jsiiGet("packaging", java.lang.String.class);
                this.path = this.jsiiGet("path", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String type, final java.lang.String artifactIdentifier, final java.lang.Object encryptionDisabled, final java.lang.String location, final java.lang.String name, final java.lang.String namespaceType, final java.lang.Object overrideArtifactName, final java.lang.String packaging, final java.lang.String path) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(type, "type is required");
                this.artifactIdentifier = artifactIdentifier;
                this.encryptionDisabled = encryptionDisabled;
                this.location = location;
                this.name = name;
                this.namespaceType = namespaceType;
                this.overrideArtifactName = overrideArtifactName;
                this.packaging = packaging;
                this.path = path;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.String getArtifactIdentifier() {
                return this.artifactIdentifier;
            }

            @Override
            public java.lang.Object getEncryptionDisabled() {
                return this.encryptionDisabled;
            }

            @Override
            public java.lang.String getLocation() {
                return this.location;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.String getNamespaceType() {
                return this.namespaceType;
            }

            @Override
            public java.lang.Object getOverrideArtifactName() {
                return this.overrideArtifactName;
            }

            @Override
            public java.lang.String getPackaging() {
                return this.packaging;
            }

            @Override
            public java.lang.String getPath() {
                return this.path;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getArtifactIdentifier() != null) {
                    data.set("artifactIdentifier", om.valueToTree(this.getArtifactIdentifier()));
                }
                if (this.getEncryptionDisabled() != null) {
                    data.set("encryptionDisabled", om.valueToTree(this.getEncryptionDisabled()));
                }
                if (this.getLocation() != null) {
                    data.set("location", om.valueToTree(this.getLocation()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getNamespaceType() != null) {
                    data.set("namespaceType", om.valueToTree(this.getNamespaceType()));
                }
                if (this.getOverrideArtifactName() != null) {
                    data.set("overrideArtifactName", om.valueToTree(this.getOverrideArtifactName()));
                }
                if (this.getPackaging() != null) {
                    data.set("packaging", om.valueToTree(this.getPackaging()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnProject.ArtifactsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArtifactsProperty.Jsii$Proxy that = (ArtifactsProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.artifactIdentifier != null ? !this.artifactIdentifier.equals(that.artifactIdentifier) : that.artifactIdentifier != null) return false;
                if (this.encryptionDisabled != null ? !this.encryptionDisabled.equals(that.encryptionDisabled) : that.encryptionDisabled != null) return false;
                if (this.location != null ? !this.location.equals(that.location) : that.location != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.namespaceType != null ? !this.namespaceType.equals(that.namespaceType) : that.namespaceType != null) return false;
                if (this.overrideArtifactName != null ? !this.overrideArtifactName.equals(that.overrideArtifactName) : that.overrideArtifactName != null) return false;
                if (this.packaging != null ? !this.packaging.equals(that.packaging) : that.packaging != null) return false;
                return this.path != null ? this.path.equals(that.path) : that.path == null;
            }

            @Override
            public int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.artifactIdentifier != null ? this.artifactIdentifier.hashCode() : 0);
                result = 31 * result + (this.encryptionDisabled != null ? this.encryptionDisabled.hashCode() : 0);
                result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.namespaceType != null ? this.namespaceType.hashCode() : 0);
                result = 31 * result + (this.overrideArtifactName != null ? this.overrideArtifactName.hashCode() : 0);
                result = 31 * result + (this.packaging != null ? this.packaging.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-batchrestrictions.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject.BatchRestrictionsProperty")
    @software.amazon.jsii.Jsii.Proxy(BatchRestrictionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BatchRestrictionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnProject.BatchRestrictionsProperty.ComputeTypesAllowed`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-batchrestrictions.html#cfn-codebuild-project-batchrestrictions-computetypesallowed
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getComputeTypesAllowed() {
            return null;
        }

        /**
         * `CfnProject.BatchRestrictionsProperty.MaximumBuildsAllowed`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-batchrestrictions.html#cfn-codebuild-project-batchrestrictions-maximumbuildsallowed
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumBuildsAllowed() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BatchRestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BatchRestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BatchRestrictionsProperty> {
            private java.util.List<java.lang.String> computeTypesAllowed;
            private java.lang.Number maximumBuildsAllowed;

            /**
             * Sets the value of {@link BatchRestrictionsProperty#getComputeTypesAllowed}
             * @param computeTypesAllowed `CfnProject.BatchRestrictionsProperty.ComputeTypesAllowed`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder computeTypesAllowed(java.util.List<java.lang.String> computeTypesAllowed) {
                this.computeTypesAllowed = computeTypesAllowed;
                return this;
            }

            /**
             * Sets the value of {@link BatchRestrictionsProperty#getMaximumBuildsAllowed}
             * @param maximumBuildsAllowed `CfnProject.BatchRestrictionsProperty.MaximumBuildsAllowed`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumBuildsAllowed(java.lang.Number maximumBuildsAllowed) {
                this.maximumBuildsAllowed = maximumBuildsAllowed;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BatchRestrictionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BatchRestrictionsProperty build() {
                return new Jsii$Proxy(computeTypesAllowed, maximumBuildsAllowed);
            }
        }

        /**
         * An implementation for {@link BatchRestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BatchRestrictionsProperty {
            private final java.util.List<java.lang.String> computeTypesAllowed;
            private final java.lang.Number maximumBuildsAllowed;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.computeTypesAllowed = this.jsiiGet("computeTypesAllowed", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.maximumBuildsAllowed = this.jsiiGet("maximumBuildsAllowed", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.util.List<java.lang.String> computeTypesAllowed, final java.lang.Number maximumBuildsAllowed) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.computeTypesAllowed = computeTypesAllowed;
                this.maximumBuildsAllowed = maximumBuildsAllowed;
            }

            @Override
            public java.util.List<java.lang.String> getComputeTypesAllowed() {
                return this.computeTypesAllowed;
            }

            @Override
            public java.lang.Number getMaximumBuildsAllowed() {
                return this.maximumBuildsAllowed;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComputeTypesAllowed() != null) {
                    data.set("computeTypesAllowed", om.valueToTree(this.getComputeTypesAllowed()));
                }
                if (this.getMaximumBuildsAllowed() != null) {
                    data.set("maximumBuildsAllowed", om.valueToTree(this.getMaximumBuildsAllowed()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnProject.BatchRestrictionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BatchRestrictionsProperty.Jsii$Proxy that = (BatchRestrictionsProperty.Jsii$Proxy) o;

                if (this.computeTypesAllowed != null ? !this.computeTypesAllowed.equals(that.computeTypesAllowed) : that.computeTypesAllowed != null) return false;
                return this.maximumBuildsAllowed != null ? this.maximumBuildsAllowed.equals(that.maximumBuildsAllowed) : that.maximumBuildsAllowed == null;
            }

            @Override
            public int hashCode() {
                int result = this.computeTypesAllowed != null ? this.computeTypesAllowed.hashCode() : 0;
                result = 31 * result + (this.maximumBuildsAllowed != null ? this.maximumBuildsAllowed.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-buildstatusconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject.BuildStatusConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(BuildStatusConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BuildStatusConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnProject.BuildStatusConfigProperty.Context`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-buildstatusconfig.html#cfn-codebuild-project-buildstatusconfig-context
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContext() {
            return null;
        }

        /**
         * `CfnProject.BuildStatusConfigProperty.TargetUrl`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-buildstatusconfig.html#cfn-codebuild-project-buildstatusconfig-targeturl
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BuildStatusConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BuildStatusConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BuildStatusConfigProperty> {
            private java.lang.String context;
            private java.lang.String targetUrl;

            /**
             * Sets the value of {@link BuildStatusConfigProperty#getContext}
             * @param context `CfnProject.BuildStatusConfigProperty.Context`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder context(java.lang.String context) {
                this.context = context;
                return this;
            }

            /**
             * Sets the value of {@link BuildStatusConfigProperty#getTargetUrl}
             * @param targetUrl `CfnProject.BuildStatusConfigProperty.TargetUrl`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetUrl(java.lang.String targetUrl) {
                this.targetUrl = targetUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BuildStatusConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BuildStatusConfigProperty build() {
                return new Jsii$Proxy(context, targetUrl);
            }
        }

        /**
         * An implementation for {@link BuildStatusConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BuildStatusConfigProperty {
            private final java.lang.String context;
            private final java.lang.String targetUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.context = this.jsiiGet("context", java.lang.String.class);
                this.targetUrl = this.jsiiGet("targetUrl", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String context, final java.lang.String targetUrl) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.context = context;
                this.targetUrl = targetUrl;
            }

            @Override
            public java.lang.String getContext() {
                return this.context;
            }

            @Override
            public java.lang.String getTargetUrl() {
                return this.targetUrl;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContext() != null) {
                    data.set("context", om.valueToTree(this.getContext()));
                }
                if (this.getTargetUrl() != null) {
                    data.set("targetUrl", om.valueToTree(this.getTargetUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnProject.BuildStatusConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BuildStatusConfigProperty.Jsii$Proxy that = (BuildStatusConfigProperty.Jsii$Proxy) o;

                if (this.context != null ? !this.context.equals(that.context) : that.context != null) return false;
                return this.targetUrl != null ? this.targetUrl.equals(that.targetUrl) : that.targetUrl == null;
            }

            @Override
            public int hashCode() {
                int result = this.context != null ? this.context.hashCode() : 0;
                result = 31 * result + (this.targetUrl != null ? this.targetUrl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject.CloudWatchLogsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLogsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLogsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnProject.CloudWatchLogsConfigProperty.Status`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-status
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * `CfnProject.CloudWatchLogsConfigProperty.GroupName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-groupname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
            return null;
        }

        /**
         * `CfnProject.CloudWatchLogsConfigProperty.StreamName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-streamname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStreamName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudWatchLogsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLogsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLogsConfigProperty> {
            private java.lang.String status;
            private java.lang.String groupName;
            private java.lang.String streamName;

            /**
             * Sets the value of {@link CloudWatchLogsConfigProperty#getStatus}
             * @param status `CfnProject.CloudWatchLogsConfigProperty.Status`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLogsConfigProperty#getGroupName}
             * @param groupName `CfnProject.CloudWatchLogsConfigProperty.GroupName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupName(java.lang.String groupName) {
                this.groupName = groupName;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLogsConfigProperty#getStreamName}
             * @param streamName `CfnProject.CloudWatchLogsConfigProperty.StreamName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamName(java.lang.String streamName) {
                this.streamName = streamName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLogsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLogsConfigProperty build() {
                return new Jsii$Proxy(status, groupName, streamName);
            }
        }

        /**
         * An implementation for {@link CloudWatchLogsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLogsConfigProperty {
            private final java.lang.String status;
            private final java.lang.String groupName;
            private final java.lang.String streamName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = this.jsiiGet("status", java.lang.String.class);
                this.groupName = this.jsiiGet("groupName", java.lang.String.class);
                this.streamName = this.jsiiGet("streamName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String status, final java.lang.String groupName, final java.lang.String streamName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(status, "status is required");
                this.groupName = groupName;
                this.streamName = streamName;
            }

            @Override
            public java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public java.lang.String getGroupName() {
                return this.groupName;
            }

            @Override
            public java.lang.String getStreamName() {
                return this.streamName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));
                if (this.getGroupName() != null) {
                    data.set("groupName", om.valueToTree(this.getGroupName()));
                }
                if (this.getStreamName() != null) {
                    data.set("streamName", om.valueToTree(this.getStreamName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnProject.CloudWatchLogsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLogsConfigProperty.Jsii$Proxy that = (CloudWatchLogsConfigProperty.Jsii$Proxy) o;

                if (!status.equals(that.status)) return false;
                if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) return false;
                return this.streamName != null ? this.streamName.equals(that.streamName) : that.streamName == null;
            }

            @Override
            public int hashCode() {
                int result = this.status.hashCode();
                result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
                result = 31 * result + (this.streamName != null ? this.streamName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject.EnvironmentProperty")
    @software.amazon.jsii.Jsii.Proxy(EnvironmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnvironmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnProject.EnvironmentProperty.ComputeType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-computetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComputeType();

        /**
         * `CfnProject.EnvironmentProperty.Image`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-image
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImage();

        /**
         * `CfnProject.EnvironmentProperty.Type`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * `CfnProject.EnvironmentProperty.Certificate`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-certificate
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificate() {
            return null;
        }

        /**
         * `CfnProject.EnvironmentProperty.EnvironmentVariables`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-environmentvariables
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironmentVariables() {
            return null;
        }

        /**
         * `CfnProject.EnvironmentProperty.ImagePullCredentialsType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-imagepullcredentialstype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImagePullCredentialsType() {
            return null;
        }

        /**
         * `CfnProject.EnvironmentProperty.PrivilegedMode`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-privilegedmode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrivilegedMode() {
            return null;
        }

        /**
         * `CfnProject.EnvironmentProperty.RegistryCredential`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-registrycredential
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRegistryCredential() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnvironmentProperty> {
            private java.lang.String computeType;
            private java.lang.String image;
            private java.lang.String type;
            private java.lang.String certificate;
            private java.lang.Object environmentVariables;
            private java.lang.String imagePullCredentialsType;
            private java.lang.Object privilegedMode;
            private java.lang.Object registryCredential;

            /**
             * Sets the value of {@link EnvironmentProperty#getComputeType}
             * @param computeType `CfnProject.EnvironmentProperty.ComputeType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder computeType(java.lang.String computeType) {
                this.computeType = computeType;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getImage}
             * @param image `CfnProject.EnvironmentProperty.Image`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder image(java.lang.String image) {
                this.image = image;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getType}
             * @param type `CfnProject.EnvironmentProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getCertificate}
             * @param certificate `CfnProject.EnvironmentProperty.Certificate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificate(java.lang.String certificate) {
                this.certificate = certificate;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getEnvironmentVariables}
             * @param environmentVariables `CfnProject.EnvironmentProperty.EnvironmentVariables`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentVariables(software.amazon.awscdk.core.IResolvable environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getEnvironmentVariables}
             * @param environmentVariables `CfnProject.EnvironmentProperty.EnvironmentVariables`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentVariables(java.util.List<java.lang.Object> environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getImagePullCredentialsType}
             * @param imagePullCredentialsType `CfnProject.EnvironmentProperty.ImagePullCredentialsType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imagePullCredentialsType(java.lang.String imagePullCredentialsType) {
                this.imagePullCredentialsType = imagePullCredentialsType;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getPrivilegedMode}
             * @param privilegedMode `CfnProject.EnvironmentProperty.PrivilegedMode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privilegedMode(java.lang.Boolean privilegedMode) {
                this.privilegedMode = privilegedMode;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getPrivilegedMode}
             * @param privilegedMode `CfnProject.EnvironmentProperty.PrivilegedMode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privilegedMode(software.amazon.awscdk.core.IResolvable privilegedMode) {
                this.privilegedMode = privilegedMode;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getRegistryCredential}
             * @param registryCredential `CfnProject.EnvironmentProperty.RegistryCredential`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder registryCredential(software.amazon.awscdk.core.IResolvable registryCredential) {
                this.registryCredential = registryCredential;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getRegistryCredential}
             * @param registryCredential `CfnProject.EnvironmentProperty.RegistryCredential`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder registryCredential(software.amazon.awscdk.services.codebuild.CfnProject.RegistryCredentialProperty registryCredential) {
                this.registryCredential = registryCredential;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnvironmentProperty build() {
                return new Jsii$Proxy(computeType, image, type, certificate, environmentVariables, imagePullCredentialsType, privilegedMode, registryCredential);
            }
        }

        /**
         * An implementation for {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentProperty {
            private final java.lang.String computeType;
            private final java.lang.String image;
            private final java.lang.String type;
            private final java.lang.String certificate;
            private final java.lang.Object environmentVariables;
            private final java.lang.String imagePullCredentialsType;
            private final java.lang.Object privilegedMode;
            private final java.lang.Object registryCredential;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.computeType = this.jsiiGet("computeType", java.lang.String.class);
                this.image = this.jsiiGet("image", java.lang.String.class);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.certificate = this.jsiiGet("certificate", java.lang.String.class);
                this.environmentVariables = this.jsiiGet("environmentVariables", java.lang.Object.class);
                this.imagePullCredentialsType = this.jsiiGet("imagePullCredentialsType", java.lang.String.class);
                this.privilegedMode = this.jsiiGet("privilegedMode", java.lang.Object.class);
                this.registryCredential = this.jsiiGet("registryCredential", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String computeType, final java.lang.String image, final java.lang.String type, final java.lang.String certificate, final java.lang.Object environmentVariables, final java.lang.String imagePullCredentialsType, final java.lang.Object privilegedMode, final java.lang.Object registryCredential) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.computeType = java.util.Objects.requireNonNull(computeType, "computeType is required");
                this.image = java.util.Objects.requireNonNull(image, "image is required");
                this.type = java.util.Objects.requireNonNull(type, "type is required");
                this.certificate = certificate;
                this.environmentVariables = environmentVariables;
                this.imagePullCredentialsType = imagePullCredentialsType;
                this.privilegedMode = privilegedMode;
                this.registryCredential = registryCredential;
            }

            @Override
            public java.lang.String getComputeType() {
                return this.computeType;
            }

            @Override
            public java.lang.String getImage() {
                return this.image;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.String getCertificate() {
                return this.certificate;
            }

            @Override
            public java.lang.Object getEnvironmentVariables() {
                return this.environmentVariables;
            }

            @Override
            public java.lang.String getImagePullCredentialsType() {
                return this.imagePullCredentialsType;
            }

            @Override
            public java.lang.Object getPrivilegedMode() {
                return this.privilegedMode;
            }

            @Override
            public java.lang.Object getRegistryCredential() {
                return this.registryCredential;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("computeType", om.valueToTree(this.getComputeType()));
                data.set("image", om.valueToTree(this.getImage()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getCertificate() != null) {
                    data.set("certificate", om.valueToTree(this.getCertificate()));
                }
                if (this.getEnvironmentVariables() != null) {
                    data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
                }
                if (this.getImagePullCredentialsType() != null) {
                    data.set("imagePullCredentialsType", om.valueToTree(this.getImagePullCredentialsType()));
                }
                if (this.getPrivilegedMode() != null) {
                    data.set("privilegedMode", om.valueToTree(this.getPrivilegedMode()));
                }
                if (this.getRegistryCredential() != null) {
                    data.set("registryCredential", om.valueToTree(this.getRegistryCredential()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnProject.EnvironmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnvironmentProperty.Jsii$Proxy that = (EnvironmentProperty.Jsii$Proxy) o;

                if (!computeType.equals(that.computeType)) return false;
                if (!image.equals(that.image)) return false;
                if (!type.equals(that.type)) return false;
                if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) return false;
                if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
                if (this.imagePullCredentialsType != null ? !this.imagePullCredentialsType.equals(that.imagePullCredentialsType) : that.imagePullCredentialsType != null) return false;
                if (this.privilegedMode != null ? !this.privilegedMode.equals(that.privilegedMode) : that.privilegedMode != null) return false;
                return this.registryCredential != null ? this.registryCredential.equals(that.registryCredential) : that.registryCredential == null;
            }

            @Override
            public int hashCode() {
                int result = this.computeType.hashCode();
                result = 31 * result + (this.image.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.certificate != null ? this.certificate.hashCode() : 0);
                result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
                result = 31 * result + (this.imagePullCredentialsType != null ? this.imagePullCredentialsType.hashCode() : 0);
                result = 31 * result + (this.privilegedMode != null ? this.privilegedMode.hashCode() : 0);
                result = 31 * result + (this.registryCredential != null ? this.registryCredential.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject.EnvironmentVariableProperty")
    @software.amazon.jsii.Jsii.Proxy(EnvironmentVariableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnvironmentVariableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnProject.EnvironmentVariableProperty.Name`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnProject.EnvironmentVariableProperty.Value`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * `CfnProject.EnvironmentVariableProperty.Type`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnvironmentVariableProperty> {
            private java.lang.String name;
            private java.lang.String value;
            private java.lang.String type;

            /**
             * Sets the value of {@link EnvironmentVariableProperty#getName}
             * @param name `CfnProject.EnvironmentVariableProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentVariableProperty#getValue}
             * @param value `CfnProject.EnvironmentVariableProperty.Value`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentVariableProperty#getType}
             * @param type `CfnProject.EnvironmentVariableProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentVariableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnvironmentVariableProperty build() {
                return new Jsii$Proxy(name, value, type);
            }
        }

        /**
         * An implementation for {@link EnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentVariableProperty {
            private final java.lang.String name;
            private final java.lang.String value;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.String.class);
                this.type = this.jsiiGet("type", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String name, final java.lang.String value, final java.lang.String type) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.value = java.util.Objects.requireNonNull(value, "value is required");
                this.type = type;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.String getValue() {
                return this.value;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnProject.EnvironmentVariableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnvironmentVariableProperty.Jsii$Proxy that = (EnvironmentVariableProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!value.equals(that.value)) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-gitsubmodulesconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject.GitSubmodulesConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(GitSubmodulesConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GitSubmodulesConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnProject.GitSubmodulesConfigProperty.FetchSubmodules`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-gitsubmodulesconfig.html#cfn-codebuild-project-gitsubmodulesconfig-fetchsubmodules
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFetchSubmodules();

        /**
         * @return a {@link Builder} of {@link GitSubmodulesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GitSubmodulesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GitSubmodulesConfigProperty> {
            private java.lang.Object fetchSubmodules;

            /**
             * Sets the value of {@link GitSubmodulesConfigProperty#getFetchSubmodules}
             * @param fetchSubmodules `CfnProject.GitSubmodulesConfigProperty.FetchSubmodules`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fetchSubmodules(java.lang.Boolean fetchSubmodules) {
                this.fetchSubmodules = fetchSubmodules;
                return this;
            }

            /**
             * Sets the value of {@link GitSubmodulesConfigProperty#getFetchSubmodules}
             * @param fetchSubmodules `CfnProject.GitSubmodulesConfigProperty.FetchSubmodules`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fetchSubmodules(software.amazon.awscdk.core.IResolvable fetchSubmodules) {
                this.fetchSubmodules = fetchSubmodules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GitSubmodulesConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GitSubmodulesConfigProperty build() {
                return new Jsii$Proxy(fetchSubmodules);
            }
        }

        /**
         * An implementation for {@link GitSubmodulesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitSubmodulesConfigProperty {
            private final java.lang.Object fetchSubmodules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fetchSubmodules = this.jsiiGet("fetchSubmodules", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object fetchSubmodules) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fetchSubmodules = java.util.Objects.requireNonNull(fetchSubmodules, "fetchSubmodules is required");
            }

            @Override
            public java.lang.Object getFetchSubmodules() {
                return this.fetchSubmodules;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fetchSubmodules", om.valueToTree(this.getFetchSubmodules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnProject.GitSubmodulesConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GitSubmodulesConfigProperty.Jsii$Proxy that = (GitSubmodulesConfigProperty.Jsii$Proxy) o;

                return this.fetchSubmodules.equals(that.fetchSubmodules);
            }

            @Override
            public int hashCode() {
                int result = this.fetchSubmodules.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject.LogsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LogsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnProject.LogsConfigProperty.CloudWatchLogs`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html#cfn-codebuild-project-logsconfig-cloudwatchlogs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLogs() {
            return null;
        }

        /**
         * `CfnProject.LogsConfigProperty.S3Logs`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html#cfn-codebuild-project-logsconfig-s3logs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Logs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogsConfigProperty> {
            private java.lang.Object cloudWatchLogs;
            private java.lang.Object s3Logs;

            /**
             * Sets the value of {@link LogsConfigProperty#getCloudWatchLogs}
             * @param cloudWatchLogs `CfnProject.LogsConfigProperty.CloudWatchLogs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogs(software.amazon.awscdk.core.IResolvable cloudWatchLogs) {
                this.cloudWatchLogs = cloudWatchLogs;
                return this;
            }

            /**
             * Sets the value of {@link LogsConfigProperty#getCloudWatchLogs}
             * @param cloudWatchLogs `CfnProject.LogsConfigProperty.CloudWatchLogs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogs(software.amazon.awscdk.services.codebuild.CfnProject.CloudWatchLogsConfigProperty cloudWatchLogs) {
                this.cloudWatchLogs = cloudWatchLogs;
                return this;
            }

            /**
             * Sets the value of {@link LogsConfigProperty#getS3Logs}
             * @param s3Logs `CfnProject.LogsConfigProperty.S3Logs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Logs(software.amazon.awscdk.core.IResolvable s3Logs) {
                this.s3Logs = s3Logs;
                return this;
            }

            /**
             * Sets the value of {@link LogsConfigProperty#getS3Logs}
             * @param s3Logs `CfnProject.LogsConfigProperty.S3Logs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Logs(software.amazon.awscdk.services.codebuild.CfnProject.S3LogsConfigProperty s3Logs) {
                this.s3Logs = s3Logs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogsConfigProperty build() {
                return new Jsii$Proxy(cloudWatchLogs, s3Logs);
            }
        }

        /**
         * An implementation for {@link LogsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogsConfigProperty {
            private final java.lang.Object cloudWatchLogs;
            private final java.lang.Object s3Logs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogs = this.jsiiGet("cloudWatchLogs", java.lang.Object.class);
                this.s3Logs = this.jsiiGet("s3Logs", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object cloudWatchLogs, final java.lang.Object s3Logs) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogs = cloudWatchLogs;
                this.s3Logs = s3Logs;
            }

            @Override
            public java.lang.Object getCloudWatchLogs() {
                return this.cloudWatchLogs;
            }

            @Override
            public java.lang.Object getS3Logs() {
                return this.s3Logs;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchLogs() != null) {
                    data.set("cloudWatchLogs", om.valueToTree(this.getCloudWatchLogs()));
                }
                if (this.getS3Logs() != null) {
                    data.set("s3Logs", om.valueToTree(this.getS3Logs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnProject.LogsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogsConfigProperty.Jsii$Proxy that = (LogsConfigProperty.Jsii$Proxy) o;

                if (this.cloudWatchLogs != null ? !this.cloudWatchLogs.equals(that.cloudWatchLogs) : that.cloudWatchLogs != null) return false;
                return this.s3Logs != null ? this.s3Logs.equals(that.s3Logs) : that.s3Logs == null;
            }

            @Override
            public int hashCode() {
                int result = this.cloudWatchLogs != null ? this.cloudWatchLogs.hashCode() : 0;
                result = 31 * result + (this.s3Logs != null ? this.s3Logs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectbuildbatchconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject.ProjectBuildBatchConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ProjectBuildBatchConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProjectBuildBatchConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnProject.ProjectBuildBatchConfigProperty.CombineArtifacts`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectbuildbatchconfig.html#cfn-codebuild-project-projectbuildbatchconfig-combineartifacts
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCombineArtifacts() {
            return null;
        }

        /**
         * `CfnProject.ProjectBuildBatchConfigProperty.Restrictions`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectbuildbatchconfig.html#cfn-codebuild-project-projectbuildbatchconfig-restrictions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRestrictions() {
            return null;
        }

        /**
         * `CfnProject.ProjectBuildBatchConfigProperty.ServiceRole`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectbuildbatchconfig.html#cfn-codebuild-project-projectbuildbatchconfig-servicerole
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceRole() {
            return null;
        }

        /**
         * `CfnProject.ProjectBuildBatchConfigProperty.TimeoutInMins`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectbuildbatchconfig.html#cfn-codebuild-project-projectbuildbatchconfig-timeoutinmins
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInMins() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProjectBuildBatchConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProjectBuildBatchConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProjectBuildBatchConfigProperty> {
            private java.lang.Object combineArtifacts;
            private java.lang.Object restrictions;
            private java.lang.String serviceRole;
            private java.lang.Number timeoutInMins;

            /**
             * Sets the value of {@link ProjectBuildBatchConfigProperty#getCombineArtifacts}
             * @param combineArtifacts `CfnProject.ProjectBuildBatchConfigProperty.CombineArtifacts`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder combineArtifacts(java.lang.Boolean combineArtifacts) {
                this.combineArtifacts = combineArtifacts;
                return this;
            }

            /**
             * Sets the value of {@link ProjectBuildBatchConfigProperty#getCombineArtifacts}
             * @param combineArtifacts `CfnProject.ProjectBuildBatchConfigProperty.CombineArtifacts`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder combineArtifacts(software.amazon.awscdk.core.IResolvable combineArtifacts) {
                this.combineArtifacts = combineArtifacts;
                return this;
            }

            /**
             * Sets the value of {@link ProjectBuildBatchConfigProperty#getRestrictions}
             * @param restrictions `CfnProject.ProjectBuildBatchConfigProperty.Restrictions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictions(software.amazon.awscdk.core.IResolvable restrictions) {
                this.restrictions = restrictions;
                return this;
            }

            /**
             * Sets the value of {@link ProjectBuildBatchConfigProperty#getRestrictions}
             * @param restrictions `CfnProject.ProjectBuildBatchConfigProperty.Restrictions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictions(software.amazon.awscdk.services.codebuild.CfnProject.BatchRestrictionsProperty restrictions) {
                this.restrictions = restrictions;
                return this;
            }

            /**
             * Sets the value of {@link ProjectBuildBatchConfigProperty#getServiceRole}
             * @param serviceRole `CfnProject.ProjectBuildBatchConfigProperty.ServiceRole`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceRole(java.lang.String serviceRole) {
                this.serviceRole = serviceRole;
                return this;
            }

            /**
             * Sets the value of {@link ProjectBuildBatchConfigProperty#getTimeoutInMins}
             * @param timeoutInMins `CfnProject.ProjectBuildBatchConfigProperty.TimeoutInMins`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutInMins(java.lang.Number timeoutInMins) {
                this.timeoutInMins = timeoutInMins;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectBuildBatchConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProjectBuildBatchConfigProperty build() {
                return new Jsii$Proxy(combineArtifacts, restrictions, serviceRole, timeoutInMins);
            }
        }

        /**
         * An implementation for {@link ProjectBuildBatchConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectBuildBatchConfigProperty {
            private final java.lang.Object combineArtifacts;
            private final java.lang.Object restrictions;
            private final java.lang.String serviceRole;
            private final java.lang.Number timeoutInMins;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.combineArtifacts = this.jsiiGet("combineArtifacts", java.lang.Object.class);
                this.restrictions = this.jsiiGet("restrictions", java.lang.Object.class);
                this.serviceRole = this.jsiiGet("serviceRole", java.lang.String.class);
                this.timeoutInMins = this.jsiiGet("timeoutInMins", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object combineArtifacts, final java.lang.Object restrictions, final java.lang.String serviceRole, final java.lang.Number timeoutInMins) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.combineArtifacts = combineArtifacts;
                this.restrictions = restrictions;
                this.serviceRole = serviceRole;
                this.timeoutInMins = timeoutInMins;
            }

            @Override
            public java.lang.Object getCombineArtifacts() {
                return this.combineArtifacts;
            }

            @Override
            public java.lang.Object getRestrictions() {
                return this.restrictions;
            }

            @Override
            public java.lang.String getServiceRole() {
                return this.serviceRole;
            }

            @Override
            public java.lang.Number getTimeoutInMins() {
                return this.timeoutInMins;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCombineArtifacts() != null) {
                    data.set("combineArtifacts", om.valueToTree(this.getCombineArtifacts()));
                }
                if (this.getRestrictions() != null) {
                    data.set("restrictions", om.valueToTree(this.getRestrictions()));
                }
                if (this.getServiceRole() != null) {
                    data.set("serviceRole", om.valueToTree(this.getServiceRole()));
                }
                if (this.getTimeoutInMins() != null) {
                    data.set("timeoutInMins", om.valueToTree(this.getTimeoutInMins()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnProject.ProjectBuildBatchConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProjectBuildBatchConfigProperty.Jsii$Proxy that = (ProjectBuildBatchConfigProperty.Jsii$Proxy) o;

                if (this.combineArtifacts != null ? !this.combineArtifacts.equals(that.combineArtifacts) : that.combineArtifacts != null) return false;
                if (this.restrictions != null ? !this.restrictions.equals(that.restrictions) : that.restrictions != null) return false;
                if (this.serviceRole != null ? !this.serviceRole.equals(that.serviceRole) : that.serviceRole != null) return false;
                return this.timeoutInMins != null ? this.timeoutInMins.equals(that.timeoutInMins) : that.timeoutInMins == null;
            }

            @Override
            public int hashCode() {
                int result = this.combineArtifacts != null ? this.combineArtifacts.hashCode() : 0;
                result = 31 * result + (this.restrictions != null ? this.restrictions.hashCode() : 0);
                result = 31 * result + (this.serviceRole != null ? this.serviceRole.hashCode() : 0);
                result = 31 * result + (this.timeoutInMins != null ? this.timeoutInMins.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject.ProjectCacheProperty")
    @software.amazon.jsii.Jsii.Proxy(ProjectCacheProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProjectCacheProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnProject.ProjectCacheProperty.Type`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * `CfnProject.ProjectCacheProperty.Location`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-location
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocation() {
            return null;
        }

        /**
         * `CfnProject.ProjectCacheProperty.Modes`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-modes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getModes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProjectCacheProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProjectCacheProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProjectCacheProperty> {
            private java.lang.String type;
            private java.lang.String location;
            private java.util.List<java.lang.String> modes;

            /**
             * Sets the value of {@link ProjectCacheProperty#getType}
             * @param type `CfnProject.ProjectCacheProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ProjectCacheProperty#getLocation}
             * @param location `CfnProject.ProjectCacheProperty.Location`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(java.lang.String location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link ProjectCacheProperty#getModes}
             * @param modes `CfnProject.ProjectCacheProperty.Modes`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modes(java.util.List<java.lang.String> modes) {
                this.modes = modes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectCacheProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProjectCacheProperty build() {
                return new Jsii$Proxy(type, location, modes);
            }
        }

        /**
         * An implementation for {@link ProjectCacheProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectCacheProperty {
            private final java.lang.String type;
            private final java.lang.String location;
            private final java.util.List<java.lang.String> modes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.location = this.jsiiGet("location", java.lang.String.class);
                this.modes = this.jsiiGet("modes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String type, final java.lang.String location, final java.util.List<java.lang.String> modes) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(type, "type is required");
                this.location = location;
                this.modes = modes;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.String getLocation() {
                return this.location;
            }

            @Override
            public java.util.List<java.lang.String> getModes() {
                return this.modes;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getLocation() != null) {
                    data.set("location", om.valueToTree(this.getLocation()));
                }
                if (this.getModes() != null) {
                    data.set("modes", om.valueToTree(this.getModes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnProject.ProjectCacheProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProjectCacheProperty.Jsii$Proxy that = (ProjectCacheProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.location != null ? !this.location.equals(that.location) : that.location != null) return false;
                return this.modes != null ? this.modes.equals(that.modes) : that.modes == null;
            }

            @Override
            public int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
                result = 31 * result + (this.modes != null ? this.modes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject.ProjectFileSystemLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(ProjectFileSystemLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProjectFileSystemLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnProject.ProjectFileSystemLocationProperty.Identifier`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html#cfn-codebuild-project-projectfilesystemlocation-identifier
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIdentifier();

        /**
         * `CfnProject.ProjectFileSystemLocationProperty.Location`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html#cfn-codebuild-project-projectfilesystemlocation-location
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocation();

        /**
         * `CfnProject.ProjectFileSystemLocationProperty.MountPoint`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html#cfn-codebuild-project-projectfilesystemlocation-mountpoint
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMountPoint();

        /**
         * `CfnProject.ProjectFileSystemLocationProperty.Type`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html#cfn-codebuild-project-projectfilesystemlocation-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * `CfnProject.ProjectFileSystemLocationProperty.MountOptions`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html#cfn-codebuild-project-projectfilesystemlocation-mountoptions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMountOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProjectFileSystemLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProjectFileSystemLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProjectFileSystemLocationProperty> {
            private java.lang.String identifier;
            private java.lang.String location;
            private java.lang.String mountPoint;
            private java.lang.String type;
            private java.lang.String mountOptions;

            /**
             * Sets the value of {@link ProjectFileSystemLocationProperty#getIdentifier}
             * @param identifier `CfnProject.ProjectFileSystemLocationProperty.Identifier`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identifier(java.lang.String identifier) {
                this.identifier = identifier;
                return this;
            }

            /**
             * Sets the value of {@link ProjectFileSystemLocationProperty#getLocation}
             * @param location `CfnProject.ProjectFileSystemLocationProperty.Location`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(java.lang.String location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link ProjectFileSystemLocationProperty#getMountPoint}
             * @param mountPoint `CfnProject.ProjectFileSystemLocationProperty.MountPoint`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPoint(java.lang.String mountPoint) {
                this.mountPoint = mountPoint;
                return this;
            }

            /**
             * Sets the value of {@link ProjectFileSystemLocationProperty#getType}
             * @param type `CfnProject.ProjectFileSystemLocationProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ProjectFileSystemLocationProperty#getMountOptions}
             * @param mountOptions `CfnProject.ProjectFileSystemLocationProperty.MountOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountOptions(java.lang.String mountOptions) {
                this.mountOptions = mountOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectFileSystemLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProjectFileSystemLocationProperty build() {
                return new Jsii$Proxy(identifier, location, mountPoint, type, mountOptions);
            }
        }

        /**
         * An implementation for {@link ProjectFileSystemLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectFileSystemLocationProperty {
            private final java.lang.String identifier;
            private final java.lang.String location;
            private final java.lang.String mountPoint;
            private final java.lang.String type;
            private final java.lang.String mountOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.identifier = this.jsiiGet("identifier", java.lang.String.class);
                this.location = this.jsiiGet("location", java.lang.String.class);
                this.mountPoint = this.jsiiGet("mountPoint", java.lang.String.class);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.mountOptions = this.jsiiGet("mountOptions", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String identifier, final java.lang.String location, final java.lang.String mountPoint, final java.lang.String type, final java.lang.String mountOptions) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.identifier = java.util.Objects.requireNonNull(identifier, "identifier is required");
                this.location = java.util.Objects.requireNonNull(location, "location is required");
                this.mountPoint = java.util.Objects.requireNonNull(mountPoint, "mountPoint is required");
                this.type = java.util.Objects.requireNonNull(type, "type is required");
                this.mountOptions = mountOptions;
            }

            @Override
            public java.lang.String getIdentifier() {
                return this.identifier;
            }

            @Override
            public java.lang.String getLocation() {
                return this.location;
            }

            @Override
            public java.lang.String getMountPoint() {
                return this.mountPoint;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.String getMountOptions() {
                return this.mountOptions;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("identifier", om.valueToTree(this.getIdentifier()));
                data.set("location", om.valueToTree(this.getLocation()));
                data.set("mountPoint", om.valueToTree(this.getMountPoint()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getMountOptions() != null) {
                    data.set("mountOptions", om.valueToTree(this.getMountOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnProject.ProjectFileSystemLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProjectFileSystemLocationProperty.Jsii$Proxy that = (ProjectFileSystemLocationProperty.Jsii$Proxy) o;

                if (!identifier.equals(that.identifier)) return false;
                if (!location.equals(that.location)) return false;
                if (!mountPoint.equals(that.mountPoint)) return false;
                if (!type.equals(that.type)) return false;
                return this.mountOptions != null ? this.mountOptions.equals(that.mountOptions) : that.mountOptions == null;
            }

            @Override
            public int hashCode() {
                int result = this.identifier.hashCode();
                result = 31 * result + (this.location.hashCode());
                result = 31 * result + (this.mountPoint.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.mountOptions != null ? this.mountOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectsourceversion.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject.ProjectSourceVersionProperty")
    @software.amazon.jsii.Jsii.Proxy(ProjectSourceVersionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProjectSourceVersionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnProject.ProjectSourceVersionProperty.SourceIdentifier`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectsourceversion.html#cfn-codebuild-project-projectsourceversion-sourceidentifier
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourceIdentifier();

        /**
         * `CfnProject.ProjectSourceVersionProperty.SourceVersion`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectsourceversion.html#cfn-codebuild-project-projectsourceversion-sourceversion
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProjectSourceVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProjectSourceVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProjectSourceVersionProperty> {
            private java.lang.String sourceIdentifier;
            private java.lang.String sourceVersion;

            /**
             * Sets the value of {@link ProjectSourceVersionProperty#getSourceIdentifier}
             * @param sourceIdentifier `CfnProject.ProjectSourceVersionProperty.SourceIdentifier`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceIdentifier(java.lang.String sourceIdentifier) {
                this.sourceIdentifier = sourceIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link ProjectSourceVersionProperty#getSourceVersion}
             * @param sourceVersion `CfnProject.ProjectSourceVersionProperty.SourceVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceVersion(java.lang.String sourceVersion) {
                this.sourceVersion = sourceVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectSourceVersionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProjectSourceVersionProperty build() {
                return new Jsii$Proxy(sourceIdentifier, sourceVersion);
            }
        }

        /**
         * An implementation for {@link ProjectSourceVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectSourceVersionProperty {
            private final java.lang.String sourceIdentifier;
            private final java.lang.String sourceVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceIdentifier = this.jsiiGet("sourceIdentifier", java.lang.String.class);
                this.sourceVersion = this.jsiiGet("sourceVersion", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String sourceIdentifier, final java.lang.String sourceVersion) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceIdentifier = java.util.Objects.requireNonNull(sourceIdentifier, "sourceIdentifier is required");
                this.sourceVersion = sourceVersion;
            }

            @Override
            public java.lang.String getSourceIdentifier() {
                return this.sourceIdentifier;
            }

            @Override
            public java.lang.String getSourceVersion() {
                return this.sourceVersion;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceIdentifier", om.valueToTree(this.getSourceIdentifier()));
                if (this.getSourceVersion() != null) {
                    data.set("sourceVersion", om.valueToTree(this.getSourceVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnProject.ProjectSourceVersionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProjectSourceVersionProperty.Jsii$Proxy that = (ProjectSourceVersionProperty.Jsii$Proxy) o;

                if (!sourceIdentifier.equals(that.sourceIdentifier)) return false;
                return this.sourceVersion != null ? this.sourceVersion.equals(that.sourceVersion) : that.sourceVersion == null;
            }

            @Override
            public int hashCode() {
                int result = this.sourceIdentifier.hashCode();
                result = 31 * result + (this.sourceVersion != null ? this.sourceVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projecttriggers.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject.ProjectTriggersProperty")
    @software.amazon.jsii.Jsii.Proxy(ProjectTriggersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProjectTriggersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnProject.ProjectTriggersProperty.FilterGroups`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projecttriggers.html#cfn-codebuild-project-projecttriggers-filtergroups
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterGroups() {
            return null;
        }

        /**
         * `CfnProject.ProjectTriggersProperty.Webhook`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projecttriggers.html#cfn-codebuild-project-projecttriggers-webhook
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWebhook() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProjectTriggersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProjectTriggersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProjectTriggersProperty> {
            private java.lang.Object filterGroups;
            private java.lang.Object webhook;

            /**
             * Sets the value of {@link ProjectTriggersProperty#getFilterGroups}
             * @param filterGroups `CfnProject.ProjectTriggersProperty.FilterGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterGroups(software.amazon.awscdk.core.IResolvable filterGroups) {
                this.filterGroups = filterGroups;
                return this;
            }

            /**
             * Sets the value of {@link ProjectTriggersProperty#getFilterGroups}
             * @param filterGroups `CfnProject.ProjectTriggersProperty.FilterGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterGroups(java.util.List<java.lang.Object> filterGroups) {
                this.filterGroups = filterGroups;
                return this;
            }

            /**
             * Sets the value of {@link ProjectTriggersProperty#getWebhook}
             * @param webhook `CfnProject.ProjectTriggersProperty.Webhook`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webhook(java.lang.Boolean webhook) {
                this.webhook = webhook;
                return this;
            }

            /**
             * Sets the value of {@link ProjectTriggersProperty#getWebhook}
             * @param webhook `CfnProject.ProjectTriggersProperty.Webhook`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webhook(software.amazon.awscdk.core.IResolvable webhook) {
                this.webhook = webhook;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectTriggersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProjectTriggersProperty build() {
                return new Jsii$Proxy(filterGroups, webhook);
            }
        }

        /**
         * An implementation for {@link ProjectTriggersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectTriggersProperty {
            private final java.lang.Object filterGroups;
            private final java.lang.Object webhook;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filterGroups = this.jsiiGet("filterGroups", java.lang.Object.class);
                this.webhook = this.jsiiGet("webhook", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object filterGroups, final java.lang.Object webhook) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filterGroups = filterGroups;
                this.webhook = webhook;
            }

            @Override
            public java.lang.Object getFilterGroups() {
                return this.filterGroups;
            }

            @Override
            public java.lang.Object getWebhook() {
                return this.webhook;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFilterGroups() != null) {
                    data.set("filterGroups", om.valueToTree(this.getFilterGroups()));
                }
                if (this.getWebhook() != null) {
                    data.set("webhook", om.valueToTree(this.getWebhook()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnProject.ProjectTriggersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProjectTriggersProperty.Jsii$Proxy that = (ProjectTriggersProperty.Jsii$Proxy) o;

                if (this.filterGroups != null ? !this.filterGroups.equals(that.filterGroups) : that.filterGroups != null) return false;
                return this.webhook != null ? this.webhook.equals(that.webhook) : that.webhook == null;
            }

            @Override
            public int hashCode() {
                int result = this.filterGroups != null ? this.filterGroups.hashCode() : 0;
                result = 31 * result + (this.webhook != null ? this.webhook.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-registrycredential.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject.RegistryCredentialProperty")
    @software.amazon.jsii.Jsii.Proxy(RegistryCredentialProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RegistryCredentialProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnProject.RegistryCredentialProperty.Credential`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-registrycredential.html#cfn-codebuild-project-registrycredential-credential
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCredential();

        /**
         * `CfnProject.RegistryCredentialProperty.CredentialProvider`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-registrycredential.html#cfn-codebuild-project-registrycredential-credentialprovider
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCredentialProvider();

        /**
         * @return a {@link Builder} of {@link RegistryCredentialProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RegistryCredentialProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RegistryCredentialProperty> {
            private java.lang.String credential;
            private java.lang.String credentialProvider;

            /**
             * Sets the value of {@link RegistryCredentialProperty#getCredential}
             * @param credential `CfnProject.RegistryCredentialProperty.Credential`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credential(java.lang.String credential) {
                this.credential = credential;
                return this;
            }

            /**
             * Sets the value of {@link RegistryCredentialProperty#getCredentialProvider}
             * @param credentialProvider `CfnProject.RegistryCredentialProperty.CredentialProvider`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialProvider(java.lang.String credentialProvider) {
                this.credentialProvider = credentialProvider;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RegistryCredentialProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RegistryCredentialProperty build() {
                return new Jsii$Proxy(credential, credentialProvider);
            }
        }

        /**
         * An implementation for {@link RegistryCredentialProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RegistryCredentialProperty {
            private final java.lang.String credential;
            private final java.lang.String credentialProvider;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.credential = this.jsiiGet("credential", java.lang.String.class);
                this.credentialProvider = this.jsiiGet("credentialProvider", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String credential, final java.lang.String credentialProvider) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.credential = java.util.Objects.requireNonNull(credential, "credential is required");
                this.credentialProvider = java.util.Objects.requireNonNull(credentialProvider, "credentialProvider is required");
            }

            @Override
            public java.lang.String getCredential() {
                return this.credential;
            }

            @Override
            public java.lang.String getCredentialProvider() {
                return this.credentialProvider;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("credential", om.valueToTree(this.getCredential()));
                data.set("credentialProvider", om.valueToTree(this.getCredentialProvider()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnProject.RegistryCredentialProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RegistryCredentialProperty.Jsii$Proxy that = (RegistryCredentialProperty.Jsii$Proxy) o;

                if (!credential.equals(that.credential)) return false;
                return this.credentialProvider.equals(that.credentialProvider);
            }

            @Override
            public int hashCode() {
                int result = this.credential.hashCode();
                result = 31 * result + (this.credentialProvider.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject.S3LogsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LogsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LogsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnProject.S3LogsConfigProperty.Status`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-status
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * `CfnProject.S3LogsConfigProperty.EncryptionDisabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-encryptiondisabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionDisabled() {
            return null;
        }

        /**
         * `CfnProject.S3LogsConfigProperty.Location`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-location
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3LogsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LogsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LogsConfigProperty> {
            private java.lang.String status;
            private java.lang.Object encryptionDisabled;
            private java.lang.String location;

            /**
             * Sets the value of {@link S3LogsConfigProperty#getStatus}
             * @param status `CfnProject.S3LogsConfigProperty.Status`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link S3LogsConfigProperty#getEncryptionDisabled}
             * @param encryptionDisabled `CfnProject.S3LogsConfigProperty.EncryptionDisabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionDisabled(java.lang.Boolean encryptionDisabled) {
                this.encryptionDisabled = encryptionDisabled;
                return this;
            }

            /**
             * Sets the value of {@link S3LogsConfigProperty#getEncryptionDisabled}
             * @param encryptionDisabled `CfnProject.S3LogsConfigProperty.EncryptionDisabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionDisabled(software.amazon.awscdk.core.IResolvable encryptionDisabled) {
                this.encryptionDisabled = encryptionDisabled;
                return this;
            }

            /**
             * Sets the value of {@link S3LogsConfigProperty#getLocation}
             * @param location `CfnProject.S3LogsConfigProperty.Location`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(java.lang.String location) {
                this.location = location;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LogsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LogsConfigProperty build() {
                return new Jsii$Proxy(status, encryptionDisabled, location);
            }
        }

        /**
         * An implementation for {@link S3LogsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LogsConfigProperty {
            private final java.lang.String status;
            private final java.lang.Object encryptionDisabled;
            private final java.lang.String location;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = this.jsiiGet("status", java.lang.String.class);
                this.encryptionDisabled = this.jsiiGet("encryptionDisabled", java.lang.Object.class);
                this.location = this.jsiiGet("location", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String status, final java.lang.Object encryptionDisabled, final java.lang.String location) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(status, "status is required");
                this.encryptionDisabled = encryptionDisabled;
                this.location = location;
            }

            @Override
            public java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public java.lang.Object getEncryptionDisabled() {
                return this.encryptionDisabled;
            }

            @Override
            public java.lang.String getLocation() {
                return this.location;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));
                if (this.getEncryptionDisabled() != null) {
                    data.set("encryptionDisabled", om.valueToTree(this.getEncryptionDisabled()));
                }
                if (this.getLocation() != null) {
                    data.set("location", om.valueToTree(this.getLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnProject.S3LogsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LogsConfigProperty.Jsii$Proxy that = (S3LogsConfigProperty.Jsii$Proxy) o;

                if (!status.equals(that.status)) return false;
                if (this.encryptionDisabled != null ? !this.encryptionDisabled.equals(that.encryptionDisabled) : that.encryptionDisabled != null) return false;
                return this.location != null ? this.location.equals(that.location) : that.location == null;
            }

            @Override
            public int hashCode() {
                int result = this.status.hashCode();
                result = 31 * result + (this.encryptionDisabled != null ? this.encryptionDisabled.hashCode() : 0);
                result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject.SourceAuthProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceAuthProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceAuthProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnProject.SourceAuthProperty.Type`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html#cfn-codebuild-project-sourceauth-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * `CfnProject.SourceAuthProperty.Resource`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html#cfn-codebuild-project-sourceauth-resource
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceAuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceAuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceAuthProperty> {
            private java.lang.String type;
            private java.lang.String resource;

            /**
             * Sets the value of {@link SourceAuthProperty#getType}
             * @param type `CfnProject.SourceAuthProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SourceAuthProperty#getResource}
             * @param resource `CfnProject.SourceAuthProperty.Resource`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resource(java.lang.String resource) {
                this.resource = resource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceAuthProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceAuthProperty build() {
                return new Jsii$Proxy(type, resource);
            }
        }

        /**
         * An implementation for {@link SourceAuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceAuthProperty {
            private final java.lang.String type;
            private final java.lang.String resource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.resource = this.jsiiGet("resource", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String type, final java.lang.String resource) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(type, "type is required");
                this.resource = resource;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.String getResource() {
                return this.resource;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getResource() != null) {
                    data.set("resource", om.valueToTree(this.getResource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnProject.SourceAuthProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceAuthProperty.Jsii$Proxy that = (SourceAuthProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.resource != null ? this.resource.equals(that.resource) : that.resource == null;
            }

            @Override
            public int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.resource != null ? this.resource.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject.SourceProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnProject.SourceProperty.Type`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * `CfnProject.SourceProperty.Auth`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-auth
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuth() {
            return null;
        }

        /**
         * `CfnProject.SourceProperty.BuildSpec`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-buildspec
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBuildSpec() {
            return null;
        }

        /**
         * `CfnProject.SourceProperty.BuildStatusConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-buildstatusconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBuildStatusConfig() {
            return null;
        }

        /**
         * `CfnProject.SourceProperty.GitCloneDepth`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-gitclonedepth
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGitCloneDepth() {
            return null;
        }

        /**
         * `CfnProject.SourceProperty.GitSubmodulesConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-gitsubmodulesconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGitSubmodulesConfig() {
            return null;
        }

        /**
         * `CfnProject.SourceProperty.InsecureSsl`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-insecuressl
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInsecureSsl() {
            return null;
        }

        /**
         * `CfnProject.SourceProperty.Location`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-location
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocation() {
            return null;
        }

        /**
         * `CfnProject.SourceProperty.ReportBuildStatus`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-reportbuildstatus
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReportBuildStatus() {
            return null;
        }

        /**
         * `CfnProject.SourceProperty.SourceIdentifier`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-sourceidentifier
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceIdentifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceProperty> {
            private java.lang.String type;
            private java.lang.Object auth;
            private java.lang.String buildSpec;
            private java.lang.Object buildStatusConfig;
            private java.lang.Number gitCloneDepth;
            private java.lang.Object gitSubmodulesConfig;
            private java.lang.Object insecureSsl;
            private java.lang.String location;
            private java.lang.Object reportBuildStatus;
            private java.lang.String sourceIdentifier;

            /**
             * Sets the value of {@link SourceProperty#getType}
             * @param type `CfnProject.SourceProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getAuth}
             * @param auth `CfnProject.SourceProperty.Auth`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auth(software.amazon.awscdk.core.IResolvable auth) {
                this.auth = auth;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getAuth}
             * @param auth `CfnProject.SourceProperty.Auth`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auth(software.amazon.awscdk.services.codebuild.CfnProject.SourceAuthProperty auth) {
                this.auth = auth;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getBuildSpec}
             * @param buildSpec `CfnProject.SourceProperty.BuildSpec`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder buildSpec(java.lang.String buildSpec) {
                this.buildSpec = buildSpec;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getBuildStatusConfig}
             * @param buildStatusConfig `CfnProject.SourceProperty.BuildStatusConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder buildStatusConfig(software.amazon.awscdk.core.IResolvable buildStatusConfig) {
                this.buildStatusConfig = buildStatusConfig;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getBuildStatusConfig}
             * @param buildStatusConfig `CfnProject.SourceProperty.BuildStatusConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder buildStatusConfig(software.amazon.awscdk.services.codebuild.CfnProject.BuildStatusConfigProperty buildStatusConfig) {
                this.buildStatusConfig = buildStatusConfig;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getGitCloneDepth}
             * @param gitCloneDepth `CfnProject.SourceProperty.GitCloneDepth`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gitCloneDepth(java.lang.Number gitCloneDepth) {
                this.gitCloneDepth = gitCloneDepth;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getGitSubmodulesConfig}
             * @param gitSubmodulesConfig `CfnProject.SourceProperty.GitSubmodulesConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gitSubmodulesConfig(software.amazon.awscdk.core.IResolvable gitSubmodulesConfig) {
                this.gitSubmodulesConfig = gitSubmodulesConfig;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getGitSubmodulesConfig}
             * @param gitSubmodulesConfig `CfnProject.SourceProperty.GitSubmodulesConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gitSubmodulesConfig(software.amazon.awscdk.services.codebuild.CfnProject.GitSubmodulesConfigProperty gitSubmodulesConfig) {
                this.gitSubmodulesConfig = gitSubmodulesConfig;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getInsecureSsl}
             * @param insecureSsl `CfnProject.SourceProperty.InsecureSsl`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder insecureSsl(java.lang.Boolean insecureSsl) {
                this.insecureSsl = insecureSsl;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getInsecureSsl}
             * @param insecureSsl `CfnProject.SourceProperty.InsecureSsl`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder insecureSsl(software.amazon.awscdk.core.IResolvable insecureSsl) {
                this.insecureSsl = insecureSsl;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getLocation}
             * @param location `CfnProject.SourceProperty.Location`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(java.lang.String location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getReportBuildStatus}
             * @param reportBuildStatus `CfnProject.SourceProperty.ReportBuildStatus`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reportBuildStatus(java.lang.Boolean reportBuildStatus) {
                this.reportBuildStatus = reportBuildStatus;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getReportBuildStatus}
             * @param reportBuildStatus `CfnProject.SourceProperty.ReportBuildStatus`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reportBuildStatus(software.amazon.awscdk.core.IResolvable reportBuildStatus) {
                this.reportBuildStatus = reportBuildStatus;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getSourceIdentifier}
             * @param sourceIdentifier `CfnProject.SourceProperty.SourceIdentifier`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceIdentifier(java.lang.String sourceIdentifier) {
                this.sourceIdentifier = sourceIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceProperty build() {
                return new Jsii$Proxy(type, auth, buildSpec, buildStatusConfig, gitCloneDepth, gitSubmodulesConfig, insecureSsl, location, reportBuildStatus, sourceIdentifier);
            }
        }

        /**
         * An implementation for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceProperty {
            private final java.lang.String type;
            private final java.lang.Object auth;
            private final java.lang.String buildSpec;
            private final java.lang.Object buildStatusConfig;
            private final java.lang.Number gitCloneDepth;
            private final java.lang.Object gitSubmodulesConfig;
            private final java.lang.Object insecureSsl;
            private final java.lang.String location;
            private final java.lang.Object reportBuildStatus;
            private final java.lang.String sourceIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.auth = this.jsiiGet("auth", java.lang.Object.class);
                this.buildSpec = this.jsiiGet("buildSpec", java.lang.String.class);
                this.buildStatusConfig = this.jsiiGet("buildStatusConfig", java.lang.Object.class);
                this.gitCloneDepth = this.jsiiGet("gitCloneDepth", java.lang.Number.class);
                this.gitSubmodulesConfig = this.jsiiGet("gitSubmodulesConfig", java.lang.Object.class);
                this.insecureSsl = this.jsiiGet("insecureSsl", java.lang.Object.class);
                this.location = this.jsiiGet("location", java.lang.String.class);
                this.reportBuildStatus = this.jsiiGet("reportBuildStatus", java.lang.Object.class);
                this.sourceIdentifier = this.jsiiGet("sourceIdentifier", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String type, final java.lang.Object auth, final java.lang.String buildSpec, final java.lang.Object buildStatusConfig, final java.lang.Number gitCloneDepth, final java.lang.Object gitSubmodulesConfig, final java.lang.Object insecureSsl, final java.lang.String location, final java.lang.Object reportBuildStatus, final java.lang.String sourceIdentifier) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(type, "type is required");
                this.auth = auth;
                this.buildSpec = buildSpec;
                this.buildStatusConfig = buildStatusConfig;
                this.gitCloneDepth = gitCloneDepth;
                this.gitSubmodulesConfig = gitSubmodulesConfig;
                this.insecureSsl = insecureSsl;
                this.location = location;
                this.reportBuildStatus = reportBuildStatus;
                this.sourceIdentifier = sourceIdentifier;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.Object getAuth() {
                return this.auth;
            }

            @Override
            public java.lang.String getBuildSpec() {
                return this.buildSpec;
            }

            @Override
            public java.lang.Object getBuildStatusConfig() {
                return this.buildStatusConfig;
            }

            @Override
            public java.lang.Number getGitCloneDepth() {
                return this.gitCloneDepth;
            }

            @Override
            public java.lang.Object getGitSubmodulesConfig() {
                return this.gitSubmodulesConfig;
            }

            @Override
            public java.lang.Object getInsecureSsl() {
                return this.insecureSsl;
            }

            @Override
            public java.lang.String getLocation() {
                return this.location;
            }

            @Override
            public java.lang.Object getReportBuildStatus() {
                return this.reportBuildStatus;
            }

            @Override
            public java.lang.String getSourceIdentifier() {
                return this.sourceIdentifier;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getAuth() != null) {
                    data.set("auth", om.valueToTree(this.getAuth()));
                }
                if (this.getBuildSpec() != null) {
                    data.set("buildSpec", om.valueToTree(this.getBuildSpec()));
                }
                if (this.getBuildStatusConfig() != null) {
                    data.set("buildStatusConfig", om.valueToTree(this.getBuildStatusConfig()));
                }
                if (this.getGitCloneDepth() != null) {
                    data.set("gitCloneDepth", om.valueToTree(this.getGitCloneDepth()));
                }
                if (this.getGitSubmodulesConfig() != null) {
                    data.set("gitSubmodulesConfig", om.valueToTree(this.getGitSubmodulesConfig()));
                }
                if (this.getInsecureSsl() != null) {
                    data.set("insecureSsl", om.valueToTree(this.getInsecureSsl()));
                }
                if (this.getLocation() != null) {
                    data.set("location", om.valueToTree(this.getLocation()));
                }
                if (this.getReportBuildStatus() != null) {
                    data.set("reportBuildStatus", om.valueToTree(this.getReportBuildStatus()));
                }
                if (this.getSourceIdentifier() != null) {
                    data.set("sourceIdentifier", om.valueToTree(this.getSourceIdentifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnProject.SourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceProperty.Jsii$Proxy that = (SourceProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.auth != null ? !this.auth.equals(that.auth) : that.auth != null) return false;
                if (this.buildSpec != null ? !this.buildSpec.equals(that.buildSpec) : that.buildSpec != null) return false;
                if (this.buildStatusConfig != null ? !this.buildStatusConfig.equals(that.buildStatusConfig) : that.buildStatusConfig != null) return false;
                if (this.gitCloneDepth != null ? !this.gitCloneDepth.equals(that.gitCloneDepth) : that.gitCloneDepth != null) return false;
                if (this.gitSubmodulesConfig != null ? !this.gitSubmodulesConfig.equals(that.gitSubmodulesConfig) : that.gitSubmodulesConfig != null) return false;
                if (this.insecureSsl != null ? !this.insecureSsl.equals(that.insecureSsl) : that.insecureSsl != null) return false;
                if (this.location != null ? !this.location.equals(that.location) : that.location != null) return false;
                if (this.reportBuildStatus != null ? !this.reportBuildStatus.equals(that.reportBuildStatus) : that.reportBuildStatus != null) return false;
                return this.sourceIdentifier != null ? this.sourceIdentifier.equals(that.sourceIdentifier) : that.sourceIdentifier == null;
            }

            @Override
            public int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.auth != null ? this.auth.hashCode() : 0);
                result = 31 * result + (this.buildSpec != null ? this.buildSpec.hashCode() : 0);
                result = 31 * result + (this.buildStatusConfig != null ? this.buildStatusConfig.hashCode() : 0);
                result = 31 * result + (this.gitCloneDepth != null ? this.gitCloneDepth.hashCode() : 0);
                result = 31 * result + (this.gitSubmodulesConfig != null ? this.gitSubmodulesConfig.hashCode() : 0);
                result = 31 * result + (this.insecureSsl != null ? this.insecureSsl.hashCode() : 0);
                result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
                result = 31 * result + (this.reportBuildStatus != null ? this.reportBuildStatus.hashCode() : 0);
                result = 31 * result + (this.sourceIdentifier != null ? this.sourceIdentifier.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject.VpcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnProject.VpcConfigProperty.SecurityGroupIds`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-securitygroupids
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * `CfnProject.VpcConfigProperty.Subnets`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-subnets
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnets() {
            return null;
        }

        /**
         * `CfnProject.VpcConfigProperty.VpcId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-vpcid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigProperty> {
            private java.util.List<java.lang.String> securityGroupIds;
            private java.util.List<java.lang.String> subnets;
            private java.lang.String vpcId;

            /**
             * Sets the value of {@link VpcConfigProperty#getSecurityGroupIds}
             * @param securityGroupIds `CfnProject.VpcConfigProperty.SecurityGroupIds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigProperty#getSubnets}
             * @param subnets `CfnProject.VpcConfigProperty.Subnets`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigProperty#getVpcId}
             * @param vpcId `CfnProject.VpcConfigProperty.VpcId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcId(java.lang.String vpcId) {
                this.vpcId = vpcId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigProperty build() {
                return new Jsii$Proxy(securityGroupIds, subnets, vpcId);
            }
        }

        /**
         * An implementation for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnets;
            private final java.lang.String vpcId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = this.jsiiGet("securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnets = this.jsiiGet("subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.vpcId = this.jsiiGet("vpcId", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.util.List<java.lang.String> securityGroupIds, final java.util.List<java.lang.String> subnets, final java.lang.String vpcId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = securityGroupIds;
                this.subnets = subnets;
                this.vpcId = vpcId;
            }

            @Override
            public java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            public java.lang.String getVpcId() {
                return this.vpcId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }
                if (this.getSubnets() != null) {
                    data.set("subnets", om.valueToTree(this.getSubnets()));
                }
                if (this.getVpcId() != null) {
                    data.set("vpcId", om.valueToTree(this.getVpcId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnProject.VpcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigProperty.Jsii$Proxy that = (VpcConfigProperty.Jsii$Proxy) o;

                if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
                if (this.subnets != null ? !this.subnets.equals(that.subnets) : that.subnets != null) return false;
                return this.vpcId != null ? this.vpcId.equals(that.vpcId) : that.vpcId == null;
            }

            @Override
            public int hashCode() {
                int result = this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0;
                result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
                result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-webhookfilter.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnProject.WebhookFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(WebhookFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebhookFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnProject.WebhookFilterProperty.Pattern`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-webhookfilter.html#cfn-codebuild-project-webhookfilter-pattern
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPattern();

        /**
         * `CfnProject.WebhookFilterProperty.Type`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-webhookfilter.html#cfn-codebuild-project-webhookfilter-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * `CfnProject.WebhookFilterProperty.ExcludeMatchedPattern`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-webhookfilter.html#cfn-codebuild-project-webhookfilter-excludematchedpattern
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeMatchedPattern() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WebhookFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebhookFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebhookFilterProperty> {
            private java.lang.String pattern;
            private java.lang.String type;
            private java.lang.Object excludeMatchedPattern;

            /**
             * Sets the value of {@link WebhookFilterProperty#getPattern}
             * @param pattern `CfnProject.WebhookFilterProperty.Pattern`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pattern(java.lang.String pattern) {
                this.pattern = pattern;
                return this;
            }

            /**
             * Sets the value of {@link WebhookFilterProperty#getType}
             * @param type `CfnProject.WebhookFilterProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link WebhookFilterProperty#getExcludeMatchedPattern}
             * @param excludeMatchedPattern `CfnProject.WebhookFilterProperty.ExcludeMatchedPattern`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeMatchedPattern(java.lang.Boolean excludeMatchedPattern) {
                this.excludeMatchedPattern = excludeMatchedPattern;
                return this;
            }

            /**
             * Sets the value of {@link WebhookFilterProperty#getExcludeMatchedPattern}
             * @param excludeMatchedPattern `CfnProject.WebhookFilterProperty.ExcludeMatchedPattern`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeMatchedPattern(software.amazon.awscdk.core.IResolvable excludeMatchedPattern) {
                this.excludeMatchedPattern = excludeMatchedPattern;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebhookFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebhookFilterProperty build() {
                return new Jsii$Proxy(pattern, type, excludeMatchedPattern);
            }
        }

        /**
         * An implementation for {@link WebhookFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebhookFilterProperty {
            private final java.lang.String pattern;
            private final java.lang.String type;
            private final java.lang.Object excludeMatchedPattern;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pattern = this.jsiiGet("pattern", java.lang.String.class);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.excludeMatchedPattern = this.jsiiGet("excludeMatchedPattern", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String pattern, final java.lang.String type, final java.lang.Object excludeMatchedPattern) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pattern = java.util.Objects.requireNonNull(pattern, "pattern is required");
                this.type = java.util.Objects.requireNonNull(type, "type is required");
                this.excludeMatchedPattern = excludeMatchedPattern;
            }

            @Override
            public java.lang.String getPattern() {
                return this.pattern;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.Object getExcludeMatchedPattern() {
                return this.excludeMatchedPattern;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("pattern", om.valueToTree(this.getPattern()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getExcludeMatchedPattern() != null) {
                    data.set("excludeMatchedPattern", om.valueToTree(this.getExcludeMatchedPattern()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnProject.WebhookFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebhookFilterProperty.Jsii$Proxy that = (WebhookFilterProperty.Jsii$Proxy) o;

                if (!pattern.equals(that.pattern)) return false;
                if (!type.equals(that.type)) return false;
                return this.excludeMatchedPattern != null ? this.excludeMatchedPattern.equals(that.excludeMatchedPattern) : that.excludeMatchedPattern == null;
            }

            @Override
            public int hashCode() {
                int result = this.pattern.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.excludeMatchedPattern != null ? this.excludeMatchedPattern.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codebuild.CfnProject}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codebuild.CfnProject> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codebuild.CfnProjectProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codebuild.CfnProjectProps.Builder();
        }

        /**
         * `AWS::CodeBuild::Project.Artifacts`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-artifacts
         * @param artifacts `AWS::CodeBuild::Project.Artifacts`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifacts(final software.amazon.awscdk.services.codebuild.CfnProject.ArtifactsProperty artifacts) {
            this.props.artifacts(artifacts);
            return this;
        }
        /**
         * `AWS::CodeBuild::Project.Artifacts`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-artifacts
         * @param artifacts `AWS::CodeBuild::Project.Artifacts`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifacts(final software.amazon.awscdk.core.IResolvable artifacts) {
            this.props.artifacts(artifacts);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.Environment`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-environment
         * @param environment `AWS::CodeBuild::Project.Environment`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final software.amazon.awscdk.core.IResolvable environment) {
            this.props.environment(environment);
            return this;
        }
        /**
         * `AWS::CodeBuild::Project.Environment`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-environment
         * @param environment `AWS::CodeBuild::Project.Environment`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final software.amazon.awscdk.services.codebuild.CfnProject.EnvironmentProperty environment) {
            this.props.environment(environment);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.ServiceRole`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-servicerole
         * @param serviceRole `AWS::CodeBuild::Project.ServiceRole`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(final java.lang.String serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.Source`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-source
         * @param source `AWS::CodeBuild::Project.Source`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final software.amazon.awscdk.services.codebuild.CfnProject.SourceProperty source) {
            this.props.source(source);
            return this;
        }
        /**
         * `AWS::CodeBuild::Project.Source`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-source
         * @param source `AWS::CodeBuild::Project.Source`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final software.amazon.awscdk.core.IResolvable source) {
            this.props.source(source);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.BadgeEnabled`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-badgeenabled
         * @param badgeEnabled `AWS::CodeBuild::Project.BadgeEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder badgeEnabled(final java.lang.Boolean badgeEnabled) {
            this.props.badgeEnabled(badgeEnabled);
            return this;
        }
        /**
         * `AWS::CodeBuild::Project.BadgeEnabled`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-badgeenabled
         * @param badgeEnabled `AWS::CodeBuild::Project.BadgeEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder badgeEnabled(final software.amazon.awscdk.core.IResolvable badgeEnabled) {
            this.props.badgeEnabled(badgeEnabled);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.BuildBatchConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-buildbatchconfig
         * @param buildBatchConfig `AWS::CodeBuild::Project.BuildBatchConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildBatchConfig(final software.amazon.awscdk.core.IResolvable buildBatchConfig) {
            this.props.buildBatchConfig(buildBatchConfig);
            return this;
        }
        /**
         * `AWS::CodeBuild::Project.BuildBatchConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-buildbatchconfig
         * @param buildBatchConfig `AWS::CodeBuild::Project.BuildBatchConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildBatchConfig(final software.amazon.awscdk.services.codebuild.CfnProject.ProjectBuildBatchConfigProperty buildBatchConfig) {
            this.props.buildBatchConfig(buildBatchConfig);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.Cache`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-cache
         * @param cache `AWS::CodeBuild::Project.Cache`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cache(final software.amazon.awscdk.core.IResolvable cache) {
            this.props.cache(cache);
            return this;
        }
        /**
         * `AWS::CodeBuild::Project.Cache`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-cache
         * @param cache `AWS::CodeBuild::Project.Cache`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cache(final software.amazon.awscdk.services.codebuild.CfnProject.ProjectCacheProperty cache) {
            this.props.cache(cache);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.Description`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-description
         * @param description `AWS::CodeBuild::Project.Description`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.EncryptionKey`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-encryptionkey
         * @param encryptionKey `AWS::CodeBuild::Project.EncryptionKey`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(final java.lang.String encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.FileSystemLocations`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-filesystemlocations
         * @param fileSystemLocations `AWS::CodeBuild::Project.FileSystemLocations`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemLocations(final software.amazon.awscdk.core.IResolvable fileSystemLocations) {
            this.props.fileSystemLocations(fileSystemLocations);
            return this;
        }
        /**
         * `AWS::CodeBuild::Project.FileSystemLocations`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-filesystemlocations
         * @param fileSystemLocations `AWS::CodeBuild::Project.FileSystemLocations`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemLocations(final java.util.List<java.lang.Object> fileSystemLocations) {
            this.props.fileSystemLocations(fileSystemLocations);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.LogsConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-logsconfig
         * @param logsConfig `AWS::CodeBuild::Project.LogsConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logsConfig(final software.amazon.awscdk.core.IResolvable logsConfig) {
            this.props.logsConfig(logsConfig);
            return this;
        }
        /**
         * `AWS::CodeBuild::Project.LogsConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-logsconfig
         * @param logsConfig `AWS::CodeBuild::Project.LogsConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logsConfig(final software.amazon.awscdk.services.codebuild.CfnProject.LogsConfigProperty logsConfig) {
            this.props.logsConfig(logsConfig);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.Name`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-name
         * @param name `AWS::CodeBuild::Project.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.QueuedTimeoutInMinutes`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-queuedtimeoutinminutes
         * @param queuedTimeoutInMinutes `AWS::CodeBuild::Project.QueuedTimeoutInMinutes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queuedTimeoutInMinutes(final java.lang.Number queuedTimeoutInMinutes) {
            this.props.queuedTimeoutInMinutes(queuedTimeoutInMinutes);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.SecondaryArtifacts`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondaryartifacts
         * @param secondaryArtifacts `AWS::CodeBuild::Project.SecondaryArtifacts`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondaryArtifacts(final software.amazon.awscdk.core.IResolvable secondaryArtifacts) {
            this.props.secondaryArtifacts(secondaryArtifacts);
            return this;
        }
        /**
         * `AWS::CodeBuild::Project.SecondaryArtifacts`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondaryartifacts
         * @param secondaryArtifacts `AWS::CodeBuild::Project.SecondaryArtifacts`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondaryArtifacts(final java.util.List<java.lang.Object> secondaryArtifacts) {
            this.props.secondaryArtifacts(secondaryArtifacts);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.SecondarySources`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondarysources
         * @param secondarySources `AWS::CodeBuild::Project.SecondarySources`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondarySources(final software.amazon.awscdk.core.IResolvable secondarySources) {
            this.props.secondarySources(secondarySources);
            return this;
        }
        /**
         * `AWS::CodeBuild::Project.SecondarySources`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondarysources
         * @param secondarySources `AWS::CodeBuild::Project.SecondarySources`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondarySources(final java.util.List<java.lang.Object> secondarySources) {
            this.props.secondarySources(secondarySources);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.SecondarySourceVersions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondarysourceversions
         * @param secondarySourceVersions `AWS::CodeBuild::Project.SecondarySourceVersions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondarySourceVersions(final software.amazon.awscdk.core.IResolvable secondarySourceVersions) {
            this.props.secondarySourceVersions(secondarySourceVersions);
            return this;
        }
        /**
         * `AWS::CodeBuild::Project.SecondarySourceVersions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondarysourceversions
         * @param secondarySourceVersions `AWS::CodeBuild::Project.SecondarySourceVersions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondarySourceVersions(final java.util.List<java.lang.Object> secondarySourceVersions) {
            this.props.secondarySourceVersions(secondarySourceVersions);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.SourceVersion`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-sourceversion
         * @param sourceVersion `AWS::CodeBuild::Project.SourceVersion`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceVersion(final java.lang.String sourceVersion) {
            this.props.sourceVersion(sourceVersion);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-tags
         * @param tags `AWS::CodeBuild::Project.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.TimeoutInMinutes`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-timeoutinminutes
         * @param timeoutInMinutes `AWS::CodeBuild::Project.TimeoutInMinutes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeoutInMinutes(final java.lang.Number timeoutInMinutes) {
            this.props.timeoutInMinutes(timeoutInMinutes);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.Triggers`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-triggers
         * @param triggers `AWS::CodeBuild::Project.Triggers`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(final software.amazon.awscdk.core.IResolvable triggers) {
            this.props.triggers(triggers);
            return this;
        }
        /**
         * `AWS::CodeBuild::Project.Triggers`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-triggers
         * @param triggers `AWS::CodeBuild::Project.Triggers`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(final software.amazon.awscdk.services.codebuild.CfnProject.ProjectTriggersProperty triggers) {
            this.props.triggers(triggers);
            return this;
        }

        /**
         * `AWS::CodeBuild::Project.VpcConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-vpcconfig
         * @param vpcConfig `AWS::CodeBuild::Project.VpcConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.core.IResolvable vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }
        /**
         * `AWS::CodeBuild::Project.VpcConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-vpcconfig
         * @param vpcConfig `AWS::CodeBuild::Project.VpcConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.services.codebuild.CfnProject.VpcConfigProperty vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codebuild.CfnProject}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codebuild.CfnProject build() {
            return new software.amazon.awscdk.services.codebuild.CfnProject(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
