/**
 * <h2>Amazon CloudFront Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * | Features | Stability |
 * | --- | --- |
 * | CFN Resources | <img alt="Stable" src="https://img.shields.io/badge/stable-success.svg?style=for-the-badge"> |
 * | Higher level constructs for Distribution | <img alt="Experimental" src="https://img.shields.io/badge/experimental-important.svg?style=for-the-badge"> |
 * | Higher level constructs for CloudFrontWebDistribution | <img alt="Stable" src="https://img.shields.io/badge/stable-success.svg?style=for-the-badge"> |
 * <p>
 * <blockquote>
 * <p>
 * <strong>CFN Resources:</strong> All classes with the <code>Cfn</code> prefix in this module (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">CFN Resources</a>) are always stable and safe to use.
 * <p>
 * </blockquote><blockquote>
 * <p>
 * <strong>Experimental:</strong> Higher level constructs in this module that are marked as experimental are under active development. They are subject to non-backward compatible changes or removal in any future version. These are not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be announced in the release notes. This means that while you may use them, you may need to update your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote><blockquote>
 * <p>
 * <strong>Stable:</strong> Higher level constructs in this module that are marked stable will not undergo any breaking changes. They will strictly follow the <a href="https://semver.org/">Semantic Versioning</a> model.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * Amazon CloudFront is a web service that speeds up distribution of your static and dynamic web content, such as .html, .css, .js, and image files, to
 * your users. CloudFront delivers your content through a worldwide network of data centers called edge locations. When a user requests content that
 * you're serving with CloudFront, the user is routed to the edge location that provides the lowest latency, so that content is delivered with the best
 * possible performance.
 * <p>
 * <h2>Distribution API - Experimental</h2>
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * The <code>Distribution</code> API is currently being built to replace the existing <code>CloudFrontWebDistribution</code> API. The <code>Distribution</code> API is optimized for the
 * most common use cases of CloudFront distributions (e.g., single origin and behavior, few customizations) while still providing the ability for more
 * advanced use cases. The API focuses on simplicity for the common use cases, and convenience methods for creating the behaviors and origins necessary
 * for more complex use cases.
 * <p>
 * <h3>Creating a distribution</h3>
 * <p>
 * CloudFront distributions deliver your content from one or more origins; an origin is the location where you store the original version of your
 * content. Origins can be created from S3 buckets or a custom origin (HTTP server). Each distribution has a default behavior which applies to all
 * requests to that distribution, and routes requests to a primary origin. Constructs to define origins are in the <code>&#64;aws-cdk/aws-cloudfront-origins</code>
 * module.
 * <p>
 * <h4>From an S3 Bucket</h4>
 * <p>
 * An S3 bucket can be added as an origin. If the bucket is configured as a website endpoint, the distribution can use S3 redirects and S3 custom error
 * documents.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.cloudfront.*;
 * import software.amazon.awscdk.services.cloudfront.origins.*;
 * 
 * // Creates a distribution for a S3 bucket.
 * var myBucket = new Bucket(this, "myBucket");
 * new Distribution(this, "myDist", new DistributionProps()
 *         .defaultBehavior(new BehaviorOptions().origin(new S3Origin(myBucket))));
 * </pre></blockquote>
 * <p>
 * The above will treat the bucket differently based on if <code>IBucket.isWebsite</code> is set or not. If the bucket is configured as a website, the bucket is
 * treated as an HTTP origin, and the built-in S3 redirects and error pages can be used. Otherwise, the bucket is handled as a bucket origin and
 * CloudFront's redirect and error handling will be used. In the latter case, the Origin wil create an origin access identity and grant it access to the
 * underlying bucket. This can be used in conjunction with a bucket that is not public to require that your users access your content using CloudFront
 * URLs and not S3 URLs directly.
 * <p>
 * <h4>ELBv2 Load Balancer</h4>
 * <p>
 * An Elastic Load Balancing (ELB) v2 load balancer may be used as an origin. In order for a load balancer to serve as an origin, it must be publicly
 * accessible (<code>internetFacing</code> is true). Both Application and Network load balancers are supported.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * 
 * Vpc vpc = new Vpc(...);
 * // Create an application load balancer in a VPC. 'internetFacing' must be 'true'
 * // for CloudFront to access the load balancer and use it as an origin.
 * ApplicationLoadBalancer lb = new ApplicationLoadBalancer(this, "LB", new ApplicationLoadBalancerProps()
 *         .vpc(vpc)
 *         .internetFacing(true));
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(Map.of("origin", new LoadBalancerV2Origin(lb)))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>From an HTTP endpoint</h2>
 * <p>
 * Origins can also be created from any other HTTP endpoint, given the domain name, and optionally, other origin properties.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(Map.of("origin", new HttpOrigin("www.example.com")))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Domain Names and Certificates</h3>
 * <p>
 * When you create a distribution, CloudFront assigns a domain name for the distribution, for example: <code>d111111abcdef8.cloudfront.net</code>; this value can
 * be retrieved from <code>distribution.distributionDomainName</code>. CloudFront distributions use a default certificate (<code>*.cloudfront.net</code>) to support HTTPS by
 * default. If you want to use your own domain name, such as <code>www.example.com</code>, you must associate a certificate with your distribution that contains
 * your domain name, and provide one (or more) domain names from the certificate for the distribution.
 * <p>
 * The certificate must be present in the AWS Certificate Manager (ACM) service in the US East (N. Virginia) region; the certificate
 * may either be created by ACM, or created elsewhere and imported into ACM. When a certificate is used, the distribution will support HTTPS connections
 * from SNI only and a minimum protocol version of TLSv1.2_2019.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var myCertificate = DnsValidatedCertificate.Builder.create(this, "mySiteCert")
 *         .domainName("www.example.com")
 *         .hostedZone(hostedZone)
 *         .build();
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(Map.of("origin", new S3Origin(myBucket)))
 *         .domainNames(asList("www.example.com"))
 *         .certificate(myCertificate)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Multiple Behaviors &amp; Origins</h3>
 * <p>
 * Each distribution has a default behavior which applies to all requests to that distribution; additional behaviors may be specified for a
 * given URL path pattern. Behaviors allow routing with multiple origins, controlling which HTTP methods to support, whether to require users to
 * use HTTPS, and what query strings or cookies to forward to your origin, among others.
 * <p>
 * The properties of the default behavior can be adjusted as part of the distribution creation. The following example shows configuring the HTTP
 * methods and viewer protocol policy of the cache.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var myWebDistribution = Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(Map.of(
 *                 "origin", new S3Origin(myBucket),
 *                 "allowedMethods", AllowedMethods.getALLOW_ALL(),
 *                 "viewerProtocolPolicy", ViewerProtocolPolicy.getREDIRECT_TO_HTTPS()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * Additional behaviors can be specified at creation, or added after the initial creation. Each additional behavior is associated with an origin,
 * and enable customization for a specific set of resources based on a URL path pattern. For example, we can add a behavior to <code>myWebDistribution</code> to
 * override the default viewer protocol policy for all of the images.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * myWebDistribution.addBehavior("/images/*.jpg", new S3Origin(myBucket), Map.of(
 *         "viewerProtocolPolicy", ViewerProtocolPolicy.getREDIRECT_TO_HTTPS()));
 * </pre></blockquote>
 * <p>
 * These behaviors can also be specified at distribution creation time.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var bucketOrigin = new S3Origin(myBucket);
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(Map.of(
 *                 "origin", bucketOrigin,
 *                 "allowedMethods", AllowedMethods.getALLOW_ALL(),
 *                 "viewerProtocolPolicy", ViewerProtocolPolicy.getREDIRECT_TO_HTTPS()))
 *         .additionalBehaviors(Map.of(
 *                 "/images/*.jpg", Map.of(
 *                         "origin", bucketOrigin,
 *                         "viewerProtocolPolicy", ViewerProtocolPolicy.getREDIRECT_TO_HTTPS())))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Lambda&#64;Edge</h3>
 * <p>
 * Lambda&#64;Edge is an extension of AWS Lambda, a compute service that lets you execute functions that customize the content that CloudFront delivers.
 * You can author Node.js or Python functions in the US East (N. Virginia) region,
 * and then execute them in AWS locations globally that are closer to the viewer,
 * without provisioning or managing servers.
 * Lambda&#64;Edge functions are associated with a specific behavior and event type.
 * Lambda&#64;Edge can be used rewrite URLs,
 * alter responses based on headers or cookies,
 * or authorize requests based on headers or authorization tokens.
 * <p>
 * The following shows a Lambda&#64;Edge function added to the default behavior and triggered on every request:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var myFunc = new Function(...);
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(Map.of(
 *                 "origin", new S3Origin(myBucket),
 *                 "edgeLambdas", asList(Map.of(
 *                         "functionVersion", myFunc.getCurrentVersion(),
 *                         "eventType", cloudfront.LambdaEdgeEventType.getVIEWER_REQUEST()))))
 *         .build();
 * </pre></blockquote>
 * <p>
 * Lambda&#64;Edge functions can also be associated with additional behaviors,
 * either at Distribution creation time,
 * or after.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // assigning at Distribution creation
 * var myOrigin = new S3Origin(myBucket);
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(Map.of("origin", myOrigin))
 *         .additionalBehaviors(Map.of(
 *                 "images/*", Map.of(
 *                         "origin", myOrigin,
 *                         "edgeLambdas", asList(Map.of(
 *                                 "functionVersion", myFunc.getCurrentVersion(),
 *                                 "eventType", cloudfront.LambdaEdgeEventType.getORIGIN_REQUEST())))))
 *         .build();
 * 
 * // assigning after creation
 * myDistribution.addBehavior("images/*", myOrigin, Map.of(
 *         "edgeLambdas", asList(Map.of(
 *                 "functionVersion", myFunc.getCurrentVersion(),
 *                 "eventType", cloudfront.LambdaEdgeEventType.getVIEWER_RESPONSE()))));
 * </pre></blockquote>
 * <p>
 * <h3>Logging</h3>
 * <p>
 * You can configure CloudFront to create log files that contain detailed information about every user request that CloudFront receives.
 * The logs can go to either an existing bucket, or a bucket will be created for you.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // Simplest form - creates a new bucket and logs to it.
 * // Simplest form - creates a new bucket and logs to it.
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(Map.of("origin", new HttpOrigin("www.example.com")))
 *         .enableLogging(true)
 *         .build();
 * 
 * // You can optionally log to a specific bucket, configure whether cookies are logged, and give the log files a prefix.
 * // You can optionally log to a specific bucket, configure whether cookies are logged, and give the log files a prefix.
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(Map.of("origin", new HttpOrigin("www.example.com")))
 *         .enableLogging(true)// Optional, this is implied if loggingBucket is specified
 *         .loggingBucket(new Bucket(this, "LoggingBucket"))
 *         .loggingFilePrefix("distribution-access-logs/")
 *         .loggingIncludesCookies(true)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>CloudFrontWebDistribution API - Stable</h2>
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * A CloudFront construct - for setting up the AWS CDN with ease!
 * <p>
 * Example usage:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var sourceBucket = new Bucket(this, "Bucket");
 * 
 * var distribution = CloudFrontWebDistribution.Builder.create(this, "MyDistribution")
 *         .originConfigs(asList(Map.of(
 *                 "s3OriginSource", Map.of(
 *                         "s3BucketSource", sourceBucket),
 *                 "behaviors", asList(Map.of("isDefaultBehavior", true)))))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Viewer certificate</h3>
 * <p>
 * By default, CloudFront Web Distributions will answer HTTPS requests with CloudFront's default certificate, only containing the distribution <code>domainName</code> (e.g. d111111abcdef8.cloudfront.net).
 * You can customize the viewer certificate property to provide a custom certificate and/or list of domain name aliases to fit your needs.
 * <p>
 * See <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-alternate-domain-names.html">Using Alternate Domain Names and HTTPS</a> in the CloudFront User Guide.
 * <p>
 * <h4>Default certificate</h4>
 * <p>
 * You can customize the default certificate aliases. This is intended to be used in combination with CNAME records in your DNS zone.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket s3BucketSource = new Bucket(this, "Bucket");
 * 
 * CloudFrontWebDistribution distribution = new CloudFrontWebDistribution(this, "AnAmazingWebsiteProbably", new CloudFrontWebDistributionProps()
 *         .originConfigs(asList(new SourceConfiguration()
 *                 .s3OriginSource(new S3OriginConfig().s3BucketSource(s3BucketSource))
 *                 .behaviors(asList(new Behavior().isDefaultBehavior(true)))))
 *         .viewerCertificate(cloudfront.ViewerCertificate.fromCloudFrontDefaultCertificate("www.example.com")));
 * </pre></blockquote>
 * <p>
 * <h4>ACM certificate</h4>
 * <p>
 * You can change the default certificate by one stored AWS Certificate Manager, or ACM.
 * Those certificate can either be generated by AWS, or purchased by another CA imported into ACM.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/cdk/api/latest/docs/aws-certificatemanager-readme.html">the aws-certificatemanager module documentation</a> or <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing Certificates into AWS Certificate Manager</a> in the AWS Certificate Manager User Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket s3BucketSource = new Bucket(this, "Bucket");
 * 
 * Certificate certificate = new Certificate(this, "Certificate", new CertificateProps()
 *         .domainName("example.com")
 *         .subjectAlternativeNames(asList("*.example.com")));
 * 
 * CloudFrontWebDistribution distribution = new CloudFrontWebDistribution(this, "AnAmazingWebsiteProbably", new CloudFrontWebDistributionProps()
 *         .originConfigs(asList(new SourceConfiguration()
 *                 .s3OriginSource(new S3OriginConfig().s3BucketSource(s3BucketSource))
 *                 .behaviors(asList(new Behavior().isDefaultBehavior(true)))))
 *         .viewerCertificate(cloudfront.ViewerCertificate.fromAcmCertificate(certificate, new ViewerCertificateOptions()
 *                 .aliases(asList("example.com", "www.example.com"))
 *                 .securityPolicy(cloudfront.SecurityPolicyProtocol.getTLS_V1())// default
 *                 .sslMethod(cloudfront.SSLMethod.getSNI()))));
 * </pre></blockquote>
 * <p>
 * <h4>IAM certificate</h4>
 * <p>
 * You can also import a certificate into the IAM certificate store.
 * <p>
 * See <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cnames-and-https-procedures.html#cnames-and-https-uploading-certificates">Importing an SSL/TLS Certificate</a> in the CloudFront User Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Bucket s3BucketSource = new Bucket(this, "Bucket");
 * 
 * CloudFrontWebDistribution distribution = new CloudFrontWebDistribution(this, "AnAmazingWebsiteProbably", new CloudFrontWebDistributionProps()
 *         .originConfigs(asList(new SourceConfiguration()
 *                 .s3OriginSource(new S3OriginConfig().s3BucketSource(s3BucketSource))
 *                 .behaviors(asList(new Behavior().isDefaultBehavior(true)))))
 *         .viewerCertificate(cloudfront.ViewerCertificate.fromIamCertificate("certificateId", new ViewerCertificateOptions()
 *                 .aliases(asList("example.com"))
 *                 .securityPolicy(cloudfront.SecurityPolicyProtocol.getSSL_V3())// default
 *                 .sslMethod(cloudfront.SSLMethod.getSNI()))));
 * </pre></blockquote>
 * <p>
 * <h4>Restrictions</h4>
 * <p>
 * CloudFront supports adding restrictions to your distribution.
 * <p>
 * See <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/georestrictions.html">Restricting the Geographic Distribution of Your Content</a> in the CloudFront User Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * CloudFrontWebDistribution.Builder.create(stack, "MyDistribution")
 *         //...
 *         .geoRestriction(GeoRestriction.whitelist("US", "UK"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Connection behaviors between CloudFront and your origin</h3>
 * <p>
 * CloudFront provides you even more control over the connection behaviors between CloudFront and your origin. You can now configure the number of connection attempts CloudFront will make to your origin and the origin connection timeout for each attempt.
 * <p>
 * See <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts">Origin Connection Attempts</a>
 * <p>
 * See <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout">Origin Connection Timeout</a>
 * <p>
 * Example usage:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var distribution = CloudFrontWebDistribution.Builder.create(this, "MyDistribution")
 *         .originConfigs(asList(Map.of(...,
 *                 "connectionAttempts", 3,
 *                 "connectionTimeout", cdk.Duration.seconds(10))))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h4>Origin Fallback</h4>
 * <p>
 * In case the origin source is not available and answers with one of the
 * specified status code the failover origin source will be used.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * CloudFrontWebDistribution.Builder.create(stack, "ADistribution")
 *         .originConfigs(asList(Map.of(
 *                 "s3OriginSource", Map.of(
 *                         "s3BucketSource", s3.Bucket.fromBucketName(stack, "aBucket", "myoriginbucket"),
 *                         "originPath", "/",
 *                         "originHeaders", Map.of(
 *                                 "myHeader", "42")),
 *                 "failoverS3OriginSource", Map.of(
 *                         "s3BucketSource", s3.Bucket.fromBucketName(stack, "aBucketFallback", "myoriginbucketfallback"),
 *                         "originPath", "/somwhere",
 *                         "originHeaders", Map.of(
 *                                 "myHeader2", "21")),
 *                 "failoverCriteriaStatusCodes", asList(FailoverStatusCode.getINTERNAL_SERVER_ERROR()),
 *                 "behaviors", asList(Map.of(
 *                         "isDefaultBehavior", true)))))
 *         .build();
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.cloudfront;
