package software.amazon.awscdk.services.cloudfront;

/**
 * S3 origin configuration for CloudFront.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.536Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.S3OriginConfig")
@software.amazon.jsii.Jsii.Proxy(S3OriginConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface S3OriginConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The source bucket to serve content from.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getS3BucketSource();

    /**
     * The optional Origin Access Identity of the origin identity cloudfront will use when calling your s3 bucket.
     * <p>
     * Default: No Origin Access Identity which requires the S3 bucket to be public accessible
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity getOriginAccessIdentity() {
        return null;
    }

    /**
     * Any additional headers to pass to the origin.
     * <p>
     * Default: - No additional headers are passed.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getOriginHeaders() {
        return null;
    }

    /**
     * The relative path to the origin root to use for sources.
     * <p>
     * Default: /
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getOriginPath() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3OriginConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3OriginConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<S3OriginConfig> {
        private software.amazon.awscdk.services.s3.IBucket s3BucketSource;
        private software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity originAccessIdentity;
        private java.util.Map<java.lang.String, java.lang.String> originHeaders;
        private java.lang.String originPath;

        /**
         * Sets the value of {@link S3OriginConfig#getS3BucketSource}
         * @param s3BucketSource The source bucket to serve content from. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3BucketSource(software.amazon.awscdk.services.s3.IBucket s3BucketSource) {
            this.s3BucketSource = s3BucketSource;
            return this;
        }

        /**
         * Sets the value of {@link S3OriginConfig#getOriginAccessIdentity}
         * @param originAccessIdentity The optional Origin Access Identity of the origin identity cloudfront will use when calling your s3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder originAccessIdentity(software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity originAccessIdentity) {
            this.originAccessIdentity = originAccessIdentity;
            return this;
        }

        /**
         * Sets the value of {@link S3OriginConfig#getOriginHeaders}
         * @param originHeaders Any additional headers to pass to the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder originHeaders(java.util.Map<java.lang.String, java.lang.String> originHeaders) {
            this.originHeaders = originHeaders;
            return this;
        }

        /**
         * Sets the value of {@link S3OriginConfig#getOriginPath}
         * @param originPath The relative path to the origin root to use for sources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder originPath(java.lang.String originPath) {
            this.originPath = originPath;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3OriginConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public S3OriginConfig build() {
            return new Jsii$Proxy(s3BucketSource, originAccessIdentity, originHeaders, originPath);
        }
    }

    /**
     * An implementation for {@link S3OriginConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3OriginConfig {
        private final software.amazon.awscdk.services.s3.IBucket s3BucketSource;
        private final software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity originAccessIdentity;
        private final java.util.Map<java.lang.String, java.lang.String> originHeaders;
        private final java.lang.String originPath;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.s3BucketSource = this.jsiiGet("s3BucketSource", software.amazon.awscdk.services.s3.IBucket.class);
            this.originAccessIdentity = this.jsiiGet("originAccessIdentity", software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity.class);
            this.originHeaders = this.jsiiGet("originHeaders", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.originPath = this.jsiiGet("originPath", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.s3.IBucket s3BucketSource, final software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity originAccessIdentity, final java.util.Map<java.lang.String, java.lang.String> originHeaders, final java.lang.String originPath) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.s3BucketSource = java.util.Objects.requireNonNull(s3BucketSource, "s3BucketSource is required");
            this.originAccessIdentity = originAccessIdentity;
            this.originHeaders = originHeaders;
            this.originPath = originPath;
        }

        @Override
        public software.amazon.awscdk.services.s3.IBucket getS3BucketSource() {
            return this.s3BucketSource;
        }

        @Override
        public software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity getOriginAccessIdentity() {
            return this.originAccessIdentity;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getOriginHeaders() {
            return this.originHeaders;
        }

        @Override
        public java.lang.String getOriginPath() {
            return this.originPath;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("s3BucketSource", om.valueToTree(this.getS3BucketSource()));
            if (this.getOriginAccessIdentity() != null) {
                data.set("originAccessIdentity", om.valueToTree(this.getOriginAccessIdentity()));
            }
            if (this.getOriginHeaders() != null) {
                data.set("originHeaders", om.valueToTree(this.getOriginHeaders()));
            }
            if (this.getOriginPath() != null) {
                data.set("originPath", om.valueToTree(this.getOriginPath()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.S3OriginConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3OriginConfig.Jsii$Proxy that = (S3OriginConfig.Jsii$Proxy) o;

            if (!s3BucketSource.equals(that.s3BucketSource)) return false;
            if (this.originAccessIdentity != null ? !this.originAccessIdentity.equals(that.originAccessIdentity) : that.originAccessIdentity != null) return false;
            if (this.originHeaders != null ? !this.originHeaders.equals(that.originHeaders) : that.originHeaders != null) return false;
            return this.originPath != null ? this.originPath.equals(that.originPath) : that.originPath == null;
        }

        @Override
        public int hashCode() {
            int result = this.s3BucketSource.hashCode();
            result = 31 * result + (this.originAccessIdentity != null ? this.originAccessIdentity.hashCode() : 0);
            result = 31 * result + (this.originHeaders != null ? this.originHeaders.hashCode() : 0);
            result = 31 * result + (this.originPath != null ? this.originPath.hashCode() : 0);
            return result;
        }
    }
}
