package software.amazon.awscdk.services.cloudfront;

/**
 * Represents a Lambda function version and event type when using Lambda@Edge.
 * <p>
 * The type of the {&#64;link AddBehaviorOptions.edgeLambdas} property.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.533Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.EdgeLambda")
@software.amazon.jsii.Jsii.Proxy(EdgeLambda.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface EdgeLambda extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of event in response to which should the function be invoked.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType getEventType();

    /**
     * The version of the Lambda function that will be invoked.
     * <p>
     * <strong>Note</strong>: it's not possible to use the '$LATEST' function version for Lambda&#64;Edge!
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IVersion getFunctionVersion();

    /**
     * @return a {@link Builder} of {@link EdgeLambda}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EdgeLambda}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<EdgeLambda> {
        private software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType eventType;
        private software.amazon.awscdk.services.lambda.IVersion functionVersion;

        /**
         * Sets the value of {@link EdgeLambda#getEventType}
         * @param eventType The type of event in response to which should the function be invoked. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder eventType(software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType eventType) {
            this.eventType = eventType;
            return this;
        }

        /**
         * Sets the value of {@link EdgeLambda#getFunctionVersion}
         * @param functionVersion The version of the Lambda function that will be invoked. This parameter is required.
         *                        <strong>Note</strong>: it's not possible to use the '$LATEST' function version for Lambda&#64;Edge!
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder functionVersion(software.amazon.awscdk.services.lambda.IVersion functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EdgeLambda}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public EdgeLambda build() {
            return new Jsii$Proxy(eventType, functionVersion);
        }
    }

    /**
     * An implementation for {@link EdgeLambda}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EdgeLambda {
        private final software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType eventType;
        private final software.amazon.awscdk.services.lambda.IVersion functionVersion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventType = this.jsiiGet("eventType", software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType.class);
            this.functionVersion = this.jsiiGet("functionVersion", software.amazon.awscdk.services.lambda.IVersion.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType eventType, final software.amazon.awscdk.services.lambda.IVersion functionVersion) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventType = java.util.Objects.requireNonNull(eventType, "eventType is required");
            this.functionVersion = java.util.Objects.requireNonNull(functionVersion, "functionVersion is required");
        }

        @Override
        public software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType getEventType() {
            return this.eventType;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IVersion getFunctionVersion() {
            return this.functionVersion;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventType", om.valueToTree(this.getEventType()));
            data.set("functionVersion", om.valueToTree(this.getFunctionVersion()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.EdgeLambda"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EdgeLambda.Jsii$Proxy that = (EdgeLambda.Jsii$Proxy) o;

            if (!eventType.equals(that.eventType)) return false;
            return this.functionVersion.equals(that.functionVersion);
        }

        @Override
        public int hashCode() {
            int result = this.eventType.hashCode();
            result = 31 * result + (this.functionVersion.hashCode());
            return result;
        }
    }
}
