package software.amazon.awscdk.services.cloudfront;

/**
 * Controls the countries in which content is distributed.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Adding restrictions to a Cloudfront Web Distribution.
 * Bucket sourceBucket;
 * CloudFrontWebDistribution.Builder.create(this, "MyDistribution")
 *         .originConfigs(List.of(SourceConfiguration.builder()
 *                 .s3OriginSource(S3OriginConfig.builder()
 *                         .s3BucketSource(sourceBucket)
 *                         .build())
 *                 .behaviors(List.of(Behavior.builder().isDefaultBehavior(true).build()))
 *                 .build()))
 *         .geoRestriction(GeoRestriction.allowlist("US", "GB"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:32.926Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.GeoRestriction")
public class GeoRestriction extends software.amazon.jsii.JsiiObject {

    protected GeoRestriction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GeoRestriction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Allow specific countries which you want CloudFront to distribute your content.
     * <p>
     * @param locations Two-letter, uppercase country code for a country that you want to allow. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.GeoRestriction allowlist(final @org.jetbrains.annotations.NotNull java.lang.String... locations) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.GeoRestriction.class, "allowlist", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.GeoRestriction.class), java.util.Arrays.<Object>stream(locations).toArray(Object[]::new));
    }

    /**
     * (deprecated) DEPRECATED.
     * <p>
     * @deprecated use `denylist`
     * @param locations This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.GeoRestriction blacklist(final @org.jetbrains.annotations.NotNull java.lang.String... locations) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.GeoRestriction.class, "blacklist", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.GeoRestriction.class), java.util.Arrays.<Object>stream(locations).toArray(Object[]::new));
    }

    /**
     * Deny specific countries which you don't want CloudFront to distribute your content.
     * <p>
     * @param locations Two-letter, uppercase country code for a country that you want to deny. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.GeoRestriction denylist(final @org.jetbrains.annotations.NotNull java.lang.String... locations) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.GeoRestriction.class, "denylist", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.GeoRestriction.class), java.util.Arrays.<Object>stream(locations).toArray(Object[]::new));
    }

    /**
     * (deprecated) DEPRECATED.
     * <p>
     * @deprecated use `allowlist`
     * @param locations This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.GeoRestriction whitelist(final @org.jetbrains.annotations.NotNull java.lang.String... locations) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.GeoRestriction.class, "whitelist", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.GeoRestriction.class), java.util.Arrays.<Object>stream(locations).toArray(Object[]::new));
    }

    /**
     * Two-letter, uppercase country code for a country that you want to allow/deny.
     * <p>
     * Include one element for each country.
     * See ISO 3166-1-alpha-2 code on the <em>International Organization for Standardization</em> website
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getLocations() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "locations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Specifies the restriction type to impose.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRestrictionType() {
        return software.amazon.jsii.Kernel.get(this, "restrictionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
