package software.amazon.awscdk.cloudassembly.schema;

/**
 * Where in S3 a file asset needs to be published.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:24:16.912Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cloudassembly.schema.$Module.class, fqn = "@aws-cdk/cloud-assembly-schema.FileDestination")
@software.amazon.jsii.Jsii.Proxy(FileDestination.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FileDestination extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.cloudassembly.schema.AwsDestination {

    /**
     * The name of the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

    /**
     * The destination object key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getObjectKey();

    /**
     * @return a {@link Builder} of {@link FileDestination}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FileDestination}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FileDestination> {
        private java.lang.String bucketName;
        private java.lang.String objectKey;
        private java.lang.String assumeRoleArn;
        private java.lang.String assumeRoleExternalId;
        private java.lang.String region;

        /**
         * Sets the value of {@link FileDestination#getBucketName}
         * @param bucketName The name of the bucket. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(java.lang.String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        /**
         * Sets the value of {@link FileDestination#getObjectKey}
         * @param objectKey The destination object key. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectKey(java.lang.String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        /**
         * Sets the value of {@link FileDestination#getAssumeRoleArn}
         * @param assumeRoleArn The role that needs to be assumed while publishing this asset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRoleArn(java.lang.String assumeRoleArn) {
            this.assumeRoleArn = assumeRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link FileDestination#getAssumeRoleExternalId}
         * @param assumeRoleExternalId The ExternalId that needs to be supplied while assuming this role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRoleExternalId(java.lang.String assumeRoleExternalId) {
            this.assumeRoleExternalId = assumeRoleExternalId;
            return this;
        }

        /**
         * Sets the value of {@link FileDestination#getRegion}
         * @param region The region where this asset will need to be published.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FileDestination}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FileDestination build() {
            return new Jsii$Proxy(bucketName, objectKey, assumeRoleArn, assumeRoleExternalId, region);
        }
    }

    /**
     * An implementation for {@link FileDestination}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileDestination {
        private final java.lang.String bucketName;
        private final java.lang.String objectKey;
        private final java.lang.String assumeRoleArn;
        private final java.lang.String assumeRoleExternalId;
        private final java.lang.String region;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucketName = this.jsiiGet("bucketName", java.lang.String.class);
            this.objectKey = this.jsiiGet("objectKey", java.lang.String.class);
            this.assumeRoleArn = this.jsiiGet("assumeRoleArn", java.lang.String.class);
            this.assumeRoleExternalId = this.jsiiGet("assumeRoleExternalId", java.lang.String.class);
            this.region = this.jsiiGet("region", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String bucketName, final java.lang.String objectKey, final java.lang.String assumeRoleArn, final java.lang.String assumeRoleExternalId, final java.lang.String region) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucketName = java.util.Objects.requireNonNull(bucketName, "bucketName is required");
            this.objectKey = java.util.Objects.requireNonNull(objectKey, "objectKey is required");
            this.assumeRoleArn = assumeRoleArn;
            this.assumeRoleExternalId = assumeRoleExternalId;
            this.region = region;
        }

        @Override
        public java.lang.String getBucketName() {
            return this.bucketName;
        }

        @Override
        public java.lang.String getObjectKey() {
            return this.objectKey;
        }

        @Override
        public java.lang.String getAssumeRoleArn() {
            return this.assumeRoleArn;
        }

        @Override
        public java.lang.String getAssumeRoleExternalId() {
            return this.assumeRoleExternalId;
        }

        @Override
        public java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucketName", om.valueToTree(this.getBucketName()));
            data.set("objectKey", om.valueToTree(this.getObjectKey()));
            if (this.getAssumeRoleArn() != null) {
                data.set("assumeRoleArn", om.valueToTree(this.getAssumeRoleArn()));
            }
            if (this.getAssumeRoleExternalId() != null) {
                data.set("assumeRoleExternalId", om.valueToTree(this.getAssumeRoleExternalId()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cloud-assembly-schema.FileDestination"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FileDestination.Jsii$Proxy that = (FileDestination.Jsii$Proxy) o;

            if (!bucketName.equals(that.bucketName)) return false;
            if (!objectKey.equals(that.objectKey)) return false;
            if (this.assumeRoleArn != null ? !this.assumeRoleArn.equals(that.assumeRoleArn) : that.assumeRoleArn != null) return false;
            if (this.assumeRoleExternalId != null ? !this.assumeRoleExternalId.equals(that.assumeRoleExternalId) : that.assumeRoleExternalId != null) return false;
            return this.region != null ? this.region.equals(that.region) : that.region == null;
        }

        @Override
        public int hashCode() {
            int result = this.bucketName.hashCode();
            result = 31 * result + (this.objectKey.hashCode());
            result = 31 * result + (this.assumeRoleArn != null ? this.assumeRoleArn.hashCode() : 0);
            result = 31 * result + (this.assumeRoleExternalId != null ? this.assumeRoleExternalId.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            return result;
        }
    }
}
