package software.amazon.awscdk.services.batch;

/**
 * Properties of a batch job queue.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:33.613Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.JobQueueProps")
@software.amazon.jsii.Jsii.Proxy(JobQueueProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface JobQueueProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The set of compute environments mapped to a job queue and their order relative to each other.
     * <p>
     * The job scheduler uses this parameter to
     * determine which compute environment should execute a given job. Compute environments must be in the VALID state before you can associate them
     * with a job queue. You can associate up to three compute environments with a job queue.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.JobQueueComputeEnvironment> getComputeEnvironments();

    /**
     * The state of the job queue.
     * <p>
     * If set to true, it is able to accept jobs.
     * <p>
     * Default: true
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * A name for the job queue.
     * <p>
     * Up to 128 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
     * <p>
     * Default: - Cloudformation-generated name
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getJobQueueName() {
        return null;
    }

    /**
     * The priority of the job queue.
     * <p>
     * Job queues with a higher priority (or a higher integer value for the priority parameter) are evaluated first
     * when associated with the same compute environment. Priority is determined in descending order, for example, a job queue with a priority value
     * of 10 is given scheduling preference over a job queue with a priority value of 1.
     * <p>
     * Default: 1
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link JobQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JobQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<JobQueueProps> {
        private java.util.List<software.amazon.awscdk.services.batch.JobQueueComputeEnvironment> computeEnvironments;
        private java.lang.Boolean enabled;
        private java.lang.String jobQueueName;
        private java.lang.Number priority;

        /**
         * Sets the value of {@link JobQueueProps#getComputeEnvironments}
         * @param computeEnvironments The set of compute environments mapped to a job queue and their order relative to each other. This parameter is required.
         *                            The job scheduler uses this parameter to
         *                            determine which compute environment should execute a given job. Compute environments must be in the VALID state before you can associate them
         *                            with a job queue. You can associate up to three compute environments with a job queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder computeEnvironments(java.util.List<software.amazon.awscdk.services.batch.JobQueueComputeEnvironment> computeEnvironments) {
            this.computeEnvironments = computeEnvironments;
            return this;
        }

        /**
         * Sets the value of {@link JobQueueProps#getEnabled}
         * @param enabled The state of the job queue.
         *                If set to true, it is able to accept jobs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link JobQueueProps#getJobQueueName}
         * @param jobQueueName A name for the job queue.
         *                     Up to 128 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jobQueueName(java.lang.String jobQueueName) {
            this.jobQueueName = jobQueueName;
            return this;
        }

        /**
         * Sets the value of {@link JobQueueProps#getPriority}
         * @param priority The priority of the job queue.
         *                 Job queues with a higher priority (or a higher integer value for the priority parameter) are evaluated first
         *                 when associated with the same compute environment. Priority is determined in descending order, for example, a job queue with a priority value
         *                 of 10 is given scheduling preference over a job queue with a priority value of 1.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JobQueueProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public JobQueueProps build() {
            return new Jsii$Proxy(computeEnvironments, enabled, jobQueueName, priority);
        }
    }

    /**
     * An implementation for {@link JobQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobQueueProps {
        private final java.util.List<software.amazon.awscdk.services.batch.JobQueueComputeEnvironment> computeEnvironments;
        private final java.lang.Boolean enabled;
        private final java.lang.String jobQueueName;
        private final java.lang.Number priority;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.computeEnvironments = this.jsiiGet("computeEnvironments", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.JobQueueComputeEnvironment.class)));
            this.enabled = this.jsiiGet("enabled", java.lang.Boolean.class);
            this.jobQueueName = this.jsiiGet("jobQueueName", java.lang.String.class);
            this.priority = this.jsiiGet("priority", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<software.amazon.awscdk.services.batch.JobQueueComputeEnvironment> computeEnvironments, final java.lang.Boolean enabled, final java.lang.String jobQueueName, final java.lang.Number priority) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.computeEnvironments = java.util.Objects.requireNonNull(computeEnvironments, "computeEnvironments is required");
            this.enabled = enabled;
            this.jobQueueName = jobQueueName;
            this.priority = priority;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.batch.JobQueueComputeEnvironment> getComputeEnvironments() {
            return this.computeEnvironments;
        }

        @Override
        public java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public java.lang.String getJobQueueName() {
            return this.jobQueueName;
        }

        @Override
        public java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("computeEnvironments", om.valueToTree(this.getComputeEnvironments()));
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getJobQueueName() != null) {
                data.set("jobQueueName", om.valueToTree(this.getJobQueueName()));
            }
            if (this.getPriority() != null) {
                data.set("priority", om.valueToTree(this.getPriority()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.JobQueueProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JobQueueProps.Jsii$Proxy that = (JobQueueProps.Jsii$Proxy) o;

            if (!computeEnvironments.equals(that.computeEnvironments)) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.jobQueueName != null ? !this.jobQueueName.equals(that.jobQueueName) : that.jobQueueName != null) return false;
            return this.priority != null ? this.priority.equals(that.priority) : that.priority == null;
        }

        @Override
        public int hashCode() {
            int result = this.computeEnvironments.hashCode();
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.jobQueueName != null ? this.jobQueueName.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            return result;
        }
    }
}
