package software.amazon.awscdk.services.batch;

/**
 * Batch Job Definition.
 * <p>
 * Defines a batch job definition to execute a specific batch job.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:33.601Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.JobDefinition")
public class JobDefinition extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.batch.IJobDefinition {

    protected JobDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected JobDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public JobDefinition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.JobDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports an existing batch job definition by its amazon resource name.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param jobDefinitionArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IJobDefinition fromJobDefinitionArn(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String jobDefinitionArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.JobDefinition.class, "fromJobDefinitionArn", software.amazon.awscdk.services.batch.IJobDefinition.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(jobDefinitionArn, "jobDefinitionArn is required") });
    }

    /**
     * The ARN of this batch job definition.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobDefinitionArn() {
        return this.jsiiGet("jobDefinitionArn", java.lang.String.class);
    }

    /**
     * The name of the batch job definition.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobDefinitionName() {
        return this.jsiiGet("jobDefinitionName", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.JobDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.JobDefinition> {
        /**
         * EXPERIMENTAL
         * <p>
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.batch.JobDefinitionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.batch.JobDefinitionProps.Builder();
        }

        /**
         * An object with various properties specific to container-based jobs.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param container An object with various properties specific to container-based jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder container(final software.amazon.awscdk.services.batch.JobDefinitionContainer container) {
            this.props.container(container);
            return this;
        }

        /**
         * The name of the job definition.
         * <p>
         * Up to 128 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
         * <p>
         * Default: Cloudformation-generated name
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param jobDefinitionName The name of the job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jobDefinitionName(final java.lang.String jobDefinitionName) {
            this.props.jobDefinitionName(jobDefinitionName);
            return this;
        }

        /**
         * An object with various properties specific to multi-node parallel jobs.
         * <p>
         * Default: - undefined
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param nodeProps An object with various properties specific to multi-node parallel jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder nodeProps(final software.amazon.awscdk.services.batch.IMultiNodeProps nodeProps) {
            this.props.nodeProps(nodeProps);
            return this;
        }

        /**
         * When you submit a job, you can specify parameters that should replace the placeholders or override the default job definition parameters.
         * <p>
         * Parameters
         * in job submission requests take precedence over the defaults in a job definition.
         * This allows you to use the same job definition for multiple jobs that use the same
         * format, and programmatically change values in the command at submission time.
         * <p>
         * Default: - undefined
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param parameters When you submit a job, you can specify parameters that should replace the placeholders or override the default job definition parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * The number of times to move a job to the RUNNABLE status.
         * <p>
         * You may specify between 1 and
         * 10 attempts. If the value of attempts is greater than one, the job is retried on failure
         * the same number of attempts as the value.
         * <p>
         * Default: 1
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param retryAttempts The number of times to move a job to the RUNNABLE status. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * The timeout configuration for jobs that are submitted with this job definition.
         * <p>
         * You can specify
         * a timeout duration after which AWS Batch terminates your jobs if they have not finished.
         * <p>
         * Default: - undefined
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param timeout The timeout configuration for jobs that are submitted with this job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder timeout(final software.amazon.awscdk.core.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.batch.JobDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.batch.JobDefinition build() {
            return new software.amazon.awscdk.services.batch.JobDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
