package software.amazon.awscdk.services.batch;

/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:33.593Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition")
public class CfnJobDefinition extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnJobDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnJobDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.batch.CfnJobDefinition.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::Batch::JobDefinition`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnJobDefinition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.CfnJobDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Batch::JobDefinition.Parameters`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getParameters() {
        return this.jsiiGet("parameters", java.lang.Object.class);
    }

    /**
     * `AWS::Batch::JobDefinition.Parameters`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        this.jsiiSet("parameters", java.util.Objects.requireNonNull(value, "parameters is required"));
    }

    /**
     * `AWS::Batch::JobDefinition.Type`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return this.jsiiGet("type", java.lang.String.class);
    }

    /**
     * `AWS::Batch::JobDefinition.Type`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * `AWS::Batch::JobDefinition.ContainerProperties`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-containerproperties
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getContainerProperties() {
        return this.jsiiGet("containerProperties", java.lang.Object.class);
    }

    /**
     * `AWS::Batch::JobDefinition.ContainerProperties`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-containerproperties
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("containerProperties", value);
    }

    /**
     * `AWS::Batch::JobDefinition.ContainerProperties`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-containerproperties
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnJobDefinition.ContainerPropertiesProperty value) {
        this.jsiiSet("containerProperties", value);
    }

    /**
     * `AWS::Batch::JobDefinition.JobDefinitionName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-jobdefinitionname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getJobDefinitionName() {
        return this.jsiiGet("jobDefinitionName", java.lang.String.class);
    }

    /**
     * `AWS::Batch::JobDefinition.JobDefinitionName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-jobdefinitionname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobDefinitionName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("jobDefinitionName", value);
    }

    /**
     * `AWS::Batch::JobDefinition.NodeProperties`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-nodeproperties
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNodeProperties() {
        return this.jsiiGet("nodeProperties", java.lang.Object.class);
    }

    /**
     * `AWS::Batch::JobDefinition.NodeProperties`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-nodeproperties
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("nodeProperties", value);
    }

    /**
     * `AWS::Batch::JobDefinition.NodeProperties`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-nodeproperties
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnJobDefinition.NodePropertiesProperty value) {
        this.jsiiSet("nodeProperties", value);
    }

    /**
     * `AWS::Batch::JobDefinition.RetryStrategy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-retrystrategy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRetryStrategy() {
        return this.jsiiGet("retryStrategy", java.lang.Object.class);
    }

    /**
     * `AWS::Batch::JobDefinition.RetryStrategy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-retrystrategy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetryStrategy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("retryStrategy", value);
    }

    /**
     * `AWS::Batch::JobDefinition.RetryStrategy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-retrystrategy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetryStrategy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnJobDefinition.RetryStrategyProperty value) {
        this.jsiiSet("retryStrategy", value);
    }

    /**
     * `AWS::Batch::JobDefinition.Timeout`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-timeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTimeout() {
        return this.jsiiGet("timeout", java.lang.Object.class);
    }

    /**
     * `AWS::Batch::JobDefinition.Timeout`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-timeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeout(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("timeout", value);
    }

    /**
     * `AWS::Batch::JobDefinition.Timeout`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-timeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeout(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnJobDefinition.TimeoutProperty value) {
        this.jsiiSet("timeout", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.ContainerPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Image`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-image
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImage();

        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Command`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-command
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return null;
        }

        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Environment`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-environment
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
            return null;
        }

        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.InstanceType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-instancetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.JobRoleArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-jobrolearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getJobRoleArn() {
            return null;
        }

        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.LinuxParameters`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-linuxparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLinuxParameters() {
            return null;
        }

        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Memory`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-memory
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMemory() {
            return null;
        }

        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.MountPoints`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-mountpoints
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMountPoints() {
            return null;
        }

        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Privileged`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-privileged
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrivileged() {
            return null;
        }

        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.ReadonlyRootFilesystem`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-readonlyrootfilesystem
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadonlyRootFilesystem() {
            return null;
        }

        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.ResourceRequirements`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-resourcerequirements
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceRequirements() {
            return null;
        }

        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Ulimits`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-ulimits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUlimits() {
            return null;
        }

        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.User`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-user
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUser() {
            return null;
        }

        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Vcpus`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-vcpus
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVcpus() {
            return null;
        }

        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Volumes`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-volumes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVolumes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContainerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerPropertiesProperty> {
            private java.lang.String image;
            private java.util.List<java.lang.String> command;
            private java.lang.Object environment;
            private java.lang.String instanceType;
            private java.lang.String jobRoleArn;
            private java.lang.Object linuxParameters;
            private java.lang.Number memory;
            private java.lang.Object mountPoints;
            private java.lang.Object privileged;
            private java.lang.Object readonlyRootFilesystem;
            private java.lang.Object resourceRequirements;
            private java.lang.Object ulimits;
            private java.lang.String user;
            private java.lang.Number vcpus;
            private java.lang.Object volumes;

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getImage}
             * @param image `CfnJobDefinition.ContainerPropertiesProperty.Image`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder image(java.lang.String image) {
                this.image = image;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getCommand}
             * @param command `CfnJobDefinition.ContainerPropertiesProperty.Command`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder command(java.util.List<java.lang.String> command) {
                this.command = command;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getEnvironment}
             * @param environment `CfnJobDefinition.ContainerPropertiesProperty.Environment`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.core.IResolvable environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getEnvironment}
             * @param environment `CfnJobDefinition.ContainerPropertiesProperty.Environment`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(java.util.List<java.lang.Object> environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getInstanceType}
             * @param instanceType `CfnJobDefinition.ContainerPropertiesProperty.InstanceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getJobRoleArn}
             * @param jobRoleArn `CfnJobDefinition.ContainerPropertiesProperty.JobRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jobRoleArn(java.lang.String jobRoleArn) {
                this.jobRoleArn = jobRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getLinuxParameters}
             * @param linuxParameters `CfnJobDefinition.ContainerPropertiesProperty.LinuxParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linuxParameters(software.amazon.awscdk.core.IResolvable linuxParameters) {
                this.linuxParameters = linuxParameters;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getLinuxParameters}
             * @param linuxParameters `CfnJobDefinition.ContainerPropertiesProperty.LinuxParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linuxParameters(software.amazon.awscdk.services.batch.CfnJobDefinition.LinuxParametersProperty linuxParameters) {
                this.linuxParameters = linuxParameters;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getMemory}
             * @param memory `CfnJobDefinition.ContainerPropertiesProperty.Memory`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memory(java.lang.Number memory) {
                this.memory = memory;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getMountPoints}
             * @param mountPoints `CfnJobDefinition.ContainerPropertiesProperty.MountPoints`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPoints(software.amazon.awscdk.core.IResolvable mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getMountPoints}
             * @param mountPoints `CfnJobDefinition.ContainerPropertiesProperty.MountPoints`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPoints(java.util.List<java.lang.Object> mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getPrivileged}
             * @param privileged `CfnJobDefinition.ContainerPropertiesProperty.Privileged`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privileged(java.lang.Boolean privileged) {
                this.privileged = privileged;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getPrivileged}
             * @param privileged `CfnJobDefinition.ContainerPropertiesProperty.Privileged`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privileged(software.amazon.awscdk.core.IResolvable privileged) {
                this.privileged = privileged;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getReadonlyRootFilesystem}
             * @param readonlyRootFilesystem `CfnJobDefinition.ContainerPropertiesProperty.ReadonlyRootFilesystem`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readonlyRootFilesystem(java.lang.Boolean readonlyRootFilesystem) {
                this.readonlyRootFilesystem = readonlyRootFilesystem;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getReadonlyRootFilesystem}
             * @param readonlyRootFilesystem `CfnJobDefinition.ContainerPropertiesProperty.ReadonlyRootFilesystem`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readonlyRootFilesystem(software.amazon.awscdk.core.IResolvable readonlyRootFilesystem) {
                this.readonlyRootFilesystem = readonlyRootFilesystem;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getResourceRequirements}
             * @param resourceRequirements `CfnJobDefinition.ContainerPropertiesProperty.ResourceRequirements`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceRequirements(software.amazon.awscdk.core.IResolvable resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getResourceRequirements}
             * @param resourceRequirements `CfnJobDefinition.ContainerPropertiesProperty.ResourceRequirements`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceRequirements(java.util.List<java.lang.Object> resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getUlimits}
             * @param ulimits `CfnJobDefinition.ContainerPropertiesProperty.Ulimits`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ulimits(software.amazon.awscdk.core.IResolvable ulimits) {
                this.ulimits = ulimits;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getUlimits}
             * @param ulimits `CfnJobDefinition.ContainerPropertiesProperty.Ulimits`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ulimits(java.util.List<java.lang.Object> ulimits) {
                this.ulimits = ulimits;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getUser}
             * @param user `CfnJobDefinition.ContainerPropertiesProperty.User`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder user(java.lang.String user) {
                this.user = user;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getVcpus}
             * @param vcpus `CfnJobDefinition.ContainerPropertiesProperty.Vcpus`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vcpus(java.lang.Number vcpus) {
                this.vcpus = vcpus;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getVolumes}
             * @param volumes `CfnJobDefinition.ContainerPropertiesProperty.Volumes`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumes(software.amazon.awscdk.core.IResolvable volumes) {
                this.volumes = volumes;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getVolumes}
             * @param volumes `CfnJobDefinition.ContainerPropertiesProperty.Volumes`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumes(java.util.List<java.lang.Object> volumes) {
                this.volumes = volumes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerPropertiesProperty build() {
                return new Jsii$Proxy(image, command, environment, instanceType, jobRoleArn, linuxParameters, memory, mountPoints, privileged, readonlyRootFilesystem, resourceRequirements, ulimits, user, vcpus, volumes);
            }
        }

        /**
         * An implementation for {@link ContainerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerPropertiesProperty {
            private final java.lang.String image;
            private final java.util.List<java.lang.String> command;
            private final java.lang.Object environment;
            private final java.lang.String instanceType;
            private final java.lang.String jobRoleArn;
            private final java.lang.Object linuxParameters;
            private final java.lang.Number memory;
            private final java.lang.Object mountPoints;
            private final java.lang.Object privileged;
            private final java.lang.Object readonlyRootFilesystem;
            private final java.lang.Object resourceRequirements;
            private final java.lang.Object ulimits;
            private final java.lang.String user;
            private final java.lang.Number vcpus;
            private final java.lang.Object volumes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.image = this.jsiiGet("image", java.lang.String.class);
                this.command = this.jsiiGet("command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.environment = this.jsiiGet("environment", java.lang.Object.class);
                this.instanceType = this.jsiiGet("instanceType", java.lang.String.class);
                this.jobRoleArn = this.jsiiGet("jobRoleArn", java.lang.String.class);
                this.linuxParameters = this.jsiiGet("linuxParameters", java.lang.Object.class);
                this.memory = this.jsiiGet("memory", java.lang.Number.class);
                this.mountPoints = this.jsiiGet("mountPoints", java.lang.Object.class);
                this.privileged = this.jsiiGet("privileged", java.lang.Object.class);
                this.readonlyRootFilesystem = this.jsiiGet("readonlyRootFilesystem", java.lang.Object.class);
                this.resourceRequirements = this.jsiiGet("resourceRequirements", java.lang.Object.class);
                this.ulimits = this.jsiiGet("ulimits", java.lang.Object.class);
                this.user = this.jsiiGet("user", java.lang.String.class);
                this.vcpus = this.jsiiGet("vcpus", java.lang.Number.class);
                this.volumes = this.jsiiGet("volumes", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String image, final java.util.List<java.lang.String> command, final java.lang.Object environment, final java.lang.String instanceType, final java.lang.String jobRoleArn, final java.lang.Object linuxParameters, final java.lang.Number memory, final java.lang.Object mountPoints, final java.lang.Object privileged, final java.lang.Object readonlyRootFilesystem, final java.lang.Object resourceRequirements, final java.lang.Object ulimits, final java.lang.String user, final java.lang.Number vcpus, final java.lang.Object volumes) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.image = java.util.Objects.requireNonNull(image, "image is required");
                this.command = command;
                this.environment = environment;
                this.instanceType = instanceType;
                this.jobRoleArn = jobRoleArn;
                this.linuxParameters = linuxParameters;
                this.memory = memory;
                this.mountPoints = mountPoints;
                this.privileged = privileged;
                this.readonlyRootFilesystem = readonlyRootFilesystem;
                this.resourceRequirements = resourceRequirements;
                this.ulimits = ulimits;
                this.user = user;
                this.vcpus = vcpus;
                this.volumes = volumes;
            }

            @Override
            public java.lang.String getImage() {
                return this.image;
            }

            @Override
            public java.util.List<java.lang.String> getCommand() {
                return this.command;
            }

            @Override
            public java.lang.Object getEnvironment() {
                return this.environment;
            }

            @Override
            public java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public java.lang.String getJobRoleArn() {
                return this.jobRoleArn;
            }

            @Override
            public java.lang.Object getLinuxParameters() {
                return this.linuxParameters;
            }

            @Override
            public java.lang.Number getMemory() {
                return this.memory;
            }

            @Override
            public java.lang.Object getMountPoints() {
                return this.mountPoints;
            }

            @Override
            public java.lang.Object getPrivileged() {
                return this.privileged;
            }

            @Override
            public java.lang.Object getReadonlyRootFilesystem() {
                return this.readonlyRootFilesystem;
            }

            @Override
            public java.lang.Object getResourceRequirements() {
                return this.resourceRequirements;
            }

            @Override
            public java.lang.Object getUlimits() {
                return this.ulimits;
            }

            @Override
            public java.lang.String getUser() {
                return this.user;
            }

            @Override
            public java.lang.Number getVcpus() {
                return this.vcpus;
            }

            @Override
            public java.lang.Object getVolumes() {
                return this.volumes;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("image", om.valueToTree(this.getImage()));
                if (this.getCommand() != null) {
                    data.set("command", om.valueToTree(this.getCommand()));
                }
                if (this.getEnvironment() != null) {
                    data.set("environment", om.valueToTree(this.getEnvironment()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getJobRoleArn() != null) {
                    data.set("jobRoleArn", om.valueToTree(this.getJobRoleArn()));
                }
                if (this.getLinuxParameters() != null) {
                    data.set("linuxParameters", om.valueToTree(this.getLinuxParameters()));
                }
                if (this.getMemory() != null) {
                    data.set("memory", om.valueToTree(this.getMemory()));
                }
                if (this.getMountPoints() != null) {
                    data.set("mountPoints", om.valueToTree(this.getMountPoints()));
                }
                if (this.getPrivileged() != null) {
                    data.set("privileged", om.valueToTree(this.getPrivileged()));
                }
                if (this.getReadonlyRootFilesystem() != null) {
                    data.set("readonlyRootFilesystem", om.valueToTree(this.getReadonlyRootFilesystem()));
                }
                if (this.getResourceRequirements() != null) {
                    data.set("resourceRequirements", om.valueToTree(this.getResourceRequirements()));
                }
                if (this.getUlimits() != null) {
                    data.set("ulimits", om.valueToTree(this.getUlimits()));
                }
                if (this.getUser() != null) {
                    data.set("user", om.valueToTree(this.getUser()));
                }
                if (this.getVcpus() != null) {
                    data.set("vcpus", om.valueToTree(this.getVcpus()));
                }
                if (this.getVolumes() != null) {
                    data.set("volumes", om.valueToTree(this.getVolumes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.ContainerPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerPropertiesProperty.Jsii$Proxy that = (ContainerPropertiesProperty.Jsii$Proxy) o;

                if (!image.equals(that.image)) return false;
                if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
                if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.jobRoleArn != null ? !this.jobRoleArn.equals(that.jobRoleArn) : that.jobRoleArn != null) return false;
                if (this.linuxParameters != null ? !this.linuxParameters.equals(that.linuxParameters) : that.linuxParameters != null) return false;
                if (this.memory != null ? !this.memory.equals(that.memory) : that.memory != null) return false;
                if (this.mountPoints != null ? !this.mountPoints.equals(that.mountPoints) : that.mountPoints != null) return false;
                if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) return false;
                if (this.readonlyRootFilesystem != null ? !this.readonlyRootFilesystem.equals(that.readonlyRootFilesystem) : that.readonlyRootFilesystem != null) return false;
                if (this.resourceRequirements != null ? !this.resourceRequirements.equals(that.resourceRequirements) : that.resourceRequirements != null) return false;
                if (this.ulimits != null ? !this.ulimits.equals(that.ulimits) : that.ulimits != null) return false;
                if (this.user != null ? !this.user.equals(that.user) : that.user != null) return false;
                if (this.vcpus != null ? !this.vcpus.equals(that.vcpus) : that.vcpus != null) return false;
                return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
            }

            @Override
            public int hashCode() {
                int result = this.image.hashCode();
                result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
                result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.jobRoleArn != null ? this.jobRoleArn.hashCode() : 0);
                result = 31 * result + (this.linuxParameters != null ? this.linuxParameters.hashCode() : 0);
                result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
                result = 31 * result + (this.mountPoints != null ? this.mountPoints.hashCode() : 0);
                result = 31 * result + (this.privileged != null ? this.privileged.hashCode() : 0);
                result = 31 * result + (this.readonlyRootFilesystem != null ? this.readonlyRootFilesystem.hashCode() : 0);
                result = 31 * result + (this.resourceRequirements != null ? this.resourceRequirements.hashCode() : 0);
                result = 31 * result + (this.ulimits != null ? this.ulimits.hashCode() : 0);
                result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
                result = 31 * result + (this.vcpus != null ? this.vcpus.hashCode() : 0);
                result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.DeviceProperty")
    @software.amazon.jsii.Jsii.Proxy(DeviceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeviceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJobDefinition.DeviceProperty.ContainerPath`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html#cfn-batch-jobdefinition-device-containerpath
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerPath() {
            return null;
        }

        /**
         * `CfnJobDefinition.DeviceProperty.HostPath`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html#cfn-batch-jobdefinition-device-hostpath
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostPath() {
            return null;
        }

        /**
         * `CfnJobDefinition.DeviceProperty.Permissions`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html#cfn-batch-jobdefinition-device-permissions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPermissions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeviceProperty> {
            private java.lang.String containerPath;
            private java.lang.String hostPath;
            private java.util.List<java.lang.String> permissions;

            /**
             * Sets the value of {@link DeviceProperty#getContainerPath}
             * @param containerPath `CfnJobDefinition.DeviceProperty.ContainerPath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPath(java.lang.String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            /**
             * Sets the value of {@link DeviceProperty#getHostPath}
             * @param hostPath `CfnJobDefinition.DeviceProperty.HostPath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostPath(java.lang.String hostPath) {
                this.hostPath = hostPath;
                return this;
            }

            /**
             * Sets the value of {@link DeviceProperty#getPermissions}
             * @param permissions `CfnJobDefinition.DeviceProperty.Permissions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder permissions(java.util.List<java.lang.String> permissions) {
                this.permissions = permissions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeviceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeviceProperty build() {
                return new Jsii$Proxy(containerPath, hostPath, permissions);
            }
        }

        /**
         * An implementation for {@link DeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeviceProperty {
            private final java.lang.String containerPath;
            private final java.lang.String hostPath;
            private final java.util.List<java.lang.String> permissions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerPath = this.jsiiGet("containerPath", java.lang.String.class);
                this.hostPath = this.jsiiGet("hostPath", java.lang.String.class);
                this.permissions = this.jsiiGet("permissions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String containerPath, final java.lang.String hostPath, final java.util.List<java.lang.String> permissions) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerPath = containerPath;
                this.hostPath = hostPath;
                this.permissions = permissions;
            }

            @Override
            public java.lang.String getContainerPath() {
                return this.containerPath;
            }

            @Override
            public java.lang.String getHostPath() {
                return this.hostPath;
            }

            @Override
            public java.util.List<java.lang.String> getPermissions() {
                return this.permissions;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerPath() != null) {
                    data.set("containerPath", om.valueToTree(this.getContainerPath()));
                }
                if (this.getHostPath() != null) {
                    data.set("hostPath", om.valueToTree(this.getHostPath()));
                }
                if (this.getPermissions() != null) {
                    data.set("permissions", om.valueToTree(this.getPermissions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.DeviceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeviceProperty.Jsii$Proxy that = (DeviceProperty.Jsii$Proxy) o;

                if (this.containerPath != null ? !this.containerPath.equals(that.containerPath) : that.containerPath != null) return false;
                if (this.hostPath != null ? !this.hostPath.equals(that.hostPath) : that.hostPath != null) return false;
                return this.permissions != null ? this.permissions.equals(that.permissions) : that.permissions == null;
            }

            @Override
            public int hashCode() {
                int result = this.containerPath != null ? this.containerPath.hashCode() : 0;
                result = 31 * result + (this.hostPath != null ? this.hostPath.hashCode() : 0);
                result = 31 * result + (this.permissions != null ? this.permissions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-environment.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.EnvironmentProperty")
    @software.amazon.jsii.Jsii.Proxy(EnvironmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnvironmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJobDefinition.EnvironmentProperty.Name`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-environment.html#cfn-batch-jobdefinition-environment-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * `CfnJobDefinition.EnvironmentProperty.Value`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-environment.html#cfn-batch-jobdefinition-environment-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnvironmentProperty> {
            private java.lang.String name;
            private java.lang.String value;

            /**
             * Sets the value of {@link EnvironmentProperty#getName}
             * @param name `CfnJobDefinition.EnvironmentProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getValue}
             * @param value `CfnJobDefinition.EnvironmentProperty.Value`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnvironmentProperty build() {
                return new Jsii$Proxy(name, value);
            }
        }

        /**
         * An implementation for {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String name, final java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = name;
                this.value = value;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.String getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.EnvironmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnvironmentProperty.Jsii$Proxy that = (EnvironmentProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.LinuxParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(LinuxParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LinuxParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJobDefinition.LinuxParametersProperty.Devices`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html#cfn-batch-jobdefinition-containerproperties-linuxparameters-devices
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDevices() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LinuxParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LinuxParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LinuxParametersProperty> {
            private java.lang.Object devices;

            /**
             * Sets the value of {@link LinuxParametersProperty#getDevices}
             * @param devices `CfnJobDefinition.LinuxParametersProperty.Devices`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder devices(software.amazon.awscdk.core.IResolvable devices) {
                this.devices = devices;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getDevices}
             * @param devices `CfnJobDefinition.LinuxParametersProperty.Devices`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder devices(java.util.List<java.lang.Object> devices) {
                this.devices = devices;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LinuxParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LinuxParametersProperty build() {
                return new Jsii$Proxy(devices);
            }
        }

        /**
         * An implementation for {@link LinuxParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LinuxParametersProperty {
            private final java.lang.Object devices;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.devices = this.jsiiGet("devices", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object devices) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.devices = devices;
            }

            @Override
            public java.lang.Object getDevices() {
                return this.devices;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDevices() != null) {
                    data.set("devices", om.valueToTree(this.getDevices()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.LinuxParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LinuxParametersProperty.Jsii$Proxy that = (LinuxParametersProperty.Jsii$Proxy) o;

                return this.devices != null ? this.devices.equals(that.devices) : that.devices == null;
            }

            @Override
            public int hashCode() {
                int result = this.devices != null ? this.devices.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.MountPointsProperty")
    @software.amazon.jsii.Jsii.Proxy(MountPointsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MountPointsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJobDefinition.MountPointsProperty.ContainerPath`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html#cfn-batch-jobdefinition-mountpoints-containerpath
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerPath() {
            return null;
        }

        /**
         * `CfnJobDefinition.MountPointsProperty.ReadOnly`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html#cfn-batch-jobdefinition-mountpoints-readonly
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadOnly() {
            return null;
        }

        /**
         * `CfnJobDefinition.MountPointsProperty.SourceVolume`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html#cfn-batch-jobdefinition-mountpoints-sourcevolume
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceVolume() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MountPointsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MountPointsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MountPointsProperty> {
            private java.lang.String containerPath;
            private java.lang.Object readOnly;
            private java.lang.String sourceVolume;

            /**
             * Sets the value of {@link MountPointsProperty#getContainerPath}
             * @param containerPath `CfnJobDefinition.MountPointsProperty.ContainerPath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPath(java.lang.String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            /**
             * Sets the value of {@link MountPointsProperty#getReadOnly}
             * @param readOnly `CfnJobDefinition.MountPointsProperty.ReadOnly`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(java.lang.Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link MountPointsProperty#getReadOnly}
             * @param readOnly `CfnJobDefinition.MountPointsProperty.ReadOnly`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(software.amazon.awscdk.core.IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link MountPointsProperty#getSourceVolume}
             * @param sourceVolume `CfnJobDefinition.MountPointsProperty.SourceVolume`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceVolume(java.lang.String sourceVolume) {
                this.sourceVolume = sourceVolume;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MountPointsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MountPointsProperty build() {
                return new Jsii$Proxy(containerPath, readOnly, sourceVolume);
            }
        }

        /**
         * An implementation for {@link MountPointsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MountPointsProperty {
            private final java.lang.String containerPath;
            private final java.lang.Object readOnly;
            private final java.lang.String sourceVolume;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerPath = this.jsiiGet("containerPath", java.lang.String.class);
                this.readOnly = this.jsiiGet("readOnly", java.lang.Object.class);
                this.sourceVolume = this.jsiiGet("sourceVolume", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String containerPath, final java.lang.Object readOnly, final java.lang.String sourceVolume) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerPath = containerPath;
                this.readOnly = readOnly;
                this.sourceVolume = sourceVolume;
            }

            @Override
            public java.lang.String getContainerPath() {
                return this.containerPath;
            }

            @Override
            public java.lang.Object getReadOnly() {
                return this.readOnly;
            }

            @Override
            public java.lang.String getSourceVolume() {
                return this.sourceVolume;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerPath() != null) {
                    data.set("containerPath", om.valueToTree(this.getContainerPath()));
                }
                if (this.getReadOnly() != null) {
                    data.set("readOnly", om.valueToTree(this.getReadOnly()));
                }
                if (this.getSourceVolume() != null) {
                    data.set("sourceVolume", om.valueToTree(this.getSourceVolume()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.MountPointsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MountPointsProperty.Jsii$Proxy that = (MountPointsProperty.Jsii$Proxy) o;

                if (this.containerPath != null ? !this.containerPath.equals(that.containerPath) : that.containerPath != null) return false;
                if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) return false;
                return this.sourceVolume != null ? this.sourceVolume.equals(that.sourceVolume) : that.sourceVolume == null;
            }

            @Override
            public int hashCode() {
                int result = this.containerPath != null ? this.containerPath.hashCode() : 0;
                result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
                result = 31 * result + (this.sourceVolume != null ? this.sourceVolume.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.NodePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(NodePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NodePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJobDefinition.NodePropertiesProperty.MainNode`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html#cfn-batch-jobdefinition-nodeproperties-mainnode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMainNode();

        /**
         * `CfnJobDefinition.NodePropertiesProperty.NodeRangeProperties`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html#cfn-batch-jobdefinition-nodeproperties-noderangeproperties
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getNodeRangeProperties();

        /**
         * `CfnJobDefinition.NodePropertiesProperty.NumNodes`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html#cfn-batch-jobdefinition-nodeproperties-numnodes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getNumNodes();

        /**
         * @return a {@link Builder} of {@link NodePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NodePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NodePropertiesProperty> {
            private java.lang.Number mainNode;
            private java.lang.Object nodeRangeProperties;
            private java.lang.Number numNodes;

            /**
             * Sets the value of {@link NodePropertiesProperty#getMainNode}
             * @param mainNode `CfnJobDefinition.NodePropertiesProperty.MainNode`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mainNode(java.lang.Number mainNode) {
                this.mainNode = mainNode;
                return this;
            }

            /**
             * Sets the value of {@link NodePropertiesProperty#getNodeRangeProperties}
             * @param nodeRangeProperties `CfnJobDefinition.NodePropertiesProperty.NodeRangeProperties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodeRangeProperties(software.amazon.awscdk.core.IResolvable nodeRangeProperties) {
                this.nodeRangeProperties = nodeRangeProperties;
                return this;
            }

            /**
             * Sets the value of {@link NodePropertiesProperty#getNodeRangeProperties}
             * @param nodeRangeProperties `CfnJobDefinition.NodePropertiesProperty.NodeRangeProperties`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodeRangeProperties(java.util.List<java.lang.Object> nodeRangeProperties) {
                this.nodeRangeProperties = nodeRangeProperties;
                return this;
            }

            /**
             * Sets the value of {@link NodePropertiesProperty#getNumNodes}
             * @param numNodes `CfnJobDefinition.NodePropertiesProperty.NumNodes`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numNodes(java.lang.Number numNodes) {
                this.numNodes = numNodes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NodePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NodePropertiesProperty build() {
                return new Jsii$Proxy(mainNode, nodeRangeProperties, numNodes);
            }
        }

        /**
         * An implementation for {@link NodePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodePropertiesProperty {
            private final java.lang.Number mainNode;
            private final java.lang.Object nodeRangeProperties;
            private final java.lang.Number numNodes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mainNode = this.jsiiGet("mainNode", java.lang.Number.class);
                this.nodeRangeProperties = this.jsiiGet("nodeRangeProperties", java.lang.Object.class);
                this.numNodes = this.jsiiGet("numNodes", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number mainNode, final java.lang.Object nodeRangeProperties, final java.lang.Number numNodes) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mainNode = java.util.Objects.requireNonNull(mainNode, "mainNode is required");
                this.nodeRangeProperties = java.util.Objects.requireNonNull(nodeRangeProperties, "nodeRangeProperties is required");
                this.numNodes = java.util.Objects.requireNonNull(numNodes, "numNodes is required");
            }

            @Override
            public java.lang.Number getMainNode() {
                return this.mainNode;
            }

            @Override
            public java.lang.Object getNodeRangeProperties() {
                return this.nodeRangeProperties;
            }

            @Override
            public java.lang.Number getNumNodes() {
                return this.numNodes;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mainNode", om.valueToTree(this.getMainNode()));
                data.set("nodeRangeProperties", om.valueToTree(this.getNodeRangeProperties()));
                data.set("numNodes", om.valueToTree(this.getNumNodes()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.NodePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NodePropertiesProperty.Jsii$Proxy that = (NodePropertiesProperty.Jsii$Proxy) o;

                if (!mainNode.equals(that.mainNode)) return false;
                if (!nodeRangeProperties.equals(that.nodeRangeProperties)) return false;
                return this.numNodes.equals(that.numNodes);
            }

            @Override
            public int hashCode() {
                int result = this.mainNode.hashCode();
                result = 31 * result + (this.nodeRangeProperties.hashCode());
                result = 31 * result + (this.numNodes.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.NodeRangePropertyProperty")
    @software.amazon.jsii.Jsii.Proxy(NodeRangePropertyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NodeRangePropertyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJobDefinition.NodeRangePropertyProperty.TargetNodes`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-targetnodes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetNodes();

        /**
         * `CfnJobDefinition.NodeRangePropertyProperty.Container`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-container
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainer() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NodeRangePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NodeRangePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NodeRangePropertyProperty> {
            private java.lang.String targetNodes;
            private java.lang.Object container;

            /**
             * Sets the value of {@link NodeRangePropertyProperty#getTargetNodes}
             * @param targetNodes `CfnJobDefinition.NodeRangePropertyProperty.TargetNodes`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetNodes(java.lang.String targetNodes) {
                this.targetNodes = targetNodes;
                return this;
            }

            /**
             * Sets the value of {@link NodeRangePropertyProperty#getContainer}
             * @param container `CfnJobDefinition.NodeRangePropertyProperty.Container`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder container(software.amazon.awscdk.core.IResolvable container) {
                this.container = container;
                return this;
            }

            /**
             * Sets the value of {@link NodeRangePropertyProperty#getContainer}
             * @param container `CfnJobDefinition.NodeRangePropertyProperty.Container`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder container(software.amazon.awscdk.services.batch.CfnJobDefinition.ContainerPropertiesProperty container) {
                this.container = container;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NodeRangePropertyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NodeRangePropertyProperty build() {
                return new Jsii$Proxy(targetNodes, container);
            }
        }

        /**
         * An implementation for {@link NodeRangePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodeRangePropertyProperty {
            private final java.lang.String targetNodes;
            private final java.lang.Object container;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetNodes = this.jsiiGet("targetNodes", java.lang.String.class);
                this.container = this.jsiiGet("container", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String targetNodes, final java.lang.Object container) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetNodes = java.util.Objects.requireNonNull(targetNodes, "targetNodes is required");
                this.container = container;
            }

            @Override
            public java.lang.String getTargetNodes() {
                return this.targetNodes;
            }

            @Override
            public java.lang.Object getContainer() {
                return this.container;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetNodes", om.valueToTree(this.getTargetNodes()));
                if (this.getContainer() != null) {
                    data.set("container", om.valueToTree(this.getContainer()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.NodeRangePropertyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NodeRangePropertyProperty.Jsii$Proxy that = (NodeRangePropertyProperty.Jsii$Proxy) o;

                if (!targetNodes.equals(that.targetNodes)) return false;
                return this.container != null ? this.container.equals(that.container) : that.container == null;
            }

            @Override
            public int hashCode() {
                int result = this.targetNodes.hashCode();
                result = 31 * result + (this.container != null ? this.container.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resourcerequirement.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.ResourceRequirementProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceRequirementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceRequirementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJobDefinition.ResourceRequirementProperty.Type`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resourcerequirement.html#cfn-batch-jobdefinition-resourcerequirement-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * `CfnJobDefinition.ResourceRequirementProperty.Value`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resourcerequirement.html#cfn-batch-jobdefinition-resourcerequirement-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceRequirementProperty> {
            private java.lang.String type;
            private java.lang.String value;

            /**
             * Sets the value of {@link ResourceRequirementProperty#getType}
             * @param type `CfnJobDefinition.ResourceRequirementProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ResourceRequirementProperty#getValue}
             * @param value `CfnJobDefinition.ResourceRequirementProperty.Value`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceRequirementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceRequirementProperty build() {
                return new Jsii$Proxy(type, value);
            }
        }

        /**
         * An implementation for {@link ResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceRequirementProperty {
            private final java.lang.String type;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String type, final java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = type;
                this.value = value;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.String getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.ResourceRequirementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceRequirementProperty.Jsii$Proxy that = (ResourceRequirementProperty.Jsii$Proxy) o;

                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public int hashCode() {
                int result = this.type != null ? this.type.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-retrystrategy.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.RetryStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(RetryStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetryStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJobDefinition.RetryStrategyProperty.Attempts`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-retrystrategy.html#cfn-batch-jobdefinition-retrystrategy-attempts
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAttempts() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetryStrategyProperty> {
            private java.lang.Number attempts;

            /**
             * Sets the value of {@link RetryStrategyProperty#getAttempts}
             * @param attempts `CfnJobDefinition.RetryStrategyProperty.Attempts`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attempts(java.lang.Number attempts) {
                this.attempts = attempts;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetryStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetryStrategyProperty build() {
                return new Jsii$Proxy(attempts);
            }
        }

        /**
         * An implementation for {@link RetryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetryStrategyProperty {
            private final java.lang.Number attempts;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attempts = this.jsiiGet("attempts", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number attempts) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attempts = attempts;
            }

            @Override
            public java.lang.Number getAttempts() {
                return this.attempts;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttempts() != null) {
                    data.set("attempts", om.valueToTree(this.getAttempts()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.RetryStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetryStrategyProperty.Jsii$Proxy that = (RetryStrategyProperty.Jsii$Proxy) o;

                return this.attempts != null ? this.attempts.equals(that.attempts) : that.attempts == null;
            }

            @Override
            public int hashCode() {
                int result = this.attempts != null ? this.attempts.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-timeout.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.TimeoutProperty")
    @software.amazon.jsii.Jsii.Proxy(TimeoutProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimeoutProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJobDefinition.TimeoutProperty.AttemptDurationSeconds`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-timeout.html#cfn-batch-jobdefinition-timeout-attemptdurationseconds
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAttemptDurationSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimeoutProperty> {
            private java.lang.Number attemptDurationSeconds;

            /**
             * Sets the value of {@link TimeoutProperty#getAttemptDurationSeconds}
             * @param attemptDurationSeconds `CfnJobDefinition.TimeoutProperty.AttemptDurationSeconds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attemptDurationSeconds(java.lang.Number attemptDurationSeconds) {
                this.attemptDurationSeconds = attemptDurationSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeoutProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimeoutProperty build() {
                return new Jsii$Proxy(attemptDurationSeconds);
            }
        }

        /**
         * An implementation for {@link TimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeoutProperty {
            private final java.lang.Number attemptDurationSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attemptDurationSeconds = this.jsiiGet("attemptDurationSeconds", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number attemptDurationSeconds) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attemptDurationSeconds = attemptDurationSeconds;
            }

            @Override
            public java.lang.Number getAttemptDurationSeconds() {
                return this.attemptDurationSeconds;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttemptDurationSeconds() != null) {
                    data.set("attemptDurationSeconds", om.valueToTree(this.getAttemptDurationSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.TimeoutProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimeoutProperty.Jsii$Proxy that = (TimeoutProperty.Jsii$Proxy) o;

                return this.attemptDurationSeconds != null ? this.attemptDurationSeconds.equals(that.attemptDurationSeconds) : that.attemptDurationSeconds == null;
            }

            @Override
            public int hashCode() {
                int result = this.attemptDurationSeconds != null ? this.attemptDurationSeconds.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.UlimitProperty")
    @software.amazon.jsii.Jsii.Proxy(UlimitProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UlimitProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJobDefinition.UlimitProperty.HardLimit`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html#cfn-batch-jobdefinition-ulimit-hardlimit
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getHardLimit();

        /**
         * `CfnJobDefinition.UlimitProperty.Name`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html#cfn-batch-jobdefinition-ulimit-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnJobDefinition.UlimitProperty.SoftLimit`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html#cfn-batch-jobdefinition-ulimit-softlimit
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSoftLimit();

        /**
         * @return a {@link Builder} of {@link UlimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UlimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UlimitProperty> {
            private java.lang.Number hardLimit;
            private java.lang.String name;
            private java.lang.Number softLimit;

            /**
             * Sets the value of {@link UlimitProperty#getHardLimit}
             * @param hardLimit `CfnJobDefinition.UlimitProperty.HardLimit`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hardLimit(java.lang.Number hardLimit) {
                this.hardLimit = hardLimit;
                return this;
            }

            /**
             * Sets the value of {@link UlimitProperty#getName}
             * @param name `CfnJobDefinition.UlimitProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link UlimitProperty#getSoftLimit}
             * @param softLimit `CfnJobDefinition.UlimitProperty.SoftLimit`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder softLimit(java.lang.Number softLimit) {
                this.softLimit = softLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UlimitProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UlimitProperty build() {
                return new Jsii$Proxy(hardLimit, name, softLimit);
            }
        }

        /**
         * An implementation for {@link UlimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UlimitProperty {
            private final java.lang.Number hardLimit;
            private final java.lang.String name;
            private final java.lang.Number softLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hardLimit = this.jsiiGet("hardLimit", java.lang.Number.class);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.softLimit = this.jsiiGet("softLimit", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number hardLimit, final java.lang.String name, final java.lang.Number softLimit) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hardLimit = java.util.Objects.requireNonNull(hardLimit, "hardLimit is required");
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.softLimit = java.util.Objects.requireNonNull(softLimit, "softLimit is required");
            }

            @Override
            public java.lang.Number getHardLimit() {
                return this.hardLimit;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.Number getSoftLimit() {
                return this.softLimit;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("hardLimit", om.valueToTree(this.getHardLimit()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("softLimit", om.valueToTree(this.getSoftLimit()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.UlimitProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UlimitProperty.Jsii$Proxy that = (UlimitProperty.Jsii$Proxy) o;

                if (!hardLimit.equals(that.hardLimit)) return false;
                if (!name.equals(that.name)) return false;
                return this.softLimit.equals(that.softLimit);
            }

            @Override
            public int hashCode() {
                int result = this.hardLimit.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.softLimit.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumeshost.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.VolumesHostProperty")
    @software.amazon.jsii.Jsii.Proxy(VolumesHostProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VolumesHostProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJobDefinition.VolumesHostProperty.SourcePath`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumeshost.html#cfn-batch-jobdefinition-volumeshost-sourcepath
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourcePath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VolumesHostProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VolumesHostProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VolumesHostProperty> {
            private java.lang.String sourcePath;

            /**
             * Sets the value of {@link VolumesHostProperty#getSourcePath}
             * @param sourcePath `CfnJobDefinition.VolumesHostProperty.SourcePath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePath(java.lang.String sourcePath) {
                this.sourcePath = sourcePath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VolumesHostProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VolumesHostProperty build() {
                return new Jsii$Proxy(sourcePath);
            }
        }

        /**
         * An implementation for {@link VolumesHostProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumesHostProperty {
            private final java.lang.String sourcePath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourcePath = this.jsiiGet("sourcePath", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String sourcePath) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourcePath = sourcePath;
            }

            @Override
            public java.lang.String getSourcePath() {
                return this.sourcePath;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSourcePath() != null) {
                    data.set("sourcePath", om.valueToTree(this.getSourcePath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.VolumesHostProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VolumesHostProperty.Jsii$Proxy that = (VolumesHostProperty.Jsii$Proxy) o;

                return this.sourcePath != null ? this.sourcePath.equals(that.sourcePath) : that.sourcePath == null;
            }

            @Override
            public int hashCode() {
                int result = this.sourcePath != null ? this.sourcePath.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.VolumesProperty")
    @software.amazon.jsii.Jsii.Proxy(VolumesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VolumesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJobDefinition.VolumesProperty.Host`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html#cfn-batch-jobdefinition-volumes-host
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHost() {
            return null;
        }

        /**
         * `CfnJobDefinition.VolumesProperty.Name`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html#cfn-batch-jobdefinition-volumes-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VolumesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VolumesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VolumesProperty> {
            private java.lang.Object host;
            private java.lang.String name;

            /**
             * Sets the value of {@link VolumesProperty#getHost}
             * @param host `CfnJobDefinition.VolumesProperty.Host`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(software.amazon.awscdk.core.IResolvable host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link VolumesProperty#getHost}
             * @param host `CfnJobDefinition.VolumesProperty.Host`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(software.amazon.awscdk.services.batch.CfnJobDefinition.VolumesHostProperty host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link VolumesProperty#getName}
             * @param name `CfnJobDefinition.VolumesProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VolumesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VolumesProperty build() {
                return new Jsii$Proxy(host, name);
            }
        }

        /**
         * An implementation for {@link VolumesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumesProperty {
            private final java.lang.Object host;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.host = this.jsiiGet("host", java.lang.Object.class);
                this.name = this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object host, final java.lang.String name) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.host = host;
                this.name = name;
            }

            @Override
            public java.lang.Object getHost() {
                return this.host;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHost() != null) {
                    data.set("host", om.valueToTree(this.getHost()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.VolumesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VolumesProperty.Jsii$Proxy that = (VolumesProperty.Jsii$Proxy) o;

                if (this.host != null ? !this.host.equals(that.host) : that.host != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public int hashCode() {
                int result = this.host != null ? this.host.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.CfnJobDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.CfnJobDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.batch.CfnJobDefinitionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.batch.CfnJobDefinitionProps.Builder();
        }

        /**
         * `AWS::Batch::JobDefinition.Type`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-type
         * @param type `AWS::Batch::JobDefinition.Type`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * `AWS::Batch::JobDefinition.ContainerProperties`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-containerproperties
         * @param containerProperties `AWS::Batch::JobDefinition.ContainerProperties`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerProperties(final software.amazon.awscdk.core.IResolvable containerProperties) {
            this.props.containerProperties(containerProperties);
            return this;
        }
        /**
         * `AWS::Batch::JobDefinition.ContainerProperties`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-containerproperties
         * @param containerProperties `AWS::Batch::JobDefinition.ContainerProperties`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerProperties(final software.amazon.awscdk.services.batch.CfnJobDefinition.ContainerPropertiesProperty containerProperties) {
            this.props.containerProperties(containerProperties);
            return this;
        }

        /**
         * `AWS::Batch::JobDefinition.JobDefinitionName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-jobdefinitionname
         * @param jobDefinitionName `AWS::Batch::JobDefinition.JobDefinitionName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionName(final java.lang.String jobDefinitionName) {
            this.props.jobDefinitionName(jobDefinitionName);
            return this;
        }

        /**
         * `AWS::Batch::JobDefinition.NodeProperties`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-nodeproperties
         * @param nodeProperties `AWS::Batch::JobDefinition.NodeProperties`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeProperties(final software.amazon.awscdk.core.IResolvable nodeProperties) {
            this.props.nodeProperties(nodeProperties);
            return this;
        }
        /**
         * `AWS::Batch::JobDefinition.NodeProperties`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-nodeproperties
         * @param nodeProperties `AWS::Batch::JobDefinition.NodeProperties`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeProperties(final software.amazon.awscdk.services.batch.CfnJobDefinition.NodePropertiesProperty nodeProperties) {
            this.props.nodeProperties(nodeProperties);
            return this;
        }

        /**
         * `AWS::Batch::JobDefinition.Parameters`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-parameters
         * @param parameters `AWS::Batch::JobDefinition.Parameters`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.lang.Object parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * `AWS::Batch::JobDefinition.RetryStrategy`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-retrystrategy
         * @param retryStrategy `AWS::Batch::JobDefinition.RetryStrategy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryStrategy(final software.amazon.awscdk.core.IResolvable retryStrategy) {
            this.props.retryStrategy(retryStrategy);
            return this;
        }
        /**
         * `AWS::Batch::JobDefinition.RetryStrategy`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-retrystrategy
         * @param retryStrategy `AWS::Batch::JobDefinition.RetryStrategy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryStrategy(final software.amazon.awscdk.services.batch.CfnJobDefinition.RetryStrategyProperty retryStrategy) {
            this.props.retryStrategy(retryStrategy);
            return this;
        }

        /**
         * `AWS::Batch::JobDefinition.Timeout`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-timeout
         * @param timeout `AWS::Batch::JobDefinition.Timeout`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.core.IResolvable timeout) {
            this.props.timeout(timeout);
            return this;
        }
        /**
         * `AWS::Batch::JobDefinition.Timeout`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-timeout
         * @param timeout `AWS::Batch::JobDefinition.Timeout`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.services.batch.CfnJobDefinition.TimeoutProperty timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.batch.CfnJobDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.CfnJobDefinition build() {
            return new software.amazon.awscdk.services.batch.CfnJobDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
