package software.amazon.awscdk.services.batch;

/**
 * A CloudFormation `AWS::Batch::ComputeEnvironment`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:33.592Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnComputeEnvironment")
public class CfnComputeEnvironment extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnComputeEnvironment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnComputeEnvironment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.batch.CfnComputeEnvironment.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::Batch::ComputeEnvironment`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnComputeEnvironment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.CfnComputeEnvironmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Batch::ComputeEnvironment.ServiceRole`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-servicerole
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceRole() {
        return this.jsiiGet("serviceRole", java.lang.String.class);
    }

    /**
     * `AWS::Batch::ComputeEnvironment.ServiceRole`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-servicerole
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceRole(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("serviceRole", java.util.Objects.requireNonNull(value, "serviceRole is required"));
    }

    /**
     * `AWS::Batch::ComputeEnvironment.Type`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return this.jsiiGet("type", java.lang.String.class);
    }

    /**
     * `AWS::Batch::ComputeEnvironment.Type`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * `AWS::Batch::ComputeEnvironment.ComputeEnvironmentName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeenvironmentname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getComputeEnvironmentName() {
        return this.jsiiGet("computeEnvironmentName", java.lang.String.class);
    }

    /**
     * `AWS::Batch::ComputeEnvironment.ComputeEnvironmentName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeenvironmentname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputeEnvironmentName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("computeEnvironmentName", value);
    }

    /**
     * `AWS::Batch::ComputeEnvironment.ComputeResources`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeresources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getComputeResources() {
        return this.jsiiGet("computeResources", java.lang.Object.class);
    }

    /**
     * `AWS::Batch::ComputeEnvironment.ComputeResources`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeresources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputeResources(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("computeResources", value);
    }

    /**
     * `AWS::Batch::ComputeEnvironment.ComputeResources`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeresources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputeResources(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnComputeEnvironment.ComputeResourcesProperty value) {
        this.jsiiSet("computeResources", value);
    }

    /**
     * `AWS::Batch::ComputeEnvironment.State`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-state
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return this.jsiiGet("state", java.lang.String.class);
    }

    /**
     * `AWS::Batch::ComputeEnvironment.State`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-state
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setState(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("state", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnComputeEnvironment.ComputeResourcesProperty")
    @software.amazon.jsii.Jsii.Proxy(ComputeResourcesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComputeResourcesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.InstanceRole`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancerole
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceRole();

        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.InstanceTypes`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancetypes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getInstanceTypes();

        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.MaxvCpus`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-maxvcpus
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxvCpus();

        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.MinvCpus`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-minvcpus
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinvCpus();

        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.Subnets`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-subnets
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets();

        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.Type`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.AllocationStrategy`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-allocationstrategy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllocationStrategy() {
            return null;
        }

        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.BidPercentage`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-bidpercentage
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBidPercentage() {
            return null;
        }

        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.DesiredvCpus`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-desiredvcpus
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDesiredvCpus() {
            return null;
        }

        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.Ec2KeyPair`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEc2KeyPair() {
            return null;
        }

        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.ImageId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-imageid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImageId() {
            return null;
        }

        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.LaunchTemplate`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-launchtemplate
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLaunchTemplate() {
            return null;
        }

        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.PlacementGroup`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-placementgroup
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPlacementGroup() {
            return null;
        }

        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.SecurityGroupIds`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-securitygroupids
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.SpotIamFleetRole`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-spotiamfleetrole
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpotIamFleetRole() {
            return null;
        }

        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.Tags`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-tags
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComputeResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComputeResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComputeResourcesProperty> {
            private java.lang.String instanceRole;
            private java.util.List<java.lang.String> instanceTypes;
            private java.lang.Number maxvCpus;
            private java.lang.Number minvCpus;
            private java.util.List<java.lang.String> subnets;
            private java.lang.String type;
            private java.lang.String allocationStrategy;
            private java.lang.Number bidPercentage;
            private java.lang.Number desiredvCpus;
            private java.lang.String ec2KeyPair;
            private java.lang.String imageId;
            private java.lang.Object launchTemplate;
            private java.lang.String placementGroup;
            private java.util.List<java.lang.String> securityGroupIds;
            private java.lang.String spotIamFleetRole;
            private java.lang.Object tags;

            /**
             * Sets the value of {@link ComputeResourcesProperty#getInstanceRole}
             * @param instanceRole `CfnComputeEnvironment.ComputeResourcesProperty.InstanceRole`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceRole(java.lang.String instanceRole) {
                this.instanceRole = instanceRole;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getInstanceTypes}
             * @param instanceTypes `CfnComputeEnvironment.ComputeResourcesProperty.InstanceTypes`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceTypes(java.util.List<java.lang.String> instanceTypes) {
                this.instanceTypes = instanceTypes;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getMaxvCpus}
             * @param maxvCpus `CfnComputeEnvironment.ComputeResourcesProperty.MaxvCpus`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxvCpus(java.lang.Number maxvCpus) {
                this.maxvCpus = maxvCpus;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getMinvCpus}
             * @param minvCpus `CfnComputeEnvironment.ComputeResourcesProperty.MinvCpus`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minvCpus(java.lang.Number minvCpus) {
                this.minvCpus = minvCpus;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getSubnets}
             * @param subnets `CfnComputeEnvironment.ComputeResourcesProperty.Subnets`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getType}
             * @param type `CfnComputeEnvironment.ComputeResourcesProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getAllocationStrategy}
             * @param allocationStrategy `CfnComputeEnvironment.ComputeResourcesProperty.AllocationStrategy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allocationStrategy(java.lang.String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getBidPercentage}
             * @param bidPercentage `CfnComputeEnvironment.ComputeResourcesProperty.BidPercentage`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bidPercentage(java.lang.Number bidPercentage) {
                this.bidPercentage = bidPercentage;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getDesiredvCpus}
             * @param desiredvCpus `CfnComputeEnvironment.ComputeResourcesProperty.DesiredvCpus`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder desiredvCpus(java.lang.Number desiredvCpus) {
                this.desiredvCpus = desiredvCpus;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getEc2KeyPair}
             * @param ec2KeyPair `CfnComputeEnvironment.ComputeResourcesProperty.Ec2KeyPair`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2KeyPair(java.lang.String ec2KeyPair) {
                this.ec2KeyPair = ec2KeyPair;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getImageId}
             * @param imageId `CfnComputeEnvironment.ComputeResourcesProperty.ImageId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageId(java.lang.String imageId) {
                this.imageId = imageId;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getLaunchTemplate}
             * @param launchTemplate `CfnComputeEnvironment.ComputeResourcesProperty.LaunchTemplate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplate(software.amazon.awscdk.core.IResolvable launchTemplate) {
                this.launchTemplate = launchTemplate;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getLaunchTemplate}
             * @param launchTemplate `CfnComputeEnvironment.ComputeResourcesProperty.LaunchTemplate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplate(software.amazon.awscdk.services.batch.CfnComputeEnvironment.LaunchTemplateSpecificationProperty launchTemplate) {
                this.launchTemplate = launchTemplate;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getPlacementGroup}
             * @param placementGroup `CfnComputeEnvironment.ComputeResourcesProperty.PlacementGroup`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placementGroup(java.lang.String placementGroup) {
                this.placementGroup = placementGroup;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getSecurityGroupIds}
             * @param securityGroupIds `CfnComputeEnvironment.ComputeResourcesProperty.SecurityGroupIds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getSpotIamFleetRole}
             * @param spotIamFleetRole `CfnComputeEnvironment.ComputeResourcesProperty.SpotIamFleetRole`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotIamFleetRole(java.lang.String spotIamFleetRole) {
                this.spotIamFleetRole = spotIamFleetRole;
                return this;
            }

            /**
             * Sets the value of {@link ComputeResourcesProperty#getTags}
             * @param tags `CfnComputeEnvironment.ComputeResourcesProperty.Tags`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tags(java.lang.Object tags) {
                this.tags = tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComputeResourcesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComputeResourcesProperty build() {
                return new Jsii$Proxy(instanceRole, instanceTypes, maxvCpus, minvCpus, subnets, type, allocationStrategy, bidPercentage, desiredvCpus, ec2KeyPair, imageId, launchTemplate, placementGroup, securityGroupIds, spotIamFleetRole, tags);
            }
        }

        /**
         * An implementation for {@link ComputeResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeResourcesProperty {
            private final java.lang.String instanceRole;
            private final java.util.List<java.lang.String> instanceTypes;
            private final java.lang.Number maxvCpus;
            private final java.lang.Number minvCpus;
            private final java.util.List<java.lang.String> subnets;
            private final java.lang.String type;
            private final java.lang.String allocationStrategy;
            private final java.lang.Number bidPercentage;
            private final java.lang.Number desiredvCpus;
            private final java.lang.String ec2KeyPair;
            private final java.lang.String imageId;
            private final java.lang.Object launchTemplate;
            private final java.lang.String placementGroup;
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.lang.String spotIamFleetRole;
            private final java.lang.Object tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceRole = this.jsiiGet("instanceRole", java.lang.String.class);
                this.instanceTypes = this.jsiiGet("instanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.maxvCpus = this.jsiiGet("maxvCpus", java.lang.Number.class);
                this.minvCpus = this.jsiiGet("minvCpus", java.lang.Number.class);
                this.subnets = this.jsiiGet("subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.allocationStrategy = this.jsiiGet("allocationStrategy", java.lang.String.class);
                this.bidPercentage = this.jsiiGet("bidPercentage", java.lang.Number.class);
                this.desiredvCpus = this.jsiiGet("desiredvCpus", java.lang.Number.class);
                this.ec2KeyPair = this.jsiiGet("ec2KeyPair", java.lang.String.class);
                this.imageId = this.jsiiGet("imageId", java.lang.String.class);
                this.launchTemplate = this.jsiiGet("launchTemplate", java.lang.Object.class);
                this.placementGroup = this.jsiiGet("placementGroup", java.lang.String.class);
                this.securityGroupIds = this.jsiiGet("securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.spotIamFleetRole = this.jsiiGet("spotIamFleetRole", java.lang.String.class);
                this.tags = this.jsiiGet("tags", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String instanceRole, final java.util.List<java.lang.String> instanceTypes, final java.lang.Number maxvCpus, final java.lang.Number minvCpus, final java.util.List<java.lang.String> subnets, final java.lang.String type, final java.lang.String allocationStrategy, final java.lang.Number bidPercentage, final java.lang.Number desiredvCpus, final java.lang.String ec2KeyPair, final java.lang.String imageId, final java.lang.Object launchTemplate, final java.lang.String placementGroup, final java.util.List<java.lang.String> securityGroupIds, final java.lang.String spotIamFleetRole, final java.lang.Object tags) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceRole = java.util.Objects.requireNonNull(instanceRole, "instanceRole is required");
                this.instanceTypes = java.util.Objects.requireNonNull(instanceTypes, "instanceTypes is required");
                this.maxvCpus = java.util.Objects.requireNonNull(maxvCpus, "maxvCpus is required");
                this.minvCpus = java.util.Objects.requireNonNull(minvCpus, "minvCpus is required");
                this.subnets = java.util.Objects.requireNonNull(subnets, "subnets is required");
                this.type = java.util.Objects.requireNonNull(type, "type is required");
                this.allocationStrategy = allocationStrategy;
                this.bidPercentage = bidPercentage;
                this.desiredvCpus = desiredvCpus;
                this.ec2KeyPair = ec2KeyPair;
                this.imageId = imageId;
                this.launchTemplate = launchTemplate;
                this.placementGroup = placementGroup;
                this.securityGroupIds = securityGroupIds;
                this.spotIamFleetRole = spotIamFleetRole;
                this.tags = tags;
            }

            @Override
            public java.lang.String getInstanceRole() {
                return this.instanceRole;
            }

            @Override
            public java.util.List<java.lang.String> getInstanceTypes() {
                return this.instanceTypes;
            }

            @Override
            public java.lang.Number getMaxvCpus() {
                return this.maxvCpus;
            }

            @Override
            public java.lang.Number getMinvCpus() {
                return this.minvCpus;
            }

            @Override
            public java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.String getAllocationStrategy() {
                return this.allocationStrategy;
            }

            @Override
            public java.lang.Number getBidPercentage() {
                return this.bidPercentage;
            }

            @Override
            public java.lang.Number getDesiredvCpus() {
                return this.desiredvCpus;
            }

            @Override
            public java.lang.String getEc2KeyPair() {
                return this.ec2KeyPair;
            }

            @Override
            public java.lang.String getImageId() {
                return this.imageId;
            }

            @Override
            public java.lang.Object getLaunchTemplate() {
                return this.launchTemplate;
            }

            @Override
            public java.lang.String getPlacementGroup() {
                return this.placementGroup;
            }

            @Override
            public java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public java.lang.String getSpotIamFleetRole() {
                return this.spotIamFleetRole;
            }

            @Override
            public java.lang.Object getTags() {
                return this.tags;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceRole", om.valueToTree(this.getInstanceRole()));
                data.set("instanceTypes", om.valueToTree(this.getInstanceTypes()));
                data.set("maxvCpus", om.valueToTree(this.getMaxvCpus()));
                data.set("minvCpus", om.valueToTree(this.getMinvCpus()));
                data.set("subnets", om.valueToTree(this.getSubnets()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getAllocationStrategy() != null) {
                    data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                }
                if (this.getBidPercentage() != null) {
                    data.set("bidPercentage", om.valueToTree(this.getBidPercentage()));
                }
                if (this.getDesiredvCpus() != null) {
                    data.set("desiredvCpus", om.valueToTree(this.getDesiredvCpus()));
                }
                if (this.getEc2KeyPair() != null) {
                    data.set("ec2KeyPair", om.valueToTree(this.getEc2KeyPair()));
                }
                if (this.getImageId() != null) {
                    data.set("imageId", om.valueToTree(this.getImageId()));
                }
                if (this.getLaunchTemplate() != null) {
                    data.set("launchTemplate", om.valueToTree(this.getLaunchTemplate()));
                }
                if (this.getPlacementGroup() != null) {
                    data.set("placementGroup", om.valueToTree(this.getPlacementGroup()));
                }
                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }
                if (this.getSpotIamFleetRole() != null) {
                    data.set("spotIamFleetRole", om.valueToTree(this.getSpotIamFleetRole()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnComputeEnvironment.ComputeResourcesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComputeResourcesProperty.Jsii$Proxy that = (ComputeResourcesProperty.Jsii$Proxy) o;

                if (!instanceRole.equals(that.instanceRole)) return false;
                if (!instanceTypes.equals(that.instanceTypes)) return false;
                if (!maxvCpus.equals(that.maxvCpus)) return false;
                if (!minvCpus.equals(that.minvCpus)) return false;
                if (!subnets.equals(that.subnets)) return false;
                if (!type.equals(that.type)) return false;
                if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
                if (this.bidPercentage != null ? !this.bidPercentage.equals(that.bidPercentage) : that.bidPercentage != null) return false;
                if (this.desiredvCpus != null ? !this.desiredvCpus.equals(that.desiredvCpus) : that.desiredvCpus != null) return false;
                if (this.ec2KeyPair != null ? !this.ec2KeyPair.equals(that.ec2KeyPair) : that.ec2KeyPair != null) return false;
                if (this.imageId != null ? !this.imageId.equals(that.imageId) : that.imageId != null) return false;
                if (this.launchTemplate != null ? !this.launchTemplate.equals(that.launchTemplate) : that.launchTemplate != null) return false;
                if (this.placementGroup != null ? !this.placementGroup.equals(that.placementGroup) : that.placementGroup != null) return false;
                if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
                if (this.spotIamFleetRole != null ? !this.spotIamFleetRole.equals(that.spotIamFleetRole) : that.spotIamFleetRole != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public int hashCode() {
                int result = this.instanceRole.hashCode();
                result = 31 * result + (this.instanceTypes.hashCode());
                result = 31 * result + (this.maxvCpus.hashCode());
                result = 31 * result + (this.minvCpus.hashCode());
                result = 31 * result + (this.subnets.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0);
                result = 31 * result + (this.bidPercentage != null ? this.bidPercentage.hashCode() : 0);
                result = 31 * result + (this.desiredvCpus != null ? this.desiredvCpus.hashCode() : 0);
                result = 31 * result + (this.ec2KeyPair != null ? this.ec2KeyPair.hashCode() : 0);
                result = 31 * result + (this.imageId != null ? this.imageId.hashCode() : 0);
                result = 31 * result + (this.launchTemplate != null ? this.launchTemplate.hashCode() : 0);
                result = 31 * result + (this.placementGroup != null ? this.placementGroup.hashCode() : 0);
                result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
                result = 31 * result + (this.spotIamFleetRole != null ? this.spotIamFleetRole.hashCode() : 0);
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-launchtemplatespecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnComputeEnvironment.LaunchTemplateSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(LaunchTemplateSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LaunchTemplateSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnComputeEnvironment.LaunchTemplateSpecificationProperty.LaunchTemplateId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-launchtemplatespecification.html#cfn-batch-computeenvironment-launchtemplatespecification-launchtemplateid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateId() {
            return null;
        }

        /**
         * `CfnComputeEnvironment.LaunchTemplateSpecificationProperty.LaunchTemplateName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-launchtemplatespecification.html#cfn-batch-computeenvironment-launchtemplatespecification-launchtemplatename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateName() {
            return null;
        }

        /**
         * `CfnComputeEnvironment.LaunchTemplateSpecificationProperty.Version`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-launchtemplatespecification.html#cfn-batch-computeenvironment-launchtemplatespecification-version
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LaunchTemplateSpecificationProperty> {
            private java.lang.String launchTemplateId;
            private java.lang.String launchTemplateName;
            private java.lang.String version;

            /**
             * Sets the value of {@link LaunchTemplateSpecificationProperty#getLaunchTemplateId}
             * @param launchTemplateId `CfnComputeEnvironment.LaunchTemplateSpecificationProperty.LaunchTemplateId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateId(java.lang.String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateSpecificationProperty#getLaunchTemplateName}
             * @param launchTemplateName `CfnComputeEnvironment.LaunchTemplateSpecificationProperty.LaunchTemplateName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateName(java.lang.String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateSpecificationProperty#getVersion}
             * @param version `CfnComputeEnvironment.LaunchTemplateSpecificationProperty.Version`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LaunchTemplateSpecificationProperty build() {
                return new Jsii$Proxy(launchTemplateId, launchTemplateName, version);
            }
        }

        /**
         * An implementation for {@link LaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateSpecificationProperty {
            private final java.lang.String launchTemplateId;
            private final java.lang.String launchTemplateName;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.launchTemplateId = this.jsiiGet("launchTemplateId", java.lang.String.class);
                this.launchTemplateName = this.jsiiGet("launchTemplateName", java.lang.String.class);
                this.version = this.jsiiGet("version", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String launchTemplateId, final java.lang.String launchTemplateName, final java.lang.String version) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.launchTemplateId = launchTemplateId;
                this.launchTemplateName = launchTemplateName;
                this.version = version;
            }

            @Override
            public java.lang.String getLaunchTemplateId() {
                return this.launchTemplateId;
            }

            @Override
            public java.lang.String getLaunchTemplateName() {
                return this.launchTemplateName;
            }

            @Override
            public java.lang.String getVersion() {
                return this.version;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLaunchTemplateId() != null) {
                    data.set("launchTemplateId", om.valueToTree(this.getLaunchTemplateId()));
                }
                if (this.getLaunchTemplateName() != null) {
                    data.set("launchTemplateName", om.valueToTree(this.getLaunchTemplateName()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnComputeEnvironment.LaunchTemplateSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LaunchTemplateSpecificationProperty.Jsii$Proxy that = (LaunchTemplateSpecificationProperty.Jsii$Proxy) o;

                if (this.launchTemplateId != null ? !this.launchTemplateId.equals(that.launchTemplateId) : that.launchTemplateId != null) return false;
                if (this.launchTemplateName != null ? !this.launchTemplateName.equals(that.launchTemplateName) : that.launchTemplateName != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public int hashCode() {
                int result = this.launchTemplateId != null ? this.launchTemplateId.hashCode() : 0;
                result = 31 * result + (this.launchTemplateName != null ? this.launchTemplateName.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.CfnComputeEnvironment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.CfnComputeEnvironment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.batch.CfnComputeEnvironmentProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.batch.CfnComputeEnvironmentProps.Builder();
        }

        /**
         * `AWS::Batch::ComputeEnvironment.ServiceRole`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-servicerole
         * @param serviceRole `AWS::Batch::ComputeEnvironment.ServiceRole`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(final java.lang.String serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        /**
         * `AWS::Batch::ComputeEnvironment.Type`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-type
         * @param type `AWS::Batch::ComputeEnvironment.Type`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * `AWS::Batch::ComputeEnvironment.ComputeEnvironmentName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeenvironmentname
         * @param computeEnvironmentName `AWS::Batch::ComputeEnvironment.ComputeEnvironmentName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeEnvironmentName(final java.lang.String computeEnvironmentName) {
            this.props.computeEnvironmentName(computeEnvironmentName);
            return this;
        }

        /**
         * `AWS::Batch::ComputeEnvironment.ComputeResources`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeresources
         * @param computeResources `AWS::Batch::ComputeEnvironment.ComputeResources`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeResources(final software.amazon.awscdk.core.IResolvable computeResources) {
            this.props.computeResources(computeResources);
            return this;
        }
        /**
         * `AWS::Batch::ComputeEnvironment.ComputeResources`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeresources
         * @param computeResources `AWS::Batch::ComputeEnvironment.ComputeResources`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeResources(final software.amazon.awscdk.services.batch.CfnComputeEnvironment.ComputeResourcesProperty computeResources) {
            this.props.computeResources(computeResources);
            return this;
        }

        /**
         * `AWS::Batch::ComputeEnvironment.State`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-state
         * @param state `AWS::Batch::ComputeEnvironment.State`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(final java.lang.String state) {
            this.props.state(state);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.batch.CfnComputeEnvironment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.CfnComputeEnvironment build() {
            return new software.amazon.awscdk.services.batch.CfnComputeEnvironment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
