/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.mediaconnect;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.mediaconnect.CfnFlowEntitlement;
import software.amazon.awscdk.services.mediaconnect.CfnFlowEntitlementProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mediaconnect.CfnFlowEntitlement")
public class CfnFlowEntitlement
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFlowEntitlement.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnFlowEntitlement(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFlowEntitlement(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnFlowEntitlement(@NotNull Construct scope, @NotNull String id, @NotNull CfnFlowEntitlementProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrEntitlementArn() {
        return (String)Kernel.get((Object)this, (String)"attrEntitlementArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@NotNull String value) {
        Kernel.set((Object)this, (String)"description", (Object)Objects.requireNonNull(value, "description is required"));
    }

    @NotNull
    public String getFlowArn() {
        return (String)Kernel.get((Object)this, (String)"flowArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setFlowArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"flowArn", (Object)Objects.requireNonNull(value, "flowArn is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @NotNull
    public List<String> getSubscribers() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"subscribers", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    public void setSubscribers(@NotNull List<String> value) {
        Kernel.set((Object)this, (String)"subscribers", Objects.requireNonNull(value, "subscribers is required"));
    }

    @Nullable
    public Number getDataTransferSubscriberFeePercent() {
        return (Number)Kernel.get((Object)this, (String)"dataTransferSubscriberFeePercent", (NativeType)NativeType.forClass(Number.class));
    }

    public void setDataTransferSubscriberFeePercent(@Nullable Number value) {
        Kernel.set((Object)this, (String)"dataTransferSubscriberFeePercent", (Object)value);
    }

    @Nullable
    public Object getEncryption() {
        return Kernel.get((Object)this, (String)"encryption", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEncryption(@Nullable EncryptionProperty value) {
        Kernel.set((Object)this, (String)"encryption", (Object)value);
    }

    public void setEncryption(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"encryption", (Object)value);
    }

    @Nullable
    public String getEntitlementStatus() {
        return (String)Kernel.get((Object)this, (String)"entitlementStatus", (NativeType)NativeType.forClass(String.class));
    }

    public void setEntitlementStatus(@Nullable String value) {
        Kernel.set((Object)this, (String)"entitlementStatus", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnFlowEntitlement> {
        private final Construct scope;
        private final String id;
        private final CfnFlowEntitlementProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnFlowEntitlementProps.Builder();
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder flowArn(String flowArn) {
            this.props.flowArn(flowArn);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder subscribers(List<String> subscribers) {
            this.props.subscribers(subscribers);
            return this;
        }

        public Builder dataTransferSubscriberFeePercent(Number dataTransferSubscriberFeePercent) {
            this.props.dataTransferSubscriberFeePercent(dataTransferSubscriberFeePercent);
            return this;
        }

        public Builder encryption(EncryptionProperty encryption) {
            this.props.encryption(encryption);
            return this;
        }

        public Builder encryption(IResolvable encryption) {
            this.props.encryption(encryption);
            return this;
        }

        public Builder entitlementStatus(String entitlementStatus) {
            this.props.entitlementStatus(entitlementStatus);
            return this;
        }

        public CfnFlowEntitlement build() {
            return new CfnFlowEntitlement(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mediaconnect.CfnFlowEntitlement.EncryptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncryptionProperty
    extends JsiiSerializable {
        @NotNull
        public String getAlgorithm();

        @NotNull
        public String getRoleArn();

        @Nullable
        default public String getConstantInitializationVector() {
            return null;
        }

        @Nullable
        default public String getDeviceId() {
            return null;
        }

        @Nullable
        default public String getKeyType() {
            return null;
        }

        @Nullable
        default public String getRegion() {
            return null;
        }

        @Nullable
        default public String getResourceId() {
            return null;
        }

        @Nullable
        default public String getSecretArn() {
            return null;
        }

        @Nullable
        default public String getUrl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EncryptionProperty> {
            String algorithm;
            String roleArn;
            String constantInitializationVector;
            String deviceId;
            String keyType;
            String region;
            String resourceId;
            String secretArn;
            String url;

            public Builder algorithm(String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder constantInitializationVector(String constantInitializationVector) {
                this.constantInitializationVector = constantInitializationVector;
                return this;
            }

            public Builder deviceId(String deviceId) {
                this.deviceId = deviceId;
                return this;
            }

            public Builder keyType(String keyType) {
                this.keyType = keyType;
                return this;
            }

            public Builder region(String region) {
                this.region = region;
                return this;
            }

            public Builder resourceId(String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public EncryptionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

