/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.eks;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.eks.CapacityType;
import software.amazon.awscdk.services.eks.ICluster;
import software.amazon.awscdk.services.eks.LaunchTemplateSpec;
import software.amazon.awscdk.services.eks.NodegroupAmiType;
import software.amazon.awscdk.services.eks.NodegroupOptions;
import software.amazon.awscdk.services.eks.NodegroupProps;
import software.amazon.awscdk.services.eks.NodegroupRemoteAccess;
import software.amazon.awscdk.services.eks.TaintSpec;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_eks.NodegroupProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface NodegroupProps
extends JsiiSerializable,
NodegroupOptions {
    @NotNull
    public ICluster getCluster();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<NodegroupProps> {
        ICluster cluster;
        NodegroupAmiType amiType;
        CapacityType capacityType;
        Number desiredSize;
        Number diskSize;
        Boolean forceUpdate;
        List<InstanceType> instanceTypes;
        Map<String, String> labels;
        LaunchTemplateSpec launchTemplateSpec;
        Number maxSize;
        Number minSize;
        String nodegroupName;
        IRole nodeRole;
        String releaseVersion;
        NodegroupRemoteAccess remoteAccess;
        SubnetSelection subnets;
        Map<String, String> tags;
        List<TaintSpec> taints;

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder amiType(NodegroupAmiType amiType) {
            this.amiType = amiType;
            return this;
        }

        public Builder capacityType(CapacityType capacityType) {
            this.capacityType = capacityType;
            return this;
        }

        public Builder desiredSize(Number desiredSize) {
            this.desiredSize = desiredSize;
            return this;
        }

        public Builder diskSize(Number diskSize) {
            this.diskSize = diskSize;
            return this;
        }

        public Builder forceUpdate(Boolean forceUpdate) {
            this.forceUpdate = forceUpdate;
            return this;
        }

        public Builder instanceTypes(List<? extends InstanceType> instanceTypes) {
            this.instanceTypes = instanceTypes;
            return this;
        }

        public Builder labels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder launchTemplateSpec(LaunchTemplateSpec launchTemplateSpec) {
            this.launchTemplateSpec = launchTemplateSpec;
            return this;
        }

        public Builder maxSize(Number maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder minSize(Number minSize) {
            this.minSize = minSize;
            return this;
        }

        public Builder nodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        public Builder nodeRole(IRole nodeRole) {
            this.nodeRole = nodeRole;
            return this;
        }

        public Builder releaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
            return this;
        }

        public Builder remoteAccess(NodegroupRemoteAccess remoteAccess) {
            this.remoteAccess = remoteAccess;
            return this;
        }

        public Builder subnets(SubnetSelection subnets) {
            this.subnets = subnets;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder taints(List<? extends TaintSpec> taints) {
            this.taints = taints;
            return this;
        }

        public NodegroupProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

