/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs.patterns;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.certificatemanager.ICertificate;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ecs.CapacityProviderStrategy;
import software.amazon.awscdk.services.ecs.CloudMapOptions;
import software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker;
import software.amazon.awscdk.services.ecs.DeploymentController;
import software.amazon.awscdk.services.ecs.Ec2Service;
import software.amazon.awscdk.services.ecs.Ec2TaskDefinition;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.PlacementConstraint;
import software.amazon.awscdk.services.ecs.PlacementStrategy;
import software.amazon.awscdk.services.ecs.PropagatedTagSource;
import software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedEc2ServiceProps;
import software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedServiceBase;
import software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedServiceRecordType;
import software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageOptions;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocolVersion;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy;
import software.amazon.awscdk.services.route53.IHostedZone;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ecs_patterns.ApplicationLoadBalancedEc2Service")
public class ApplicationLoadBalancedEc2Service
extends ApplicationLoadBalancedServiceBase {
    protected ApplicationLoadBalancedEc2Service(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApplicationLoadBalancedEc2Service(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ApplicationLoadBalancedEc2Service(@NotNull Construct scope, @NotNull String id, @Nullable ApplicationLoadBalancedEc2ServiceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public ApplicationLoadBalancedEc2Service(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public Ec2Service getService() {
        return (Ec2Service)Kernel.get((Object)((Object)this), (String)"service", (NativeType)NativeType.forClass(Ec2Service.class));
    }

    @NotNull
    public Ec2TaskDefinition getTaskDefinition() {
        return (Ec2TaskDefinition)Kernel.get((Object)((Object)this), (String)"taskDefinition", (NativeType)NativeType.forClass(Ec2TaskDefinition.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ApplicationLoadBalancedEc2Service> {
        private final Construct scope;
        private final String id;
        private ApplicationLoadBalancedEc2ServiceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder capacityProviderStrategies(List<? extends CapacityProviderStrategy> capacityProviderStrategies) {
            this.props().capacityProviderStrategies(capacityProviderStrategies);
            return this;
        }

        public Builder certificate(ICertificate certificate) {
            this.props().certificate(certificate);
            return this;
        }

        public Builder circuitBreaker(DeploymentCircuitBreaker circuitBreaker) {
            this.props().circuitBreaker(circuitBreaker);
            return this;
        }

        public Builder cloudMapOptions(CloudMapOptions cloudMapOptions) {
            this.props().cloudMapOptions(cloudMapOptions);
            return this;
        }

        public Builder cluster(ICluster cluster) {
            this.props().cluster(cluster);
            return this;
        }

        public Builder deploymentController(DeploymentController deploymentController) {
            this.props().deploymentController(deploymentController);
            return this;
        }

        public Builder desiredCount(Number desiredCount) {
            this.props().desiredCount(desiredCount);
            return this;
        }

        public Builder domainName(String domainName) {
            this.props().domainName(domainName);
            return this;
        }

        public Builder domainZone(IHostedZone domainZone) {
            this.props().domainZone(domainZone);
            return this;
        }

        public Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.props().enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        public Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.props().enableExecuteCommand(enableExecuteCommand);
            return this;
        }

        public Builder healthCheckGracePeriod(Duration healthCheckGracePeriod) {
            this.props().healthCheckGracePeriod(healthCheckGracePeriod);
            return this;
        }

        public Builder idleTimeout(Duration idleTimeout) {
            this.props().idleTimeout(idleTimeout);
            return this;
        }

        public Builder listenerPort(Number listenerPort) {
            this.props().listenerPort(listenerPort);
            return this;
        }

        public Builder loadBalancer(IApplicationLoadBalancer loadBalancer) {
            this.props().loadBalancer(loadBalancer);
            return this;
        }

        public Builder loadBalancerName(String loadBalancerName) {
            this.props().loadBalancerName(loadBalancerName);
            return this;
        }

        public Builder maxHealthyPercent(Number maxHealthyPercent) {
            this.props().maxHealthyPercent(maxHealthyPercent);
            return this;
        }

        public Builder minHealthyPercent(Number minHealthyPercent) {
            this.props().minHealthyPercent(minHealthyPercent);
            return this;
        }

        public Builder openListener(Boolean openListener) {
            this.props().openListener(openListener);
            return this;
        }

        public Builder propagateTags(PropagatedTagSource propagateTags) {
            this.props().propagateTags(propagateTags);
            return this;
        }

        public Builder protocol(ApplicationProtocol protocol) {
            this.props().protocol(protocol);
            return this;
        }

        public Builder protocolVersion(ApplicationProtocolVersion protocolVersion) {
            this.props().protocolVersion(protocolVersion);
            return this;
        }

        public Builder publicLoadBalancer(Boolean publicLoadBalancer) {
            this.props().publicLoadBalancer(publicLoadBalancer);
            return this;
        }

        public Builder recordType(ApplicationLoadBalancedServiceRecordType recordType) {
            this.props().recordType(recordType);
            return this;
        }

        public Builder redirectHttp(Boolean redirectHttp) {
            this.props().redirectHttp(redirectHttp);
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.props().serviceName(serviceName);
            return this;
        }

        public Builder sslPolicy(SslPolicy sslPolicy) {
            this.props().sslPolicy(sslPolicy);
            return this;
        }

        public Builder targetProtocol(ApplicationProtocol targetProtocol) {
            this.props().targetProtocol(targetProtocol);
            return this;
        }

        public Builder taskImageOptions(ApplicationLoadBalancedTaskImageOptions taskImageOptions) {
            this.props().taskImageOptions(taskImageOptions);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props().vpc(vpc);
            return this;
        }

        public Builder cpu(Number cpu) {
            this.props().cpu(cpu);
            return this;
        }

        public Builder memoryLimitMiB(Number memoryLimitMiB) {
            this.props().memoryLimitMiB(memoryLimitMiB);
            return this;
        }

        public Builder memoryReservationMiB(Number memoryReservationMiB) {
            this.props().memoryReservationMiB(memoryReservationMiB);
            return this;
        }

        public Builder placementConstraints(List<? extends PlacementConstraint> placementConstraints) {
            this.props().placementConstraints(placementConstraints);
            return this;
        }

        public Builder placementStrategies(List<? extends PlacementStrategy> placementStrategies) {
            this.props().placementStrategies(placementStrategies);
            return this;
        }

        public Builder taskDefinition(Ec2TaskDefinition taskDefinition) {
            this.props().taskDefinition(taskDefinition);
            return this;
        }

        public ApplicationLoadBalancedEc2Service build() {
            return new ApplicationLoadBalancedEc2Service(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private ApplicationLoadBalancedEc2ServiceProps.Builder props() {
            if (this.props == null) {
                this.props = new ApplicationLoadBalancedEc2ServiceProps.Builder();
            }
            return this.props;
        }
    }
}

