/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint;
import software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAttributes;
import software.amazon.awscdk.services.ec2.InterfaceVpcEndpointProps;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ec2.VpcEndpoint;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.InterfaceVpcEndpoint")
public class InterfaceVpcEndpoint
extends VpcEndpoint
implements IInterfaceVpcEndpoint {
    protected InterfaceVpcEndpoint(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InterfaceVpcEndpoint(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public InterfaceVpcEndpoint(@NotNull Construct scope, @NotNull String id, @NotNull InterfaceVpcEndpointProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IInterfaceVpcEndpoint fromInterfaceVpcEndpointAttributes(@NotNull Construct scope, @NotNull String id, @NotNull InterfaceVpcEndpointAttributes attrs) {
        return (IInterfaceVpcEndpoint)JsiiObject.jsiiStaticCall(InterfaceVpcEndpoint.class, (String)"fromInterfaceVpcEndpointAttributes", (NativeType)NativeType.forClass(IInterfaceVpcEndpoint.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @NotNull
    public String getVpcEndpointCreationTimestamp() {
        return (String)Kernel.get((Object)this, (String)"vpcEndpointCreationTimestamp", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<String> getVpcEndpointDnsEntries() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"vpcEndpointDnsEntries", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @Override
    @NotNull
    public String getVpcEndpointId() {
        return (String)Kernel.get((Object)this, (String)"vpcEndpointId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<String> getVpcEndpointNetworkInterfaceIds() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"vpcEndpointNetworkInterfaceIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<InterfaceVpcEndpoint> {
        private final Construct scope;
        private final String id;
        private final InterfaceVpcEndpointProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new InterfaceVpcEndpointProps.Builder();
        }

        public Builder service(IInterfaceVpcEndpointService service) {
            this.props.service(service);
            return this;
        }

        public Builder lookupSupportedAzs(Boolean lookupSupportedAzs) {
            this.props.lookupSupportedAzs(lookupSupportedAzs);
            return this;
        }

        public Builder open(Boolean open) {
            this.props.open(open);
            return this;
        }

        public Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.props.privateDnsEnabled(privateDnsEnabled);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder subnets(SubnetSelection subnets) {
            this.props.subnets(subnets);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public InterfaceVpcEndpoint build() {
            return new InterfaceVpcEndpoint(this.scope, this.id, this.props.build());
        }
    }
}

