package software.amazon.awscdk.services.supportapp;

/**
 * A CloudFormation `AWS::SupportApp::SlackChannelConfiguration`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.supportapp.*;
 * CfnSlackChannelConfiguration cfnSlackChannelConfiguration = CfnSlackChannelConfiguration.Builder.create(this, "MyCfnSlackChannelConfiguration")
 *         .channelId("channelId")
 *         .channelRoleArn("channelRoleArn")
 *         .notifyOnCaseSeverity("notifyOnCaseSeverity")
 *         .teamId("teamId")
 *         // the properties below are optional
 *         .channelName("channelName")
 *         .notifyOnAddCorrespondenceToCase(false)
 *         .notifyOnCreateOrReopenCase(false)
 *         .notifyOnResolveCase(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:15.365Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_supportapp.CfnSlackChannelConfiguration")
public class CfnSlackChannelConfiguration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnSlackChannelConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSlackChannelConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.supportapp.CfnSlackChannelConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SupportApp::SlackChannelConfiguration`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSlackChannelConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.supportapp.CfnSlackChannelConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::SupportApp::SlackChannelConfiguration.ChannelId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getChannelId() {
        return software.amazon.jsii.Kernel.get(this, "channelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::SupportApp::SlackChannelConfiguration.ChannelId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "channelId", java.util.Objects.requireNonNull(value, "channelId is required"));
    }

    /**
     * `AWS::SupportApp::SlackChannelConfiguration.ChannelRoleArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getChannelRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "channelRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::SupportApp::SlackChannelConfiguration.ChannelRoleArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "channelRoleArn", java.util.Objects.requireNonNull(value, "channelRoleArn is required"));
    }

    /**
     * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnCaseSeverity`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getNotifyOnCaseSeverity() {
        return software.amazon.jsii.Kernel.get(this, "notifyOnCaseSeverity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnCaseSeverity`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotifyOnCaseSeverity(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "notifyOnCaseSeverity", java.util.Objects.requireNonNull(value, "notifyOnCaseSeverity is required"));
    }

    /**
     * `AWS::SupportApp::SlackChannelConfiguration.TeamId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTeamId() {
        return software.amazon.jsii.Kernel.get(this, "teamId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::SupportApp::SlackChannelConfiguration.TeamId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTeamId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "teamId", java.util.Objects.requireNonNull(value, "teamId is required"));
    }

    /**
     * `AWS::SupportApp::SlackChannelConfiguration.ChannelName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getChannelName() {
        return software.amazon.jsii.Kernel.get(this, "channelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::SupportApp::SlackChannelConfiguration.ChannelName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "channelName", value);
    }

    /**
     * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnAddCorrespondenceToCase`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNotifyOnAddCorrespondenceToCase() {
        return software.amazon.jsii.Kernel.get(this, "notifyOnAddCorrespondenceToCase", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnAddCorrespondenceToCase`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotifyOnAddCorrespondenceToCase(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "notifyOnAddCorrespondenceToCase", value);
    }

    /**
     * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnAddCorrespondenceToCase`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotifyOnAddCorrespondenceToCase(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "notifyOnAddCorrespondenceToCase", value);
    }

    /**
     * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnCreateOrReopenCase`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNotifyOnCreateOrReopenCase() {
        return software.amazon.jsii.Kernel.get(this, "notifyOnCreateOrReopenCase", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnCreateOrReopenCase`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotifyOnCreateOrReopenCase(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "notifyOnCreateOrReopenCase", value);
    }

    /**
     * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnCreateOrReopenCase`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotifyOnCreateOrReopenCase(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "notifyOnCreateOrReopenCase", value);
    }

    /**
     * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnResolveCase`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNotifyOnResolveCase() {
        return software.amazon.jsii.Kernel.get(this, "notifyOnResolveCase", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnResolveCase`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotifyOnResolveCase(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "notifyOnResolveCase", value);
    }

    /**
     * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnResolveCase`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotifyOnResolveCase(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "notifyOnResolveCase", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.supportapp.CfnSlackChannelConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.supportapp.CfnSlackChannelConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.supportapp.CfnSlackChannelConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.supportapp.CfnSlackChannelConfigurationProps.Builder();
        }

        /**
         * `AWS::SupportApp::SlackChannelConfiguration.ChannelId`.
         * <p>
         * @return {@code this}
         * @param channelId `AWS::SupportApp::SlackChannelConfiguration.ChannelId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelId(final java.lang.String channelId) {
            this.props.channelId(channelId);
            return this;
        }

        /**
         * `AWS::SupportApp::SlackChannelConfiguration.ChannelRoleArn`.
         * <p>
         * @return {@code this}
         * @param channelRoleArn `AWS::SupportApp::SlackChannelConfiguration.ChannelRoleArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelRoleArn(final java.lang.String channelRoleArn) {
            this.props.channelRoleArn(channelRoleArn);
            return this;
        }

        /**
         * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnCaseSeverity`.
         * <p>
         * @return {@code this}
         * @param notifyOnCaseSeverity `AWS::SupportApp::SlackChannelConfiguration.NotifyOnCaseSeverity`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnCaseSeverity(final java.lang.String notifyOnCaseSeverity) {
            this.props.notifyOnCaseSeverity(notifyOnCaseSeverity);
            return this;
        }

        /**
         * `AWS::SupportApp::SlackChannelConfiguration.TeamId`.
         * <p>
         * @return {@code this}
         * @param teamId `AWS::SupportApp::SlackChannelConfiguration.TeamId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder teamId(final java.lang.String teamId) {
            this.props.teamId(teamId);
            return this;
        }

        /**
         * `AWS::SupportApp::SlackChannelConfiguration.ChannelName`.
         * <p>
         * @return {@code this}
         * @param channelName `AWS::SupportApp::SlackChannelConfiguration.ChannelName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelName(final java.lang.String channelName) {
            this.props.channelName(channelName);
            return this;
        }

        /**
         * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnAddCorrespondenceToCase`.
         * <p>
         * @return {@code this}
         * @param notifyOnAddCorrespondenceToCase `AWS::SupportApp::SlackChannelConfiguration.NotifyOnAddCorrespondenceToCase`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnAddCorrespondenceToCase(final java.lang.Boolean notifyOnAddCorrespondenceToCase) {
            this.props.notifyOnAddCorrespondenceToCase(notifyOnAddCorrespondenceToCase);
            return this;
        }
        /**
         * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnAddCorrespondenceToCase`.
         * <p>
         * @return {@code this}
         * @param notifyOnAddCorrespondenceToCase `AWS::SupportApp::SlackChannelConfiguration.NotifyOnAddCorrespondenceToCase`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnAddCorrespondenceToCase(final software.amazon.awscdk.IResolvable notifyOnAddCorrespondenceToCase) {
            this.props.notifyOnAddCorrespondenceToCase(notifyOnAddCorrespondenceToCase);
            return this;
        }

        /**
         * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnCreateOrReopenCase`.
         * <p>
         * @return {@code this}
         * @param notifyOnCreateOrReopenCase `AWS::SupportApp::SlackChannelConfiguration.NotifyOnCreateOrReopenCase`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnCreateOrReopenCase(final java.lang.Boolean notifyOnCreateOrReopenCase) {
            this.props.notifyOnCreateOrReopenCase(notifyOnCreateOrReopenCase);
            return this;
        }
        /**
         * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnCreateOrReopenCase`.
         * <p>
         * @return {@code this}
         * @param notifyOnCreateOrReopenCase `AWS::SupportApp::SlackChannelConfiguration.NotifyOnCreateOrReopenCase`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnCreateOrReopenCase(final software.amazon.awscdk.IResolvable notifyOnCreateOrReopenCase) {
            this.props.notifyOnCreateOrReopenCase(notifyOnCreateOrReopenCase);
            return this;
        }

        /**
         * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnResolveCase`.
         * <p>
         * @return {@code this}
         * @param notifyOnResolveCase `AWS::SupportApp::SlackChannelConfiguration.NotifyOnResolveCase`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnResolveCase(final java.lang.Boolean notifyOnResolveCase) {
            this.props.notifyOnResolveCase(notifyOnResolveCase);
            return this;
        }
        /**
         * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnResolveCase`.
         * <p>
         * @return {@code this}
         * @param notifyOnResolveCase `AWS::SupportApp::SlackChannelConfiguration.NotifyOnResolveCase`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnResolveCase(final software.amazon.awscdk.IResolvable notifyOnResolveCase) {
            this.props.notifyOnResolveCase(notifyOnResolveCase);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.supportapp.CfnSlackChannelConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.supportapp.CfnSlackChannelConfiguration build() {
            return new software.amazon.awscdk.services.supportapp.CfnSlackChannelConfiguration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
