package software.amazon.awscdk.services.stepfunctions;

/**
 * Two types of state machines are available in AWS Step Functions: EXPRESS AND STANDARD.
 * <p>
 * Default: STANDARD
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Pass stateMachineDefinition = new Pass(this, "PassState");
 * IStateMachine stateMachine = StateMachine.Builder.create(this, "StateMachine")
 *         .definition(stateMachineDefinition)
 *         .stateMachineType(StateMachineType.EXPRESS)
 *         .build();
 * StepFunctionsRestApi.Builder.create(this, "StepFunctionsRestApi")
 *         .deploy(true)
 *         .stateMachine(stateMachine)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:15.211Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.StateMachineType")
public enum StateMachineType {
    /**
     * Express Workflows are ideal for high-volume, event processing workloads.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EXPRESS,
    /**
     * Standard Workflows are ideal for long-running, durable, and auditable workflows.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
}
