package software.amazon.awscdk.services.stepfunctions;

/**
 * A collection of connected states.
 * <p>
 * A StateGraph is used to keep track of all states that are connected (have
 * transitions between them). It does not include the substatemachines in
 * a Parallel's branches: those are their own StateGraphs, but the graphs
 * themselves have a hierarchical relationship as well.
 * <p>
 * By assigning states to a definitive StateGraph, we verify that no state
 * machines are constructed. In particular:
 * <p>
 * <ul>
 * <li>Every state object can only ever be in 1 StateGraph, and not inadvertently
 * be used in two graphs.</li>
 * <li>Every stateId must be unique across all states in the entire state
 * machine.</li>
 * </ul>
 * <p>
 * All policy statements in all states in all substatemachines are bubbled so
 * that the top-level StateMachine instantiation can read them all and add
 * them to the IAM Role.
 * <p>
 * You do not need to instantiate this class; it is used internally.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * State state;
 * StateGraph stateGraph = new StateGraph(state, "graphDescription");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:15.209Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.StateGraph")
public class StateGraph extends software.amazon.jsii.JsiiObject {

    protected StateGraph(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StateGraph(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param startState state that gets executed when the state machine is launched. This parameter is required.
     * @param graphDescription description of the state machine. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public StateGraph(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State startState, final @org.jetbrains.annotations.NotNull java.lang.String graphDescription) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(startState, "startState is required"), java.util.Objects.requireNonNull(graphDescription, "graphDescription is required") });
    }

    /**
     * Register a Policy Statement used by states in this graph.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void registerPolicyStatement(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        software.amazon.jsii.Kernel.call(this, "registerPolicyStatement", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Register a state as part of this graph.
     * <p>
     * Called by State.bindToGraph().
     * <p>
     * @param state This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void registerState(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State state) {
        software.amazon.jsii.Kernel.call(this, "registerState", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(state, "state is required") });
    }

    /**
     * Register this graph as a child of the given graph.
     * <p>
     * Resource changes will be bubbled up to the given graph.
     * <p>
     * @param graph This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void registerSuperGraph(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateGraph graph) {
        software.amazon.jsii.Kernel.call(this, "registerSuperGraph", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(graph, "graph is required") });
    }

    /**
     * Return the Amazon States Language JSON for this graph.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull com.fasterxml.jackson.databind.node.ObjectNode toGraphJson() {
        return software.amazon.jsii.Kernel.call(this, "toGraphJson", software.amazon.jsii.NativeType.forClass(com.fasterxml.jackson.databind.node.ObjectNode.class));
    }

    /**
     * Return a string description of this graph.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The accumulated policy statements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getPolicyStatements() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "policyStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))));
    }

    /**
     * state that gets executed when the state machine is launched.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State getStartState() {
        return software.amazon.jsii.Kernel.get(this, "startState", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.State.class));
    }

    /**
     * Set a timeout to render into the graph JSON.
     * <p>
     * Read/write. Only makes sense on the top-level graph, subgraphs
     * do not support this feature.
     * <p>
     * Default: No timeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
    }

    /**
     * Set a timeout to render into the graph JSON.
     * <p>
     * Read/write. Only makes sense on the top-level graph, subgraphs
     * do not support this feature.
     * <p>
     * Default: No timeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeout(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration value) {
        software.amazon.jsii.Kernel.set(this, "timeout", value);
    }
}
