package software.amazon.awscdk.services.ssmincidents;

/**
 * A CloudFormation `AWS::SSMIncidents::ResponsePlan`.
 * <p>
 * The <code>AWS::SSMIncidents::ResponsePlan</code> resource specifies the details of the response plan that are used when creating an incident.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssmincidents.*;
 * CfnResponsePlan cfnResponsePlan = CfnResponsePlan.Builder.create(this, "MyCfnResponsePlan")
 *         .incidentTemplate(IncidentTemplateProperty.builder()
 *                 .impact(123)
 *                 .title("title")
 *                 // the properties below are optional
 *                 .dedupeString("dedupeString")
 *                 .incidentTags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .notificationTargets(List.of(NotificationTargetItemProperty.builder()
 *                         .snsTopicArn("snsTopicArn")
 *                         .build()))
 *                 .summary("summary")
 *                 .build())
 *         .name("name")
 *         // the properties below are optional
 *         .actions(List.of(ActionProperty.builder()
 *                 .ssmAutomation(SsmAutomationProperty.builder()
 *                         .documentName("documentName")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .documentVersion("documentVersion")
 *                         .dynamicParameters(List.of(DynamicSsmParameterProperty.builder()
 *                                 .key("key")
 *                                 .value(DynamicSsmParameterValueProperty.builder()
 *                                         .variable("variable")
 *                                         .build())
 *                                 .build()))
 *                         .parameters(List.of(SsmParameterProperty.builder()
 *                                 .key("key")
 *                                 .values(List.of("values"))
 *                                 .build()))
 *                         .targetAccount("targetAccount")
 *                         .build())
 *                 .build()))
 *         .chatChannel(ChatChannelProperty.builder()
 *                 .chatbotSns(List.of("chatbotSns"))
 *                 .build())
 *         .displayName("displayName")
 *         .engagements(List.of("engagements"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:15.145Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmincidents.CfnResponsePlan")
public class CfnResponsePlan extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnResponsePlan(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnResponsePlan(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ssmincidents.CfnResponsePlan.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SSMIncidents::ResponsePlan`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnResponsePlan(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssmincidents.CfnResponsePlanProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Details used to create an incident when using this response plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getIncidentTemplate() {
        return software.amazon.jsii.Kernel.get(this, "incidentTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Details used to create an incident when using this response plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIncidentTemplate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssmincidents.CfnResponsePlan.IncidentTemplateProperty value) {
        software.amazon.jsii.Kernel.set(this, "incidentTemplate", java.util.Objects.requireNonNull(value, "incidentTemplate is required"));
    }

    /**
     * Details used to create an incident when using this response plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIncidentTemplate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "incidentTemplate", java.util.Objects.requireNonNull(value, "incidentTemplate is required"));
    }

    /**
     * The name of the response plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the response plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The actions that the response plan starts at the beginning of an incident.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getActions() {
        return software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The actions that the response plan starts at the beginning of an incident.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "actions", value);
    }

    /**
     * The actions that the response plan starts at the beginning of an incident.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.ssmincidents.CfnResponsePlan.ActionProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.ssmincidents.CfnResponsePlan.ActionProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "actions", value);
    }

    /**
     * The AWS Chatbot chat channel used for collaboration during an incident.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getChatChannel() {
        return software.amazon.jsii.Kernel.get(this, "chatChannel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The AWS Chatbot chat channel used for collaboration during an incident.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChatChannel(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ssmincidents.CfnResponsePlan.ChatChannelProperty value) {
        software.amazon.jsii.Kernel.set(this, "chatChannel", value);
    }

    /**
     * The AWS Chatbot chat channel used for collaboration during an incident.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChatChannel(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "chatChannel", value);
    }

    /**
     * The human readable name of the response plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The human readable name of the response plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisplayName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "displayName", value);
    }

    /**
     * The contacts and escalation plans that the response plan engages during an incident.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEngagements() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "engagements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The contacts and escalation plans that the response plan engages during an incident.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngagements(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "engagements", value);
    }
    /**
     * The `Action` property type specifies the configuration to launch.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmincidents.*;
     * ActionProperty actionProperty = ActionProperty.builder()
     *         .ssmAutomation(SsmAutomationProperty.builder()
     *                 .documentName("documentName")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .documentVersion("documentVersion")
     *                 .dynamicParameters(List.of(DynamicSsmParameterProperty.builder()
     *                         .key("key")
     *                         .value(DynamicSsmParameterValueProperty.builder()
     *                                 .variable("variable")
     *                                 .build())
     *                         .build()))
     *                 .parameters(List.of(SsmParameterProperty.builder()
     *                         .key("key")
     *                         .values(List.of("values"))
     *                         .build()))
     *                 .targetAccount("targetAccount")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmincidents.CfnResponsePlan.ActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Details about the Systems Manager automation document that will be used as a runbook during an incident.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSsmAutomation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionProperty> {
            java.lang.Object ssmAutomation;

            /**
             * Sets the value of {@link ActionProperty#getSsmAutomation}
             * @param ssmAutomation Details about the Systems Manager automation document that will be used as a runbook during an incident.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ssmAutomation(software.amazon.awscdk.services.ssmincidents.CfnResponsePlan.SsmAutomationProperty ssmAutomation) {
                this.ssmAutomation = ssmAutomation;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getSsmAutomation}
             * @param ssmAutomation Details about the Systems Manager automation document that will be used as a runbook during an incident.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ssmAutomation(software.amazon.awscdk.IResolvable ssmAutomation) {
                this.ssmAutomation = ssmAutomation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionProperty {
            private final java.lang.Object ssmAutomation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ssmAutomation = software.amazon.jsii.Kernel.get(this, "ssmAutomation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ssmAutomation = builder.ssmAutomation;
            }

            @Override
            public final java.lang.Object getSsmAutomation() {
                return this.ssmAutomation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSsmAutomation() != null) {
                    data.set("ssmAutomation", om.valueToTree(this.getSsmAutomation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmincidents.CfnResponsePlan.ActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionProperty.Jsii$Proxy that = (ActionProperty.Jsii$Proxy) o;

                return this.ssmAutomation != null ? this.ssmAutomation.equals(that.ssmAutomation) : that.ssmAutomation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ssmAutomation != null ? this.ssmAutomation.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The AWS Chatbot chat channel used for collaboration during an incident.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmincidents.*;
     * ChatChannelProperty chatChannelProperty = ChatChannelProperty.builder()
     *         .chatbotSns(List.of("chatbotSns"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmincidents.CfnResponsePlan.ChatChannelProperty")
    @software.amazon.jsii.Jsii.Proxy(ChatChannelProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ChatChannelProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The SNS targets that AWS Chatbot uses to notify the chat channel of updates to an incident.
         * <p>
         * You can also make updates to the incident through the chat channel by using the SNS topics
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getChatbotSns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ChatChannelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ChatChannelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ChatChannelProperty> {
            java.util.List<java.lang.String> chatbotSns;

            /**
             * Sets the value of {@link ChatChannelProperty#getChatbotSns}
             * @param chatbotSns The SNS targets that AWS Chatbot uses to notify the chat channel of updates to an incident.
             *                   You can also make updates to the incident through the chat channel by using the SNS topics
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder chatbotSns(java.util.List<java.lang.String> chatbotSns) {
                this.chatbotSns = chatbotSns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ChatChannelProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ChatChannelProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ChatChannelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChatChannelProperty {
            private final java.util.List<java.lang.String> chatbotSns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.chatbotSns = software.amazon.jsii.Kernel.get(this, "chatbotSns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.chatbotSns = builder.chatbotSns;
            }

            @Override
            public final java.util.List<java.lang.String> getChatbotSns() {
                return this.chatbotSns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getChatbotSns() != null) {
                    data.set("chatbotSns", om.valueToTree(this.getChatbotSns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmincidents.CfnResponsePlan.ChatChannelProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ChatChannelProperty.Jsii$Proxy that = (ChatChannelProperty.Jsii$Proxy) o;

                return this.chatbotSns != null ? this.chatbotSns.equals(that.chatbotSns) : that.chatbotSns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.chatbotSns != null ? this.chatbotSns.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmincidents.*;
     * DynamicSsmParameterProperty dynamicSsmParameterProperty = DynamicSsmParameterProperty.builder()
     *         .key("key")
     *         .value(DynamicSsmParameterValueProperty.builder()
     *                 .variable("variable")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmincidents.CfnResponsePlan.DynamicSsmParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(DynamicSsmParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynamicSsmParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnResponsePlan.DynamicSsmParameterProperty.Key`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * `CfnResponsePlan.DynamicSsmParameterProperty.Value`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValue();

        /**
         * @return a {@link Builder} of {@link DynamicSsmParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynamicSsmParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynamicSsmParameterProperty> {
            java.lang.String key;
            java.lang.Object value;

            /**
             * Sets the value of {@link DynamicSsmParameterProperty#getKey}
             * @param key `CfnResponsePlan.DynamicSsmParameterProperty.Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link DynamicSsmParameterProperty#getValue}
             * @param value `CfnResponsePlan.DynamicSsmParameterProperty.Value`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.services.ssmincidents.CfnResponsePlan.DynamicSsmParameterValueProperty value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link DynamicSsmParameterProperty#getValue}
             * @param value `CfnResponsePlan.DynamicSsmParameterProperty.Value`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamicSsmParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynamicSsmParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynamicSsmParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamicSsmParameterProperty {
            private final java.lang.String key;
            private final java.lang.Object value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmincidents.CfnResponsePlan.DynamicSsmParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynamicSsmParameterProperty.Jsii$Proxy that = (DynamicSsmParameterProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmincidents.*;
     * DynamicSsmParameterValueProperty dynamicSsmParameterValueProperty = DynamicSsmParameterValueProperty.builder()
     *         .variable("variable")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmincidents.CfnResponsePlan.DynamicSsmParameterValueProperty")
    @software.amazon.jsii.Jsii.Proxy(DynamicSsmParameterValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynamicSsmParameterValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnResponsePlan.DynamicSsmParameterValueProperty.Variable`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVariable() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DynamicSsmParameterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynamicSsmParameterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynamicSsmParameterValueProperty> {
            java.lang.String variable;

            /**
             * Sets the value of {@link DynamicSsmParameterValueProperty#getVariable}
             * @param variable `CfnResponsePlan.DynamicSsmParameterValueProperty.Variable`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variable(java.lang.String variable) {
                this.variable = variable;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamicSsmParameterValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynamicSsmParameterValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynamicSsmParameterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamicSsmParameterValueProperty {
            private final java.lang.String variable;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.variable = software.amazon.jsii.Kernel.get(this, "variable", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.variable = builder.variable;
            }

            @Override
            public final java.lang.String getVariable() {
                return this.variable;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getVariable() != null) {
                    data.set("variable", om.valueToTree(this.getVariable()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmincidents.CfnResponsePlan.DynamicSsmParameterValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynamicSsmParameterValueProperty.Jsii$Proxy that = (DynamicSsmParameterValueProperty.Jsii$Proxy) o;

                return this.variable != null ? this.variable.equals(that.variable) : that.variable == null;
            }

            @Override
            public final int hashCode() {
                int result = this.variable != null ? this.variable.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The `IncidentTemplate` property type specifies details used to create an incident when using this response plan.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmincidents.*;
     * IncidentTemplateProperty incidentTemplateProperty = IncidentTemplateProperty.builder()
     *         .impact(123)
     *         .title("title")
     *         // the properties below are optional
     *         .dedupeString("dedupeString")
     *         .incidentTags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .notificationTargets(List.of(NotificationTargetItemProperty.builder()
     *                 .snsTopicArn("snsTopicArn")
     *                 .build()))
     *         .summary("summary")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmincidents.CfnResponsePlan.IncidentTemplateProperty")
    @software.amazon.jsii.Jsii.Proxy(IncidentTemplateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IncidentTemplateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the impact to the customers. Providing an impact overwrites the impact provided by a response plan.
         * <p>
         * <strong>Possible impacts:</strong> - <code>1</code> - Critical impact, this typically relates to full application failure that impacts many to all customers.
         * <p>
         * <ul>
         * <li><code>2</code> - High impact, partial application failure with impact to many customers.</li>
         * <li><code>3</code> - Medium impact, the application is providing reduced service to customers.</li>
         * <li><code>4</code> - Low impact, customer might aren't impacted by the problem yet.</li>
         * <li><code>5</code> - No impact, customers aren't currently impacted but urgent action is needed to avoid impact.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getImpact();

        /**
         * The title of the incident is a brief and easily recognizable.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTitle();

        /**
         * Used to create only one incident record for an incident.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDedupeString() {
            return null;
        }

        /**
         * `CfnResponsePlan.IncidentTemplateProperty.IncidentTags`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncidentTags() {
            return null;
        }

        /**
         * The SNS targets that AWS Chatbot uses to notify the chat channel of updates to an incident.
         * <p>
         * You can also make updates to the incident through the chat channel using the SNS topics.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNotificationTargets() {
            return null;
        }

        /**
         * The summary describes what has happened during the incident.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSummary() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IncidentTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IncidentTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IncidentTemplateProperty> {
            java.lang.Number impact;
            java.lang.String title;
            java.lang.String dedupeString;
            java.lang.Object incidentTags;
            java.lang.Object notificationTargets;
            java.lang.String summary;

            /**
             * Sets the value of {@link IncidentTemplateProperty#getImpact}
             * @param impact Defines the impact to the customers. Providing an impact overwrites the impact provided by a response plan. This parameter is required.
             *               <strong>Possible impacts:</strong> - <code>1</code> - Critical impact, this typically relates to full application failure that impacts many to all customers.
             *               <p>
             *               <ul>
             *               <li><code>2</code> - High impact, partial application failure with impact to many customers.</li>
             *               <li><code>3</code> - Medium impact, the application is providing reduced service to customers.</li>
             *               <li><code>4</code> - Low impact, customer might aren't impacted by the problem yet.</li>
             *               <li><code>5</code> - No impact, customers aren't currently impacted but urgent action is needed to avoid impact.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder impact(java.lang.Number impact) {
                this.impact = impact;
                return this;
            }

            /**
             * Sets the value of {@link IncidentTemplateProperty#getTitle}
             * @param title The title of the incident is a brief and easily recognizable. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(java.lang.String title) {
                this.title = title;
                return this;
            }

            /**
             * Sets the value of {@link IncidentTemplateProperty#getDedupeString}
             * @param dedupeString Used to create only one incident record for an incident.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dedupeString(java.lang.String dedupeString) {
                this.dedupeString = dedupeString;
                return this;
            }

            /**
             * Sets the value of {@link IncidentTemplateProperty#getIncidentTags}
             * @param incidentTags `CfnResponsePlan.IncidentTemplateProperty.IncidentTags`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder incidentTags(software.amazon.awscdk.IResolvable incidentTags) {
                this.incidentTags = incidentTags;
                return this;
            }

            /**
             * Sets the value of {@link IncidentTemplateProperty#getIncidentTags}
             * @param incidentTags `CfnResponsePlan.IncidentTemplateProperty.IncidentTags`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder incidentTags(java.util.List<? extends java.lang.Object> incidentTags) {
                this.incidentTags = incidentTags;
                return this;
            }

            /**
             * Sets the value of {@link IncidentTemplateProperty#getNotificationTargets}
             * @param notificationTargets The SNS targets that AWS Chatbot uses to notify the chat channel of updates to an incident.
             *                            You can also make updates to the incident through the chat channel using the SNS topics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notificationTargets(software.amazon.awscdk.IResolvable notificationTargets) {
                this.notificationTargets = notificationTargets;
                return this;
            }

            /**
             * Sets the value of {@link IncidentTemplateProperty#getNotificationTargets}
             * @param notificationTargets The SNS targets that AWS Chatbot uses to notify the chat channel of updates to an incident.
             *                            You can also make updates to the incident through the chat channel using the SNS topics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notificationTargets(java.util.List<? extends java.lang.Object> notificationTargets) {
                this.notificationTargets = notificationTargets;
                return this;
            }

            /**
             * Sets the value of {@link IncidentTemplateProperty#getSummary}
             * @param summary The summary describes what has happened during the incident.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder summary(java.lang.String summary) {
                this.summary = summary;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IncidentTemplateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IncidentTemplateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IncidentTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IncidentTemplateProperty {
            private final java.lang.Number impact;
            private final java.lang.String title;
            private final java.lang.String dedupeString;
            private final java.lang.Object incidentTags;
            private final java.lang.Object notificationTargets;
            private final java.lang.String summary;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.impact = software.amazon.jsii.Kernel.get(this, "impact", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dedupeString = software.amazon.jsii.Kernel.get(this, "dedupeString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.incidentTags = software.amazon.jsii.Kernel.get(this, "incidentTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.notificationTargets = software.amazon.jsii.Kernel.get(this, "notificationTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.summary = software.amazon.jsii.Kernel.get(this, "summary", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.impact = java.util.Objects.requireNonNull(builder.impact, "impact is required");
                this.title = java.util.Objects.requireNonNull(builder.title, "title is required");
                this.dedupeString = builder.dedupeString;
                this.incidentTags = builder.incidentTags;
                this.notificationTargets = builder.notificationTargets;
                this.summary = builder.summary;
            }

            @Override
            public final java.lang.Number getImpact() {
                return this.impact;
            }

            @Override
            public final java.lang.String getTitle() {
                return this.title;
            }

            @Override
            public final java.lang.String getDedupeString() {
                return this.dedupeString;
            }

            @Override
            public final java.lang.Object getIncidentTags() {
                return this.incidentTags;
            }

            @Override
            public final java.lang.Object getNotificationTargets() {
                return this.notificationTargets;
            }

            @Override
            public final java.lang.String getSummary() {
                return this.summary;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("impact", om.valueToTree(this.getImpact()));
                data.set("title", om.valueToTree(this.getTitle()));
                if (this.getDedupeString() != null) {
                    data.set("dedupeString", om.valueToTree(this.getDedupeString()));
                }
                if (this.getIncidentTags() != null) {
                    data.set("incidentTags", om.valueToTree(this.getIncidentTags()));
                }
                if (this.getNotificationTargets() != null) {
                    data.set("notificationTargets", om.valueToTree(this.getNotificationTargets()));
                }
                if (this.getSummary() != null) {
                    data.set("summary", om.valueToTree(this.getSummary()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmincidents.CfnResponsePlan.IncidentTemplateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IncidentTemplateProperty.Jsii$Proxy that = (IncidentTemplateProperty.Jsii$Proxy) o;

                if (!impact.equals(that.impact)) return false;
                if (!title.equals(that.title)) return false;
                if (this.dedupeString != null ? !this.dedupeString.equals(that.dedupeString) : that.dedupeString != null) return false;
                if (this.incidentTags != null ? !this.incidentTags.equals(that.incidentTags) : that.incidentTags != null) return false;
                if (this.notificationTargets != null ? !this.notificationTargets.equals(that.notificationTargets) : that.notificationTargets != null) return false;
                return this.summary != null ? this.summary.equals(that.summary) : that.summary == null;
            }

            @Override
            public final int hashCode() {
                int result = this.impact.hashCode();
                result = 31 * result + (this.title.hashCode());
                result = 31 * result + (this.dedupeString != null ? this.dedupeString.hashCode() : 0);
                result = 31 * result + (this.incidentTags != null ? this.incidentTags.hashCode() : 0);
                result = 31 * result + (this.notificationTargets != null ? this.notificationTargets.hashCode() : 0);
                result = 31 * result + (this.summary != null ? this.summary.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The SNS topic that's used by AWS Chatbot to notify the incidents chat channel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmincidents.*;
     * NotificationTargetItemProperty notificationTargetItemProperty = NotificationTargetItemProperty.builder()
     *         .snsTopicArn("snsTopicArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmincidents.CfnResponsePlan.NotificationTargetItemProperty")
    @software.amazon.jsii.Jsii.Proxy(NotificationTargetItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotificationTargetItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the SNS topic.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSnsTopicArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NotificationTargetItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotificationTargetItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotificationTargetItemProperty> {
            java.lang.String snsTopicArn;

            /**
             * Sets the value of {@link NotificationTargetItemProperty#getSnsTopicArn}
             * @param snsTopicArn The Amazon Resource Name (ARN) of the SNS topic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsTopicArn(java.lang.String snsTopicArn) {
                this.snsTopicArn = snsTopicArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationTargetItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotificationTargetItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NotificationTargetItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationTargetItemProperty {
            private final java.lang.String snsTopicArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.snsTopicArn = software.amazon.jsii.Kernel.get(this, "snsTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.snsTopicArn = builder.snsTopicArn;
            }

            @Override
            public final java.lang.String getSnsTopicArn() {
                return this.snsTopicArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSnsTopicArn() != null) {
                    data.set("snsTopicArn", om.valueToTree(this.getSnsTopicArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmincidents.CfnResponsePlan.NotificationTargetItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotificationTargetItemProperty.Jsii$Proxy that = (NotificationTargetItemProperty.Jsii$Proxy) o;

                return this.snsTopicArn != null ? this.snsTopicArn.equals(that.snsTopicArn) : that.snsTopicArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.snsTopicArn != null ? this.snsTopicArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The `SsmAutomation` property type specifies details about the Systems Manager automation document that will be used as a runbook during an incident.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmincidents.*;
     * SsmAutomationProperty ssmAutomationProperty = SsmAutomationProperty.builder()
     *         .documentName("documentName")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .documentVersion("documentVersion")
     *         .dynamicParameters(List.of(DynamicSsmParameterProperty.builder()
     *                 .key("key")
     *                 .value(DynamicSsmParameterValueProperty.builder()
     *                         .variable("variable")
     *                         .build())
     *                 .build()))
     *         .parameters(List.of(SsmParameterProperty.builder()
     *                 .key("key")
     *                 .values(List.of("values"))
     *                 .build()))
     *         .targetAccount("targetAccount")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmincidents.CfnResponsePlan.SsmAutomationProperty")
    @software.amazon.jsii.Jsii.Proxy(SsmAutomationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SsmAutomationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The automation document's name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDocumentName();

        /**
         * The Amazon Resource Name (ARN) of the role that the automation document will assume when running commands.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The automation document's version to use when running.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentVersion() {
            return null;
        }

        /**
         * `CfnResponsePlan.SsmAutomationProperty.DynamicParameters`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamicParameters() {
            return null;
        }

        /**
         * The key-value pair parameters to use when running the automation document.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * The account that the automation document will be run in.
         * <p>
         * This can be in either the management account or an application account.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetAccount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SsmAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SsmAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SsmAutomationProperty> {
            java.lang.String documentName;
            java.lang.String roleArn;
            java.lang.String documentVersion;
            java.lang.Object dynamicParameters;
            java.lang.Object parameters;
            java.lang.String targetAccount;

            /**
             * Sets the value of {@link SsmAutomationProperty#getDocumentName}
             * @param documentName The automation document's name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentName(java.lang.String documentName) {
                this.documentName = documentName;
                return this;
            }

            /**
             * Sets the value of {@link SsmAutomationProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the role that the automation document will assume when running commands. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link SsmAutomationProperty#getDocumentVersion}
             * @param documentVersion The automation document's version to use when running.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentVersion(java.lang.String documentVersion) {
                this.documentVersion = documentVersion;
                return this;
            }

            /**
             * Sets the value of {@link SsmAutomationProperty#getDynamicParameters}
             * @param dynamicParameters `CfnResponsePlan.SsmAutomationProperty.DynamicParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamicParameters(software.amazon.awscdk.IResolvable dynamicParameters) {
                this.dynamicParameters = dynamicParameters;
                return this;
            }

            /**
             * Sets the value of {@link SsmAutomationProperty#getDynamicParameters}
             * @param dynamicParameters `CfnResponsePlan.SsmAutomationProperty.DynamicParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamicParameters(java.util.List<? extends java.lang.Object> dynamicParameters) {
                this.dynamicParameters = dynamicParameters;
                return this;
            }

            /**
             * Sets the value of {@link SsmAutomationProperty#getParameters}
             * @param parameters The key-value pair parameters to use when running the automation document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link SsmAutomationProperty#getParameters}
             * @param parameters The key-value pair parameters to use when running the automation document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.util.List<? extends java.lang.Object> parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link SsmAutomationProperty#getTargetAccount}
             * @param targetAccount The account that the automation document will be run in.
             *                      This can be in either the management account or an application account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetAccount(java.lang.String targetAccount) {
                this.targetAccount = targetAccount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SsmAutomationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SsmAutomationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SsmAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SsmAutomationProperty {
            private final java.lang.String documentName;
            private final java.lang.String roleArn;
            private final java.lang.String documentVersion;
            private final java.lang.Object dynamicParameters;
            private final java.lang.Object parameters;
            private final java.lang.String targetAccount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.documentName = software.amazon.jsii.Kernel.get(this, "documentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.documentVersion = software.amazon.jsii.Kernel.get(this, "documentVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dynamicParameters = software.amazon.jsii.Kernel.get(this, "dynamicParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.targetAccount = software.amazon.jsii.Kernel.get(this, "targetAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.documentName = java.util.Objects.requireNonNull(builder.documentName, "documentName is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.documentVersion = builder.documentVersion;
                this.dynamicParameters = builder.dynamicParameters;
                this.parameters = builder.parameters;
                this.targetAccount = builder.targetAccount;
            }

            @Override
            public final java.lang.String getDocumentName() {
                return this.documentName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getDocumentVersion() {
                return this.documentVersion;
            }

            @Override
            public final java.lang.Object getDynamicParameters() {
                return this.dynamicParameters;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            public final java.lang.String getTargetAccount() {
                return this.targetAccount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("documentName", om.valueToTree(this.getDocumentName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getDocumentVersion() != null) {
                    data.set("documentVersion", om.valueToTree(this.getDocumentVersion()));
                }
                if (this.getDynamicParameters() != null) {
                    data.set("dynamicParameters", om.valueToTree(this.getDynamicParameters()));
                }
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }
                if (this.getTargetAccount() != null) {
                    data.set("targetAccount", om.valueToTree(this.getTargetAccount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmincidents.CfnResponsePlan.SsmAutomationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SsmAutomationProperty.Jsii$Proxy that = (SsmAutomationProperty.Jsii$Proxy) o;

                if (!documentName.equals(that.documentName)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (this.documentVersion != null ? !this.documentVersion.equals(that.documentVersion) : that.documentVersion != null) return false;
                if (this.dynamicParameters != null ? !this.dynamicParameters.equals(that.dynamicParameters) : that.dynamicParameters != null) return false;
                if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
                return this.targetAccount != null ? this.targetAccount.equals(that.targetAccount) : that.targetAccount == null;
            }

            @Override
            public final int hashCode() {
                int result = this.documentName.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.documentVersion != null ? this.documentVersion.hashCode() : 0);
                result = 31 * result + (this.dynamicParameters != null ? this.dynamicParameters.hashCode() : 0);
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                result = 31 * result + (this.targetAccount != null ? this.targetAccount.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The key-value pair parameters to use when running the automation document.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmincidents.*;
     * SsmParameterProperty ssmParameterProperty = SsmParameterProperty.builder()
     *         .key("key")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmincidents.CfnResponsePlan.SsmParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(SsmParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SsmParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key parameter to use when running the automation document.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value parameter to use when running the automation document.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link SsmParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SsmParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SsmParameterProperty> {
            java.lang.String key;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link SsmParameterProperty#getKey}
             * @param key The key parameter to use when running the automation document. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link SsmParameterProperty#getValues}
             * @param values The value parameter to use when running the automation document. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SsmParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SsmParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SsmParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SsmParameterProperty {
            private final java.lang.String key;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmincidents.CfnResponsePlan.SsmParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SsmParameterProperty.Jsii$Proxy that = (SsmParameterProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ssmincidents.CfnResponsePlan}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ssmincidents.CfnResponsePlan> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ssmincidents.CfnResponsePlanProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ssmincidents.CfnResponsePlanProps.Builder();
        }

        /**
         * Details used to create an incident when using this response plan.
         * <p>
         * @return {@code this}
         * @param incidentTemplate Details used to create an incident when using this response plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder incidentTemplate(final software.amazon.awscdk.services.ssmincidents.CfnResponsePlan.IncidentTemplateProperty incidentTemplate) {
            this.props.incidentTemplate(incidentTemplate);
            return this;
        }
        /**
         * Details used to create an incident when using this response plan.
         * <p>
         * @return {@code this}
         * @param incidentTemplate Details used to create an incident when using this response plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder incidentTemplate(final software.amazon.awscdk.IResolvable incidentTemplate) {
            this.props.incidentTemplate(incidentTemplate);
            return this;
        }

        /**
         * The name of the response plan.
         * <p>
         * @return {@code this}
         * @param name The name of the response plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The actions that the response plan starts at the beginning of an incident.
         * <p>
         * @return {@code this}
         * @param actions The actions that the response plan starts at the beginning of an incident. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final software.amazon.awscdk.IResolvable actions) {
            this.props.actions(actions);
            return this;
        }
        /**
         * The actions that the response plan starts at the beginning of an incident.
         * <p>
         * @return {@code this}
         * @param actions The actions that the response plan starts at the beginning of an incident. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final java.util.List<? extends java.lang.Object> actions) {
            this.props.actions(actions);
            return this;
        }

        /**
         * The AWS Chatbot chat channel used for collaboration during an incident.
         * <p>
         * @return {@code this}
         * @param chatChannel The AWS Chatbot chat channel used for collaboration during an incident. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder chatChannel(final software.amazon.awscdk.services.ssmincidents.CfnResponsePlan.ChatChannelProperty chatChannel) {
            this.props.chatChannel(chatChannel);
            return this;
        }
        /**
         * The AWS Chatbot chat channel used for collaboration during an incident.
         * <p>
         * @return {@code this}
         * @param chatChannel The AWS Chatbot chat channel used for collaboration during an incident. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder chatChannel(final software.amazon.awscdk.IResolvable chatChannel) {
            this.props.chatChannel(chatChannel);
            return this;
        }

        /**
         * The human readable name of the response plan.
         * <p>
         * @return {@code this}
         * @param displayName The human readable name of the response plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.props.displayName(displayName);
            return this;
        }

        /**
         * The contacts and escalation plans that the response plan engages during an incident.
         * <p>
         * @return {@code this}
         * @param engagements The contacts and escalation plans that the response plan engages during an incident. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engagements(final java.util.List<java.lang.String> engagements) {
            this.props.engagements(engagements);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ssmincidents.CfnResponsePlan}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ssmincidents.CfnResponsePlan build() {
            return new software.amazon.awscdk.services.ssmincidents.CfnResponsePlan(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
