/**
 * <h1>Amazon Simple Queue Service Construct Library</h1>
 * <p>
 * Amazon Simple Queue Service (SQS) is a fully managed message queuing service that
 * enables you to decouple and scale microservices, distributed systems, and serverless
 * applications. SQS eliminates the complexity and overhead associated with managing and
 * operating message oriented middleware, and empowers developers to focus on differentiating work.
 * Using SQS, you can send, store, and receive messages between software components at any volume,
 * without losing messages or requiring other services to be available.
 * <p>
 * <h2>Installation</h2>
 * <p>
 * Import to your project:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.sqs.*;
 * </pre></blockquote>
 * <p>
 * <h2>Basic usage</h2>
 * <p>
 * Here's how to add a basic queue to your application:
 * <p>
 * <blockquote><pre>
 * new Queue(this, "Queue");
 * </pre></blockquote>
 * <p>
 * <h2>Encryption</h2>
 * <p>
 * By default queues are encrypted using SSE-SQS. If you want to change the encryption mode, set the <code>encryption</code> property.
 * The following encryption modes are supported:
 * <p>
 * <ul>
 * <li>KMS key that SQS manages for you</li>
 * <li>KMS key that you can managed yourself</li>
 * <li>Server-side encryption managed by SQS (SSE-SQS)</li>
 * <li>Unencrypted</li>
 * </ul>
 * <p>
 * To learn more about SSE-SQS on Amazon SQS, please visit the
 * <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html">Amazon SQS documentation</a>.
 * <p>
 * <blockquote><pre>
 * // Use managed key
 * // Use managed key
 * Queue.Builder.create(this, "Queue")
 *         .encryption(QueueEncryption.KMS_MANAGED)
 *         .build();
 * 
 * // Use custom key
 * Key myKey = new Key(this, "Key");
 * 
 * Queue.Builder.create(this, "Queue")
 *         .encryption(QueueEncryption.KMS)
 *         .encryptionMasterKey(myKey)
 *         .build();
 * 
 * // Use SQS managed server side encryption (SSE-SQS)
 * // Use SQS managed server side encryption (SSE-SQS)
 * Queue.Builder.create(this, "Queue")
 *         .encryption(QueueEncryption.SQS_MANAGED)
 *         .build();
 * 
 * // Unencrypted queue
 * // Unencrypted queue
 * Queue.Builder.create(this, "Queue")
 *         .encryption(QueueEncryption.UNENCRYPTED)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Encryption in transit</h2>
 * <p>
 * If you want to enforce encryption of data in transit, set the <code>enforceSSL</code> property to <code>true</code>.
 * A resource policy statement that allows only encrypted connections over HTTPS (TLS)
 * will be added to the queue.
 * <p>
 * <blockquote><pre>
 * Queue.Builder.create(this, "Queue")
 *         .enforceSSL(true)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>First-In-First-Out (FIFO) queues</h2>
 * <p>
 * FIFO queues give guarantees on the order in which messages are dequeued, and have additional
 * features in order to help guarantee exactly-once processing. For more information, see
 * the SQS manual. Note that FIFO queues are not available in all AWS regions.
 * <p>
 * A queue can be made a FIFO queue by either setting <code>fifo: true</code>, giving it a name which ends
 * in <code>".fifo"</code>, or by enabling a FIFO specific feature such as: content-based deduplication,
 * deduplication scope or fifo throughput limit.
 */
package software.amazon.awscdk.services.sqs;
