package software.amazon.awscdk.services.ses;

/**
 * TLS policy for a configuration set.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IDedicatedIpPool myPool;
 * ConfigurationSet.Builder.create(this, "ConfigurationSet")
 *         .customTrackingRedirectDomain("track.cdk.dev")
 *         .suppressionReasons(SuppressionReasons.COMPLAINTS_ONLY)
 *         .tlsPolicy(ConfigurationSetTlsPolicy.REQUIRE)
 *         .dedicatedIpPool(myPool)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:15.000Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.ConfigurationSetTlsPolicy")
public enum ConfigurationSetTlsPolicy {
    /**
     * Messages are only delivered if a TLS connection can be established.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REQUIRE,
    /**
     * Messages can be delivered in plain text if a TLS connection can't be established.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OPTIONAL,
}
