package software.amazon.awscdk.services.ses;

/**
 * A CloudFormation `AWS::SES::VdmAttributes`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * CfnVdmAttributes cfnVdmAttributes = CfnVdmAttributes.Builder.create(this, "MyCfnVdmAttributes")
 *         .dashboardAttributes(DashboardAttributesProperty.builder()
 *                 .engagementMetrics("engagementMetrics")
 *                 .build())
 *         .guardianAttributes(GuardianAttributesProperty.builder()
 *                 .optimizedSharedDelivery("optimizedSharedDelivery")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:14.998Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnVdmAttributes")
public class CfnVdmAttributes extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnVdmAttributes(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnVdmAttributes(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ses.CfnVdmAttributes.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SES::VdmAttributes`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnVdmAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnVdmAttributesProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::SES::VdmAttributes`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnVdmAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVdmAttributesResourceId() {
        return software.amazon.jsii.Kernel.get(this, "attrVdmAttributesResourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::SES::VdmAttributes.DashboardAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDashboardAttributes() {
        return software.amazon.jsii.Kernel.get(this, "dashboardAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SES::VdmAttributes.DashboardAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDashboardAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnVdmAttributes.DashboardAttributesProperty value) {
        software.amazon.jsii.Kernel.set(this, "dashboardAttributes", value);
    }

    /**
     * `AWS::SES::VdmAttributes.DashboardAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDashboardAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dashboardAttributes", value);
    }

    /**
     * `AWS::SES::VdmAttributes.GuardianAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGuardianAttributes() {
        return software.amazon.jsii.Kernel.get(this, "guardianAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SES::VdmAttributes.GuardianAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGuardianAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnVdmAttributes.GuardianAttributesProperty value) {
        software.amazon.jsii.Kernel.set(this, "guardianAttributes", value);
    }

    /**
     * `AWS::SES::VdmAttributes.GuardianAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGuardianAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "guardianAttributes", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * DashboardAttributesProperty dashboardAttributesProperty = DashboardAttributesProperty.builder()
     *         .engagementMetrics("engagementMetrics")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnVdmAttributes.DashboardAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(DashboardAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashboardAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnVdmAttributes.DashboardAttributesProperty.EngagementMetrics`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEngagementMetrics() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DashboardAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashboardAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashboardAttributesProperty> {
            java.lang.String engagementMetrics;

            /**
             * Sets the value of {@link DashboardAttributesProperty#getEngagementMetrics}
             * @param engagementMetrics `CfnVdmAttributes.DashboardAttributesProperty.EngagementMetrics`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder engagementMetrics(java.lang.String engagementMetrics) {
                this.engagementMetrics = engagementMetrics;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashboardAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashboardAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashboardAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashboardAttributesProperty {
            private final java.lang.String engagementMetrics;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.engagementMetrics = software.amazon.jsii.Kernel.get(this, "engagementMetrics", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.engagementMetrics = builder.engagementMetrics;
            }

            @Override
            public final java.lang.String getEngagementMetrics() {
                return this.engagementMetrics;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEngagementMetrics() != null) {
                    data.set("engagementMetrics", om.valueToTree(this.getEngagementMetrics()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnVdmAttributes.DashboardAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashboardAttributesProperty.Jsii$Proxy that = (DashboardAttributesProperty.Jsii$Proxy) o;

                return this.engagementMetrics != null ? this.engagementMetrics.equals(that.engagementMetrics) : that.engagementMetrics == null;
            }

            @Override
            public final int hashCode() {
                int result = this.engagementMetrics != null ? this.engagementMetrics.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * GuardianAttributesProperty guardianAttributesProperty = GuardianAttributesProperty.builder()
     *         .optimizedSharedDelivery("optimizedSharedDelivery")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnVdmAttributes.GuardianAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(GuardianAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GuardianAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnVdmAttributes.GuardianAttributesProperty.OptimizedSharedDelivery`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOptimizedSharedDelivery() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GuardianAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GuardianAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GuardianAttributesProperty> {
            java.lang.String optimizedSharedDelivery;

            /**
             * Sets the value of {@link GuardianAttributesProperty#getOptimizedSharedDelivery}
             * @param optimizedSharedDelivery `CfnVdmAttributes.GuardianAttributesProperty.OptimizedSharedDelivery`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optimizedSharedDelivery(java.lang.String optimizedSharedDelivery) {
                this.optimizedSharedDelivery = optimizedSharedDelivery;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GuardianAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GuardianAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GuardianAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GuardianAttributesProperty {
            private final java.lang.String optimizedSharedDelivery;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.optimizedSharedDelivery = software.amazon.jsii.Kernel.get(this, "optimizedSharedDelivery", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.optimizedSharedDelivery = builder.optimizedSharedDelivery;
            }

            @Override
            public final java.lang.String getOptimizedSharedDelivery() {
                return this.optimizedSharedDelivery;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOptimizedSharedDelivery() != null) {
                    data.set("optimizedSharedDelivery", om.valueToTree(this.getOptimizedSharedDelivery()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnVdmAttributes.GuardianAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GuardianAttributesProperty.Jsii$Proxy that = (GuardianAttributesProperty.Jsii$Proxy) o;

                return this.optimizedSharedDelivery != null ? this.optimizedSharedDelivery.equals(that.optimizedSharedDelivery) : that.optimizedSharedDelivery == null;
            }

            @Override
            public final int hashCode() {
                int result = this.optimizedSharedDelivery != null ? this.optimizedSharedDelivery.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.CfnVdmAttributes}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.CfnVdmAttributes> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ses.CfnVdmAttributesProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * `AWS::SES::VdmAttributes.DashboardAttributes`.
         * <p>
         * @return {@code this}
         * @param dashboardAttributes `AWS::SES::VdmAttributes.DashboardAttributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashboardAttributes(final software.amazon.awscdk.services.ses.CfnVdmAttributes.DashboardAttributesProperty dashboardAttributes) {
            this.props().dashboardAttributes(dashboardAttributes);
            return this;
        }
        /**
         * `AWS::SES::VdmAttributes.DashboardAttributes`.
         * <p>
         * @return {@code this}
         * @param dashboardAttributes `AWS::SES::VdmAttributes.DashboardAttributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashboardAttributes(final software.amazon.awscdk.IResolvable dashboardAttributes) {
            this.props().dashboardAttributes(dashboardAttributes);
            return this;
        }

        /**
         * `AWS::SES::VdmAttributes.GuardianAttributes`.
         * <p>
         * @return {@code this}
         * @param guardianAttributes `AWS::SES::VdmAttributes.GuardianAttributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder guardianAttributes(final software.amazon.awscdk.services.ses.CfnVdmAttributes.GuardianAttributesProperty guardianAttributes) {
            this.props().guardianAttributes(guardianAttributes);
            return this;
        }
        /**
         * `AWS::SES::VdmAttributes.GuardianAttributes`.
         * <p>
         * @return {@code this}
         * @param guardianAttributes `AWS::SES::VdmAttributes.GuardianAttributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder guardianAttributes(final software.amazon.awscdk.IResolvable guardianAttributes) {
            this.props().guardianAttributes(guardianAttributes);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ses.CfnVdmAttributes}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.CfnVdmAttributes build() {
            return new software.amazon.awscdk.services.ses.CfnVdmAttributes(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ses.CfnVdmAttributesProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ses.CfnVdmAttributesProps.Builder();
            }
            return this.props;
        }
    }
}
