package software.amazon.awscdk.services.ses;

/**
 * A CloudFormation `AWS::SES::ConfigurationSetEventDestination`.
 * <p>
 * Specifies a configuration set event destination. An event destination is an AWS service that Amazon SES publishes email sending events to. When you specify an event destination, you provide one, and only one, destination. You can send event data to Amazon CloudWatch or Amazon Kinesis Data Firehose.
 * <p>
 * <blockquote>
 * <p>
 * You can't specify Amazon SNS event destinations in CloudFormation templates.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * CfnConfigurationSetEventDestination cfnConfigurationSetEventDestination = CfnConfigurationSetEventDestination.Builder.create(this, "MyCfnConfigurationSetEventDestination")
 *         .configurationSetName("configurationSetName")
 *         .eventDestination(EventDestinationProperty.builder()
 *                 .matchingEventTypes(List.of("matchingEventTypes"))
 *                 // the properties below are optional
 *                 .cloudWatchDestination(CloudWatchDestinationProperty.builder()
 *                         .dimensionConfigurations(List.of(DimensionConfigurationProperty.builder()
 *                                 .defaultDimensionValue("defaultDimensionValue")
 *                                 .dimensionName("dimensionName")
 *                                 .dimensionValueSource("dimensionValueSource")
 *                                 .build()))
 *                         .build())
 *                 .enabled(false)
 *                 .kinesisFirehoseDestination(KinesisFirehoseDestinationProperty.builder()
 *                         .deliveryStreamArn("deliveryStreamArn")
 *                         .iamRoleArn("iamRoleArn")
 *                         .build())
 *                 .name("name")
 *                 .snsDestination(SnsDestinationProperty.builder()
 *                         .topicArn("topicArn")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:14.967Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination")
public class CfnConfigurationSetEventDestination extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnConfigurationSetEventDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfigurationSetEventDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SES::ConfigurationSetEventDestination`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfigurationSetEventDestination(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestinationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the configuration set that contains the event destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConfigurationSetName() {
        return software.amazon.jsii.Kernel.get(this, "configurationSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the configuration set that contains the event destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationSetName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "configurationSetName", java.util.Objects.requireNonNull(value, "configurationSetName is required"));
    }

    /**
     * The event destination object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getEventDestination() {
        return software.amazon.jsii.Kernel.get(this, "eventDestination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The event destination object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination.EventDestinationProperty value) {
        software.amazon.jsii.Kernel.set(this, "eventDestination", java.util.Objects.requireNonNull(value, "eventDestination is required"));
    }

    /**
     * The event destination object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "eventDestination", java.util.Objects.requireNonNull(value, "eventDestination is required"));
    }
    /**
     * Contains information associated with an Amazon CloudWatch event destination to which email sending events are published.
     * <p>
     * Event destinations, such as Amazon CloudWatch, are associated with configuration sets, which enable you to publish email sending events. For information about using configuration sets, see the <a href="https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html">Amazon SES Developer Guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * CloudWatchDestinationProperty cloudWatchDestinationProperty = CloudWatchDestinationProperty.builder()
     *         .dimensionConfigurations(List.of(DimensionConfigurationProperty.builder()
     *                 .defaultDimensionValue("defaultDimensionValue")
     *                 .dimensionName("dimensionName")
     *                 .dimensionValueSource("dimensionValueSource")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.CloudWatchDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon CloudWatch.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensionConfigurations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudWatchDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchDestinationProperty> {
            java.lang.Object dimensionConfigurations;

            /**
             * Sets the value of {@link CloudWatchDestinationProperty#getDimensionConfigurations}
             * @param dimensionConfigurations A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon CloudWatch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionConfigurations(software.amazon.awscdk.IResolvable dimensionConfigurations) {
                this.dimensionConfigurations = dimensionConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchDestinationProperty#getDimensionConfigurations}
             * @param dimensionConfigurations A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon CloudWatch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionConfigurations(java.util.List<? extends java.lang.Object> dimensionConfigurations) {
                this.dimensionConfigurations = dimensionConfigurations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchDestinationProperty {
            private final java.lang.Object dimensionConfigurations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensionConfigurations = software.amazon.jsii.Kernel.get(this, "dimensionConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensionConfigurations = builder.dimensionConfigurations;
            }

            @Override
            public final java.lang.Object getDimensionConfigurations() {
                return this.dimensionConfigurations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDimensionConfigurations() != null) {
                    data.set("dimensionConfigurations", om.valueToTree(this.getDimensionConfigurations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.CloudWatchDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchDestinationProperty.Jsii$Proxy that = (CloudWatchDestinationProperty.Jsii$Proxy) o;

                return this.dimensionConfigurations != null ? this.dimensionConfigurations.equals(that.dimensionConfigurations) : that.dimensionConfigurations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dimensionConfigurations != null ? this.dimensionConfigurations.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains the dimension configuration to use when you publish email sending events to Amazon CloudWatch.
     * <p>
     * For information about publishing email sending events to Amazon CloudWatch, see the <a href="https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html">Amazon SES Developer Guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * DimensionConfigurationProperty dimensionConfigurationProperty = DimensionConfigurationProperty.builder()
     *         .defaultDimensionValue("defaultDimensionValue")
     *         .dimensionName("dimensionName")
     *         .dimensionValueSource("dimensionValueSource")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.DimensionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DimensionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DimensionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default value of the dimension that is published to Amazon CloudWatch if you do not provide the value of the dimension when you send an email.
         * <p>
         * The default value must meet the following requirements:
         * <p>
         * <ul>
         * <li>Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), dashes (-), at signs (&#64;), or periods (.).</li>
         * <li>Contain 256 characters or fewer.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDefaultDimensionValue();

        /**
         * The name of an Amazon CloudWatch dimension associated with an email sending metric.
         * <p>
         * The name must meet the following requirements:
         * <p>
         * <ul>
         * <li>Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), dashes (-), or colons (:).</li>
         * <li>Contain 256 characters or fewer.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDimensionName();

        /**
         * The place where Amazon SES finds the value of a dimension to publish to Amazon CloudWatch.
         * <p>
         * To use the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header or a parameter to the <code>SendEmail</code> / <code>SendRawEmail</code> API, specify <code>messageTag</code> . To use your own email headers, specify <code>emailHeader</code> . To put a custom tag on any link included in your email, specify <code>linkTag</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDimensionValueSource();

        /**
         * @return a {@link Builder} of {@link DimensionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DimensionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DimensionConfigurationProperty> {
            java.lang.String defaultDimensionValue;
            java.lang.String dimensionName;
            java.lang.String dimensionValueSource;

            /**
             * Sets the value of {@link DimensionConfigurationProperty#getDefaultDimensionValue}
             * @param defaultDimensionValue The default value of the dimension that is published to Amazon CloudWatch if you do not provide the value of the dimension when you send an email. This parameter is required.
             *                              The default value must meet the following requirements:
             *                              <p>
             *                              <ul>
             *                              <li>Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), dashes (-), at signs (&#64;), or periods (.).</li>
             *                              <li>Contain 256 characters or fewer.</li>
             *                              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultDimensionValue(java.lang.String defaultDimensionValue) {
                this.defaultDimensionValue = defaultDimensionValue;
                return this;
            }

            /**
             * Sets the value of {@link DimensionConfigurationProperty#getDimensionName}
             * @param dimensionName The name of an Amazon CloudWatch dimension associated with an email sending metric. This parameter is required.
             *                      The name must meet the following requirements:
             *                      <p>
             *                      <ul>
             *                      <li>Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), dashes (-), or colons (:).</li>
             *                      <li>Contain 256 characters or fewer.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionName(java.lang.String dimensionName) {
                this.dimensionName = dimensionName;
                return this;
            }

            /**
             * Sets the value of {@link DimensionConfigurationProperty#getDimensionValueSource}
             * @param dimensionValueSource The place where Amazon SES finds the value of a dimension to publish to Amazon CloudWatch. This parameter is required.
             *                             To use the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header or a parameter to the <code>SendEmail</code> / <code>SendRawEmail</code> API, specify <code>messageTag</code> . To use your own email headers, specify <code>emailHeader</code> . To put a custom tag on any link included in your email, specify <code>linkTag</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionValueSource(java.lang.String dimensionValueSource) {
                this.dimensionValueSource = dimensionValueSource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DimensionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DimensionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DimensionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DimensionConfigurationProperty {
            private final java.lang.String defaultDimensionValue;
            private final java.lang.String dimensionName;
            private final java.lang.String dimensionValueSource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultDimensionValue = software.amazon.jsii.Kernel.get(this, "defaultDimensionValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dimensionName = software.amazon.jsii.Kernel.get(this, "dimensionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dimensionValueSource = software.amazon.jsii.Kernel.get(this, "dimensionValueSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultDimensionValue = java.util.Objects.requireNonNull(builder.defaultDimensionValue, "defaultDimensionValue is required");
                this.dimensionName = java.util.Objects.requireNonNull(builder.dimensionName, "dimensionName is required");
                this.dimensionValueSource = java.util.Objects.requireNonNull(builder.dimensionValueSource, "dimensionValueSource is required");
            }

            @Override
            public final java.lang.String getDefaultDimensionValue() {
                return this.defaultDimensionValue;
            }

            @Override
            public final java.lang.String getDimensionName() {
                return this.dimensionName;
            }

            @Override
            public final java.lang.String getDimensionValueSource() {
                return this.dimensionValueSource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultDimensionValue", om.valueToTree(this.getDefaultDimensionValue()));
                data.set("dimensionName", om.valueToTree(this.getDimensionName()));
                data.set("dimensionValueSource", om.valueToTree(this.getDimensionValueSource()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.DimensionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DimensionConfigurationProperty.Jsii$Proxy that = (DimensionConfigurationProperty.Jsii$Proxy) o;

                if (!defaultDimensionValue.equals(that.defaultDimensionValue)) return false;
                if (!dimensionName.equals(that.dimensionName)) return false;
                return this.dimensionValueSource.equals(that.dimensionValueSource);
            }

            @Override
            public final int hashCode() {
                int result = this.defaultDimensionValue.hashCode();
                result = 31 * result + (this.dimensionName.hashCode());
                result = 31 * result + (this.dimensionValueSource.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains information about an event destination.
     * <p>
     * <blockquote>
     * <p>
     * When you create or update an event destination, you must provide one, and only one, destination. The destination can be Amazon CloudWatch, Amazon Kinesis Firehose or Amazon Simple Notification Service (Amazon SNS).
     * <p>
     * </blockquote>
     * <p>
     * Event destinations are associated with configuration sets, which enable you to publish email sending events to Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS). For information about using configuration sets, see the <a href="https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html">Amazon SES Developer Guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * EventDestinationProperty eventDestinationProperty = EventDestinationProperty.builder()
     *         .matchingEventTypes(List.of("matchingEventTypes"))
     *         // the properties below are optional
     *         .cloudWatchDestination(CloudWatchDestinationProperty.builder()
     *                 .dimensionConfigurations(List.of(DimensionConfigurationProperty.builder()
     *                         .defaultDimensionValue("defaultDimensionValue")
     *                         .dimensionName("dimensionName")
     *                         .dimensionValueSource("dimensionValueSource")
     *                         .build()))
     *                 .build())
     *         .enabled(false)
     *         .kinesisFirehoseDestination(KinesisFirehoseDestinationProperty.builder()
     *                 .deliveryStreamArn("deliveryStreamArn")
     *                 .iamRoleArn("iamRoleArn")
     *                 .build())
     *         .name("name")
     *         .snsDestination(SnsDestinationProperty.builder()
     *                 .topicArn("topicArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.EventDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(EventDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of email sending events to publish to the event destination.
         * <p>
         * <ul>
         * <li><code>send</code> - The call was successful and Amazon SES is attempting to deliver the email.</li>
         * <li><code>reject</code> - Amazon SES determined that the email contained a virus and rejected it.</li>
         * <li><code>bounce</code> - The recipient's mail server permanently rejected the email. This corresponds to a hard bounce.</li>
         * <li><code>complaint</code> - The recipient marked the email as spam.</li>
         * <li><code>delivery</code> - Amazon SES successfully delivered the email to the recipient's mail server.</li>
         * <li><code>open</code> - The recipient received the email and opened it in their email client.</li>
         * <li><code>click</code> - The recipient clicked one or more links in the email.</li>
         * <li><code>renderingFailure</code> - Amazon SES did not send the email because of a template rendering issue.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getMatchingEventTypes();

        /**
         * An object that contains the names, default values, and sources of the dimensions associated with an Amazon CloudWatch event destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchDestination() {
            return null;
        }

        /**
         * Sets whether Amazon SES publishes events to this destination when you send an email with the associated configuration set.
         * <p>
         * Set to <code>true</code> to enable publishing to this destination; set to <code>false</code> to prevent publishing to this destination. The default value is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * An object that contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisFirehoseDestination() {
            return null;
        }

        /**
         * The name of the event destination. The name must meet the following requirements:.
         * <p>
         * <ul>
         * <li>Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</li>
         * <li>Contain 64 characters or fewer.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * `CfnConfigurationSetEventDestination.EventDestinationProperty.SnsDestination`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnsDestination() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventDestinationProperty> {
            java.util.List<java.lang.String> matchingEventTypes;
            java.lang.Object cloudWatchDestination;
            java.lang.Object enabled;
            java.lang.Object kinesisFirehoseDestination;
            java.lang.String name;
            java.lang.Object snsDestination;

            /**
             * Sets the value of {@link EventDestinationProperty#getMatchingEventTypes}
             * @param matchingEventTypes The type of email sending events to publish to the event destination. This parameter is required.
             *                           <ul>
             *                           <li><code>send</code> - The call was successful and Amazon SES is attempting to deliver the email.</li>
             *                           <li><code>reject</code> - Amazon SES determined that the email contained a virus and rejected it.</li>
             *                           <li><code>bounce</code> - The recipient's mail server permanently rejected the email. This corresponds to a hard bounce.</li>
             *                           <li><code>complaint</code> - The recipient marked the email as spam.</li>
             *                           <li><code>delivery</code> - Amazon SES successfully delivered the email to the recipient's mail server.</li>
             *                           <li><code>open</code> - The recipient received the email and opened it in their email client.</li>
             *                           <li><code>click</code> - The recipient clicked one or more links in the email.</li>
             *                           <li><code>renderingFailure</code> - Amazon SES did not send the email because of a template rendering issue.</li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchingEventTypes(java.util.List<java.lang.String> matchingEventTypes) {
                this.matchingEventTypes = matchingEventTypes;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getCloudWatchDestination}
             * @param cloudWatchDestination An object that contains the names, default values, and sources of the dimensions associated with an Amazon CloudWatch event destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchDestination(software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination.CloudWatchDestinationProperty cloudWatchDestination) {
                this.cloudWatchDestination = cloudWatchDestination;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getCloudWatchDestination}
             * @param cloudWatchDestination An object that contains the names, default values, and sources of the dimensions associated with an Amazon CloudWatch event destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchDestination(software.amazon.awscdk.IResolvable cloudWatchDestination) {
                this.cloudWatchDestination = cloudWatchDestination;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getEnabled}
             * @param enabled Sets whether Amazon SES publishes events to this destination when you send an email with the associated configuration set.
             *                Set to <code>true</code> to enable publishing to this destination; set to <code>false</code> to prevent publishing to this destination. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getEnabled}
             * @param enabled Sets whether Amazon SES publishes events to this destination when you send an email with the associated configuration set.
             *                Set to <code>true</code> to enable publishing to this destination; set to <code>false</code> to prevent publishing to this destination. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getKinesisFirehoseDestination}
             * @param kinesisFirehoseDestination An object that contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisFirehoseDestination(software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination.KinesisFirehoseDestinationProperty kinesisFirehoseDestination) {
                this.kinesisFirehoseDestination = kinesisFirehoseDestination;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getKinesisFirehoseDestination}
             * @param kinesisFirehoseDestination An object that contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisFirehoseDestination(software.amazon.awscdk.IResolvable kinesisFirehoseDestination) {
                this.kinesisFirehoseDestination = kinesisFirehoseDestination;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getName}
             * @param name The name of the event destination. The name must meet the following requirements:.
             *             <ul>
             *             <li>Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</li>
             *             <li>Contain 64 characters or fewer.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getSnsDestination}
             * @param snsDestination `CfnConfigurationSetEventDestination.EventDestinationProperty.SnsDestination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsDestination(software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination.SnsDestinationProperty snsDestination) {
                this.snsDestination = snsDestination;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getSnsDestination}
             * @param snsDestination `CfnConfigurationSetEventDestination.EventDestinationProperty.SnsDestination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsDestination(software.amazon.awscdk.IResolvable snsDestination) {
                this.snsDestination = snsDestination;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventDestinationProperty {
            private final java.util.List<java.lang.String> matchingEventTypes;
            private final java.lang.Object cloudWatchDestination;
            private final java.lang.Object enabled;
            private final java.lang.Object kinesisFirehoseDestination;
            private final java.lang.String name;
            private final java.lang.Object snsDestination;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.matchingEventTypes = software.amazon.jsii.Kernel.get(this, "matchingEventTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cloudWatchDestination = software.amazon.jsii.Kernel.get(this, "cloudWatchDestination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kinesisFirehoseDestination = software.amazon.jsii.Kernel.get(this, "kinesisFirehoseDestination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.snsDestination = software.amazon.jsii.Kernel.get(this, "snsDestination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.matchingEventTypes = java.util.Objects.requireNonNull(builder.matchingEventTypes, "matchingEventTypes is required");
                this.cloudWatchDestination = builder.cloudWatchDestination;
                this.enabled = builder.enabled;
                this.kinesisFirehoseDestination = builder.kinesisFirehoseDestination;
                this.name = builder.name;
                this.snsDestination = builder.snsDestination;
            }

            @Override
            public final java.util.List<java.lang.String> getMatchingEventTypes() {
                return this.matchingEventTypes;
            }

            @Override
            public final java.lang.Object getCloudWatchDestination() {
                return this.cloudWatchDestination;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getKinesisFirehoseDestination() {
                return this.kinesisFirehoseDestination;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getSnsDestination() {
                return this.snsDestination;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("matchingEventTypes", om.valueToTree(this.getMatchingEventTypes()));
                if (this.getCloudWatchDestination() != null) {
                    data.set("cloudWatchDestination", om.valueToTree(this.getCloudWatchDestination()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getKinesisFirehoseDestination() != null) {
                    data.set("kinesisFirehoseDestination", om.valueToTree(this.getKinesisFirehoseDestination()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getSnsDestination() != null) {
                    data.set("snsDestination", om.valueToTree(this.getSnsDestination()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.EventDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventDestinationProperty.Jsii$Proxy that = (EventDestinationProperty.Jsii$Proxy) o;

                if (!matchingEventTypes.equals(that.matchingEventTypes)) return false;
                if (this.cloudWatchDestination != null ? !this.cloudWatchDestination.equals(that.cloudWatchDestination) : that.cloudWatchDestination != null) return false;
                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.kinesisFirehoseDestination != null ? !this.kinesisFirehoseDestination.equals(that.kinesisFirehoseDestination) : that.kinesisFirehoseDestination != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.snsDestination != null ? this.snsDestination.equals(that.snsDestination) : that.snsDestination == null;
            }

            @Override
            public final int hashCode() {
                int result = this.matchingEventTypes.hashCode();
                result = 31 * result + (this.cloudWatchDestination != null ? this.cloudWatchDestination.hashCode() : 0);
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                result = 31 * result + (this.kinesisFirehoseDestination != null ? this.kinesisFirehoseDestination.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.snsDestination != null ? this.snsDestination.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
     * <p>
     * Event destinations, such as Amazon Kinesis Firehose, are associated with configuration sets, which enable you to publish email sending events. For information about using configuration sets, see the <a href="https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html">Amazon SES Developer Guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * KinesisFirehoseDestinationProperty kinesisFirehoseDestinationProperty = KinesisFirehoseDestinationProperty.builder()
     *         .deliveryStreamArn("deliveryStreamArn")
     *         .iamRoleArn("iamRoleArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.KinesisFirehoseDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisFirehoseDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisFirehoseDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeliveryStreamArn();

        /**
         * The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis Firehose stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIamRoleArn();

        /**
         * @return a {@link Builder} of {@link KinesisFirehoseDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisFirehoseDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisFirehoseDestinationProperty> {
            java.lang.String deliveryStreamArn;
            java.lang.String iamRoleArn;

            /**
             * Sets the value of {@link KinesisFirehoseDestinationProperty#getDeliveryStreamArn}
             * @param deliveryStreamArn The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deliveryStreamArn(java.lang.String deliveryStreamArn) {
                this.deliveryStreamArn = deliveryStreamArn;
                return this;
            }

            /**
             * Sets the value of {@link KinesisFirehoseDestinationProperty#getIamRoleArn}
             * @param iamRoleArn The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis Firehose stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamRoleArn(java.lang.String iamRoleArn) {
                this.iamRoleArn = iamRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisFirehoseDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisFirehoseDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisFirehoseDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisFirehoseDestinationProperty {
            private final java.lang.String deliveryStreamArn;
            private final java.lang.String iamRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deliveryStreamArn = software.amazon.jsii.Kernel.get(this, "deliveryStreamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iamRoleArn = software.amazon.jsii.Kernel.get(this, "iamRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deliveryStreamArn = java.util.Objects.requireNonNull(builder.deliveryStreamArn, "deliveryStreamArn is required");
                this.iamRoleArn = java.util.Objects.requireNonNull(builder.iamRoleArn, "iamRoleArn is required");
            }

            @Override
            public final java.lang.String getDeliveryStreamArn() {
                return this.deliveryStreamArn;
            }

            @Override
            public final java.lang.String getIamRoleArn() {
                return this.iamRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deliveryStreamArn", om.valueToTree(this.getDeliveryStreamArn()));
                data.set("iamRoleArn", om.valueToTree(this.getIamRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.KinesisFirehoseDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisFirehoseDestinationProperty.Jsii$Proxy that = (KinesisFirehoseDestinationProperty.Jsii$Proxy) o;

                if (!deliveryStreamArn.equals(that.deliveryStreamArn)) return false;
                return this.iamRoleArn.equals(that.iamRoleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.deliveryStreamArn.hashCode();
                result = 31 * result + (this.iamRoleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * SnsDestinationProperty snsDestinationProperty = SnsDestinationProperty.builder()
     *         .topicArn("topicArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.SnsDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(SnsDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnsDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnConfigurationSetEventDestination.SnsDestinationProperty.TopicARN`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTopicArn();

        /**
         * @return a {@link Builder} of {@link SnsDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnsDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnsDestinationProperty> {
            java.lang.String topicArn;

            /**
             * Sets the value of {@link SnsDestinationProperty#getTopicArn}
             * @param topicArn `CfnConfigurationSetEventDestination.SnsDestinationProperty.TopicARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicArn(java.lang.String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnsDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnsDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnsDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnsDestinationProperty {
            private final java.lang.String topicArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.topicArn = software.amazon.jsii.Kernel.get(this, "topicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.topicArn = java.util.Objects.requireNonNull(builder.topicArn, "topicArn is required");
            }

            @Override
            public final java.lang.String getTopicArn() {
                return this.topicArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("topicArn", om.valueToTree(this.getTopicArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSetEventDestination.SnsDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnsDestinationProperty.Jsii$Proxy that = (SnsDestinationProperty.Jsii$Proxy) o;

                return this.topicArn.equals(that.topicArn);
            }

            @Override
            public final int hashCode() {
                int result = this.topicArn.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestinationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestinationProps.Builder();
        }

        /**
         * The name of the configuration set that contains the event destination.
         * <p>
         * @return {@code this}
         * @param configurationSetName The name of the configuration set that contains the event destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSetName(final java.lang.String configurationSetName) {
            this.props.configurationSetName(configurationSetName);
            return this;
        }

        /**
         * The event destination object.
         * <p>
         * @return {@code this}
         * @param eventDestination The event destination object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventDestination(final software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination.EventDestinationProperty eventDestination) {
            this.props.eventDestination(eventDestination);
            return this;
        }
        /**
         * The event destination object.
         * <p>
         * @return {@code this}
         * @param eventDestination The event destination object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventDestination(final software.amazon.awscdk.IResolvable eventDestination) {
            this.props.eventDestination(eventDestination);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination build() {
            return new software.amazon.awscdk.services.ses.CfnConfigurationSetEventDestination(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
