package software.amazon.awscdk.services.secretsmanager;

/**
 * Properties for defining a `CfnSecretTargetAttachment`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.secretsmanager.*;
 * CfnSecretTargetAttachmentProps cfnSecretTargetAttachmentProps = CfnSecretTargetAttachmentProps.builder()
 *         .secretId("secretId")
 *         .targetId("targetId")
 *         .targetType("targetType")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:14.833Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.CfnSecretTargetAttachmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnSecretTargetAttachmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSecretTargetAttachmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN or name of the secret.
     * <p>
     * To reference a secret also created in this template, use the see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html">Ref</a> function with the secret's logical ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSecretId();

    /**
     * The ID of the database or cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetId();

    /**
     * A string that defines the type of service or database associated with the secret.
     * <p>
     * This value instructs Secrets Manager how to update the secret with the details of the service or database. This value must be one of the following:
     * <p>
     * <ul>
     * <li>AWS::RDS::DBInstance</li>
     * <li>AWS::RDS::DBCluster</li>
     * <li>AWS::Redshift::Cluster</li>
     * <li>AWS::DocDB::DBInstance</li>
     * <li>AWS::DocDB::DBCluster</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetType();

    /**
     * @return a {@link Builder} of {@link CfnSecretTargetAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSecretTargetAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSecretTargetAttachmentProps> {
        java.lang.String secretId;
        java.lang.String targetId;
        java.lang.String targetType;

        /**
         * Sets the value of {@link CfnSecretTargetAttachmentProps#getSecretId}
         * @param secretId The ARN or name of the secret. This parameter is required.
         *                 To reference a secret also created in this template, use the see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html">Ref</a> function with the secret's logical ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretId(java.lang.String secretId) {
            this.secretId = secretId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecretTargetAttachmentProps#getTargetId}
         * @param targetId The ID of the database or cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetId(java.lang.String targetId) {
            this.targetId = targetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecretTargetAttachmentProps#getTargetType}
         * @param targetType A string that defines the type of service or database associated with the secret. This parameter is required.
         *                   This value instructs Secrets Manager how to update the secret with the details of the service or database. This value must be one of the following:
         *                   <p>
         *                   <ul>
         *                   <li>AWS::RDS::DBInstance</li>
         *                   <li>AWS::RDS::DBCluster</li>
         *                   <li>AWS::Redshift::Cluster</li>
         *                   <li>AWS::DocDB::DBInstance</li>
         *                   <li>AWS::DocDB::DBCluster</li>
         *                   </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetType(java.lang.String targetType) {
            this.targetType = targetType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSecretTargetAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSecretTargetAttachmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSecretTargetAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSecretTargetAttachmentProps {
        private final java.lang.String secretId;
        private final java.lang.String targetId;
        private final java.lang.String targetType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.secretId = software.amazon.jsii.Kernel.get(this, "secretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetId = software.amazon.jsii.Kernel.get(this, "targetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetType = software.amazon.jsii.Kernel.get(this, "targetType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.secretId = java.util.Objects.requireNonNull(builder.secretId, "secretId is required");
            this.targetId = java.util.Objects.requireNonNull(builder.targetId, "targetId is required");
            this.targetType = java.util.Objects.requireNonNull(builder.targetType, "targetType is required");
        }

        @Override
        public final java.lang.String getSecretId() {
            return this.secretId;
        }

        @Override
        public final java.lang.String getTargetId() {
            return this.targetId;
        }

        @Override
        public final java.lang.String getTargetType() {
            return this.targetType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("secretId", om.valueToTree(this.getSecretId()));
            data.set("targetId", om.valueToTree(this.getTargetId()));
            data.set("targetType", om.valueToTree(this.getTargetType()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_secretsmanager.CfnSecretTargetAttachmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSecretTargetAttachmentProps.Jsii$Proxy that = (CfnSecretTargetAttachmentProps.Jsii$Proxy) o;

            if (!secretId.equals(that.secretId)) return false;
            if (!targetId.equals(that.targetId)) return false;
            return this.targetType.equals(that.targetType);
        }

        @Override
        public final int hashCode() {
            int result = this.secretId.hashCode();
            result = 31 * result + (this.targetId.hashCode());
            result = 31 * result + (this.targetType.hashCode());
            return result;
        }
    }
}
