package software.amazon.awscdk.services.scheduler;

/**
 * Properties for defining a `CfnSchedule`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.scheduler.*;
 * Object tags;
 * CfnScheduleProps cfnScheduleProps = CfnScheduleProps.builder()
 *         .flexibleTimeWindow(FlexibleTimeWindowProperty.builder()
 *                 .mode("mode")
 *                 // the properties below are optional
 *                 .maximumWindowInMinutes(123)
 *                 .build())
 *         .scheduleExpression("scheduleExpression")
 *         .target(TargetProperty.builder()
 *                 .arn("arn")
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .deadLetterConfig(DeadLetterConfigProperty.builder()
 *                         .arn("arn")
 *                         .build())
 *                 .ecsParameters(EcsParametersProperty.builder()
 *                         .taskDefinitionArn("taskDefinitionArn")
 *                         // the properties below are optional
 *                         .capacityProviderStrategy(List.of(CapacityProviderStrategyItemProperty.builder()
 *                                 .capacityProvider("capacityProvider")
 *                                 // the properties below are optional
 *                                 .base(123)
 *                                 .weight(123)
 *                                 .build()))
 *                         .enableEcsManagedTags(false)
 *                         .enableExecuteCommand(false)
 *                         .group("group")
 *                         .launchType("launchType")
 *                         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                                 .awsvpcConfiguration(AwsVpcConfigurationProperty.builder()
 *                                         .subnets(List.of("subnets"))
 *                                         // the properties below are optional
 *                                         .assignPublicIp("assignPublicIp")
 *                                         .securityGroups(List.of("securityGroups"))
 *                                         .build())
 *                                 .build())
 *                         .placementConstraints(List.of(PlacementConstraintProperty.builder()
 *                                 .expression("expression")
 *                                 .type("type")
 *                                 .build()))
 *                         .placementStrategy(List.of(PlacementStrategyProperty.builder()
 *                                 .field("field")
 *                                 .type("type")
 *                                 .build()))
 *                         .platformVersion("platformVersion")
 *                         .propagateTags("propagateTags")
 *                         .referenceId("referenceId")
 *                         .tags(List.of(tags))
 *                         .taskCount(123)
 *                         .build())
 *                 .eventBridgeParameters(EventBridgeParametersProperty.builder()
 *                         .detailType("detailType")
 *                         .source("source")
 *                         .build())
 *                 .input("input")
 *                 .kinesisParameters(KinesisParametersProperty.builder()
 *                         .partitionKey("partitionKey")
 *                         .build())
 *                 .retryPolicy(RetryPolicyProperty.builder()
 *                         .maximumEventAgeInSeconds(123)
 *                         .maximumRetryAttempts(123)
 *                         .build())
 *                 .sageMakerPipelineParameters(SageMakerPipelineParametersProperty.builder()
 *                         .pipelineParameterList(List.of(SageMakerPipelineParameterProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .build())
 *                 .sqsParameters(SqsParametersProperty.builder()
 *                         .messageGroupId("messageGroupId")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .endDate("endDate")
 *         .groupName("groupName")
 *         .kmsKeyArn("kmsKeyArn")
 *         .name("name")
 *         .scheduleExpressionTimezone("scheduleExpressionTimezone")
 *         .startDate("startDate")
 *         .state("state")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:14.804Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.CfnScheduleProps")
@software.amazon.jsii.Jsii.Proxy(CfnScheduleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnScheduleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::Scheduler::Schedule.FlexibleTimeWindow`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getFlexibleTimeWindow();

    /**
     * `AWS::Scheduler::Schedule.ScheduleExpression`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScheduleExpression();

    /**
     * `AWS::Scheduler::Schedule.Target`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTarget();

    /**
     * `AWS::Scheduler::Schedule.Description`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * `AWS::Scheduler::Schedule.EndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndDate() {
        return null;
    }

    /**
     * `AWS::Scheduler::Schedule.GroupName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
        return null;
    }

    /**
     * `AWS::Scheduler::Schedule.KmsKeyArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return null;
    }

    /**
     * `AWS::Scheduler::Schedule.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * `AWS::Scheduler::Schedule.ScheduleExpressionTimezone`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScheduleExpressionTimezone() {
        return null;
    }

    /**
     * `AWS::Scheduler::Schedule.StartDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStartDate() {
        return null;
    }

    /**
     * `AWS::Scheduler::Schedule.State`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnScheduleProps> {
        java.lang.Object flexibleTimeWindow;
        java.lang.String scheduleExpression;
        java.lang.Object target;
        java.lang.String description;
        java.lang.String endDate;
        java.lang.String groupName;
        java.lang.String kmsKeyArn;
        java.lang.String name;
        java.lang.String scheduleExpressionTimezone;
        java.lang.String startDate;
        java.lang.String state;

        /**
         * Sets the value of {@link CfnScheduleProps#getFlexibleTimeWindow}
         * @param flexibleTimeWindow `AWS::Scheduler::Schedule.FlexibleTimeWindow`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flexibleTimeWindow(software.amazon.awscdk.services.scheduler.CfnSchedule.FlexibleTimeWindowProperty flexibleTimeWindow) {
            this.flexibleTimeWindow = flexibleTimeWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getFlexibleTimeWindow}
         * @param flexibleTimeWindow `AWS::Scheduler::Schedule.FlexibleTimeWindow`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flexibleTimeWindow(software.amazon.awscdk.IResolvable flexibleTimeWindow) {
            this.flexibleTimeWindow = flexibleTimeWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getScheduleExpression}
         * @param scheduleExpression `AWS::Scheduler::Schedule.ScheduleExpression`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleExpression(java.lang.String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getTarget}
         * @param target `AWS::Scheduler::Schedule.Target`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(software.amazon.awscdk.services.scheduler.CfnSchedule.TargetProperty target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getTarget}
         * @param target `AWS::Scheduler::Schedule.Target`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(software.amazon.awscdk.IResolvable target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getDescription}
         * @param description `AWS::Scheduler::Schedule.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getEndDate}
         * @param endDate `AWS::Scheduler::Schedule.EndDate`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endDate(java.lang.String endDate) {
            this.endDate = endDate;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getGroupName}
         * @param groupName `AWS::Scheduler::Schedule.GroupName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupName(java.lang.String groupName) {
            this.groupName = groupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getKmsKeyArn}
         * @param kmsKeyArn `AWS::Scheduler::Schedule.KmsKeyArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getName}
         * @param name `AWS::Scheduler::Schedule.Name`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getScheduleExpressionTimezone}
         * @param scheduleExpressionTimezone `AWS::Scheduler::Schedule.ScheduleExpressionTimezone`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleExpressionTimezone(java.lang.String scheduleExpressionTimezone) {
            this.scheduleExpressionTimezone = scheduleExpressionTimezone;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getStartDate}
         * @param startDate `AWS::Scheduler::Schedule.StartDate`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startDate(java.lang.String startDate) {
            this.startDate = startDate;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getState}
         * @param state `AWS::Scheduler::Schedule.State`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(java.lang.String state) {
            this.state = state;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnScheduleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnScheduleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnScheduleProps {
        private final java.lang.Object flexibleTimeWindow;
        private final java.lang.String scheduleExpression;
        private final java.lang.Object target;
        private final java.lang.String description;
        private final java.lang.String endDate;
        private final java.lang.String groupName;
        private final java.lang.String kmsKeyArn;
        private final java.lang.String name;
        private final java.lang.String scheduleExpressionTimezone;
        private final java.lang.String startDate;
        private final java.lang.String state;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.flexibleTimeWindow = software.amazon.jsii.Kernel.get(this, "flexibleTimeWindow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endDate = software.amazon.jsii.Kernel.get(this, "endDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.groupName = software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scheduleExpressionTimezone = software.amazon.jsii.Kernel.get(this, "scheduleExpressionTimezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.startDate = software.amazon.jsii.Kernel.get(this, "startDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.flexibleTimeWindow = java.util.Objects.requireNonNull(builder.flexibleTimeWindow, "flexibleTimeWindow is required");
            this.scheduleExpression = java.util.Objects.requireNonNull(builder.scheduleExpression, "scheduleExpression is required");
            this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
            this.description = builder.description;
            this.endDate = builder.endDate;
            this.groupName = builder.groupName;
            this.kmsKeyArn = builder.kmsKeyArn;
            this.name = builder.name;
            this.scheduleExpressionTimezone = builder.scheduleExpressionTimezone;
            this.startDate = builder.startDate;
            this.state = builder.state;
        }

        @Override
        public final java.lang.Object getFlexibleTimeWindow() {
            return this.flexibleTimeWindow;
        }

        @Override
        public final java.lang.String getScheduleExpression() {
            return this.scheduleExpression;
        }

        @Override
        public final java.lang.Object getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getEndDate() {
            return this.endDate;
        }

        @Override
        public final java.lang.String getGroupName() {
            return this.groupName;
        }

        @Override
        public final java.lang.String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getScheduleExpressionTimezone() {
            return this.scheduleExpressionTimezone;
        }

        @Override
        public final java.lang.String getStartDate() {
            return this.startDate;
        }

        @Override
        public final java.lang.String getState() {
            return this.state;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("flexibleTimeWindow", om.valueToTree(this.getFlexibleTimeWindow()));
            data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
            data.set("target", om.valueToTree(this.getTarget()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEndDate() != null) {
                data.set("endDate", om.valueToTree(this.getEndDate()));
            }
            if (this.getGroupName() != null) {
                data.set("groupName", om.valueToTree(this.getGroupName()));
            }
            if (this.getKmsKeyArn() != null) {
                data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getScheduleExpressionTimezone() != null) {
                data.set("scheduleExpressionTimezone", om.valueToTree(this.getScheduleExpressionTimezone()));
            }
            if (this.getStartDate() != null) {
                data.set("startDate", om.valueToTree(this.getStartDate()));
            }
            if (this.getState() != null) {
                data.set("state", om.valueToTree(this.getState()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.CfnScheduleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnScheduleProps.Jsii$Proxy that = (CfnScheduleProps.Jsii$Proxy) o;

            if (!flexibleTimeWindow.equals(that.flexibleTimeWindow)) return false;
            if (!scheduleExpression.equals(that.scheduleExpression)) return false;
            if (!target.equals(that.target)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.endDate != null ? !this.endDate.equals(that.endDate) : that.endDate != null) return false;
            if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) return false;
            if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.scheduleExpressionTimezone != null ? !this.scheduleExpressionTimezone.equals(that.scheduleExpressionTimezone) : that.scheduleExpressionTimezone != null) return false;
            if (this.startDate != null ? !this.startDate.equals(that.startDate) : that.startDate != null) return false;
            return this.state != null ? this.state.equals(that.state) : that.state == null;
        }

        @Override
        public final int hashCode() {
            int result = this.flexibleTimeWindow.hashCode();
            result = 31 * result + (this.scheduleExpression.hashCode());
            result = 31 * result + (this.target.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
            result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
            result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.scheduleExpressionTimezone != null ? this.scheduleExpressionTimezone.hashCode() : 0);
            result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            return result;
        }
    }
}
