package software.amazon.awscdk.services.s3;

/**
 * All http request methods.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Bucket bucket = Bucket.Builder.create(this, "MyRedirectedBucket")
 *         .websiteRoutingRules(List.of(RoutingRule.builder()
 *                 .hostName("www.example.com")
 *                 .httpRedirectCode("302")
 *                 .protocol(RedirectProtocol.HTTPS)
 *                 .replaceKey(ReplaceKey.prefixWith("test/"))
 *                 .condition(RoutingRuleCondition.builder()
 *                         .httpErrorCodeReturnedEquals("200")
 *                         .keyPrefixEquals("prefix")
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:14.544Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.RedirectProtocol")
public enum RedirectProtocol {
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTPS,
}
