package software.amazon.awscdk.services.route53;

/**
 * Create a Route53 public hosted zone.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Stack stack1 = Stack.Builder.create(app, "Stack1")
 *         .env(Environment.builder()
 *                 .region("us-east-1")
 *                 .build())
 *         .crossRegionReferences(true)
 *         .build();
 * Certificate cert = Certificate.Builder.create(stack1, "Cert")
 *         .domainName("*.example.com")
 *         .validation(CertificateValidation.fromDns(PublicHostedZone.fromHostedZoneId(stack1, "Zone", "Z0329774B51CGXTDQV3X")))
 *         .build();
 * Stack stack2 = Stack.Builder.create(app, "Stack2")
 *         .env(Environment.builder()
 *                 .region("us-east-2")
 *                 .build())
 *         .crossRegionReferences(true)
 *         .build();
 * Distribution.Builder.create(stack2, "Distribution")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(new HttpOrigin("example.com"))
 *                 .build())
 *         .domainNames(List.of("dev.example.com"))
 *         .certificate(cert)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:14.391Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.PublicHostedZone")
public class PublicHostedZone extends software.amazon.awscdk.services.route53.HostedZone implements software.amazon.awscdk.services.route53.IPublicHostedZone {

    protected PublicHostedZone(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PublicHostedZone(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PublicHostedZone(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.PublicHostedZoneProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports a public hosted zone from another stack.
     * <p>
     * Use when both hosted zone ID and hosted zone name are known.
     * <p>
     * @param scope the parent Construct for this Construct. This parameter is required.
     * @param id the logical name of this Construct. This parameter is required.
     * @param attrs the PublicHostedZoneAttributes (hosted zone ID and hosted zone name). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IPublicHostedZone fromPublicHostedZoneAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.PublicHostedZoneAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.PublicHostedZone.class, "fromPublicHostedZoneAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IPublicHostedZone.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Import a Route 53 public hosted zone defined either outside the CDK, or in a different CDK stack.
     * <p>
     * Use when hosted zone ID is known. If a PublicHostedZone is imported with this method the zoneName cannot be referenced.
     * If the zoneName is needed then the PublicHostedZone should be imported with <code>fromPublicHostedZoneAttributes()</code>.
     * <p>
     * @param scope the parent Construct for this Construct. This parameter is required.
     * @param id the logical name of this Construct. This parameter is required.
     * @param publicHostedZoneId the ID of the public hosted zone to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IPublicHostedZone fromPublicHostedZoneId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String publicHostedZoneId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.PublicHostedZone.class, "fromPublicHostedZoneId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IPublicHostedZone.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(publicHostedZoneId, "publicHostedZoneId is required") });
    }

    /**
     * Adds a delegation from this zone to a designated zone.
     * <p>
     * @param delegate the zone being delegated to. This parameter is required.
     * @param opts options for creating the DNS record, if any.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDelegation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IPublicHostedZone delegate, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.ZoneDelegationOptions opts) {
        software.amazon.jsii.Kernel.call(this, "addDelegation", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(delegate, "delegate is required"), opts });
    }

    /**
     * Adds a delegation from this zone to a designated zone.
     * <p>
     * @param delegate the zone being delegated to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDelegation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IPublicHostedZone delegate) {
        software.amazon.jsii.Kernel.call(this, "addDelegation", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(delegate, "delegate is required") });
    }

    /**
     * Add another VPC to this private hosted zone.
     * <p>
     * @param _vpc This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addVpc(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc _vpc) {
        software.amazon.jsii.Kernel.call(this, "addVpc", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(_vpc, "_vpc is required") });
    }

    /**
     * Role for cross account zone delegation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.Role getCrossAccountZoneDelegationRole() {
        return software.amazon.jsii.Kernel.get(this, "crossAccountZoneDelegationRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Role.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.route53.PublicHostedZone}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53.PublicHostedZone> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.route53.PublicHostedZoneProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.route53.PublicHostedZoneProps.Builder();
        }

        /**
         * The name of the domain.
         * <p>
         * For resource record types that include a domain
         * name, specify a fully qualified domain name.
         * <p>
         * @return {@code this}
         * @param zoneName The name of the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zoneName(final java.lang.String zoneName) {
            this.props.zoneName(zoneName);
            return this;
        }

        /**
         * Any comments that you want to include about the hosted zone.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param comment Any comments that you want to include about the hosted zone. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) for the log group that you want Amazon Route 53 to send query logs to.
         * <p>
         * Default: disabled
         * <p>
         * @return {@code this}
         * @param queryLogsLogGroupArn The Amazon Resource Name (ARN) for the log group that you want Amazon Route 53 to send query logs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLogsLogGroupArn(final java.lang.String queryLogsLogGroupArn) {
            this.props.queryLogsLogGroupArn(queryLogsLogGroupArn);
            return this;
        }

        /**
         * Whether to create a CAA record to restrict certificate authorities allowed to issue certificates for this domain to Amazon only.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param caaAmazon Whether to create a CAA record to restrict certificate authorities allowed to issue certificates for this domain to Amazon only. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caaAmazon(final java.lang.Boolean caaAmazon) {
            this.props.caaAmazon(caaAmazon);
            return this;
        }

        /**
         * A principal which is trusted to assume a role for zone delegation.
         * <p>
         * Default: - No delegation configuration
         * <p>
         * @return {@code this}
         * @param crossAccountZoneDelegationPrincipal A principal which is trusted to assume a role for zone delegation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossAccountZoneDelegationPrincipal(final software.amazon.awscdk.services.iam.IPrincipal crossAccountZoneDelegationPrincipal) {
            this.props.crossAccountZoneDelegationPrincipal(crossAccountZoneDelegationPrincipal);
            return this;
        }

        /**
         * The name of the role created for cross account delegation.
         * <p>
         * Default: - A role name is generated automatically
         * <p>
         * @return {@code this}
         * @param crossAccountZoneDelegationRoleName The name of the role created for cross account delegation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossAccountZoneDelegationRoleName(final java.lang.String crossAccountZoneDelegationRoleName) {
            this.props.crossAccountZoneDelegationRoleName(crossAccountZoneDelegationRoleName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.route53.PublicHostedZone}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.route53.PublicHostedZone build() {
            return new software.amazon.awscdk.services.route53.PublicHostedZone(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
