package software.amazon.awscdk.services.resourceexplorer2;

/**
 * Properties for defining a `CfnView`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.resourceexplorer2.*;
 * CfnViewProps cfnViewProps = CfnViewProps.builder()
 *         .viewName("viewName")
 *         // the properties below are optional
 *         .filters(FiltersProperty.builder()
 *                 .filterString("filterString")
 *                 .build())
 *         .includedProperties(List.of(IncludedPropertyProperty.builder()
 *                 .name("name")
 *                 .build()))
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:14.281Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_resourceexplorer2.CfnViewProps")
@software.amazon.jsii.Jsii.Proxy(CfnViewProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnViewProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::ResourceExplorer2::View.ViewName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getViewName();

    /**
     * `AWS::ResourceExplorer2::View.Filters`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFilters() {
        return null;
    }

    /**
     * `AWS::ResourceExplorer2::View.IncludedProperties`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIncludedProperties() {
        return null;
    }

    /**
     * `AWS::ResourceExplorer2::View.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnViewProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnViewProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnViewProps> {
        java.lang.String viewName;
        java.lang.Object filters;
        java.lang.Object includedProperties;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnViewProps#getViewName}
         * @param viewName `AWS::ResourceExplorer2::View.ViewName`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder viewName(java.lang.String viewName) {
            this.viewName = viewName;
            return this;
        }

        /**
         * Sets the value of {@link CfnViewProps#getFilters}
         * @param filters `AWS::ResourceExplorer2::View.Filters`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filters(software.amazon.awscdk.services.resourceexplorer2.CfnView.FiltersProperty filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Sets the value of {@link CfnViewProps#getFilters}
         * @param filters `AWS::ResourceExplorer2::View.Filters`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filters(software.amazon.awscdk.IResolvable filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Sets the value of {@link CfnViewProps#getIncludedProperties}
         * @param includedProperties `AWS::ResourceExplorer2::View.IncludedProperties`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includedProperties(software.amazon.awscdk.IResolvable includedProperties) {
            this.includedProperties = includedProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnViewProps#getIncludedProperties}
         * @param includedProperties `AWS::ResourceExplorer2::View.IncludedProperties`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includedProperties(java.util.List<? extends java.lang.Object> includedProperties) {
            this.includedProperties = includedProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnViewProps#getTags}
         * @param tags `AWS::ResourceExplorer2::View.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnViewProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnViewProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnViewProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnViewProps {
        private final java.lang.String viewName;
        private final java.lang.Object filters;
        private final java.lang.Object includedProperties;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.viewName = software.amazon.jsii.Kernel.get(this, "viewName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.filters = software.amazon.jsii.Kernel.get(this, "filters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.includedProperties = software.amazon.jsii.Kernel.get(this, "includedProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.viewName = java.util.Objects.requireNonNull(builder.viewName, "viewName is required");
            this.filters = builder.filters;
            this.includedProperties = builder.includedProperties;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getViewName() {
            return this.viewName;
        }

        @Override
        public final java.lang.Object getFilters() {
            return this.filters;
        }

        @Override
        public final java.lang.Object getIncludedProperties() {
            return this.includedProperties;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("viewName", om.valueToTree(this.getViewName()));
            if (this.getFilters() != null) {
                data.set("filters", om.valueToTree(this.getFilters()));
            }
            if (this.getIncludedProperties() != null) {
                data.set("includedProperties", om.valueToTree(this.getIncludedProperties()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_resourceexplorer2.CfnViewProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnViewProps.Jsii$Proxy that = (CfnViewProps.Jsii$Proxy) o;

            if (!viewName.equals(that.viewName)) return false;
            if (this.filters != null ? !this.filters.equals(that.filters) : that.filters != null) return false;
            if (this.includedProperties != null ? !this.includedProperties.equals(that.includedProperties) : that.includedProperties != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.viewName.hashCode();
            result = 31 * result + (this.filters != null ? this.filters.hashCode() : 0);
            result = 31 * result + (this.includedProperties != null ? this.includedProperties.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
