package software.amazon.awscdk.services.refactorspaces;

/**
 * A CloudFormation `AWS::RefactorSpaces::Route`.
 * <p>
 * Creates an AWS Migration Hub Refactor Spaces route. The account owner of the service resource is always the environment owner, regardless of the account creating the route. Routes target a service in the application. If an application does not have any routes, then the first route must be created as a <code>DEFAULT</code> <code>RouteType</code> .
 * <p>
 * <blockquote>
 * <p>
 * In the <code>AWS::RefactorSpaces::Route</code> resource, you can only update the <code>SourcePath</code> and <code>Methods</code> properties, which reside under the <code>UriPathRoute</code> property. All other properties associated with the <code>AWS::RefactorSpaces::Route</code> cannot be updated, even though the property description might indicate otherwise.
 * <p>
 * </blockquote>
 * <p>
 * When you create a route, Refactor Spaces configures the Amazon API Gateway to send traffic to the target service.
 * <p>
 * <ul>
 * <li>If the service has a URL endpoint, and the endpoint resolves to a private IP address, Refactor Spaces routes traffic using the API Gateway VPC link.</li>
 * <li>If the service has a URL endpoint, and the endpoint resolves to a public IP address, Refactor Spaces routes traffic over the public internet.</li>
 * <li>If the service has a AWS Lambda function endpoint, then Refactor Spaces uses API Gateway ’s Lambda integration.</li>
 * </ul>
 * <p>
 * A health check is performed on the service when the route is created. If the health check fails, the route transitions to <code>FAILED</code> , and no traffic is sent to the service. For Lambda functions, the Lambda function state is checked. If the function is not active, the function configuration is updated so Lambda resources are provisioned. If the Lambda state is <code>Failed</code> , then the route creation fails. For more information, see the <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunctionConfiguration.html#SSS-GetFunctionConfiguration-response-State">GetFunctionConfiguration's State response parameter</a> in the <em>AWS Lambda Developer Guide</em> . For public URLs, a connection is opened to the public endpoint. If the URL is not reachable, the health check fails. For private URLs, a target groups is created and the target group health check is run. The <code>HealthCheckProtocol</code> , <code>HealthCheckPort</code> , and <code>HealthCheckPath</code> are the same protocol, port, and path specified in the URL or Health URL if used. All other settings use the default values, as described in <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/target-group-health-checks.html">Health checks for your target groups</a> . The health check is considered successful if at least one target within the target group transitions to healthy state.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.refactorspaces.*;
 * CfnRoute cfnRoute = CfnRoute.Builder.create(this, "MyCfnRoute")
 *         .applicationIdentifier("applicationIdentifier")
 *         .environmentIdentifier("environmentIdentifier")
 *         .serviceIdentifier("serviceIdentifier")
 *         // the properties below are optional
 *         .defaultRoute(DefaultRouteInputProperty.builder()
 *                 .activationState("activationState")
 *                 .build())
 *         .routeType("routeType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .uriPathRoute(UriPathRouteInputProperty.builder()
 *                 .activationState("activationState")
 *                 // the properties below are optional
 *                 .includeChildPaths(false)
 *                 .methods(List.of("methods"))
 *                 .sourcePath("sourcePath")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:14.260Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_refactorspaces.CfnRoute")
public class CfnRoute extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnRoute(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRoute(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.refactorspaces.CfnRoute.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::RefactorSpaces::Route`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRoute(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.refactorspaces.CfnRouteProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A mapping of Amazon API Gateway path resources to resource IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPathResourceToId() {
        return software.amazon.jsii.Kernel.get(this, "attrPathResourceToId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRouteIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "attrRouteIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags assigned to the route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The unique identifier of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "applicationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationIdentifier", java.util.Objects.requireNonNull(value, "applicationIdentifier is required"));
    }

    /**
     * The unique identifier of the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "environmentIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironmentIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "environmentIdentifier", java.util.Objects.requireNonNull(value, "environmentIdentifier is required"));
    }

    /**
     * The unique identifier of the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "serviceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceIdentifier", java.util.Objects.requireNonNull(value, "serviceIdentifier is required"));
    }

    /**
     * `AWS::RefactorSpaces::Route.DefaultRoute`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefaultRoute() {
        return software.amazon.jsii.Kernel.get(this, "defaultRoute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::RefactorSpaces::Route.DefaultRoute`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultRoute(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.refactorspaces.CfnRoute.DefaultRouteInputProperty value) {
        software.amazon.jsii.Kernel.set(this, "defaultRoute", value);
    }

    /**
     * `AWS::RefactorSpaces::Route.DefaultRoute`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultRoute(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "defaultRoute", value);
    }

    /**
     * The route type of the route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRouteType() {
        return software.amazon.jsii.Kernel.get(this, "routeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The route type of the route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRouteType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "routeType", value);
    }

    /**
     * The configuration for the URI path route type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUriPathRoute() {
        return software.amazon.jsii.Kernel.get(this, "uriPathRoute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for the URI path route type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUriPathRoute(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.refactorspaces.CfnRoute.UriPathRouteInputProperty value) {
        software.amazon.jsii.Kernel.set(this, "uriPathRoute", value);
    }

    /**
     * The configuration for the URI path route type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUriPathRoute(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "uriPathRoute", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.refactorspaces.*;
     * DefaultRouteInputProperty defaultRouteInputProperty = DefaultRouteInputProperty.builder()
     *         .activationState("activationState")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_refactorspaces.CfnRoute.DefaultRouteInputProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultRouteInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultRouteInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnRoute.DefaultRouteInputProperty.ActivationState`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getActivationState();

        /**
         * @return a {@link Builder} of {@link DefaultRouteInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultRouteInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultRouteInputProperty> {
            java.lang.String activationState;

            /**
             * Sets the value of {@link DefaultRouteInputProperty#getActivationState}
             * @param activationState `CfnRoute.DefaultRouteInputProperty.ActivationState`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder activationState(java.lang.String activationState) {
                this.activationState = activationState;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultRouteInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultRouteInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefaultRouteInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultRouteInputProperty {
            private final java.lang.String activationState;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.activationState = software.amazon.jsii.Kernel.get(this, "activationState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.activationState = java.util.Objects.requireNonNull(builder.activationState, "activationState is required");
            }

            @Override
            public final java.lang.String getActivationState() {
                return this.activationState;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("activationState", om.valueToTree(this.getActivationState()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_refactorspaces.CfnRoute.DefaultRouteInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultRouteInputProperty.Jsii$Proxy that = (DefaultRouteInputProperty.Jsii$Proxy) o;

                return this.activationState.equals(that.activationState);
            }

            @Override
            public final int hashCode() {
                int result = this.activationState.hashCode();
                return result;
            }
        }
    }
    /**
     * The configuration for the URI path route type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.refactorspaces.*;
     * UriPathRouteInputProperty uriPathRouteInputProperty = UriPathRouteInputProperty.builder()
     *         .activationState("activationState")
     *         // the properties below are optional
     *         .includeChildPaths(false)
     *         .methods(List.of("methods"))
     *         .sourcePath("sourcePath")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_refactorspaces.CfnRoute.UriPathRouteInputProperty")
    @software.amazon.jsii.Jsii.Proxy(UriPathRouteInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UriPathRouteInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether traffic is forwarded to this route’s service after the route is created.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getActivationState();

        /**
         * Indicates whether to match all subpaths of the given source path.
         * <p>
         * If this value is <code>false</code> , requests must match the source path exactly before they are forwarded to this route's service.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeChildPaths() {
            return null;
        }

        /**
         * A list of HTTP methods to match.
         * <p>
         * An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMethods() {
            return null;
        }

        /**
         * The path to use to match traffic.
         * <p>
         * Paths must start with <code>/</code> and are relative to the base of the application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourcePath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UriPathRouteInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UriPathRouteInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UriPathRouteInputProperty> {
            java.lang.String activationState;
            java.lang.Object includeChildPaths;
            java.util.List<java.lang.String> methods;
            java.lang.String sourcePath;

            /**
             * Sets the value of {@link UriPathRouteInputProperty#getActivationState}
             * @param activationState Indicates whether traffic is forwarded to this route’s service after the route is created. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder activationState(java.lang.String activationState) {
                this.activationState = activationState;
                return this;
            }

            /**
             * Sets the value of {@link UriPathRouteInputProperty#getIncludeChildPaths}
             * @param includeChildPaths Indicates whether to match all subpaths of the given source path.
             *                          If this value is <code>false</code> , requests must match the source path exactly before they are forwarded to this route's service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildPaths(java.lang.Boolean includeChildPaths) {
                this.includeChildPaths = includeChildPaths;
                return this;
            }

            /**
             * Sets the value of {@link UriPathRouteInputProperty#getIncludeChildPaths}
             * @param includeChildPaths Indicates whether to match all subpaths of the given source path.
             *                          If this value is <code>false</code> , requests must match the source path exactly before they are forwarded to this route's service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildPaths(software.amazon.awscdk.IResolvable includeChildPaths) {
                this.includeChildPaths = includeChildPaths;
                return this;
            }

            /**
             * Sets the value of {@link UriPathRouteInputProperty#getMethods}
             * @param methods A list of HTTP methods to match.
             *                An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder methods(java.util.List<java.lang.String> methods) {
                this.methods = methods;
                return this;
            }

            /**
             * Sets the value of {@link UriPathRouteInputProperty#getSourcePath}
             * @param sourcePath The path to use to match traffic.
             *                   Paths must start with <code>/</code> and are relative to the base of the application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePath(java.lang.String sourcePath) {
                this.sourcePath = sourcePath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UriPathRouteInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UriPathRouteInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UriPathRouteInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UriPathRouteInputProperty {
            private final java.lang.String activationState;
            private final java.lang.Object includeChildPaths;
            private final java.util.List<java.lang.String> methods;
            private final java.lang.String sourcePath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.activationState = software.amazon.jsii.Kernel.get(this, "activationState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includeChildPaths = software.amazon.jsii.Kernel.get(this, "includeChildPaths", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.methods = software.amazon.jsii.Kernel.get(this, "methods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.sourcePath = software.amazon.jsii.Kernel.get(this, "sourcePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.activationState = java.util.Objects.requireNonNull(builder.activationState, "activationState is required");
                this.includeChildPaths = builder.includeChildPaths;
                this.methods = builder.methods;
                this.sourcePath = builder.sourcePath;
            }

            @Override
            public final java.lang.String getActivationState() {
                return this.activationState;
            }

            @Override
            public final java.lang.Object getIncludeChildPaths() {
                return this.includeChildPaths;
            }

            @Override
            public final java.util.List<java.lang.String> getMethods() {
                return this.methods;
            }

            @Override
            public final java.lang.String getSourcePath() {
                return this.sourcePath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("activationState", om.valueToTree(this.getActivationState()));
                if (this.getIncludeChildPaths() != null) {
                    data.set("includeChildPaths", om.valueToTree(this.getIncludeChildPaths()));
                }
                if (this.getMethods() != null) {
                    data.set("methods", om.valueToTree(this.getMethods()));
                }
                if (this.getSourcePath() != null) {
                    data.set("sourcePath", om.valueToTree(this.getSourcePath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_refactorspaces.CfnRoute.UriPathRouteInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UriPathRouteInputProperty.Jsii$Proxy that = (UriPathRouteInputProperty.Jsii$Proxy) o;

                if (!activationState.equals(that.activationState)) return false;
                if (this.includeChildPaths != null ? !this.includeChildPaths.equals(that.includeChildPaths) : that.includeChildPaths != null) return false;
                if (this.methods != null ? !this.methods.equals(that.methods) : that.methods != null) return false;
                return this.sourcePath != null ? this.sourcePath.equals(that.sourcePath) : that.sourcePath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.activationState.hashCode();
                result = 31 * result + (this.includeChildPaths != null ? this.includeChildPaths.hashCode() : 0);
                result = 31 * result + (this.methods != null ? this.methods.hashCode() : 0);
                result = 31 * result + (this.sourcePath != null ? this.sourcePath.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.refactorspaces.CfnRoute}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.refactorspaces.CfnRoute> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.refactorspaces.CfnRouteProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.refactorspaces.CfnRouteProps.Builder();
        }

        /**
         * The unique identifier of the application.
         * <p>
         * @return {@code this}
         * @param applicationIdentifier The unique identifier of the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationIdentifier(final java.lang.String applicationIdentifier) {
            this.props.applicationIdentifier(applicationIdentifier);
            return this;
        }

        /**
         * The unique identifier of the environment.
         * <p>
         * @return {@code this}
         * @param environmentIdentifier The unique identifier of the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentIdentifier(final java.lang.String environmentIdentifier) {
            this.props.environmentIdentifier(environmentIdentifier);
            return this;
        }

        /**
         * The unique identifier of the service.
         * <p>
         * @return {@code this}
         * @param serviceIdentifier The unique identifier of the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceIdentifier(final java.lang.String serviceIdentifier) {
            this.props.serviceIdentifier(serviceIdentifier);
            return this;
        }

        /**
         * `AWS::RefactorSpaces::Route.DefaultRoute`.
         * <p>
         * @return {@code this}
         * @param defaultRoute `AWS::RefactorSpaces::Route.DefaultRoute`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRoute(final software.amazon.awscdk.services.refactorspaces.CfnRoute.DefaultRouteInputProperty defaultRoute) {
            this.props.defaultRoute(defaultRoute);
            return this;
        }
        /**
         * `AWS::RefactorSpaces::Route.DefaultRoute`.
         * <p>
         * @return {@code this}
         * @param defaultRoute `AWS::RefactorSpaces::Route.DefaultRoute`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRoute(final software.amazon.awscdk.IResolvable defaultRoute) {
            this.props.defaultRoute(defaultRoute);
            return this;
        }

        /**
         * The route type of the route.
         * <p>
         * @return {@code this}
         * @param routeType The route type of the route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeType(final java.lang.String routeType) {
            this.props.routeType(routeType);
            return this;
        }

        /**
         * The tags assigned to the route.
         * <p>
         * @return {@code this}
         * @param tags The tags assigned to the route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The configuration for the URI path route type.
         * <p>
         * @return {@code this}
         * @param uriPathRoute The configuration for the URI path route type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uriPathRoute(final software.amazon.awscdk.services.refactorspaces.CfnRoute.UriPathRouteInputProperty uriPathRoute) {
            this.props.uriPathRoute(uriPathRoute);
            return this;
        }
        /**
         * The configuration for the URI path route type.
         * <p>
         * @return {@code this}
         * @param uriPathRoute The configuration for the URI path route type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uriPathRoute(final software.amazon.awscdk.IResolvable uriPathRoute) {
            this.props.uriPathRoute(uriPathRoute);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.refactorspaces.CfnRoute}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.refactorspaces.CfnRoute build() {
            return new software.amazon.awscdk.services.refactorspaces.CfnRoute(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
