package software.amazon.awscdk.services.pinpointemail;

/**
 * A CloudFormation `AWS::PinpointEmail::ConfigurationSet`.
 * <p>
 * Create a configuration set. <em>Configuration sets</em> are groups of rules that you can apply to the emails you send using Amazon Pinpoint. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pinpointemail.*;
 * CfnConfigurationSet cfnConfigurationSet = CfnConfigurationSet.Builder.create(this, "MyCfnConfigurationSet")
 *         .name("name")
 *         // the properties below are optional
 *         .deliveryOptions(DeliveryOptionsProperty.builder()
 *                 .sendingPoolName("sendingPoolName")
 *                 .build())
 *         .reputationOptions(ReputationOptionsProperty.builder()
 *                 .reputationMetricsEnabled(false)
 *                 .build())
 *         .sendingOptions(SendingOptionsProperty.builder()
 *                 .sendingEnabled(false)
 *                 .build())
 *         .tags(List.of(TagsProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .trackingOptions(TrackingOptionsProperty.builder()
 *                 .customRedirectDomain("customRedirectDomain")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:13.934Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpointemail.CfnConfigurationSet")
public class CfnConfigurationSet extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnConfigurationSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfigurationSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::PinpointEmail::ConfigurationSet`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfigurationSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.pinpointemail.CfnConfigurationSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeliveryOptions() {
        return software.amazon.jsii.Kernel.get(this, "deliveryOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeliveryOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet.DeliveryOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "deliveryOptions", value);
    }

    /**
     * An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeliveryOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deliveryOptions", value);
    }

    /**
     * An object that defines whether or not Amazon Pinpoint collects reputation metrics for the emails that you send that use the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getReputationOptions() {
        return software.amazon.jsii.Kernel.get(this, "reputationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that defines whether or not Amazon Pinpoint collects reputation metrics for the emails that you send that use the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReputationOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet.ReputationOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "reputationOptions", value);
    }

    /**
     * An object that defines whether or not Amazon Pinpoint collects reputation metrics for the emails that you send that use the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReputationOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "reputationOptions", value);
    }

    /**
     * An object that defines whether or not Amazon Pinpoint can send email that you send using the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSendingOptions() {
        return software.amazon.jsii.Kernel.get(this, "sendingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that defines whether or not Amazon Pinpoint can send email that you send using the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSendingOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet.SendingOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "sendingOptions", value);
    }

    /**
     * An object that defines whether or not Amazon Pinpoint can send email that you send using the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSendingOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sendingOptions", value);
    }

    /**
     * An object that defines the tags (keys and values) that you want to associate with the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet.TagsProperty> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet.TagsProperty>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet.TagsProperty.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An object that defines the tags (keys and values) that you want to associate with the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet.TagsProperty> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * An object that defines the open and click tracking options for emails that you send using the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTrackingOptions() {
        return software.amazon.jsii.Kernel.get(this, "trackingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that defines the open and click tracking options for emails that you send using the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTrackingOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet.TrackingOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "trackingOptions", value);
    }

    /**
     * An object that defines the open and click tracking options for emails that you send using the configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTrackingOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "trackingOptions", value);
    }
    /**
     * Used to associate a configuration set with a dedicated IP pool.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpointemail.*;
     * DeliveryOptionsProperty deliveryOptionsProperty = DeliveryOptionsProperty.builder()
     *         .sendingPoolName("sendingPoolName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpointemail.CfnConfigurationSet.DeliveryOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(DeliveryOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeliveryOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the dedicated IP pool that you want to associate with the configuration set.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSendingPoolName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeliveryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeliveryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeliveryOptionsProperty> {
            java.lang.String sendingPoolName;

            /**
             * Sets the value of {@link DeliveryOptionsProperty#getSendingPoolName}
             * @param sendingPoolName The name of the dedicated IP pool that you want to associate with the configuration set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sendingPoolName(java.lang.String sendingPoolName) {
                this.sendingPoolName = sendingPoolName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeliveryOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeliveryOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeliveryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeliveryOptionsProperty {
            private final java.lang.String sendingPoolName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sendingPoolName = software.amazon.jsii.Kernel.get(this, "sendingPoolName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sendingPoolName = builder.sendingPoolName;
            }

            @Override
            public final java.lang.String getSendingPoolName() {
                return this.sendingPoolName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSendingPoolName() != null) {
                    data.set("sendingPoolName", om.valueToTree(this.getSendingPoolName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpointemail.CfnConfigurationSet.DeliveryOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeliveryOptionsProperty.Jsii$Proxy that = (DeliveryOptionsProperty.Jsii$Proxy) o;

                return this.sendingPoolName != null ? this.sendingPoolName.equals(that.sendingPoolName) : that.sendingPoolName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sendingPoolName != null ? this.sendingPoolName.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Enable or disable collection of reputation metrics for emails that you send using this configuration set in the current AWS Region.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpointemail.*;
     * ReputationOptionsProperty reputationOptionsProperty = ReputationOptionsProperty.builder()
     *         .reputationMetricsEnabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpointemail.CfnConfigurationSet.ReputationOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ReputationOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReputationOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If `true` , tracking of reputation metrics is enabled for the configuration set.
         * <p>
         * If <code>false</code> , tracking of reputation metrics is disabled for the configuration set.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReputationMetricsEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReputationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReputationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReputationOptionsProperty> {
            java.lang.Object reputationMetricsEnabled;

            /**
             * Sets the value of {@link ReputationOptionsProperty#getReputationMetricsEnabled}
             * @param reputationMetricsEnabled If `true` , tracking of reputation metrics is enabled for the configuration set.
             *                                 If <code>false</code> , tracking of reputation metrics is disabled for the configuration set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reputationMetricsEnabled(java.lang.Boolean reputationMetricsEnabled) {
                this.reputationMetricsEnabled = reputationMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ReputationOptionsProperty#getReputationMetricsEnabled}
             * @param reputationMetricsEnabled If `true` , tracking of reputation metrics is enabled for the configuration set.
             *                                 If <code>false</code> , tracking of reputation metrics is disabled for the configuration set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reputationMetricsEnabled(software.amazon.awscdk.IResolvable reputationMetricsEnabled) {
                this.reputationMetricsEnabled = reputationMetricsEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReputationOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReputationOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReputationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReputationOptionsProperty {
            private final java.lang.Object reputationMetricsEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.reputationMetricsEnabled = software.amazon.jsii.Kernel.get(this, "reputationMetricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.reputationMetricsEnabled = builder.reputationMetricsEnabled;
            }

            @Override
            public final java.lang.Object getReputationMetricsEnabled() {
                return this.reputationMetricsEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReputationMetricsEnabled() != null) {
                    data.set("reputationMetricsEnabled", om.valueToTree(this.getReputationMetricsEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpointemail.CfnConfigurationSet.ReputationOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReputationOptionsProperty.Jsii$Proxy that = (ReputationOptionsProperty.Jsii$Proxy) o;

                return this.reputationMetricsEnabled != null ? this.reputationMetricsEnabled.equals(that.reputationMetricsEnabled) : that.reputationMetricsEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.reputationMetricsEnabled != null ? this.reputationMetricsEnabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Used to enable or disable email sending for messages that use this configuration set in the current AWS Region.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpointemail.*;
     * SendingOptionsProperty sendingOptionsProperty = SendingOptionsProperty.builder()
     *         .sendingEnabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpointemail.CfnConfigurationSet.SendingOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(SendingOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SendingOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If `true` , email sending is enabled for the configuration set.
         * <p>
         * If <code>false</code> , email sending is disabled for the configuration set.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSendingEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SendingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SendingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SendingOptionsProperty> {
            java.lang.Object sendingEnabled;

            /**
             * Sets the value of {@link SendingOptionsProperty#getSendingEnabled}
             * @param sendingEnabled If `true` , email sending is enabled for the configuration set.
             *                       If <code>false</code> , email sending is disabled for the configuration set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sendingEnabled(java.lang.Boolean sendingEnabled) {
                this.sendingEnabled = sendingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link SendingOptionsProperty#getSendingEnabled}
             * @param sendingEnabled If `true` , email sending is enabled for the configuration set.
             *                       If <code>false</code> , email sending is disabled for the configuration set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sendingEnabled(software.amazon.awscdk.IResolvable sendingEnabled) {
                this.sendingEnabled = sendingEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SendingOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SendingOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SendingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SendingOptionsProperty {
            private final java.lang.Object sendingEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sendingEnabled = software.amazon.jsii.Kernel.get(this, "sendingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sendingEnabled = builder.sendingEnabled;
            }

            @Override
            public final java.lang.Object getSendingEnabled() {
                return this.sendingEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSendingEnabled() != null) {
                    data.set("sendingEnabled", om.valueToTree(this.getSendingEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpointemail.CfnConfigurationSet.SendingOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SendingOptionsProperty.Jsii$Proxy that = (SendingOptionsProperty.Jsii$Proxy) o;

                return this.sendingEnabled != null ? this.sendingEnabled.equals(that.sendingEnabled) : that.sendingEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sendingEnabled != null ? this.sendingEnabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that defines the tags (keys and values) that you want to associate with the configuration set.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpointemail.*;
     * TagsProperty tagsProperty = TagsProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpointemail.CfnConfigurationSet.TagsProperty")
    @software.amazon.jsii.Jsii.Proxy(TagsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * One part of a key-value pair that defines a tag.
         * <p>
         * The maximum length of a tag key is 128 characters. The minimum length is 1 character.
         * <p>
         * If you specify tags for the configuration set, then this value is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * The optional part of a key-value pair that defines a tag.
         * <p>
         * The maximum length of a tag value is 256 characters. The minimum length is 0 characters. If you don’t want a resource to have a specific tag value, don’t specify a value for this parameter. Amazon Pinpoint will set the value to an empty string.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagsProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link TagsProperty#getKey}
             * @param key One part of a key-value pair that defines a tag.
             *            The maximum length of a tag key is 128 characters. The minimum length is 1 character.
             *            <p>
             *            If you specify tags for the configuration set, then this value is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link TagsProperty#getValue}
             * @param value The optional part of a key-value pair that defines a tag.
             *              The maximum length of a tag value is 256 characters. The minimum length is 0 characters. If you don’t want a resource to have a specific tag value, don’t specify a value for this parameter. Amazon Pinpoint will set the value to an empty string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagsProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = builder.key;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpointemail.CfnConfigurationSet.TagsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagsProperty.Jsii$Proxy that = (TagsProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that defines the tracking options for a configuration set.
     * <p>
     * When you use Amazon Pinpoint to send an email, it contains an invisible image that's used to track when recipients open your email. If your email contains links, those links are changed slightly in order to track when recipients click them.
     * <p>
     * These images and links include references to a domain operated by AWS . You can optionally configure Amazon Pinpoint to use a domain that you operate for these images and links.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpointemail.*;
     * TrackingOptionsProperty trackingOptionsProperty = TrackingOptionsProperty.builder()
     *         .customRedirectDomain("customRedirectDomain")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpointemail.CfnConfigurationSet.TrackingOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(TrackingOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TrackingOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The domain that you want to use for tracking open and click events.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomRedirectDomain() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TrackingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TrackingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TrackingOptionsProperty> {
            java.lang.String customRedirectDomain;

            /**
             * Sets the value of {@link TrackingOptionsProperty#getCustomRedirectDomain}
             * @param customRedirectDomain The domain that you want to use for tracking open and click events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customRedirectDomain(java.lang.String customRedirectDomain) {
                this.customRedirectDomain = customRedirectDomain;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TrackingOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TrackingOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TrackingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrackingOptionsProperty {
            private final java.lang.String customRedirectDomain;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customRedirectDomain = software.amazon.jsii.Kernel.get(this, "customRedirectDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customRedirectDomain = builder.customRedirectDomain;
            }

            @Override
            public final java.lang.String getCustomRedirectDomain() {
                return this.customRedirectDomain;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomRedirectDomain() != null) {
                    data.set("customRedirectDomain", om.valueToTree(this.getCustomRedirectDomain()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpointemail.CfnConfigurationSet.TrackingOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TrackingOptionsProperty.Jsii$Proxy that = (TrackingOptionsProperty.Jsii$Proxy) o;

                return this.customRedirectDomain != null ? this.customRedirectDomain.equals(that.customRedirectDomain) : that.customRedirectDomain == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customRedirectDomain != null ? this.customRedirectDomain.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.pinpointemail.CfnConfigurationSetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.pinpointemail.CfnConfigurationSetProps.Builder();
        }

        /**
         * The name of the configuration set.
         * <p>
         * @return {@code this}
         * @param name The name of the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.
         * <p>
         * @return {@code this}
         * @param deliveryOptions An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryOptions(final software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet.DeliveryOptionsProperty deliveryOptions) {
            this.props.deliveryOptions(deliveryOptions);
            return this;
        }
        /**
         * An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.
         * <p>
         * @return {@code this}
         * @param deliveryOptions An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryOptions(final software.amazon.awscdk.IResolvable deliveryOptions) {
            this.props.deliveryOptions(deliveryOptions);
            return this;
        }

        /**
         * An object that defines whether or not Amazon Pinpoint collects reputation metrics for the emails that you send that use the configuration set.
         * <p>
         * @return {@code this}
         * @param reputationOptions An object that defines whether or not Amazon Pinpoint collects reputation metrics for the emails that you send that use the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reputationOptions(final software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet.ReputationOptionsProperty reputationOptions) {
            this.props.reputationOptions(reputationOptions);
            return this;
        }
        /**
         * An object that defines whether or not Amazon Pinpoint collects reputation metrics for the emails that you send that use the configuration set.
         * <p>
         * @return {@code this}
         * @param reputationOptions An object that defines whether or not Amazon Pinpoint collects reputation metrics for the emails that you send that use the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reputationOptions(final software.amazon.awscdk.IResolvable reputationOptions) {
            this.props.reputationOptions(reputationOptions);
            return this;
        }

        /**
         * An object that defines whether or not Amazon Pinpoint can send email that you send using the configuration set.
         * <p>
         * @return {@code this}
         * @param sendingOptions An object that defines whether or not Amazon Pinpoint can send email that you send using the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sendingOptions(final software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet.SendingOptionsProperty sendingOptions) {
            this.props.sendingOptions(sendingOptions);
            return this;
        }
        /**
         * An object that defines whether or not Amazon Pinpoint can send email that you send using the configuration set.
         * <p>
         * @return {@code this}
         * @param sendingOptions An object that defines whether or not Amazon Pinpoint can send email that you send using the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sendingOptions(final software.amazon.awscdk.IResolvable sendingOptions) {
            this.props.sendingOptions(sendingOptions);
            return this;
        }

        /**
         * An object that defines the tags (keys and values) that you want to associate with the configuration set.
         * <p>
         * @return {@code this}
         * @param tags An object that defines the tags (keys and values) that you want to associate with the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet.TagsProperty> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * An object that defines the open and click tracking options for emails that you send using the configuration set.
         * <p>
         * @return {@code this}
         * @param trackingOptions An object that defines the open and click tracking options for emails that you send using the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackingOptions(final software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet.TrackingOptionsProperty trackingOptions) {
            this.props.trackingOptions(trackingOptions);
            return this;
        }
        /**
         * An object that defines the open and click tracking options for emails that you send using the configuration set.
         * <p>
         * @return {@code this}
         * @param trackingOptions An object that defines the open and click tracking options for emails that you send using the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackingOptions(final software.amazon.awscdk.IResolvable trackingOptions) {
            this.props.trackingOptions(trackingOptions);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet build() {
            return new software.amazon.awscdk.services.pinpointemail.CfnConfigurationSet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
