package software.amazon.awscdk.services.personalize;

/**
 * A CloudFormation `AWS::Personalize::Solution`.
 * <p>
 * An object that provides information about a solution. A solution is a trained model that can be deployed as a campaign.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.personalize.*;
 * Object autoMlConfig;
 * Object hpoConfig;
 * CfnSolution cfnSolution = CfnSolution.Builder.create(this, "MyCfnSolution")
 *         .datasetGroupArn("datasetGroupArn")
 *         .name("name")
 *         // the properties below are optional
 *         .eventType("eventType")
 *         .performAutoMl(false)
 *         .performHpo(false)
 *         .recipeArn("recipeArn")
 *         .solutionConfig(SolutionConfigProperty.builder()
 *                 .algorithmHyperParameters(Map.of(
 *                         "algorithmHyperParametersKey", "algorithmHyperParameters"))
 *                 .autoMlConfig(autoMlConfig)
 *                 .eventValueThreshold("eventValueThreshold")
 *                 .featureTransformationParameters(Map.of(
 *                         "featureTransformationParametersKey", "featureTransformationParameters"))
 *                 .hpoConfig(hpoConfig)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:13.854Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_personalize.CfnSolution")
public class CfnSolution extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnSolution(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSolution(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.personalize.CfnSolution.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Personalize::Solution`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSolution(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.personalize.CfnSolutionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the solution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSolutionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSolutionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the dataset group that provides the training data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDatasetGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "datasetGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the dataset group that provides the training data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatasetGroupArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "datasetGroupArn", java.util.Objects.requireNonNull(value, "datasetGroupArn is required"));
    }

    /**
     * The name of the solution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the solution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The event type (for example, 'click' or 'like') that is used for training the model.
     * <p>
     * If no <code>eventType</code> is provided, Amazon Personalize uses all interactions for training with equal weight regardless of type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEventType() {
        return software.amazon.jsii.Kernel.get(this, "eventType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The event type (for example, 'click' or 'like') that is used for training the model.
     * <p>
     * If no <code>eventType</code> is provided, Amazon Personalize uses all interactions for training with equal weight regardless of type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "eventType", value);
    }

    /**
     * When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified in the solution configuration ( `recipeArn` must not be specified).
     * <p>
     * When false (the default), Amazon Personalize uses <code>recipeArn</code> for training.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPerformAutoMl() {
        return software.amazon.jsii.Kernel.get(this, "performAutoMl", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified in the solution configuration ( `recipeArn` must not be specified).
     * <p>
     * When false (the default), Amazon Personalize uses <code>recipeArn</code> for training.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformAutoMl(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "performAutoMl", value);
    }

    /**
     * When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified in the solution configuration ( `recipeArn` must not be specified).
     * <p>
     * When false (the default), Amazon Personalize uses <code>recipeArn</code> for training.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformAutoMl(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "performAutoMl", value);
    }

    /**
     * Whether to perform hyperparameter optimization (HPO) on the chosen recipe.
     * <p>
     * The default is <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPerformHpo() {
        return software.amazon.jsii.Kernel.get(this, "performHpo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether to perform hyperparameter optimization (HPO) on the chosen recipe.
     * <p>
     * The default is <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformHpo(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "performHpo", value);
    }

    /**
     * Whether to perform hyperparameter optimization (HPO) on the chosen recipe.
     * <p>
     * The default is <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformHpo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "performHpo", value);
    }

    /**
     * The ARN of the recipe used to create the solution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRecipeArn() {
        return software.amazon.jsii.Kernel.get(this, "recipeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the recipe used to create the solution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecipeArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "recipeArn", value);
    }

    /**
     * Describes the configuration properties for the solution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSolutionConfig() {
        return software.amazon.jsii.Kernel.get(this, "solutionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes the configuration properties for the solution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSolutionConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.personalize.CfnSolution.SolutionConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "solutionConfig", value);
    }

    /**
     * Describes the configuration properties for the solution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSolutionConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "solutionConfig", value);
    }
    /**
     * Describes the configuration properties for the solution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.personalize.*;
     * Object autoMlConfig;
     * Object hpoConfig;
     * SolutionConfigProperty solutionConfigProperty = SolutionConfigProperty.builder()
     *         .algorithmHyperParameters(Map.of(
     *                 "algorithmHyperParametersKey", "algorithmHyperParameters"))
     *         .autoMlConfig(autoMlConfig)
     *         .eventValueThreshold("eventValueThreshold")
     *         .featureTransformationParameters(Map.of(
     *                 "featureTransformationParametersKey", "featureTransformationParameters"))
     *         .hpoConfig(hpoConfig)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_personalize.CfnSolution.SolutionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SolutionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SolutionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Lists the hyperparameter names and ranges.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAlgorithmHyperParameters() {
            return null;
        }

        /**
         * The [AutoMLConfig](https://docs.aws.amazon.com/personalize/latest/dg/API_AutoMLConfig.html) object containing a list of recipes to search when AutoML is performed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoMlConfig() {
            return null;
        }

        /**
         * Only events with a value greater than or equal to this threshold are used for training a model.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventValueThreshold() {
            return null;
        }

        /**
         * Lists the feature transformation parameters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFeatureTransformationParameters() {
            return null;
        }

        /**
         * Describes the properties for hyperparameter optimization (HPO).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHpoConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SolutionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SolutionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SolutionConfigProperty> {
            java.lang.Object algorithmHyperParameters;
            java.lang.Object autoMlConfig;
            java.lang.String eventValueThreshold;
            java.lang.Object featureTransformationParameters;
            java.lang.Object hpoConfig;

            /**
             * Sets the value of {@link SolutionConfigProperty#getAlgorithmHyperParameters}
             * @param algorithmHyperParameters Lists the hyperparameter names and ranges.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder algorithmHyperParameters(software.amazon.awscdk.IResolvable algorithmHyperParameters) {
                this.algorithmHyperParameters = algorithmHyperParameters;
                return this;
            }

            /**
             * Sets the value of {@link SolutionConfigProperty#getAlgorithmHyperParameters}
             * @param algorithmHyperParameters Lists the hyperparameter names and ranges.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder algorithmHyperParameters(java.util.Map<java.lang.String, java.lang.String> algorithmHyperParameters) {
                this.algorithmHyperParameters = algorithmHyperParameters;
                return this;
            }

            /**
             * Sets the value of {@link SolutionConfigProperty#getAutoMlConfig}
             * @param autoMlConfig The [AutoMLConfig](https://docs.aws.amazon.com/personalize/latest/dg/API_AutoMLConfig.html) object containing a list of recipes to search when AutoML is performed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoMlConfig(java.lang.Object autoMlConfig) {
                this.autoMlConfig = autoMlConfig;
                return this;
            }

            /**
             * Sets the value of {@link SolutionConfigProperty#getEventValueThreshold}
             * @param eventValueThreshold Only events with a value greater than or equal to this threshold are used for training a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventValueThreshold(java.lang.String eventValueThreshold) {
                this.eventValueThreshold = eventValueThreshold;
                return this;
            }

            /**
             * Sets the value of {@link SolutionConfigProperty#getFeatureTransformationParameters}
             * @param featureTransformationParameters Lists the feature transformation parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureTransformationParameters(software.amazon.awscdk.IResolvable featureTransformationParameters) {
                this.featureTransformationParameters = featureTransformationParameters;
                return this;
            }

            /**
             * Sets the value of {@link SolutionConfigProperty#getFeatureTransformationParameters}
             * @param featureTransformationParameters Lists the feature transformation parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureTransformationParameters(java.util.Map<java.lang.String, java.lang.String> featureTransformationParameters) {
                this.featureTransformationParameters = featureTransformationParameters;
                return this;
            }

            /**
             * Sets the value of {@link SolutionConfigProperty#getHpoConfig}
             * @param hpoConfig Describes the properties for hyperparameter optimization (HPO).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hpoConfig(java.lang.Object hpoConfig) {
                this.hpoConfig = hpoConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SolutionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SolutionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SolutionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SolutionConfigProperty {
            private final java.lang.Object algorithmHyperParameters;
            private final java.lang.Object autoMlConfig;
            private final java.lang.String eventValueThreshold;
            private final java.lang.Object featureTransformationParameters;
            private final java.lang.Object hpoConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.algorithmHyperParameters = software.amazon.jsii.Kernel.get(this, "algorithmHyperParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.autoMlConfig = software.amazon.jsii.Kernel.get(this, "autoMlConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventValueThreshold = software.amazon.jsii.Kernel.get(this, "eventValueThreshold", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.featureTransformationParameters = software.amazon.jsii.Kernel.get(this, "featureTransformationParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hpoConfig = software.amazon.jsii.Kernel.get(this, "hpoConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.algorithmHyperParameters = builder.algorithmHyperParameters;
                this.autoMlConfig = builder.autoMlConfig;
                this.eventValueThreshold = builder.eventValueThreshold;
                this.featureTransformationParameters = builder.featureTransformationParameters;
                this.hpoConfig = builder.hpoConfig;
            }

            @Override
            public final java.lang.Object getAlgorithmHyperParameters() {
                return this.algorithmHyperParameters;
            }

            @Override
            public final java.lang.Object getAutoMlConfig() {
                return this.autoMlConfig;
            }

            @Override
            public final java.lang.String getEventValueThreshold() {
                return this.eventValueThreshold;
            }

            @Override
            public final java.lang.Object getFeatureTransformationParameters() {
                return this.featureTransformationParameters;
            }

            @Override
            public final java.lang.Object getHpoConfig() {
                return this.hpoConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlgorithmHyperParameters() != null) {
                    data.set("algorithmHyperParameters", om.valueToTree(this.getAlgorithmHyperParameters()));
                }
                if (this.getAutoMlConfig() != null) {
                    data.set("autoMlConfig", om.valueToTree(this.getAutoMlConfig()));
                }
                if (this.getEventValueThreshold() != null) {
                    data.set("eventValueThreshold", om.valueToTree(this.getEventValueThreshold()));
                }
                if (this.getFeatureTransformationParameters() != null) {
                    data.set("featureTransformationParameters", om.valueToTree(this.getFeatureTransformationParameters()));
                }
                if (this.getHpoConfig() != null) {
                    data.set("hpoConfig", om.valueToTree(this.getHpoConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_personalize.CfnSolution.SolutionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SolutionConfigProperty.Jsii$Proxy that = (SolutionConfigProperty.Jsii$Proxy) o;

                if (this.algorithmHyperParameters != null ? !this.algorithmHyperParameters.equals(that.algorithmHyperParameters) : that.algorithmHyperParameters != null) return false;
                if (this.autoMlConfig != null ? !this.autoMlConfig.equals(that.autoMlConfig) : that.autoMlConfig != null) return false;
                if (this.eventValueThreshold != null ? !this.eventValueThreshold.equals(that.eventValueThreshold) : that.eventValueThreshold != null) return false;
                if (this.featureTransformationParameters != null ? !this.featureTransformationParameters.equals(that.featureTransformationParameters) : that.featureTransformationParameters != null) return false;
                return this.hpoConfig != null ? this.hpoConfig.equals(that.hpoConfig) : that.hpoConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.algorithmHyperParameters != null ? this.algorithmHyperParameters.hashCode() : 0;
                result = 31 * result + (this.autoMlConfig != null ? this.autoMlConfig.hashCode() : 0);
                result = 31 * result + (this.eventValueThreshold != null ? this.eventValueThreshold.hashCode() : 0);
                result = 31 * result + (this.featureTransformationParameters != null ? this.featureTransformationParameters.hashCode() : 0);
                result = 31 * result + (this.hpoConfig != null ? this.hpoConfig.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.personalize.CfnSolution}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.personalize.CfnSolution> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.personalize.CfnSolutionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.personalize.CfnSolutionProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the dataset group that provides the training data.
         * <p>
         * @return {@code this}
         * @param datasetGroupArn The Amazon Resource Name (ARN) of the dataset group that provides the training data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetGroupArn(final java.lang.String datasetGroupArn) {
            this.props.datasetGroupArn(datasetGroupArn);
            return this;
        }

        /**
         * The name of the solution.
         * <p>
         * @return {@code this}
         * @param name The name of the solution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The event type (for example, 'click' or 'like') that is used for training the model.
         * <p>
         * If no <code>eventType</code> is provided, Amazon Personalize uses all interactions for training with equal weight regardless of type.
         * <p>
         * @return {@code this}
         * @param eventType The event type (for example, 'click' or 'like') that is used for training the model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventType(final java.lang.String eventType) {
            this.props.eventType(eventType);
            return this;
        }

        /**
         * When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified in the solution configuration ( `recipeArn` must not be specified).
         * <p>
         * When false (the default), Amazon Personalize uses <code>recipeArn</code> for training.
         * <p>
         * @return {@code this}
         * @param performAutoMl When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified in the solution configuration ( `recipeArn` must not be specified). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performAutoMl(final java.lang.Boolean performAutoMl) {
            this.props.performAutoMl(performAutoMl);
            return this;
        }
        /**
         * When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified in the solution configuration ( `recipeArn` must not be specified).
         * <p>
         * When false (the default), Amazon Personalize uses <code>recipeArn</code> for training.
         * <p>
         * @return {@code this}
         * @param performAutoMl When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified in the solution configuration ( `recipeArn` must not be specified). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performAutoMl(final software.amazon.awscdk.IResolvable performAutoMl) {
            this.props.performAutoMl(performAutoMl);
            return this;
        }

        /**
         * Whether to perform hyperparameter optimization (HPO) on the chosen recipe.
         * <p>
         * The default is <code>false</code> .
         * <p>
         * @return {@code this}
         * @param performHpo Whether to perform hyperparameter optimization (HPO) on the chosen recipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performHpo(final java.lang.Boolean performHpo) {
            this.props.performHpo(performHpo);
            return this;
        }
        /**
         * Whether to perform hyperparameter optimization (HPO) on the chosen recipe.
         * <p>
         * The default is <code>false</code> .
         * <p>
         * @return {@code this}
         * @param performHpo Whether to perform hyperparameter optimization (HPO) on the chosen recipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performHpo(final software.amazon.awscdk.IResolvable performHpo) {
            this.props.performHpo(performHpo);
            return this;
        }

        /**
         * The ARN of the recipe used to create the solution.
         * <p>
         * @return {@code this}
         * @param recipeArn The ARN of the recipe used to create the solution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recipeArn(final java.lang.String recipeArn) {
            this.props.recipeArn(recipeArn);
            return this;
        }

        /**
         * Describes the configuration properties for the solution.
         * <p>
         * @return {@code this}
         * @param solutionConfig Describes the configuration properties for the solution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder solutionConfig(final software.amazon.awscdk.services.personalize.CfnSolution.SolutionConfigProperty solutionConfig) {
            this.props.solutionConfig(solutionConfig);
            return this;
        }
        /**
         * Describes the configuration properties for the solution.
         * <p>
         * @return {@code this}
         * @param solutionConfig Describes the configuration properties for the solution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder solutionConfig(final software.amazon.awscdk.IResolvable solutionConfig) {
            this.props.solutionConfig(solutionConfig);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.personalize.CfnSolution}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.personalize.CfnSolution build() {
            return new software.amazon.awscdk.services.personalize.CfnSolution(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
