package software.amazon.awscdk.services.opsworks;

/**
 * Properties for defining a `CfnLayer`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.opsworks.*;
 * Object customJson;
 * CfnLayerProps cfnLayerProps = CfnLayerProps.builder()
 *         .autoAssignElasticIps(false)
 *         .autoAssignPublicIps(false)
 *         .enableAutoHealing(false)
 *         .name("name")
 *         .shortname("shortname")
 *         .stackId("stackId")
 *         .type("type")
 *         // the properties below are optional
 *         .attributes(Map.of(
 *                 "attributesKey", "attributes"))
 *         .customInstanceProfileArn("customInstanceProfileArn")
 *         .customJson(customJson)
 *         .customRecipes(RecipesProperty.builder()
 *                 .configure(List.of("configure"))
 *                 .deploy(List.of("deploy"))
 *                 .setup(List.of("setup"))
 *                 .shutdown(List.of("shutdown"))
 *                 .undeploy(List.of("undeploy"))
 *                 .build())
 *         .customSecurityGroupIds(List.of("customSecurityGroupIds"))
 *         .installUpdatesOnBoot(false)
 *         .lifecycleEventConfiguration(LifecycleEventConfigurationProperty.builder()
 *                 .shutdownEventConfiguration(ShutdownEventConfigurationProperty.builder()
 *                         .delayUntilElbConnectionsDrained(false)
 *                         .executionTimeout(123)
 *                         .build())
 *                 .build())
 *         .loadBasedAutoScaling(LoadBasedAutoScalingProperty.builder()
 *                 .downScaling(AutoScalingThresholdsProperty.builder()
 *                         .cpuThreshold(123)
 *                         .ignoreMetricsTime(123)
 *                         .instanceCount(123)
 *                         .loadThreshold(123)
 *                         .memoryThreshold(123)
 *                         .thresholdsWaitTime(123)
 *                         .build())
 *                 .enable(false)
 *                 .upScaling(AutoScalingThresholdsProperty.builder()
 *                         .cpuThreshold(123)
 *                         .ignoreMetricsTime(123)
 *                         .instanceCount(123)
 *                         .loadThreshold(123)
 *                         .memoryThreshold(123)
 *                         .thresholdsWaitTime(123)
 *                         .build())
 *                 .build())
 *         .packages(List.of("packages"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .useEbsOptimizedInstances(false)
 *         .volumeConfigurations(List.of(VolumeConfigurationProperty.builder()
 *                 .encrypted(false)
 *                 .iops(123)
 *                 .mountPoint("mountPoint")
 *                 .numberOfDisks(123)
 *                 .raidLevel(123)
 *                 .size(123)
 *                 .volumeType("volumeType")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:13.805Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnLayerProps")
@software.amazon.jsii.Jsii.Proxy(CfnLayerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLayerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether to automatically assign an [Elastic IP address](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) to the layer's instances. For more information, see [How to Edit a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html) .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAutoAssignElasticIps();

    /**
     * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAutoAssignPublicIps();

    /**
     * Whether to disable auto healing for the layer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getEnableAutoHealing();

    /**
     * The layer name, which is used by the console.
     * <p>
     * Layer names can be a maximum of 32 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS OpsWorks Stacks and by Chef recipes.
     * <p>
     * The short name is also used as the name for the directory where your app files are installed. It can have a maximum of 32 characters, which are limited to the alphanumeric characters, '-', '_', and '.'.
     * <p>
     * Built-in layer short names are defined by AWS OpsWorks Stacks. For more information, see the <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getShortname();

    /**
     * The layer stack ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStackId();

    /**
     * The layer type.
     * <p>
     * A stack cannot have more than one built-in layer of the same type. It can have any number of custom layers. Built-in layers are not available in Chef 12 stacks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * One or more user-defined key-value pairs to be added to the stack attributes.
     * <p>
     * To create a cluster layer, set the <code>EcsClusterArn</code> attribute to the cluster's ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAttributes() {
        return null;
    }

    /**
     * The ARN of an IAM profile to be used for the layer's EC2 instances.
     * <p>
     * For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomInstanceProfileArn() {
        return null;
    }

    /**
     * A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer's instances.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html">Using Custom JSON</a> . This feature is supported as of version 1.7.42 of the AWS CLI .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomJson() {
        return null;
    }

    /**
     * A `LayerCustomRecipes` object that specifies the layer custom recipes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomRecipes() {
        return null;
    }

    /**
     * An array containing the layer custom security group IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCustomSecurityGroupIds() {
        return null;
    }

    /**
     * Whether to install operating system and package updates when the instance boots.
     * <p>
     * The default value is <code>true</code> . To control when updates are installed, set this value to <code>false</code> . You must then update your instances manually by using <a href="https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateDeployment">CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
     * <p>
     * <blockquote>
     * <p>
     * To ensure that your instances have the latest security updates, we strongly recommend using the default value of <code>true</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInstallUpdatesOnBoot() {
        return null;
    }

    /**
     * A `LifeCycleEventConfiguration` object that you can use to configure the Shutdown event to specify an execution timeout and enable or disable Elastic Load Balancer connection draining.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLifecycleEventConfiguration() {
        return null;
    }

    /**
     * The load-based scaling configuration for the AWS OpsWorks layer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLoadBasedAutoScaling() {
        return null;
    }

    /**
     * An array of `Package` objects that describes the layer packages.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPackages() {
        return null;
    }

    /**
     * Specifies one or more sets of tags (key–value pairs) to associate with this AWS OpsWorks layer.
     * <p>
     * Use tags to manage your resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Whether to use Amazon EBS-optimized instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUseEbsOptimizedInstances() {
        return null;
    }

    /**
     * A `VolumeConfigurations` object that describes the layer's Amazon EBS volumes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVolumeConfigurations() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLayerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLayerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLayerProps> {
        java.lang.Object autoAssignElasticIps;
        java.lang.Object autoAssignPublicIps;
        java.lang.Object enableAutoHealing;
        java.lang.String name;
        java.lang.String shortname;
        java.lang.String stackId;
        java.lang.String type;
        java.lang.Object attributes;
        java.lang.String customInstanceProfileArn;
        java.lang.Object customJson;
        java.lang.Object customRecipes;
        java.util.List<java.lang.String> customSecurityGroupIds;
        java.lang.Object installUpdatesOnBoot;
        java.lang.Object lifecycleEventConfiguration;
        java.lang.Object loadBasedAutoScaling;
        java.util.List<java.lang.String> packages;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object useEbsOptimizedInstances;
        java.lang.Object volumeConfigurations;

        /**
         * Sets the value of {@link CfnLayerProps#getAutoAssignElasticIps}
         * @param autoAssignElasticIps Whether to automatically assign an [Elastic IP address](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) to the layer's instances. For more information, see [How to Edit a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html) . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoAssignElasticIps(java.lang.Boolean autoAssignElasticIps) {
            this.autoAssignElasticIps = autoAssignElasticIps;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getAutoAssignElasticIps}
         * @param autoAssignElasticIps Whether to automatically assign an [Elastic IP address](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) to the layer's instances. For more information, see [How to Edit a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html) . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoAssignElasticIps(software.amazon.awscdk.IResolvable autoAssignElasticIps) {
            this.autoAssignElasticIps = autoAssignElasticIps;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getAutoAssignPublicIps}
         * @param autoAssignPublicIps For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances. This parameter is required.
         *                            For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoAssignPublicIps(java.lang.Boolean autoAssignPublicIps) {
            this.autoAssignPublicIps = autoAssignPublicIps;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getAutoAssignPublicIps}
         * @param autoAssignPublicIps For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances. This parameter is required.
         *                            For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoAssignPublicIps(software.amazon.awscdk.IResolvable autoAssignPublicIps) {
            this.autoAssignPublicIps = autoAssignPublicIps;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getEnableAutoHealing}
         * @param enableAutoHealing Whether to disable auto healing for the layer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAutoHealing(java.lang.Boolean enableAutoHealing) {
            this.enableAutoHealing = enableAutoHealing;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getEnableAutoHealing}
         * @param enableAutoHealing Whether to disable auto healing for the layer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAutoHealing(software.amazon.awscdk.IResolvable enableAutoHealing) {
            this.enableAutoHealing = enableAutoHealing;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getName}
         * @param name The layer name, which is used by the console. This parameter is required.
         *             Layer names can be a maximum of 32 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getShortname}
         * @param shortname For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS OpsWorks Stacks and by Chef recipes. This parameter is required.
         *                  The short name is also used as the name for the directory where your app files are installed. It can have a maximum of 32 characters, which are limited to the alphanumeric characters, '-', '_', and '.'.
         *                  <p>
         *                  Built-in layer short names are defined by AWS OpsWorks Stacks. For more information, see the <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shortname(java.lang.String shortname) {
            this.shortname = shortname;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getStackId}
         * @param stackId The layer stack ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackId(java.lang.String stackId) {
            this.stackId = stackId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getType}
         * @param type The layer type. This parameter is required.
         *             A stack cannot have more than one built-in layer of the same type. It can have any number of custom layers. Built-in layers are not available in Chef 12 stacks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getAttributes}
         * @param attributes One or more user-defined key-value pairs to be added to the stack attributes.
         *                   To create a cluster layer, set the <code>EcsClusterArn</code> attribute to the cluster's ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(software.amazon.awscdk.IResolvable attributes) {
            this.attributes = attributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getAttributes}
         * @param attributes One or more user-defined key-value pairs to be added to the stack attributes.
         *                   To create a cluster layer, set the <code>EcsClusterArn</code> attribute to the cluster's ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(java.util.Map<java.lang.String, java.lang.String> attributes) {
            this.attributes = attributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getCustomInstanceProfileArn}
         * @param customInstanceProfileArn The ARN of an IAM profile to be used for the layer's EC2 instances.
         *                                 For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customInstanceProfileArn(java.lang.String customInstanceProfileArn) {
            this.customInstanceProfileArn = customInstanceProfileArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getCustomJson}
         * @param customJson A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer's instances.
         *                   For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html">Using Custom JSON</a> . This feature is supported as of version 1.7.42 of the AWS CLI .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customJson(java.lang.Object customJson) {
            this.customJson = customJson;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getCustomRecipes}
         * @param customRecipes A `LayerCustomRecipes` object that specifies the layer custom recipes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customRecipes(software.amazon.awscdk.services.opsworks.CfnLayer.RecipesProperty customRecipes) {
            this.customRecipes = customRecipes;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getCustomRecipes}
         * @param customRecipes A `LayerCustomRecipes` object that specifies the layer custom recipes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customRecipes(software.amazon.awscdk.IResolvable customRecipes) {
            this.customRecipes = customRecipes;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getCustomSecurityGroupIds}
         * @param customSecurityGroupIds An array containing the layer custom security group IDs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customSecurityGroupIds(java.util.List<java.lang.String> customSecurityGroupIds) {
            this.customSecurityGroupIds = customSecurityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getInstallUpdatesOnBoot}
         * @param installUpdatesOnBoot Whether to install operating system and package updates when the instance boots.
         *                             The default value is <code>true</code> . To control when updates are installed, set this value to <code>false</code> . You must then update your instances manually by using <a href="https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateDeployment">CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
         *                             <p>
         *                             <blockquote>
         *                             <p>
         *                             To ensure that your instances have the latest security updates, we strongly recommend using the default value of <code>true</code> .
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder installUpdatesOnBoot(java.lang.Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getInstallUpdatesOnBoot}
         * @param installUpdatesOnBoot Whether to install operating system and package updates when the instance boots.
         *                             The default value is <code>true</code> . To control when updates are installed, set this value to <code>false</code> . You must then update your instances manually by using <a href="https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateDeployment">CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
         *                             <p>
         *                             <blockquote>
         *                             <p>
         *                             To ensure that your instances have the latest security updates, we strongly recommend using the default value of <code>true</code> .
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder installUpdatesOnBoot(software.amazon.awscdk.IResolvable installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getLifecycleEventConfiguration}
         * @param lifecycleEventConfiguration A `LifeCycleEventConfiguration` object that you can use to configure the Shutdown event to specify an execution timeout and enable or disable Elastic Load Balancer connection draining.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleEventConfiguration(software.amazon.awscdk.services.opsworks.CfnLayer.LifecycleEventConfigurationProperty lifecycleEventConfiguration) {
            this.lifecycleEventConfiguration = lifecycleEventConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getLifecycleEventConfiguration}
         * @param lifecycleEventConfiguration A `LifeCycleEventConfiguration` object that you can use to configure the Shutdown event to specify an execution timeout and enable or disable Elastic Load Balancer connection draining.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleEventConfiguration(software.amazon.awscdk.IResolvable lifecycleEventConfiguration) {
            this.lifecycleEventConfiguration = lifecycleEventConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getLoadBasedAutoScaling}
         * @param loadBasedAutoScaling The load-based scaling configuration for the AWS OpsWorks layer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBasedAutoScaling(software.amazon.awscdk.services.opsworks.CfnLayer.LoadBasedAutoScalingProperty loadBasedAutoScaling) {
            this.loadBasedAutoScaling = loadBasedAutoScaling;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getLoadBasedAutoScaling}
         * @param loadBasedAutoScaling The load-based scaling configuration for the AWS OpsWorks layer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBasedAutoScaling(software.amazon.awscdk.IResolvable loadBasedAutoScaling) {
            this.loadBasedAutoScaling = loadBasedAutoScaling;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getPackages}
         * @param packages An array of `Package` objects that describes the layer packages.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packages(java.util.List<java.lang.String> packages) {
            this.packages = packages;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getTags}
         * @param tags Specifies one or more sets of tags (key–value pairs) to associate with this AWS OpsWorks layer.
         *             Use tags to manage your resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getUseEbsOptimizedInstances}
         * @param useEbsOptimizedInstances Whether to use Amazon EBS-optimized instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useEbsOptimizedInstances(java.lang.Boolean useEbsOptimizedInstances) {
            this.useEbsOptimizedInstances = useEbsOptimizedInstances;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getUseEbsOptimizedInstances}
         * @param useEbsOptimizedInstances Whether to use Amazon EBS-optimized instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useEbsOptimizedInstances(software.amazon.awscdk.IResolvable useEbsOptimizedInstances) {
            this.useEbsOptimizedInstances = useEbsOptimizedInstances;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getVolumeConfigurations}
         * @param volumeConfigurations A `VolumeConfigurations` object that describes the layer's Amazon EBS volumes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeConfigurations(software.amazon.awscdk.IResolvable volumeConfigurations) {
            this.volumeConfigurations = volumeConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerProps#getVolumeConfigurations}
         * @param volumeConfigurations A `VolumeConfigurations` object that describes the layer's Amazon EBS volumes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeConfigurations(java.util.List<? extends java.lang.Object> volumeConfigurations) {
            this.volumeConfigurations = volumeConfigurations;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLayerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLayerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLayerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLayerProps {
        private final java.lang.Object autoAssignElasticIps;
        private final java.lang.Object autoAssignPublicIps;
        private final java.lang.Object enableAutoHealing;
        private final java.lang.String name;
        private final java.lang.String shortname;
        private final java.lang.String stackId;
        private final java.lang.String type;
        private final java.lang.Object attributes;
        private final java.lang.String customInstanceProfileArn;
        private final java.lang.Object customJson;
        private final java.lang.Object customRecipes;
        private final java.util.List<java.lang.String> customSecurityGroupIds;
        private final java.lang.Object installUpdatesOnBoot;
        private final java.lang.Object lifecycleEventConfiguration;
        private final java.lang.Object loadBasedAutoScaling;
        private final java.util.List<java.lang.String> packages;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object useEbsOptimizedInstances;
        private final java.lang.Object volumeConfigurations;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoAssignElasticIps = software.amazon.jsii.Kernel.get(this, "autoAssignElasticIps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.autoAssignPublicIps = software.amazon.jsii.Kernel.get(this, "autoAssignPublicIps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableAutoHealing = software.amazon.jsii.Kernel.get(this, "enableAutoHealing", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.shortname = software.amazon.jsii.Kernel.get(this, "shortname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stackId = software.amazon.jsii.Kernel.get(this, "stackId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customInstanceProfileArn = software.amazon.jsii.Kernel.get(this, "customInstanceProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customJson = software.amazon.jsii.Kernel.get(this, "customJson", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customRecipes = software.amazon.jsii.Kernel.get(this, "customRecipes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customSecurityGroupIds = software.amazon.jsii.Kernel.get(this, "customSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.installUpdatesOnBoot = software.amazon.jsii.Kernel.get(this, "installUpdatesOnBoot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.lifecycleEventConfiguration = software.amazon.jsii.Kernel.get(this, "lifecycleEventConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.loadBasedAutoScaling = software.amazon.jsii.Kernel.get(this, "loadBasedAutoScaling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.packages = software.amazon.jsii.Kernel.get(this, "packages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.useEbsOptimizedInstances = software.amazon.jsii.Kernel.get(this, "useEbsOptimizedInstances", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.volumeConfigurations = software.amazon.jsii.Kernel.get(this, "volumeConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoAssignElasticIps = java.util.Objects.requireNonNull(builder.autoAssignElasticIps, "autoAssignElasticIps is required");
            this.autoAssignPublicIps = java.util.Objects.requireNonNull(builder.autoAssignPublicIps, "autoAssignPublicIps is required");
            this.enableAutoHealing = java.util.Objects.requireNonNull(builder.enableAutoHealing, "enableAutoHealing is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.shortname = java.util.Objects.requireNonNull(builder.shortname, "shortname is required");
            this.stackId = java.util.Objects.requireNonNull(builder.stackId, "stackId is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.attributes = builder.attributes;
            this.customInstanceProfileArn = builder.customInstanceProfileArn;
            this.customJson = builder.customJson;
            this.customRecipes = builder.customRecipes;
            this.customSecurityGroupIds = builder.customSecurityGroupIds;
            this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
            this.lifecycleEventConfiguration = builder.lifecycleEventConfiguration;
            this.loadBasedAutoScaling = builder.loadBasedAutoScaling;
            this.packages = builder.packages;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.useEbsOptimizedInstances = builder.useEbsOptimizedInstances;
            this.volumeConfigurations = builder.volumeConfigurations;
        }

        @Override
        public final java.lang.Object getAutoAssignElasticIps() {
            return this.autoAssignElasticIps;
        }

        @Override
        public final java.lang.Object getAutoAssignPublicIps() {
            return this.autoAssignPublicIps;
        }

        @Override
        public final java.lang.Object getEnableAutoHealing() {
            return this.enableAutoHealing;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getShortname() {
            return this.shortname;
        }

        @Override
        public final java.lang.String getStackId() {
            return this.stackId;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getAttributes() {
            return this.attributes;
        }

        @Override
        public final java.lang.String getCustomInstanceProfileArn() {
            return this.customInstanceProfileArn;
        }

        @Override
        public final java.lang.Object getCustomJson() {
            return this.customJson;
        }

        @Override
        public final java.lang.Object getCustomRecipes() {
            return this.customRecipes;
        }

        @Override
        public final java.util.List<java.lang.String> getCustomSecurityGroupIds() {
            return this.customSecurityGroupIds;
        }

        @Override
        public final java.lang.Object getInstallUpdatesOnBoot() {
            return this.installUpdatesOnBoot;
        }

        @Override
        public final java.lang.Object getLifecycleEventConfiguration() {
            return this.lifecycleEventConfiguration;
        }

        @Override
        public final java.lang.Object getLoadBasedAutoScaling() {
            return this.loadBasedAutoScaling;
        }

        @Override
        public final java.util.List<java.lang.String> getPackages() {
            return this.packages;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getUseEbsOptimizedInstances() {
            return this.useEbsOptimizedInstances;
        }

        @Override
        public final java.lang.Object getVolumeConfigurations() {
            return this.volumeConfigurations;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("autoAssignElasticIps", om.valueToTree(this.getAutoAssignElasticIps()));
            data.set("autoAssignPublicIps", om.valueToTree(this.getAutoAssignPublicIps()));
            data.set("enableAutoHealing", om.valueToTree(this.getEnableAutoHealing()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("shortname", om.valueToTree(this.getShortname()));
            data.set("stackId", om.valueToTree(this.getStackId()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getAttributes() != null) {
                data.set("attributes", om.valueToTree(this.getAttributes()));
            }
            if (this.getCustomInstanceProfileArn() != null) {
                data.set("customInstanceProfileArn", om.valueToTree(this.getCustomInstanceProfileArn()));
            }
            if (this.getCustomJson() != null) {
                data.set("customJson", om.valueToTree(this.getCustomJson()));
            }
            if (this.getCustomRecipes() != null) {
                data.set("customRecipes", om.valueToTree(this.getCustomRecipes()));
            }
            if (this.getCustomSecurityGroupIds() != null) {
                data.set("customSecurityGroupIds", om.valueToTree(this.getCustomSecurityGroupIds()));
            }
            if (this.getInstallUpdatesOnBoot() != null) {
                data.set("installUpdatesOnBoot", om.valueToTree(this.getInstallUpdatesOnBoot()));
            }
            if (this.getLifecycleEventConfiguration() != null) {
                data.set("lifecycleEventConfiguration", om.valueToTree(this.getLifecycleEventConfiguration()));
            }
            if (this.getLoadBasedAutoScaling() != null) {
                data.set("loadBasedAutoScaling", om.valueToTree(this.getLoadBasedAutoScaling()));
            }
            if (this.getPackages() != null) {
                data.set("packages", om.valueToTree(this.getPackages()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUseEbsOptimizedInstances() != null) {
                data.set("useEbsOptimizedInstances", om.valueToTree(this.getUseEbsOptimizedInstances()));
            }
            if (this.getVolumeConfigurations() != null) {
                data.set("volumeConfigurations", om.valueToTree(this.getVolumeConfigurations()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnLayerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLayerProps.Jsii$Proxy that = (CfnLayerProps.Jsii$Proxy) o;

            if (!autoAssignElasticIps.equals(that.autoAssignElasticIps)) return false;
            if (!autoAssignPublicIps.equals(that.autoAssignPublicIps)) return false;
            if (!enableAutoHealing.equals(that.enableAutoHealing)) return false;
            if (!name.equals(that.name)) return false;
            if (!shortname.equals(that.shortname)) return false;
            if (!stackId.equals(that.stackId)) return false;
            if (!type.equals(that.type)) return false;
            if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) return false;
            if (this.customInstanceProfileArn != null ? !this.customInstanceProfileArn.equals(that.customInstanceProfileArn) : that.customInstanceProfileArn != null) return false;
            if (this.customJson != null ? !this.customJson.equals(that.customJson) : that.customJson != null) return false;
            if (this.customRecipes != null ? !this.customRecipes.equals(that.customRecipes) : that.customRecipes != null) return false;
            if (this.customSecurityGroupIds != null ? !this.customSecurityGroupIds.equals(that.customSecurityGroupIds) : that.customSecurityGroupIds != null) return false;
            if (this.installUpdatesOnBoot != null ? !this.installUpdatesOnBoot.equals(that.installUpdatesOnBoot) : that.installUpdatesOnBoot != null) return false;
            if (this.lifecycleEventConfiguration != null ? !this.lifecycleEventConfiguration.equals(that.lifecycleEventConfiguration) : that.lifecycleEventConfiguration != null) return false;
            if (this.loadBasedAutoScaling != null ? !this.loadBasedAutoScaling.equals(that.loadBasedAutoScaling) : that.loadBasedAutoScaling != null) return false;
            if (this.packages != null ? !this.packages.equals(that.packages) : that.packages != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.useEbsOptimizedInstances != null ? !this.useEbsOptimizedInstances.equals(that.useEbsOptimizedInstances) : that.useEbsOptimizedInstances != null) return false;
            return this.volumeConfigurations != null ? this.volumeConfigurations.equals(that.volumeConfigurations) : that.volumeConfigurations == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoAssignElasticIps.hashCode();
            result = 31 * result + (this.autoAssignPublicIps.hashCode());
            result = 31 * result + (this.enableAutoHealing.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.shortname.hashCode());
            result = 31 * result + (this.stackId.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
            result = 31 * result + (this.customInstanceProfileArn != null ? this.customInstanceProfileArn.hashCode() : 0);
            result = 31 * result + (this.customJson != null ? this.customJson.hashCode() : 0);
            result = 31 * result + (this.customRecipes != null ? this.customRecipes.hashCode() : 0);
            result = 31 * result + (this.customSecurityGroupIds != null ? this.customSecurityGroupIds.hashCode() : 0);
            result = 31 * result + (this.installUpdatesOnBoot != null ? this.installUpdatesOnBoot.hashCode() : 0);
            result = 31 * result + (this.lifecycleEventConfiguration != null ? this.lifecycleEventConfiguration.hashCode() : 0);
            result = 31 * result + (this.loadBasedAutoScaling != null ? this.loadBasedAutoScaling.hashCode() : 0);
            result = 31 * result + (this.packages != null ? this.packages.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.useEbsOptimizedInstances != null ? this.useEbsOptimizedInstances.hashCode() : 0);
            result = 31 * result + (this.volumeConfigurations != null ? this.volumeConfigurations.hashCode() : 0);
            return result;
        }
    }
}
